/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSAddSubNumericUnitNode;
import com.oracle.truffle.js.nodes.unary.JSOverloadedUnaryNode;
import com.oracle.truffle.js.nodes.unary.JSOverloadedUnaryNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=JSAddSubNumericUnitNode.class)
public final class JSAddSubNumericUnitNodeGen
extends JSAddSubNumericUnitNode {
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private JSOverloadedUnaryNode overloaded_overloadedOperatorNode_;

    private JSAddSubNumericUnitNodeGen(JavaScriptNode operand, boolean isAddition, boolean truncate) {
        super(operand, isAddition, truncate);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x3C) == 0 && (state_0 & 0x3D) != 0) {
            return this.execute_int0(state_0, frameValue);
        }
        if ((state_0 & 0x39) == 0 && (state_0 & 0x3D) != 0) {
            return this.execute_double1(state_0, frameValue);
        }
        return this.execute_generic2(state_0, frameValue);
    }

    private Object execute_int0(int state_0__, VirtualFrame frameValue) {
        int operandNodeValue_;
        int state_0 = state_0__;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        try {
            return this.doInt(operandNodeValue_);
        }
        catch (ArithmeticException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            state_0 = this.state_0_;
            state_0 &= 0xFFFFFFFE;
            this.state_0_ = state_0 |= 2;
            return this.executeAndSpecialize(operandNodeValue_);
        }
    }

    private Object execute_double1(int state_0__, VirtualFrame frameValue) {
        double operandNodeValue_;
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        try {
            if ((state_0 & 0x180) == 0 && (state_0 & 0x3D) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0x140) == 0 && (state_0 & 0x3D) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x1C0) >>> 6, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return this.doDouble(operandNodeValue_);
    }

    private Object execute_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state_0 & 0x3D) != 0) {
            if ((state_0 & 1) != 0 && operandNodeValue_ instanceof Integer) {
                int operandNodeValue__ = (Integer)operandNodeValue_;
                try {
                    return this.doInt(operandNodeValue__);
                }
                catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    return this.executeAndSpecialize(operandNodeValue__);
                }
            }
            if ((state_0 & 4) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x1C0) >>> 6, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0x1C0) >>> 6, operandNodeValue_);
                return this.doDouble(operandNodeValue__);
            }
            if ((state_0 & 8) != 0 && operandNodeValue_ instanceof BigInt) {
                BigInt operandNodeValue__ = (BigInt)operandNodeValue_;
                return this.doBigInt(operandNodeValue__);
            }
            if ((state_0 & 0x10) != 0 && JSGuards.isJavaNumber(operandNodeValue_)) {
                return this.doJavaNumber(operandNodeValue_);
            }
            if ((state_0 & 0x20) != 0 && operandNodeValue_ instanceof JSOverloadedOperatorsObject) {
                JSOverloadedOperatorsObject operandNodeValue__ = (JSOverloadedOperatorsObject)operandNodeValue_;
                JSOverloadedUnaryNode overloadedOperatorNode__ = this.overloaded_overloadedOperatorNode_;
                if (overloadedOperatorNode__ != null) {
                    return this.doOverloaded(operandNodeValue__, overloadedOperatorNode__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0x20) != 0) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        if ((state_0 & 0x10) == 0 && (state_0 & 0x14) != 0) {
            return this.executeDouble_double3(state_0, frameValue);
        }
        return this.executeDouble_generic4(state_0, frameValue);
    }

    private double executeDouble_double3(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        double operandNodeValue_;
        int state_0 = state_0__;
        int operandNodeValue_int = 0;
        try {
            if ((state_0 & 0x180) == 0 && (state_0 & 0x3D) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else if ((state_0 & 0x140) == 0 && (state_0 & 0x3D) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x1C0) >>> 6, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
        }
        assert ((state_0 & 4) != 0);
        return this.doDouble(operandNodeValue_);
    }

    private double executeDouble_generic4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = state_0__;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state_0 & 0x14) != 0) {
            if ((state_0 & 4) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x1C0) >>> 6, operandNodeValue_)) {
                double operandNodeValue__ = JSTypesGen.asImplicitDouble((state_0 & 0x1C0) >>> 6, operandNodeValue_);
                return this.doDouble(operandNodeValue__);
            }
            if ((state_0 & 0x10) != 0 && JSGuards.isJavaNumber(operandNodeValue_)) {
                return this.doJavaNumber(operandNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize(operandNodeValue_));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int operandNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 0x20) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state_0 & 1) != 0) {
            try {
                return this.doInt(operandNodeValue_);
            }
            catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                return JSTypesGen.expectInteger(this.executeAndSpecialize(operandNodeValue_));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(operandNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0x3C) == 0 && (state_0 & 0x3D) != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state_0 & 0x29) == 0 && (state_0 & 0x3D) != 0) {
                this.executeDouble(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return;
        }
    }

    private Object executeAndSpecialize(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 4) == 0 && (state_0 & 2) == 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (Integer)operandNodeValue;
            this.state_0_ = state_0 |= 1;
            try {
                return this.doInt(operandNodeValue_);
            }
            catch (ArithmeticException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                return this.executeAndSpecialize(operandNodeValue_);
            }
        }
        int doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue);
        if (doubleCast0 != 0) {
            double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
            state_0 &= 0xFFFFFFFE;
            state_0 |= doubleCast0 << 6;
            this.state_0_ = state_0 |= 4;
            return this.doDouble(operandNodeValue_);
        }
        if (operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt)operandNodeValue;
            this.state_0_ = state_0 |= 8;
            return this.doBigInt(operandNodeValue_);
        }
        if (JSGuards.isJavaNumber(operandNodeValue)) {
            this.state_0_ = state_0 |= 0x10;
            return this.doJavaNumber(operandNodeValue);
        }
        if (operandNodeValue instanceof JSOverloadedOperatorsObject) {
            JSOverloadedOperatorsObject operandNodeValue_ = (JSOverloadedOperatorsObject)operandNodeValue;
            JSOverloadedUnaryNode overloadedOperatorNode__ = this.insert(JSOverloadedUnaryNodeGen.create(this.getOverloadedOperatorName()));
            Objects.requireNonNull(overloadedOperatorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.overloaded_overloadedOperatorNode_ = overloadedOperatorNode__;
            this.state_0_ = state_0 |= 0x20;
            return this.doOverloaded(operandNodeValue_, overloadedOperatorNode__);
        }
        throw new UnsupportedSpecializationException(this, new Node[]{this.operandNode}, operandNodeValue);
    }

    @NeverDefault
    public static JSAddSubNumericUnitNode create(JavaScriptNode operand, boolean isAddition, boolean truncate) {
        return new JSAddSubNumericUnitNodeGen(operand, isAddition, truncate);
    }
}

