/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSErrorObjectGen;
import com.oracle.truffle.js.runtime.objects.JSCopyableObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.JSObject;

@ExportLibrary(value=InteropLibrary.class)
@ImportStatic(value={JSConfig.class})
public final class JSErrorObject
extends JSNonProxyObject
implements JSCopyableObject {
    private GraalJSException exception;

    protected JSErrorObject(Shape shape, JSDynamicObject proto) {
        super(shape, proto);
    }

    public static JSErrorObject create(Shape shape, JSDynamicObject proto) {
        return new JSErrorObject(shape, proto);
    }

    @Override
    protected JSObject copyWithoutProperties(Shape shape) {
        return new JSErrorObject(shape, this.getPrototypeOf());
    }

    public GraalJSException getException() {
        assert (this.exception != null) : this;
        return this.exception;
    }

    public void setException(GraalJSException exception) {
        this.exception = exception;
    }

    @Override
    public TruffleString getClassName() {
        return this.getBuiltinToStringTag();
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        return JSError.CLASS_NAME;
    }

    @ExportMessage
    public boolean isException() {
        return this.exception != null;
    }

    @ExportMessage
    public RuntimeException throwException() {
        throw this.getException();
    }

    @ExportMessage
    public ExceptionType getExceptionType(@Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) throws UnsupportedMessageException {
        return exceptions.getExceptionType(this.getException());
    }

    @ExportMessage
    public boolean isExceptionIncompleteSource(@Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) throws UnsupportedMessageException {
        return exceptions.isExceptionIncompleteSource(this.getException());
    }

    @ExportMessage
    public boolean hasExceptionMessage(@Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) {
        return exceptions.hasExceptionMessage(this.getException());
    }

    @ExportMessage
    public Object getExceptionMessage(@Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) throws UnsupportedMessageException {
        return exceptions.getExceptionMessage(this.getException());
    }

    @ExportMessage
    public boolean hasExceptionStackTrace(@Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) {
        return exceptions.hasExceptionStackTrace(this.getException());
    }

    @ExportMessage
    public Object getExceptionStackTrace(@Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) throws UnsupportedMessageException {
        return exceptions.getExceptionStackTrace(this.getException());
    }

    @ExportMessage
    public boolean hasExceptionCause(@Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) {
        return exceptions.hasExceptionCause(this.getException());
    }

    @ExportMessage
    public Object getExceptionCause(@Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary exceptions) throws UnsupportedMessageException {
        return exceptions.getExceptionCause(this.getException());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        TruffleString messageStr;
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return super.toDisplayStringImpl(allowSideEffects, format, depth);
        }
        Object name = JSError.getPropertyWithoutSideEffect(this, JSError.NAME);
        Object message = JSError.getPropertyWithoutSideEffect(this, JSError.MESSAGE);
        TruffleString nameStr = name != null ? JSRuntime.toDisplayStringImpl(name, allowSideEffects, ToDisplayStringFormat.getDefaultFormat(), depth + 1, this) : JSError.CLASS_NAME;
        TruffleString truffleString = messageStr = message != null ? JSRuntime.toDisplayStringImpl(message, allowSideEffects, ToDisplayStringFormat.getDefaultFormat(), depth + 1, this) : Strings.EMPTY_STRING;
        if (nameStr.isEmpty()) {
            if (messageStr.isEmpty()) {
                return JSError.CLASS_NAME;
            }
            return messageStr;
        }
        if (Strings.isEmpty(messageStr)) {
            return nameStr;
        }
        return Strings.concatAll(nameStr, Strings.COLON_SPACE, messageStr);
    }

    public static void ensureInitialized() throws ClassNotFoundException {
        Class.forName(JSErrorObjectGen.class.getName());
    }

    @ExportMessage
    public static final class IsIdenticalOrUndefined {
        @Specialization
        public static TriState doError(JSErrorObject receiver, JSDynamicObject other) {
            return TriState.valueOf(receiver == other);
        }

        @Specialization
        public static TriState doException(JSErrorObject receiver, GraalJSException other) {
            return TriState.valueOf(receiver == other.getErrorObjectLazy());
        }

        @Fallback
        public static TriState doOther(JSErrorObject receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }
}

