/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.NativeContextDispatch;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.time.Duration;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolateThread;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectHandles;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.function.CEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.WordFactory;

final class NativeContextDispatchGen {
    NativeContextDispatchGen() {
    }

    static NativeContextDispatch createHSToNative(EnterprisePolyglotImpl enterprisePolyglotImpl) {
        return new StartPoint(enterprisePolyglotImpl);
    }

    static NativeContextDispatch createNativeToNative(EnterprisePolyglotImpl enterprisePolyglotImpl) {
        return new StartPoint(enterprisePolyglotImpl);
    }

    static NativeContextDispatch create(EnterprisePolyglotImpl enterprisePolyglotImpl) {
        if (ImageInfo.inImageCode()) {
            return NativeContextDispatchGen.createNativeToNative(enterprisePolyglotImpl);
        }
        return NativeContextDispatchGen.createHSToNative(enterprisePolyglotImpl);
    }

    private static final class StartPoint
    extends NativeContextDispatch {
        private static final BinaryMarshaller<Duration> durationMarshaller;
        private static final BinaryMarshaller<Object> objectWithValueReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(EnterprisePolyglotImpl enterprisePolyglotImpl) {
            super(enterprisePolyglotImpl);
        }

        @Override
        void closeImpl(Object object, boolean bl) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.closeImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle(), bl);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        void explicitEnterImpl(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.explicitEnterImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        void explicitLeaveImpl(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.explicitLeaveImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        Object getBindingsImpl(Object object, String string) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.getBindingsImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle(), string);
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object2 = objectWithValueReceiverMarshaller.read(binaryInput);
                return object2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public Object getPolyglotBindings(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.getPolyglotBindings0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object2 = objectWithValueReceiverMarshaller.read(binaryInput);
                return object2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        boolean initializeLanguageImpl(Object object, String string) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                boolean bl = StartPoint.initializeLanguageImpl0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle(), string);
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public boolean interrupt(Object object, Duration duration) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                int n2 = durationMarshaller.inferSize(duration);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create(n2);
                durationMarshaller.write(byteArrayBinaryOutput, duration);
                boolean bl = StartPoint.interrupt0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle(), byteArrayBinaryOutput.getArray());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void resetLimits(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.resetLimits0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void safepoint(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                StartPoint.safepoint0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native void closeImpl0(long var0, long var2, boolean var4);

        private static native void explicitEnterImpl0(long var0, long var2);

        private static native void explicitLeaveImpl0(long var0, long var2);

        private static native byte[] getBindingsImpl0(long var0, long var2, String var4);

        private static native byte[] getPolyglotBindings0(long var0, long var2);

        private static native boolean initializeLanguageImpl0(long var0, long var2, String var4);

        private static native boolean interrupt0(long var0, long var2, byte[] var4);

        private static native void resetLimits0(long var0, long var2);

        private static native void safepoint0(long var0, long var2);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            durationMarshaller = jNIConfig.lookupMarshaller(Duration.class, new Class[0]);
            objectWithValueReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.ValueReceiver.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Duration> durationMarshaller;
        private static final BinaryMarshaller<Object> objectWithValueReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_closeImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void closeImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, boolean bl) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeContextDispatchGen::closeImpl", jNIEnv);){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.close(object2, bl);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_explicitEnterImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void explicitEnterImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeContextDispatchGen::explicitEnterImpl", jNIEnv);){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.explicitEnter(object2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_explicitLeaveImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void explicitLeaveImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeContextDispatchGen::explicitLeaveImpl", jNIEnv);){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.explicitLeave(object2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_getBindingsImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray getBindingsImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JString jString) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeContextDispatchGen::getBindingsImpl", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get(256);
                Object object3 = abstractContextDispatch.getBindings(object2, JNIUtil.createString(jNIEnv, jString));
                int n2 = objectWithValueReceiverMarshaller.inferSize(object3);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create(n2) : BinaryOutput.create(cCharPointer, 256, false);){
                    objectWithValueReceiverMarshaller.write(cCharPointerBinaryOutput, object3);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray(jNIEnv, n3);
                    JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n3, cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult(jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_getPolyglotBindings0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray getPolyglotBindings(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeContextDispatchGen::getPolyglotBindings", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get(256);
                Object object3 = abstractContextDispatch.getPolyglotBindings(object2);
                int n2 = objectWithValueReceiverMarshaller.inferSize(object3);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create(n2) : BinaryOutput.create(cCharPointer, 256, false);){
                    objectWithValueReceiverMarshaller.write(cCharPointerBinaryOutput, object3);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray(jNIEnv, n3);
                    JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n3, cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult(jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_initializeLanguageImpl0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean initializeLanguageImpl(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JString jString) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeContextDispatchGen::initializeLanguageImpl", jNIEnv);
            try {
                boolean bl;
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                boolean bl2 = bl = abstractContextDispatch.initializeLanguage(object2, JNIUtil.createString(jNIEnv, jString));
                jNIMethodScope.close();
                return bl2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable(throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_interrupt0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean interrupt(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JByteArray jByteArray) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeContextDispatchGen::interrupt", jNIEnv);){
                boolean bl;
                block11: {
                    Object object = NativeObjectHandles.resolve(l3, Object.class);
                    AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                    Object object2 = NativeContextDispatch.resolveReceiver(object);
                    CCharPointer cCharPointer = (CCharPointer)StackValue.get(256);
                    int n2 = JNIUtil.GetArrayLength(jNIEnv, jByteArray);
                    CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc(n2);
                    try {
                        boolean bl2;
                        JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray, 0, n2, cCharPointer2);
                        BinaryInput binaryInput = BinaryInput.create(cCharPointer2, n2);
                        Duration duration = durationMarshaller.read(binaryInput);
                        bl = bl2 = abstractContextDispatch.interrupt(object2, duration);
                        if (cCharPointer2 == cCharPointer) break block11;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointer2 != cCharPointer) {
                            UnmanagedMemory.free(cCharPointer2);
                        }
                        throw throwable;
                    }
                    UnmanagedMemory.free(cCharPointer2);
                }
                return bl;
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                return false;
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_resetLimits0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void resetLimits(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeContextDispatchGen::resetLimits", jNIEnv);){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.resetLimits(object2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeContextDispatchGen_00024StartPoint_safepoint0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void safepoint(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeContextDispatchGen::safepoint", jNIEnv);){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = NativeContextDispatch.resolveNativeDelegate(object);
                Object object2 = NativeContextDispatch.resolveReceiver(object);
                abstractContextDispatch.safepoint(object2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            durationMarshaller = jNIConfig.lookupMarshaller(Duration.class, new Class[0]);
            objectWithValueReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.ValueReceiver.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

