/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorBaseNode;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.input.InputReadNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.string.Encodings;

public abstract class TRegexExecutorNode
extends TRegexExecutorBaseNode {
    public static final double CONTINUE_PROBABILITY = 0.99;
    public static final double EXIT_PROBABILITY = 0.010000000000000009;
    public static final double LATIN1_PROBABILITY = 0.7;
    public static final double BMP_PROBABILITY = 0.2;
    public static final double ASTRAL_PROBABILITY = 0.1;
    private final RegexSource source;
    private final int numberOfCaptureGroups;
    private final int numberOfTransitions;
    @Node.Child
    private InputReadNode charAtNode = InputReadNode.create();
    private final BranchProfile bmpProfile = BranchProfile.create();
    private final BranchProfile astralProfile = BranchProfile.create();

    protected TRegexExecutorNode(RegexAST ast, int numberOfTransitions) {
        this(ast.getSource(), ast.getNumberOfCaptureGroups(), numberOfTransitions);
    }

    protected TRegexExecutorNode(TRegexExecutorNode copy) {
        this(copy.source, copy.numberOfCaptureGroups, copy.numberOfTransitions);
    }

    protected TRegexExecutorNode(RegexSource source, int numberOfCaptureGroups, int numberOfTransitions) {
        this.source = source;
        this.numberOfCaptureGroups = numberOfCaptureGroups;
        this.numberOfTransitions = numberOfTransitions;
    }

    @Override
    public RegexSource getSource() {
        return this.source;
    }

    public final int getNumberOfCaptureGroups() {
        return this.numberOfCaptureGroups;
    }

    @Override
    public final int getNumberOfTransitions() {
        return this.numberOfTransitions;
    }

    public BranchProfile getBMPProfile() {
        return this.bmpProfile;
    }

    public BranchProfile getAstralProfile() {
        return this.astralProfile;
    }

    public boolean inputAtBegin(TRegexExecutorLocals locals) {
        return locals.getIndex() == (this.isForward() ? locals.getRegionFrom() : locals.getRegionTo());
    }

    public boolean inputAtEnd(TRegexExecutorLocals locals) {
        return locals.getIndex() == (this.isForward() ? locals.getRegionTo() : locals.getRegionFrom());
    }

    public int getMinIndex(TRegexExecutorLocals locals) {
        return locals.getRegionFrom();
    }

    public int getMaxIndex(TRegexExecutorLocals locals) {
        return locals.getMaxIndex();
    }

    public boolean inputHasNext(TRegexExecutorLocals locals) {
        return this.inputHasNext(locals, locals.getIndex());
    }

    public boolean inputHasNext(TRegexExecutorLocals locals, int index) {
        return this.inputHasNext(locals, index, this.isForward());
    }

    public boolean inputHasNext(TRegexExecutorLocals locals, int index, boolean forward) {
        return forward ? index < this.getMaxIndex(locals) : index > this.getMinIndex(locals);
    }

    public int inputReadAndDecode(TRegexExecutorLocals locals, TruffleString.CodeRange codeRange) {
        return this.inputReadAndDecode(locals, locals.getIndex(), codeRange);
    }

    @ExplodeLoop
    public int inputReadAndDecode(TRegexExecutorLocals locals, int index, TruffleString.CodeRange codeRange) {
        CompilerAsserts.partialEvaluationConstant((Object)codeRange);
        if (this.getEncoding() == Encodings.UTF_16) {
            locals.setNextIndex(this.inputIncRaw(index));
            int c2 = this.inputReadRaw(locals, index);
            if ((codeRange == TruffleString.CodeRange.VALID || codeRange == TruffleString.CodeRange.BROKEN) && CompilerDirectives.injectBranchProbability(0.1, this.inputUTF16IsHighSurrogate(c2)) && CompilerDirectives.injectBranchProbability(0.75, this.inputHasNext(locals, locals.getNextIndex()))) {
                int c22 = this.inputReadRaw(locals, locals.getNextIndex());
                if (codeRange == TruffleString.CodeRange.VALID || this.inputUTF16IsLowSurrogate(c22)) {
                    locals.setNextIndex(this.inputIncRaw(locals.getNextIndex()));
                    return this.inputUTF16ToCodePoint(c2, c22);
                }
            }
            return c2;
        }
        if (this.getEncoding() == Encodings.UTF_8) {
            int c3 = this.inputReadRaw(locals, index);
            if (codeRange == TruffleString.CodeRange.ASCII) {
                locals.setNextIndex(this.inputIncRaw(index));
                return c3;
            }
            if (CompilerDirectives.injectBranchProbability(0.7, c3 < 128)) {
                locals.setNextIndex(this.inputIncRaw(index));
                return c3;
            }
            int codepoint = c3 & 0x3F;
            if (!this.isForward()) {
                assert (c3 >> 6 == 2);
                for (int i2 = 1; i2 < 4; ++i2) {
                    c3 = this.inputReadRaw(locals, index - i2);
                    if (!CompilerDirectives.injectBranchProbability(0.75, i2 < 3) || !CompilerDirectives.injectBranchProbability(0.75, c3 >> 6 == 2)) break;
                    codepoint |= (c3 & 0x3F) << 6 * i2;
                }
            }
            int nBytes = TRegexExecutorNode.inputUTF8NumberOfLeadingOnes(c3);
            assert (1 < nBytes && nBytes < 5) : nBytes;
            if (this.isForward()) {
                locals.setNextIndex(this.inputIncRaw(index));
                codepoint = c3 & 255 >>> nBytes;
                switch (nBytes) {
                    case 4: {
                        codepoint = codepoint << 6 | this.inputReadRaw(locals, locals.getNextIndex()) & 0x3F;
                        locals.setNextIndex(this.inputIncRaw(locals.getNextIndex()));
                    }
                    case 3: {
                        codepoint = codepoint << 6 | this.inputReadRaw(locals, locals.getNextIndex()) & 0x3F;
                        locals.setNextIndex(this.inputIncRaw(locals.getNextIndex()));
                    }
                }
                codepoint = codepoint << 6 | this.inputReadRaw(locals, locals.getNextIndex()) & 0x3F;
                locals.setNextIndex(this.inputIncRaw(locals.getNextIndex()));
                return codepoint;
            }
            locals.setNextIndex(this.inputIncRaw(index, nBytes));
            return codepoint | (c3 & 255 >>> nBytes) << 6 * (nBytes - 1);
        }
        assert (this.getEncoding() == Encodings.UTF_16_RAW || this.getEncoding() == Encodings.UTF_32 || this.getEncoding() == Encodings.LATIN_1 || this.getEncoding() == Encodings.BYTES || this.getEncoding() == Encodings.ASCII);
        locals.setNextIndex(this.inputIncRaw(index));
        return this.inputReadRaw(locals, index);
    }

    public boolean inputUTF16IsHighSurrogate(int c2) {
        return Encodings.Encoding.UTF16.isHighSurrogate(c2, this.isForward());
    }

    public boolean inputUTF16IsLowSurrogate(int c2) {
        return Encodings.Encoding.UTF16.isLowSurrogate(c2, this.isForward());
    }

    public int inputUTF16ToCodePoint(int highSurrogate, int lowSurrogate) {
        return this.isForward() ? Character.toCodePoint((char)highSurrogate, (char)lowSurrogate) : Character.toCodePoint((char)lowSurrogate, (char)highSurrogate);
    }

    private static boolean inputUTF8IsTrailingByte(int c2) {
        return c2 >> 6 == 2;
    }

    private static int inputUTF8NumberOfLeadingOnes(int c2) {
        return Integer.numberOfLeadingZeros(~(c2 << 24));
    }

    public int inputReadRaw(TRegexExecutorLocals locals) {
        return this.inputReadRaw(locals, locals.getIndex());
    }

    public int inputReadRaw(TRegexExecutorLocals locals, int index) {
        return this.inputReadRaw(locals, index, this.isForward());
    }

    public int inputReadRaw(TRegexExecutorLocals locals, boolean forward) {
        return this.inputReadRaw(locals, locals.getIndex(), forward);
    }

    public int inputReadRaw(TRegexExecutorLocals locals, int index, boolean forward) {
        return this.charAtNode.execute(this, locals.getInput(), forward ? index : index - 1, this.getEncoding());
    }

    public void inputAdvance(TRegexExecutorLocals locals) {
        locals.setIndex(locals.getNextIndex());
    }

    public void inputSkip(TRegexExecutorLocals locals, TruffleString.CodeRange codeRange) {
        this.inputSkipIntl(locals, this.isForward(), codeRange);
    }

    public void inputSkipReverse(TRegexExecutorLocals locals, TruffleString.CodeRange codeRange) {
        this.inputSkipIntl(locals, !this.isForward(), codeRange);
    }

    protected void inputSkipIntl(TRegexExecutorLocals locals, boolean forward, TruffleString.CodeRange codeRange) {
        this.inputIncRaw(locals, this.inputGetCodePointSize(locals, forward, codeRange), forward);
    }

    public int inputGetCodePointSize(TRegexExecutorLocals locals, TruffleString.CodeRange codeRange) {
        return this.inputGetCodePointSize(locals, this.isForward(), codeRange);
    }

    public int inputGetCodePointSize(TRegexExecutorLocals locals, boolean forward, TruffleString.CodeRange codeRange) {
        CompilerAsserts.partialEvaluationConstant(forward);
        CompilerAsserts.partialEvaluationConstant((Object)codeRange);
        if (this.isUTF16()) {
            if (codeRange == TruffleString.CodeRange.VALID) {
                return Encodings.Encoding.UTF16.isHighSurrogate(this.inputReadRaw(locals, forward), forward) ? 2 : 1;
            }
            if (codeRange == TruffleString.CodeRange.BROKEN) {
                if (Encodings.Encoding.UTF16.isHighSurrogate(this.inputReadRaw(locals, forward), forward) && this.inputHasNext(locals, TRegexExecutorNode.inputIncRaw(locals.getIndex(), 1, forward), forward) && Encodings.Encoding.UTF16.isLowSurrogate(this.inputReadRaw(locals, TRegexExecutorNode.inputIncRaw(locals.getIndex(), 1, forward), forward), forward)) {
                    return 2;
                }
                return 1;
            }
            return 1;
        }
        if (this.isUTF8()) {
            int c2;
            if (codeRange == TruffleString.CodeRange.ASCII) {
                return 1;
            }
            if (forward) {
                int c3 = this.inputReadRaw(locals, true);
                if (c3 < 128) {
                    return 1;
                }
                this.getBMPProfile().enter();
                return TRegexExecutorNode.inputUTF8NumberOfLeadingOnes(c3);
            }
            int i2 = 0;
            do {
                c2 = this.inputReadRaw(locals, TRegexExecutorNode.inputIncRaw(locals.getIndex(), i2, false), false);
            } while (this.inputHasNext(locals, TRegexExecutorNode.inputIncRaw(locals.getIndex(), ++i2, false), false) && TRegexExecutorNode.inputUTF8IsTrailingByte(c2));
            return i2;
        }
        assert (this.getEncoding() == Encodings.UTF_16_RAW || this.getEncoding() == Encodings.UTF_32 || this.getEncoding() == Encodings.LATIN_1 || this.getEncoding() == Encodings.BYTES || this.getEncoding() == Encodings.ASCII);
        return 1;
    }

    public void inputIncRaw(TRegexExecutorLocals locals) {
        this.inputIncRaw(locals, 1);
    }

    public void inputIncRaw(TRegexExecutorLocals locals, int offset) {
        this.inputIncRaw(locals, offset, this.isForward());
    }

    public void inputIncRaw(TRegexExecutorLocals locals, int offset, boolean forward) {
        locals.setIndex(TRegexExecutorNode.inputIncRaw(locals.getIndex(), offset, forward));
    }

    public int inputIncRaw(int index) {
        return TRegexExecutorNode.inputIncRaw(index, 1, this.isForward());
    }

    public int inputIncRaw(int index, int offset) {
        return TRegexExecutorNode.inputIncRaw(index, offset, this.isForward());
    }

    public static int inputIncRaw(int index, int offset, boolean forward) {
        assert (offset >= 0);
        return forward ? index + offset : index - offset;
    }

    public void inputIncNextIndexRaw(TRegexExecutorLocals locals) {
        this.inputIncNextIndexRaw(locals, 1);
    }

    public void inputIncNextIndexRaw(TRegexExecutorLocals locals, int offset) {
        locals.setNextIndex(TRegexExecutorNode.inputIncRaw(locals.getIndex(), offset, this.isForward()));
    }

    public int countUpTo(TRegexExecutorLocals locals, int max, int nCodePoints, TruffleString.CodeRange codeRange) {
        CompilerAsserts.partialEvaluationConstant(nCodePoints);
        if (nCodePoints > 0) {
            int i2;
            assert (this.isForward());
            int index = locals.getIndex();
            for (i2 = 0; locals.getIndex() < max && i2 < nCodePoints; ++i2) {
                this.inputSkipIntl(locals, true, codeRange);
            }
            locals.setIndex(index);
            return i2;
        }
        return 0;
    }

    public int rewindUpTo(TRegexExecutorLocals locals, int min, int nCodePoints, TruffleString.CodeRange codeRange) {
        CompilerAsserts.partialEvaluationConstant(nCodePoints);
        if (nCodePoints > 0) {
            int i2;
            assert (this.isForward());
            for (i2 = 0; locals.getIndex() > min && i2 < nCodePoints; ++i2) {
                this.inputSkipIntl(locals, false, codeRange);
            }
            return i2;
        }
        return 0;
    }

    @Override
    public boolean isSimpleCG() {
        throw CompilerDirectives.shouldNotReachHere();
    }
}

