/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public final class ConditionalBackReferenceGroup
extends Group {
    private final int referencedGroupNumber;

    public ConditionalBackReferenceGroup(int referencedGroupNumber) {
        this.referencedGroupNumber = referencedGroupNumber;
    }

    private ConditionalBackReferenceGroup(ConditionalBackReferenceGroup copy) {
        super(copy);
        this.referencedGroupNumber = copy.referencedGroupNumber;
    }

    public int getReferencedGroupNumber() {
        return this.referencedGroupNumber;
    }

    @Override
    public ConditionalBackReferenceGroup copy(RegexAST ast) {
        return ast.register(new ConditionalBackReferenceGroup(this));
    }

    @Override
    public ConditionalBackReferenceGroup copyRecursive(RegexAST ast, CompilationBuffer compilationBuffer) {
        ConditionalBackReferenceGroup copy = this.copy(ast);
        for (Sequence s2 : this.getAlternatives()) {
            copy.add(s2.copyRecursive(ast, compilationBuffer));
        }
        return copy;
    }

    @Override
    public boolean equalsSemantic(RegexASTNode obj, boolean ignoreQuantifier) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConditionalBackReferenceGroup)) {
            return false;
        }
        ConditionalBackReferenceGroup o2 = (ConditionalBackReferenceGroup)obj;
        assert (this.size() == 2 && o2.size() == 2);
        assert (this.getGroupNumber() == -1 && o2.getGroupNumber() == -1);
        if (this.referencedGroupNumber != o2.referencedGroupNumber || this.isLoop() != o2.isLoop() || !ignoreQuantifier && !this.quantifierEquals(o2)) {
            return false;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.getAlternatives().get(i2).equalsSemantic(o2.getAlternatives().get(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "(?(" + this.referencedGroupNumber + ")" + this.alternativesToString() + ")" + this.loopToString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return super.toJson("ConditionalBackReferenceGroup").append(Json.prop("referencedGroupNumber", this.referencedGroupNumber), Json.prop("isLoop", this.isLoop()), Json.prop("isExpandedLoop", this.isExpandedQuantifier()), Json.prop("alternatives", this.getAlternatives()));
    }
}

