/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors.java;

import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.errors.JavaErrorMessages;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.RegexValidator;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.flavors.java.JavaFlags;
import com.oracle.truffle.regex.tregex.parser.flavors.java.JavaRegexLexer;
import java.util.ArrayList;

public class JavaRegexValidator
implements RegexValidator {
    private final RegexSource source;
    private final JavaRegexLexer lexer;

    public static JavaRegexValidator createValidator(RegexSource source, CompilationBuffer compilationBuffer) throws RegexSyntaxException {
        return new JavaRegexValidator(source, compilationBuffer);
    }

    public JavaRegexValidator(RegexSource source, CompilationBuffer compilationBuffer) throws RegexSyntaxException {
        this.source = source;
        this.lexer = new JavaRegexLexer(source, JavaFlags.parseFlags(source.getFlags()), compilationBuffer);
    }

    @Override
    public void validate() throws RegexSyntaxException {
        ArrayList<RegexStackElem> syntaxStack = new ArrayList<RegexStackElem>();
        CurTermState curTermState = CurTermState.Null;
        Token token = null;
        while (this.lexer.hasNext()) {
            Token last = token;
            token = this.lexer.next();
            block0 : switch (token.kind) {
                case A: 
                case Z: 
                case z: 
                case caret: 
                case dollar: 
                case wordBoundary: 
                case nonWordBoundary: 
                case charClass: 
                case classSet: 
                case linebreak: 
                case backReference: {
                    curTermState = CurTermState.Other;
                    break;
                }
                case quantifier: {
                    Token.Quantifier quantifier = (Token.Quantifier)token;
                    if (last instanceof Token.Quantifier && quantifier.isSingleChar()) {
                        throw this.syntaxErrorHere(JavaErrorMessages.danglingMetaCharacter(quantifier));
                    }
                    if (curTermState == CurTermState.Null && quantifier.isSingleChar()) {
                        throw this.syntaxErrorHere(JavaErrorMessages.danglingMetaCharacter(quantifier));
                    }
                    if (!quantifier.isPossessive()) break;
                    throw new UnsupportedRegexException("possessive quantifiers are not supported");
                }
                case alternation: 
                case inlineFlags: {
                    curTermState = CurTermState.Null;
                    break;
                }
                case captureGroupBegin: 
                case nonCaptureGroupBegin: {
                    curTermState = CurTermState.Null;
                    syntaxStack.add(RegexStackElem.Group);
                    break;
                }
                case lookAheadAssertionBegin: {
                    curTermState = CurTermState.Null;
                    syntaxStack.add(RegexStackElem.LookAheadAssertion);
                    break;
                }
                case lookBehindAssertionBegin: {
                    curTermState = CurTermState.Null;
                    syntaxStack.add(RegexStackElem.LookBehindAssertion);
                    break;
                }
                case groupEnd: {
                    if (syntaxStack.isEmpty()) {
                        throw this.syntaxErrorHere("Unmatched ')'");
                    }
                    RegexStackElem poppedElem = (RegexStackElem)((Object)syntaxStack.remove(syntaxStack.size() - 1));
                    switch (poppedElem.ordinal()) {
                        case 1: {
                            curTermState = CurTermState.LookAheadAssertion;
                            break block0;
                        }
                        case 2: {
                            curTermState = CurTermState.LookBehindAssertion;
                            break block0;
                        }
                        case 0: {
                            curTermState = CurTermState.Other;
                        }
                    }
                }
            }
        }
        if (!syntaxStack.isEmpty()) {
            throw this.syntaxErrorHere("Unclosed group");
        }
    }

    private RegexSyntaxException syntaxErrorHere(String message) {
        return RegexSyntaxException.createPattern(this.source, message, this.lexer.getLastTokenPosition());
    }

    private static enum CurTermState {
        Null,
        LookAheadAssertion,
        LookBehindAssertion,
        Other;

    }

    private static enum RegexStackElem {
        Group,
        LookAheadAssertion,
        LookBehindAssertion;

    }
}

