/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.hotspot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.runtime.OptimizedFastThreadLocal;
import com.oracle.truffle.runtime.hotspot.HotSpotTruffleRuntime;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;

final class HotSpotFastThreadLocal
extends OptimizedFastThreadLocal {
    static final HotSpotFastThreadLocal SINGLETON = new HotSpotFastThreadLocal();
    private static final ThreadLocal<Object[]> VIRTUAL_THREADS_THREAD_LOCAL = new ThreadLocal();
    private static final HotSpotJVMCIRuntime RUNTIME = HotSpotJVMCIRuntime.runtime();

    HotSpotFastThreadLocal() {
    }

    @Override
    public void set(Object[] data) {
        HotSpotFastThreadLocal.setJVMCIReservedReference(data);
    }

    @Override
    public Object[] get() {
        return HotSpotFastThreadLocal.getJVMCIReservedReference();
    }

    static Object[] getJVMCIReservedReference() {
        if (HotSpotTruffleRuntime.getRuntime().bypassedReservedOop()) {
            return (Object[])RUNTIME.getThreadLocalObject(0);
        }
        return null;
    }

    static void setJVMCIReservedReference(Object[] v2) {
        if (!HotSpotTruffleRuntime.getRuntime().bypassedReservedOop()) {
            throw CompilerDirectives.shouldNotReachHere("Bypassed reserved oop without compiler initialization triggered.");
        }
        RUNTIME.setThreadLocalObject(0, (Object)v2);
    }

    static void unmount() {
        Object[] threadLocals = (Object[])RUNTIME.getThreadLocalObject(0);
        VIRTUAL_THREADS_THREAD_LOCAL.set(threadLocals);
    }

    static void mount() {
        Object[] threadLocals = VIRTUAL_THREADS_THREAD_LOCAL.get();
        RUNTIME.setThreadLocalObject(0, (Object)threadLocals);
    }
}

