/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.client.gui.component.input;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class WidgetDialog
extends AbstractWidget
implements GuiEventListener {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"integratedscripting", (String)"textures/gui/dialog.png");
    public static final int WIDTH = 216;
    private static final int HEIGHT = 71;
    private final Font font;
    private final Screen parent;
    private final Component title;
    private final Component message;
    private final ButtonText buttonConfirm;
    private final ButtonText buttonCancel;

    public WidgetDialog(Font font, int x2, int y2, Screen parent, Component title, Component message, Component confirm, Component cancel, Button.OnPress confirmCallback, Button.OnPress cancelCallback) {
        super(x2, y2, 216, 71, message);
        this.font = font;
        this.parent = parent;
        this.title = title;
        this.message = message;
        this.buttonConfirm = new ButtonText(x2 + 50, y2 + 71 - 15 - 5, 50, 15, confirm, confirm, confirmCallback, true);
        this.buttonCancel = new ButtonText(x2 + 216 - 50 - 50, y2 + 71 - 15 - 5, 50, 15, cancel, cancel, cancelCallback, true);
    }

    protected void drawBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fill(0, 0, this.parent.width, this.parent.height, IModHelpers.get().getBaseHelpers().RGBAToInt(50, 50, 50, 100));
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX(), this.getY(), 0.0f, 0.0f, 216, 71, 256, 256);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttonConfirm.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttonCancel.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.getX() + this.width / 2, this.getY() + 4, ARGB.opaque((int)0xFFFFFF));
        FormattedCharSequence formattedcharsequence = this.message.getVisualOrderText();
        guiGraphics.drawString(this.font, this.message, this.getX() + this.width / 2 - this.font.width(formattedcharsequence) / 2, this.getY() + 25, ARGB.opaque((int)0x404040), false);
    }

    public boolean mouseClicked(MouseButtonEvent mouse, boolean isDoubleClick) {
        return this.buttonConfirm.mouseClicked(mouse, isDoubleClick) || this.buttonCancel.mouseClicked(mouse, isDoubleClick) || super.mouseClicked(mouse, isDoubleClick);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, this.message);
    }
}

