/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.operator.CurriedOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.evaluate.ScriptHelpers;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.proxy.ProxyObject;

public class ValueObjectProxyObject<V extends IValue>
implements ProxyObject {
    private final Context context;
    private final IEvaluationExceptionFactory exceptionFactory;
    private final ValueObjectTypeBase<V> valueType;
    private final V value;
    private final Map<String, IOperator> methods;
    private final String memberNbtKey;
    private final ValueDeseralizationContext valueDeseralizationContext;
    @Nullable
    private Value memberNbtValue;

    public ValueObjectProxyObject(Context context, IEvaluationExceptionFactory exceptionFactory, String memberNbtKey, Map<String, IOperator> methods, ValueObjectTypeBase<V> valueType, V value, ValueDeseralizationContext valueDeseralizationContext) {
        this.context = context;
        this.exceptionFactory = exceptionFactory;
        this.valueType = valueType;
        this.methods = methods;
        this.value = value;
        this.memberNbtKey = memberNbtKey;
        this.valueDeseralizationContext = valueDeseralizationContext;
    }

    public ValueObjectTypeBase<V> getValueType() {
        return this.valueType;
    }

    @Nullable
    public IValue getValue() {
        return this.value;
    }

    @Override
    public Object getMember(String key) {
        try {
            IOperator operator = this.methods.get(key);
            if (operator != null) {
                CurriedOperator curriedOperator = new CurriedOperator(operator, new IVariable[]{new Variable(this.value)});
                return ValueTranslators.REGISTRY.translateToGraal(this.context, ValueTypeOperator.ValueOperator.of((IOperator)curriedOperator), this.exceptionFactory, this.valueDeseralizationContext);
            }
            if (key.equals(this.memberNbtKey)) {
                if (this.memberNbtValue == null) {
                    CompoundTag tag = IModHelpers.get().getMinecraftHelpers().valueOutputToNbt(o2 -> this.valueType.serialize(o2, this.value), this.valueDeseralizationContext.holderLookupProvider());
                    this.memberNbtValue = ValueTranslators.TRANSLATOR_NBT.translateTag(this.context, (Tag)(tag.contains("v") ? tag.get("v") : tag), this.exceptionFactory, this.valueDeseralizationContext);
                }
                return this.memberNbtValue;
            }
            return null;
        }
        catch (EvaluationException e2) {
            ScriptHelpers.sneakyThrow(e2);
            return null;
        }
    }

    @Override
    public Object getMemberKeys() {
        return new String[]{this.memberNbtKey};
    }

    @Override
    public boolean hasMember(String key) {
        return key.equals(this.memberNbtKey) || this.methods != null && this.methods.containsKey(key);
    }

    @Override
    public void putMember(String key, Value value) {
        ScriptHelpers.sneakyThrow(this.exceptionFactory.createError(Component.translatable((String)"valuetype.integratedscripting.error.translation.proxyobject_putMember", (Object[])new Object[]{key, this.valueType.getTypeName()})));
    }
}

