/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.evaluate.translation.translator;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.compress.utils.Lists;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integratedscripting.api.evaluate.translation.IEvaluationExceptionFactory;
import org.cyclops.integratedscripting.api.evaluate.translation.IValueTranslator;
import org.cyclops.integratedscripting.evaluate.translation.ValueTranslators;
import org.cyclops.integratedscripting.evaluate.translation.translator.OperatorProxyExecutable;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Context;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.PolyglotException;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.Value;

public class ValueTranslatorOperator
implements IValueTranslator<ValueTypeOperator.ValueOperator> {
    @Override
    public IValueType<?> getValueType() {
        return ValueTypes.OPERATOR;
    }

    @Override
    public boolean canHandleGraalValue(Value value) {
        return value.canExecute();
    }

    @Override
    public boolean canTranslateNbt() {
        return false;
    }

    @Override
    public Value translateToGraal(Context context, ValueTypeOperator.ValueOperator value, IEvaluationExceptionFactory exceptionFactory, ValueDeseralizationContext valueDeseralizationContext) throws EvaluationException {
        return context.asValue(new OperatorProxyExecutable(context, value, exceptionFactory, valueDeseralizationContext));
    }

    @Override
    public ValueTypeOperator.ValueOperator translateFromGraal(Context context, Value value, IEvaluationExceptionFactory exceptionFactory, ValueDeseralizationContext valueDeseralizationContext) throws EvaluationException {
        if (value.isProxyObject()) {
            try {
                OperatorProxyExecutable cast = (OperatorProxyExecutable)value.asProxyObject();
                return cast.getValue();
            }
            catch (ClassCastException cast) {
                // empty catch block
            }
        }
        int argCount = value.getMember("length").asInt();
        IValueType[] inputValueTypes = new IValueType[argCount];
        for (int i2 = 0; i2 < argCount; ++i2) {
            inputValueTypes[i2] = ValueTypes.CATEGORY_ANY;
        }
        return ValueTypeOperator.ValueOperator.of((IOperator)new GraalOperator(inputValueTypes, args -> {
            Value returnValue;
            IVariable[] variables = args.getVariables();
            Value[] values = new Value[variables.length];
            context.resetLimits();
            for (int i2 = 0; i2 < variables.length; ++i2) {
                try {
                    values[i2] = ValueTranslators.REGISTRY.translateToGraal(context, variables[i2].getValue(), exceptionFactory, valueDeseralizationContext);
                    continue;
                }
                catch (PolyglotException e2) {
                    throw exceptionFactory.createError(e2.getMessage());
                }
            }
            try {
                returnValue = value.execute(values);
            }
            catch (PolyglotException e3) {
                throw exceptionFactory.createError(e3.getMessage());
            }
            return ValueTranslators.REGISTRY.translateFromGraal(context, returnValue, exceptionFactory, valueDeseralizationContext);
        }));
    }

    @Override
    public Tag translateToNbt(Context context, ValueTypeOperator.ValueOperator value, IEvaluationExceptionFactory exceptionFactory) throws EvaluationException {
        throw exceptionFactory.createError(Component.translatable((String)"valuetype.integratedscripting.error.translation.unsupported_translateToNbt", (Object[])new Object[]{Component.translatable((String)value.getType().getTranslationKey()), value.getType().toCompactString((IValue)value)}));
    }

    static {
        Operators.REGISTRY.registerSerializer((IOperatorSerializer)new GraalOperator.Serializer());
    }

    public static class GraalOperator
    extends OperatorBase {
        protected GraalOperator(IValueType[] inputTypes, OperatorBase.IFunction function) {
            super("graal", "graal", "graal", null, false, inputTypes, (IValueType)ValueTypes.CATEGORY_ANY, function, null);
        }

        protected String getUnlocalizedType() {
            return "integratedscript";
        }

        protected String getModId() {
            return "integratedscripting";
        }

        public static class Serializer
        implements IOperatorSerializer<GraalOperator> {
            public boolean canHandle(IOperator operator) {
                return operator instanceof GraalOperator;
            }

            public ResourceLocation getUniqueName() {
                return ResourceLocation.fromNamespaceAndPath((String)"integratedscripting", (String)"graal");
            }

            public void serialize(ValueOutput valueOutput, GraalOperator operator) {
                ValueOutput.TypedOutputList list = valueOutput.list("v", (Codec)Codec.STRING);
                for (int i2 = 0; i2 < operator.getInputTypes().length; ++i2) {
                    list.add((Object)operator.getInputTypes()[i2].getUniqueName().toString());
                }
            }

            public GraalOperator deserialize(ValueInput valueInput) throws EvaluationException {
                ArrayList inputTypes = Lists.newArrayList();
                for (String value : (ValueInput.TypedInputList)valueInput.list("v", (Codec)Codec.STRING).orElseThrow()) {
                    inputTypes.add(ValueTypes.REGISTRY.getValueType(ResourceLocation.parse((String)value)));
                }
                return new GraalOperator(inputTypes.toArray(new IValueType[0]), variables -> {
                    throw new EvaluationException(Component.translatable((String)"operator.integratedscripting.error.no_graal_serialization"));
                });
            }
        }
    }
}

