/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ArityException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.DirectCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.IndirectCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.utilities.TriState;

@ExportLibrary(value=InteropLibrary.class)
final class PolyglotParsedEval
implements TruffleObject {
    final PolyglotLanguageContext languageContext;
    final Source source;
    final CallTarget target;

    PolyglotParsedEval(PolyglotLanguageContext languageContext, Source source, CallTarget target) {
        this.languageContext = languageContext;
        this.source = source;
        this.target = target;
    }

    @ExportMessage
    static boolean isExecutable(PolyglotParsedEval eval) {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static int identityHashCode(PolyglotParsedEval receiver) {
        return Objects.hash(receiver.languageContext, System.identityHashCode(receiver.target));
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    static String toDisplayString(PolyglotParsedEval receiver, boolean sideEffects) {
        return "Parsed[Source=" + String.valueOf(receiver.source) + "]";
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doDefault(PolyglotParsedEval receiver, PolyglotParsedEval other) {
            return receiver.target == other.target && receiver.languageContext == other.languageContext ? TriState.TRUE : TriState.FALSE;
        }

        @Fallback
        static TriState doOther(PolyglotParsedEval receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }

    @ExportMessage
    static class Execute {
        Execute() {
        }

        @Specialization(guards={"eval.target == callNode.getCallTarget()"}, limit="5")
        static Object doCached(PolyglotParsedEval eval, Object[] args, @Cached(value="create(eval.target)") DirectCallNode callNode) throws ArityException {
            Object result = callNode.call(args);
            if (eval.source.isInteractive()) {
                PolyglotContextImpl.printResult(eval.languageContext, result);
            }
            return result;
        }

        @Specialization(replaces={"doCached"})
        static Object doIndirect(PolyglotParsedEval eval, Object[] args, @Cached IndirectCallNode callNode) {
            Object result = callNode.call(eval.target, args);
            if (eval.source.isInteractive()) {
                PolyglotContextImpl.printResult(eval.languageContext, result);
            }
            return result;
        }
    }
}

