/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.SourceCacheListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;

final class PolyglotSourceCache {
    private final Cache strongCache;
    private final Cache weakCache;
    private SourceCacheListener sourceCacheListener;

    PolyglotSourceCache(SourceCacheListener sourceCacheListener) {
        this.sourceCacheListener = sourceCacheListener;
        this.weakCache = new WeakCache();
        this.strongCache = new StrongCache();
    }

    void patch(SourceCacheListener listener) {
        this.sourceCacheListener = listener;
    }

    CallTarget parseCached(PolyglotLanguageContext context, Source source, String[] argumentNames) {
        CallTarget target;
        if (source.isCached()) {
            Cache strong = this.strongCache;
            boolean useStrong = context.getEngine().storeEngine;
            if ((useStrong || !strong.isEmpty()) && (target = strong.lookup(context, source, argumentNames, useStrong)) != null) {
                return target;
            }
            target = this.weakCache.lookup(context, source, argumentNames, true);
        } else {
            long parseStart = 0L;
            if (this.sourceCacheListener != null) {
                parseStart = System.currentTimeMillis();
            }
            target = PolyglotSourceCache.parseImpl(context, argumentNames, source);
            if (this.sourceCacheListener != null) {
                this.sourceCacheListener.onCacheMiss(source, target, SourceCacheListener.CacheType.UNCACHED, parseStart);
            }
        }
        return target;
    }

    void listCachedSources(PolyglotImpl polyglot, Collection<Object> source) {
        this.strongCache.listSources(polyglot, source);
        this.weakCache.listSources(polyglot, source);
    }

    private static CallTarget parseImpl(PolyglotLanguageContext context, String[] argumentNames, Source source) {
        PolyglotSourceCache.validateSource(context, source);
        CallTarget parsedTarget = EngineAccessor.LANGUAGE.parse(context.requireEnv(), source, null, argumentNames);
        if (parsedTarget == null) {
            throw new IllegalStateException(String.format("Parsing resulted in a null CallTarget for %s.", source));
        }
        return parsedTarget;
    }

    private static void validateSource(PolyglotLanguageContext context, Source source) {
        boolean expectCharacters;
        if (!source.hasBytes() && !source.hasCharacters()) {
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The source does not specify characters nor bytes.", new Object[0]));
        }
        String mimeType = source.getMimeType();
        Set<String> mimeTypes = context.language.cache.getMimeTypes();
        if (mimeType != null && !mimeTypes.contains(mimeType)) {
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s does not support MIME type %s. Supported MIME types are %s.", source.getLanguage(), mimeType, mimeTypes));
        }
        String activeMimeType = mimeType;
        if (activeMimeType == null) {
            activeMimeType = context.language.cache.getDefaultMimeType();
        }
        boolean bl = expectCharacters = activeMimeType != null ? context.language.cache.isCharacterMimeType(activeMimeType) : true;
        if (mimeType != null && source.hasCharacters() != expectCharacters) {
            if (source.hasBytes()) {
                throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. MIME type '%s' is character based for language '%s' but the source contents are byte based.", mimeType, source.getLanguage()));
            }
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. MIME type '%s' is byte based for language '%s' but the source contents are character based.", mimeType, source.getLanguage()));
        }
        if (source.hasCharacters() != expectCharacters) {
            HashSet<String> binaryMimeTypes = new HashSet<String>();
            HashSet<String> characterMimeTypes = new HashSet<String>();
            for (String supportedMimeType : mimeTypes) {
                if (context.language.cache.isCharacterMimeType(supportedMimeType)) {
                    characterMimeTypes.add(supportedMimeType);
                    continue;
                }
                binaryMimeTypes.add(supportedMimeType);
            }
            if (expectCharacters) {
                if (binaryMimeTypes.isEmpty()) {
                    throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s only supports character based sources but a binary based source was provided.", source.getLanguage()));
                }
                throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s expects character based sources by default but a binary based source was provided. Provide a binary based source instead or specify a MIME type for the source. Available MIME types for binary based sources are %s.", source.getLanguage(), binaryMimeTypes));
            }
            if (characterMimeTypes.isEmpty()) {
                throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s only supports binary based sources but a character based source was provided.", source.getLanguage()));
            }
            throw PolyglotEngineException.illegalArgument(String.format("Error evaluating the source. The language %s expects character based sources by default but a binary based source was provided. Provide a character based source instead or specify a MIME type for the source. Available MIME types for character based sources are %s.", source.getLanguage(), characterMimeTypes));
        }
    }

    private final class WeakCache
    extends Cache {
        private final ConcurrentHashMap<WeakSourceKey, WeakCacheValue> sourceCache = new ConcurrentHashMap();
        private final ReferenceQueue<Source> deadSources = new ReferenceQueue();

        private WeakCache() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        CallTarget lookup(PolyglotLanguageContext context, Source source, String[] argumentNames, boolean parse) {
            this.cleanupStaleEntries();
            Object sourceId = EngineAccessor.SOURCE.getSourceIdentifier(source);
            Source sourceValue = EngineAccessor.SOURCE.copySource(source);
            WeakSourceKey ref = new WeakSourceKey(new SourceKey(sourceId, argumentNames), source, this.deadSources);
            WeakCacheValue value = this.sourceCache.get(ref);
            if (value == null) {
                if (!parse) return null;
                long parseStart = 0L;
                if (PolyglotSourceCache.this.sourceCacheListener != null) {
                    parseStart = System.currentTimeMillis();
                }
                try {
                    value = new WeakCacheValue(PolyglotSourceCache.parseImpl(context, argumentNames, sourceValue), sourceValue);
                    WeakCacheValue prev = this.sourceCache.putIfAbsent(ref, value);
                    if (prev != null) {
                        value = prev;
                    }
                    if (PolyglotSourceCache.this.sourceCacheListener == null) return value.target;
                    PolyglotSourceCache.this.sourceCacheListener.onCacheMiss(source, value.target, SourceCacheListener.CacheType.WEAK, parseStart);
                    return value.target;
                }
                catch (Throwable t2) {
                    if (PolyglotSourceCache.this.sourceCacheListener == null) throw t2;
                    PolyglotSourceCache.this.sourceCacheListener.onCacheFail(context.context.layer, source, SourceCacheListener.CacheType.WEAK, parseStart, t2);
                    throw t2;
                }
            } else {
                value.hits.incrementAndGet();
                if (PolyglotSourceCache.this.sourceCacheListener == null) return value.target;
                PolyglotSourceCache.this.sourceCacheListener.onCacheHit(source, value.target, SourceCacheListener.CacheType.WEAK, value.hits.get());
            }
            return value.target;
        }

        @Override
        boolean isEmpty() {
            return this.sourceCache.isEmpty();
        }

        @Override
        void listSources(PolyglotImpl polyglot, Collection<Object> sources) {
            this.cleanupStaleEntries();
            for (WeakCacheValue value : this.sourceCache.values()) {
                sources.add(PolyglotImpl.getOrCreatePolyglotSource(polyglot, value.source));
            }
        }

        private void cleanupStaleEntries() {
            WeakSourceKey sourceRef;
            while ((sourceRef = (WeakSourceKey)this.deadSources.poll()) != null) {
                WeakCacheValue value = this.sourceCache.remove(sourceRef);
                if (value == null || PolyglotSourceCache.this.sourceCacheListener == null) continue;
                PolyglotSourceCache.this.sourceCacheListener.onCacheEvict(value.source, value.target, SourceCacheListener.CacheType.WEAK, value.hits.get());
            }
        }
    }

    private static abstract class Cache {
        private Cache() {
        }

        abstract boolean isEmpty();

        abstract CallTarget lookup(PolyglotLanguageContext var1, Source var2, String[] var3, boolean var4);

        abstract void listSources(PolyglotImpl var1, Collection<Object> var2);
    }

    private final class StrongCache
    extends Cache {
        private final ConcurrentHashMap<SourceKey, StrongCacheValue> sourceCache = new ConcurrentHashMap();

        private StrongCache() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        CallTarget lookup(PolyglotLanguageContext context, Source source, String[] argumentNames, boolean parse) {
            SourceKey key = new SourceKey(source, argumentNames);
            StrongCacheValue value = this.sourceCache.get(key);
            if (value == null) {
                if (!parse) return null;
                long parseStart = 0L;
                if (PolyglotSourceCache.this.sourceCacheListener != null) {
                    parseStart = System.currentTimeMillis();
                }
                try {
                    value = new StrongCacheValue(PolyglotSourceCache.parseImpl(context, argumentNames, source));
                    StrongCacheValue prevValue = this.sourceCache.putIfAbsent(key, value);
                    if (prevValue != null) {
                        value = prevValue;
                    }
                    if (PolyglotSourceCache.this.sourceCacheListener == null) return value.target;
                    PolyglotSourceCache.this.sourceCacheListener.onCacheMiss(source, value.target, SourceCacheListener.CacheType.STRONG, parseStart);
                    return value.target;
                }
                catch (Throwable t2) {
                    if (PolyglotSourceCache.this.sourceCacheListener == null) throw t2;
                    PolyglotSourceCache.this.sourceCacheListener.onCacheFail(context.context.layer, source, SourceCacheListener.CacheType.STRONG, parseStart, t2);
                    throw t2;
                }
            } else {
                value.hits.incrementAndGet();
                if (PolyglotSourceCache.this.sourceCacheListener == null) return value.target;
                PolyglotSourceCache.this.sourceCacheListener.onCacheHit(source, value.target, SourceCacheListener.CacheType.STRONG, value.hits.get());
            }
            return value.target;
        }

        @Override
        boolean isEmpty() {
            return this.sourceCache.isEmpty();
        }

        @Override
        void listSources(PolyglotImpl polyglot, Collection<Object> sources) {
            for (SourceKey key : this.sourceCache.keySet()) {
                sources.add(PolyglotImpl.getOrCreatePolyglotSource(polyglot, (Source)key.key));
            }
        }
    }

    private static final class WeakSourceKey
    extends WeakReference<Source> {
        final SourceKey key;

        WeakSourceKey(SourceKey key, Source value, ReferenceQueue<? super Source> q2) {
            super(value, q2);
            this.key = key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof WeakSourceKey) {
                WeakSourceKey other = (WeakSourceKey)obj;
                return this.key.equals(other.key);
            }
            return false;
        }
    }

    private static final class SourceKey {
        private final Object key;
        private final String[] arguments;

        SourceKey(Object key, String[] arguments) {
            this.key = key;
            this.arguments = arguments != null && arguments.length == 0 ? null : arguments;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.key.hashCode();
            result = 31 * result + Arrays.hashCode(this.arguments);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceKey) {
                SourceKey other = (SourceKey)obj;
                return this.key.equals(other.key) && Arrays.equals(this.arguments, other.arguments);
            }
            return false;
        }
    }

    static class WeakCacheValue {
        final CallTarget target;
        final Source source;
        final AtomicLong hits = new AtomicLong();

        WeakCacheValue(CallTarget target, Source source) {
            this.target = target;
            this.source = source;
        }
    }

    static class StrongCacheValue {
        final CallTarget target;
        final AtomicLong hits = new AtomicLong();

        StrongCacheValue(CallTarget target) {
            this.target = target;
        }
    }
}

