/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.GuestHostLanguage;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotObject;
import com.oracle.truffle.polyglot.enterprise.HSTruffleException;
import com.oracle.truffle.polyglot.enterprise.HSTruffleObject;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

abstract class HSHostLanguageService
extends AbstractPolyglotImpl.AbstractHostLanguageService {
    volatile HSPolyglotObject hostServiceEndpoint;

    HSHostLanguageService(HSPolyglotObject hSPolyglotObject, AbstractPolyglotImpl abstractPolyglotImpl) {
        super(abstractPolyglotImpl);
        this.hostServiceEndpoint = hSPolyglotObject;
    }

    @Override
    public final boolean isHostValue(Object object) {
        return this.isHostObject(object) || this.isHostFunction(object) || this.isHostException(object);
    }

    @Override
    public final boolean isHostException(Object object) {
        if (object instanceof HSTruffleObject || object instanceof HSTruffleException) {
            return this.isHostExceptionImpl(object);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    abstract boolean isHostExceptionImpl(Object var1);

    @Override
    public final boolean isHostFunction(Object object) {
        if (object instanceof HSTruffleObject || object instanceof HSTruffleException) {
            return this.isHostFunctionImpl(object);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    abstract boolean isHostFunctionImpl(Object var1);

    @Override
    public final boolean isHostObject(Object object) {
        if (object instanceof HSTruffleObject || object instanceof HSTruffleException) {
            return this.isHostObjectImpl(object);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    abstract boolean isHostObjectImpl(Object var1);

    @Override
    public final boolean isHostSymbol(Object object) {
        if (object instanceof HSTruffleObject || object instanceof HSTruffleException) {
            return this.isHostSymbolImpl(object);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    abstract boolean isHostSymbolImpl(Object var1);

    @Override
    public final boolean isHostProxy(Object object) {
        if (object instanceof HSTruffleObject || object instanceof HSTruffleException) {
            return this.isHostProxyImpl(object);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    abstract boolean isHostProxyImpl(Object var1);

    @Override
    @CompilerDirectives.TruffleBoundary
    public abstract Object findStaticClass(Object var1, String var2);

    @Override
    @CompilerDirectives.TruffleBoundary
    public abstract Object createHostAdapter(Object var1, Object[] var2, Object var3);

    @Override
    @CompilerDirectives.TruffleBoundary
    public abstract void addToHostClassPath(Object var1, Object var2);

    @Override
    public final void initializeHostContext(Object object, Object object2, Object object3, ClassLoader classLoader, Predicate<String> predicate, boolean bl, boolean bl2) {
        ((GuestHostLanguage.GuestHostLanguageContext)object2).internalOuterContext = EnterpriseEngineAccessor.ENGINE.getOuterContext(object);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public abstract RuntimeException toHostException(Object var1, Throwable var2);

    @Override
    @CompilerDirectives.TruffleBoundary
    public abstract Error toHostResourceError(Throwable var1);

    @Override
    @CompilerDirectives.TruffleBoundary
    public abstract Throwable unboxHostException(Throwable var1);

    @Override
    public final int findNextGuestToHostStackTraceElement(StackTraceElement stackTraceElement, StackTraceElement[] stackTraceElementArray, int n2) {
        StackTraceElement stackTraceElement2 = stackTraceElement;
        int n3 = n2;
        while (HSHostLanguageService.isGuestToHostReflectiveCall(stackTraceElement2) && n3 < stackTraceElementArray.length) {
            stackTraceElement2 = stackTraceElementArray[n3++];
        }
        if (HSHostLanguageService.isGuestToHostCallFromHostInterop(stackTraceElement2)) {
            return n3 - n2;
        }
        return -1;
    }

    private static boolean isGuestToHostReflectiveCall(StackTraceElement stackTraceElement) {
        switch (stackTraceElement.getClassName()) {
            case "sun.reflect.NativeMethodAccessorImpl": 
            case "sun.reflect.DelegatingMethodAccessorImpl": 
            case "jdk.internal.reflect.NativeMethodAccessorImpl": 
            case "jdk.internal.reflect.DelegatingMethodAccessorImpl": 
            case "java.lang.reflect.Method": {
                return stackTraceElement.getMethodName().startsWith("invoke");
            }
        }
        return false;
    }

    private static boolean isGuestToHostCallFromHostInterop(StackTraceElement stackTraceElement) {
        switch (stackTraceElement.getClassName()) {
            case "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodDesc$SingleMethod$MHBase": {
                return stackTraceElement.getMethodName().equals("invokeHandle");
            }
            case "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodDesc$SingleMethod$MethodReflectImpl": {
                return stackTraceElement.getMethodName().equals("reflectInvoke");
            }
            case "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostObject$GuestToHostCalls": {
                return true;
            }
        }
        return stackTraceElement.getClassName().startsWith("org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.GuestToHostCodeCache$") && stackTraceElement.getMethodName().equals("executeImpl");
    }

    @Override
    public final Object asHostStaticClass(Object object, Class<?> clazz) {
        throw HSHostLanguageService.unsupported();
    }

    @Override
    public final Object unboxHostObject(Object object) {
        throw HSHostLanguageService.unsupported();
    }

    @Override
    public final Object toHostObject(Object object, Object object2) {
        throw HSHostLanguageService.unsupported();
    }

    @Override
    public final Object toGuestValue(Object object, Object object2, boolean bl) {
        if (HSHostLanguageService.isGuestPrimitive(object2) || object2 instanceof TruffleObject) {
            return object2;
        }
        throw HSHostLanguageService.unsupported();
    }

    @Override
    public final Object migrateValue(Object object, Object object2, Object object3) {
        if (this.isHostObject(object2) || this.isHostSymbol(object2)) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (object2 instanceof TruffleObject) {
            if (object3 == null) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            return null;
        }
        assert (InteropLibrary.isValidValue(object2));
        return object2;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public abstract boolean allowsPublicAccess();

    @Override
    public final Object asHostDynamicClass(Object object, Class<?> clazz) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    public final Object findDynamicClass(Object object, String string) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    public final <T> T toHostType(Object object, Object object2, Object object3, Object object4, Class<T> clazz, Type type) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    public final Object unboxProxyObject(Object object) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    public final void pin(Object object) {
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    public final void release() {
        this.hostServiceEndpoint = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void bindToContext(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        if (this.hostServiceEndpoint == null) {
            HSHostLanguageService hSHostLanguageService = this;
            synchronized (hSHostLanguageService) {
                if (this.hostServiceEndpoint == null) {
                    HSPolyglotObject hSPolyglotObject;
                    this.hostServiceEndpoint = hSPolyglotObject = new HSPolyglotObject(jNIEnv, jObject);
                }
            }
        }
    }

    private static boolean isGuestPrimitive(Object object) {
        return object instanceof Integer || object instanceof Double || object instanceof Long || object instanceof Float || object instanceof Boolean || object instanceof Character || object instanceof Byte || object instanceof Short || object instanceof String;
    }

    private static RuntimeException unsupported() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException("Not supported in a spawned isolate.");
    }
}

