/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSSeekableByteChannel;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNICalls;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIClassCache;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.UnmanagedMemory;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;

final class HSSeekableByteChannelGen {
    HSSeekableByteChannelGen() {
    }

    static HSSeekableByteChannel createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSSeekableByteChannel {
        private static final BinaryMarshaller<ByteBuffer> byteBufferWithReadOnlyMarshaller;
        private static final BinaryMarshaller<ByteBuffer> byteBufferWithWriteOnlyMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        @Override
        public void close() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.closeMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean isOpen() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isOpenMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public long position() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticLong(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.positionMethod2, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public SeekableByteChannel position(long l2) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(l2);
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.positionMethod3, jValue);
                return r2.isNonNull() ? HSSeekableByteChannelGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            int n2;
            block17: {
                int n3;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(512);
                int n4 = 4 + byteBufferWithReadOnlyMarshaller.inferSize(byteBuffer);
                if (n4 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n4);
                    n3 = n4;
                } else {
                    cCharPointer = cCharPointer2;
                    n3 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n3, false);){
                        byteBufferWithReadOnlyMarshaller.write((BinaryOutput)object, byteBuffer);
                        int n5 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, Math.max(n5, n3));
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n5, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(2, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.readMethod, (JNI.JValue)object);
                    int n6 = JNIUtil.GetArrayLength(jNIEnv, jByteArray2);
                    if (n3 < n6) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n6);
                    }
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray2, 0, n6, cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer, n6);
                    int n7 = binaryInput.readInt();
                    byteBufferWithReadOnlyMarshaller.readUpdate(binaryInput, byteBuffer);
                    n2 = n7;
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return n2;
        }

        @Override
        public long size() throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticLong(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.sizeMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public SeekableByteChannel truncate(long l2) throws IOException {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = StackValue.get(2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(l2);
                Object r2 = ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.truncateMethod, jValue);
                return r2.isNonNull() ? HSSeekableByteChannelGen.createNativeToHS(jNIEnv, r2) : null;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            int n2;
            block17: {
                int n3;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get(512);
                int n4 = 4 + byteBufferWithWriteOnlyMarshaller.inferSize(byteBuffer);
                if (n4 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n4);
                    n3 = n4;
                } else {
                    cCharPointer = cCharPointer2;
                    n3 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (Object object = BinaryOutput.create(cCharPointer, n3, false);){
                        byteBufferWithWriteOnlyMarshaller.write((BinaryOutput)object, byteBuffer);
                        int n5 = ((BinaryOutput.CCharPointerBinaryOutput)object).getPosition();
                        jByteArray = JNIUtil.NewByteArray(jNIEnv, Math.max(n5, n3));
                        JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n5, ((BinaryOutput.CCharPointerBinaryOutput)object).getAddress());
                    }
                    object = StackValue.get(2, JNI.JValue.class);
                    object.addressOf(0).setJObject(this.getHandle());
                    object.addressOf(1).setJObject(jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.writeMethod, (JNI.JValue)object);
                    int n6 = JNIUtil.GetArrayLength(jNIEnv, jByteArray2);
                    if (n3 < n6) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc(n6);
                    }
                    JNIUtil.GetByteArrayRegion(jNIEnv, jByteArray2, 0, n6, cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create(cCharPointer, n6);
                    int n7 = binaryInput.readInt();
                    byteBufferWithWriteOnlyMarshaller.readUpdate(binaryInput, byteBuffer);
                    n2 = n7;
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free(cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free(cCharPointer);
            }
            return n2;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            byteBufferWithReadOnlyMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, PolyglotJNIConfig.ReadOnly.class);
            byteBufferWithWriteOnlyMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, PolyglotJNIConfig.WriteOnly.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod closeMethod;
            final JNICalls.JNIMethod isOpenMethod;
            final JNICalls.JNIMethod positionMethod2;
            final JNICalls.JNIMethod positionMethod3;
            final JNICalls.JNIMethod readMethod;
            final JNICalls.JNIMethod sizeMethod;
            final JNICalls.JNIMethod truncateMethod;
            final JNICalls.JNIMethod writeMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass(jNIEnv, EndPoint.class);
                this.closeMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "close", "(Ljava/nio/channels/SeekableByteChannel;)V");
                this.isOpenMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "isOpen", "(Ljava/nio/channels/SeekableByteChannel;)Z");
                this.positionMethod2 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "position", "(Ljava/nio/channels/SeekableByteChannel;)J");
                this.positionMethod3 = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "position", "(Ljava/nio/channels/SeekableByteChannel;J)Ljava/nio/channels/SeekableByteChannel;");
                this.readMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "read", "(Ljava/nio/channels/SeekableByteChannel;[B)[B");
                this.sizeMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "size", "(Ljava/nio/channels/SeekableByteChannel;)J");
                this.truncateMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "truncate", "(Ljava/nio/channels/SeekableByteChannel;J)Ljava/nio/channels/SeekableByteChannel;");
                this.writeMethod = JNICalls.JNIMethod.findMethod(jNIEnv, this.endPointClass, true, "write", "(Ljava/nio/channels/SeekableByteChannel;[B)[B");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<ByteBuffer> byteBufferWithReadOnlyMarshaller;
        private static final BinaryMarshaller<ByteBuffer> byteBufferWithWriteOnlyMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void close(SeekableByteChannel seekableByteChannel) {
            try {
                seekableByteChannel.close();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isOpen(SeekableByteChannel seekableByteChannel) {
            try {
                boolean bl = seekableByteChannel.isOpen();
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static long position(SeekableByteChannel seekableByteChannel) {
            try {
                long l2 = seekableByteChannel.position();
                return l2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static SeekableByteChannel position(SeekableByteChannel seekableByteChannel, long l2) {
            try {
                SeekableByteChannel seekableByteChannel2 = seekableByteChannel.position(l2);
                return seekableByteChannel2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] read(SeekableByteChannel seekableByteChannel, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                ByteBuffer byteBuffer = byteBufferWithReadOnlyMarshaller.read(binaryInput);
                int n2 = seekableByteChannel.read(byteBuffer);
                int n3 = 4 + byteBufferWithReadOnlyMarshaller.inferUpdateSize(byteBuffer);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n3 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create(n3) : BinaryOutput.create(byArray);
                byteArrayBinaryOutput.writeInt(n2);
                byteBufferWithReadOnlyMarshaller.writeUpdate(byteArrayBinaryOutput, byteBuffer);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static long size(SeekableByteChannel seekableByteChannel) {
            try {
                long l2 = seekableByteChannel.size();
                return l2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static SeekableByteChannel truncate(SeekableByteChannel seekableByteChannel, long l2) {
            try {
                SeekableByteChannel seekableByteChannel2 = seekableByteChannel.truncate(l2);
                return seekableByteChannel2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] write(SeekableByteChannel seekableByteChannel, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create(byArray);
                ByteBuffer byteBuffer = byteBufferWithWriteOnlyMarshaller.read(binaryInput);
                int n2 = seekableByteChannel.write(byteBuffer);
                int n3 = 4 + byteBufferWithWriteOnlyMarshaller.inferUpdateSize(byteBuffer);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n3 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create(n3) : BinaryOutput.create(byArray);
                byteArrayBinaryOutput.writeInt(n2);
                byteBufferWithWriteOnlyMarshaller.writeUpdate(byteArrayBinaryOutput, byteBuffer);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable(throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            byteBufferWithReadOnlyMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, PolyglotJNIConfig.ReadOnly.class);
            byteBufferWithWriteOnlyMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, PolyglotJNIConfig.WriteOnly.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

