/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeLanguageDispatch;
import com.oracle.truffle.polyglot.enterprise.NativeOptionDescriptorsGen;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolateThread;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectHandles;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.TypeLiteral;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.function.CEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptors;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.WordFactory;

final class NativeLanguageDispatchGen {
    NativeLanguageDispatchGen() {
    }

    static NativeLanguageDispatch createHSToNative(AbstractPolyglotImpl abstractPolyglotImpl) {
        return new StartPoint(abstractPolyglotImpl);
    }

    static NativeLanguageDispatch createNativeToNative(AbstractPolyglotImpl abstractPolyglotImpl) {
        return new StartPoint(abstractPolyglotImpl);
    }

    static NativeLanguageDispatch create(AbstractPolyglotImpl abstractPolyglotImpl) {
        if (ImageInfo.inImageCode()) {
            return NativeLanguageDispatchGen.createNativeToNative(abstractPolyglotImpl);
        }
        return NativeLanguageDispatchGen.createHSToNative(abstractPolyglotImpl);
    }

    private static final class StartPoint
    extends NativeLanguageDispatch {
        private static final BinaryMarshaller<Set<String>> setOfStringMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private final Map<Object, Set<String>> getMimeTypesCache = Collections.synchronizedMap(new WeakHashMap());
        private final Map<Object, OptionDescriptors> getOptionsCache = Collections.synchronizedMap(new WeakHashMap());

        StartPoint(AbstractPolyglotImpl abstractPolyglotImpl) {
            super(abstractPolyglotImpl);
        }

        @Override
        public String getDefaultMimeType(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getDefaultMimeType0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public String getId(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getId0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public String getImplementationName(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getImplementationName0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public Set<String> getMimeTypes(Object object) {
            Set<String> set = this.getMimeTypesCache.get(object);
            if (set == null) {
                NativeObject nativeObject = (NativeObject)object;
                NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
                try {
                    byte[] byArray = StartPoint.getMimeTypes0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                    BinaryInput binaryInput = BinaryInput.create(byArray);
                    set = setOfStringMarshaller.read(binaryInput);
                    this.getMimeTypesCache.put(object, set);
                }
                catch (ForeignException foreignException) {
                    throw foreignException.throwOriginalException(throwableMarshaller);
                }
                finally {
                    nativeIsolateThread.leave();
                }
            }
            return set;
        }

        @Override
        public String getName(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getName0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public OptionDescriptors getOptions(Object object) {
            OptionDescriptors optionDescriptors = this.getOptionsCache.get(object);
            if (optionDescriptors == null) {
                NativeObject nativeObject = (NativeObject)object;
                NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
                try {
                    long l2 = StartPoint.getOptions0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                    optionDescriptors = l2 != 0L ? NativeOptionDescriptorsGen.create(nativeObject.getIsolate(), l2) : null;
                    this.getOptionsCache.put(object, optionDescriptors);
                }
                catch (ForeignException foreignException) {
                    throw foreignException.throwOriginalException(throwableMarshaller);
                }
                finally {
                    nativeIsolateThread.leave();
                }
            }
            return optionDescriptors;
        }

        @Override
        public String getVersion(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getVersion0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public String getWebsite(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getWebsite0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public boolean isInteractive(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                boolean bl = StartPoint.isInteractive0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native String getDefaultMimeType0(long var0, long var2);

        private static native String getId0(long var0, long var2);

        private static native String getImplementationName0(long var0, long var2);

        private static native byte[] getMimeTypes0(long var0, long var2);

        private static native String getName0(long var0, long var2);

        private static native long getOptions0(long var0, long var2);

        private static native String getVersion0(long var0, long var2);

        private static native String getWebsite0(long var0, long var2);

        private static native boolean isInteractive0(long var0, long var2);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            setOfStringMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<Set<String>>(){}, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Set<String>> setOfStringMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getDefaultMimeType0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getDefaultMimeType(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getDefaultMimeType", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getDefaultMimeType(object2);
                jNIMethodScope.setObjectResult(JNIUtil.createHSString(jNIEnv, string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getId0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getId(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getId", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getId(object2);
                jNIMethodScope.setObjectResult(JNIUtil.createHSString(jNIEnv, string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getImplementationName0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getImplementationName(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getImplementationName", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getImplementationName(object2);
                jNIMethodScope.setObjectResult(JNIUtil.createHSString(jNIEnv, string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getMimeTypes0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray getMimeTypes(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getMimeTypes", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get(256);
                Set<String> set = abstractLanguageDispatch.getMimeTypes(object2);
                int n2 = setOfStringMarshaller.inferSize(set);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create(n2) : BinaryOutput.create(cCharPointer, 256, false);){
                    setOfStringMarshaller.write(cCharPointerBinaryOutput, set);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray(jNIEnv, n3);
                    JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n3, cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult(jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getName0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getName(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getName", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getName(object2);
                jNIMethodScope.setObjectResult(JNIUtil.createHSString(jNIEnv, string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getOptions0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static long getOptions(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getOptions", jNIEnv);
            try {
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                OptionDescriptors optionDescriptors = abstractLanguageDispatch.getOptions(object2);
                long l4 = NativeObjectHandles.create(optionDescriptors);
                jNIMethodScope.close();
                return l4;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable(throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return 0L;
                }
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getVersion0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getVersion(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getVersion", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getVersion(object2);
                jNIMethodScope.setObjectResult(JNIUtil.createHSString(jNIEnv, string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_getWebsite0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getWebsite(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::getWebsite", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                String string = abstractLanguageDispatch.getWebsite(object2);
                jNIMethodScope.setObjectResult(JNIUtil.createHSString(jNIEnv, string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeLanguageDispatchGen_00024StartPoint_isInteractive0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean isInteractive(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeLanguageDispatchGen::isInteractive", jNIEnv);
            try {
                boolean bl;
                Object object = NativeObjectHandles.resolve(l3, Object.class);
                AbstractPolyglotImpl.AbstractLanguageDispatch abstractLanguageDispatch = NativeLanguageDispatch.resolveNativeDelegate(object);
                Object object2 = NativeLanguageDispatch.resolveReceiver(object);
                boolean bl2 = bl = abstractLanguageDispatch.isInteractive(object2);
                jNIMethodScope.close();
                return bl2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jNIMethodScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    ForeignException.forThrowable(throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                    return false;
                }
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            setOfStringMarshaller = jNIConfig.lookupMarshaller(new TypeLiteral<Set<String>>(){}, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

