/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api;

import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.LanguageAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;

public final class TruffleThreadBuilder {
    private final Object polyglotLanguageContext;
    private final Runnable runnable;
    private TruffleContext truffleContext;
    private ThreadGroup threadGroup;
    private long stackSize;
    private Runnable beforeEnter;
    private Runnable afterLeave;
    private boolean virtual;

    TruffleThreadBuilder(Object polyglotLanguageContext, Runnable runnable) {
        Objects.requireNonNull(runnable);
        this.polyglotLanguageContext = polyglotLanguageContext;
        this.runnable = runnable;
    }

    public TruffleThreadBuilder context(TruffleContext innerContext) {
        this.truffleContext = innerContext;
        return this;
    }

    public TruffleThreadBuilder threadGroup(ThreadGroup g2) {
        this.threadGroup = g2;
        return this;
    }

    public TruffleThreadBuilder stackSize(long size) {
        this.stackSize = size;
        return this;
    }

    public TruffleThreadBuilder beforeEnter(Runnable r2) {
        this.beforeEnter = r2;
        return this;
    }

    public TruffleThreadBuilder afterLeave(Runnable r2) {
        this.afterLeave = r2;
        return this;
    }

    public TruffleThreadBuilder virtual(boolean v2) {
        this.virtual = v2;
        return this;
    }

    @CompilerDirectives.TruffleBoundary
    public Thread build() {
        try {
            return LanguageAccessor.engineAccess().createThread(this.polyglotLanguageContext, this.runnable, this.truffleContext != null ? this.truffleContext.polyglotContext : null, this.threadGroup, this.stackSize, this.beforeEnter, this.afterLeave, this.virtual);
        }
        catch (Throwable t2) {
            throw TruffleLanguage.Env.engineToLanguageException(t2);
        }
    }
}

