/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;

public interface FrameInstance {
    public Frame getFrame(FrameAccess var1);

    public boolean isVirtualFrame();

    default public int getCompilationTier() {
        return 0;
    }

    default public boolean isCompilationRoot() {
        return true;
    }

    public Node getCallNode();

    public CallTarget getCallTarget();

    default public int getBytecodeIndex() {
        RootCallTarget target = (RootCallTarget)this.getCallTarget();
        Node callNode = this.getCallNode();
        RootNode rootNode = target.getRootNode();
        return FrameAccessor.NODES.findBytecodeIndex(rootNode, callNode, this.captureFrame(rootNode));
    }

    private Frame captureFrame(RootNode rootNode) {
        return FrameAccessor.NODES.isCaptureFramesForTrace(rootNode, this.getCompilationTier() > 0) ? this.getFrame(FrameAccess.READ_ONLY) : null;
    }

    public static enum FrameAccess {
        READ_ONLY,
        READ_WRITE,
        MATERIALIZE;

    }
}

