/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;

public final class ReadOnlyArrayList<T>
implements List<T> {
    private final T[] arr;
    private final int first;
    private final int last;

    private ReadOnlyArrayList(T[] arr, int first, int last) {
        this.arr = arr;
        this.first = first;
        this.last = last;
        if (first > last) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> List<T> asList(T[] arr, int first, int last) {
        return new ReadOnlyArrayList<T>(arr, first, last);
    }

    @Override
    public int size() {
        return this.last - this.first;
    }

    @Override
    public boolean isEmpty() {
        return this.first == this.last;
    }

    @Override
    public boolean contains(Object o2) {
        for (int i2 = this.first; i2 < this.last; ++i2) {
            if (o2 != this.arr[i2] && (o2 == null || !o2.equals(this.arr[i2]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new LI(this.first);
    }

    @Override
    public Object[] toArray() {
        return this.toArray((A[])new Object[this.size()]);
    }

    @Override
    public <A> A[] toArray(A[] b2) {
        Object[] a2 = b2.length < this.size() ? (Object[])Array.newInstance(b2.getClass().getComponentType(), this.size()) : b2;
        int i2 = 0;
        for (int at = this.first; at < this.last; ++at) {
            a2[i2] = this.arr[at];
            ++i2;
        }
        return a2;
    }

    @Override
    public boolean add(Object e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        for (Object obj : c2) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        int at = this.first + index;
        if (at < this.first || at >= this.last) {
            throw new ArrayIndexOutOfBoundsException();
        }
        T ret = this.arr[at];
        return ret;
    }

    @Override
    public T set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o2) {
        for (int i2 = this.first; i2 < this.last; ++i2) {
            if (!(this.arr[i2] == null ? o2 == null : this.arr[i2].equals(o2))) continue;
            return i2 - this.first;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o2) {
        for (int i2 = this.last - 1; i2 >= this.first; --i2) {
            if (!(this.arr[i2] == null ? o2 == null : this.arr[i2].equals(o2))) continue;
            return i2 - this.first;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new LI(this.first);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new LI(this.first + index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new ReadOnlyArrayList<T>(this.arr, this.first + fromIndex, this.first + toIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        Iterator<T> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            T e2;
            sb.append((Object)((e2 = it.next()) == this ? "(this Collection)" : e2));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private final class LI
    implements ListIterator<T>,
    Iterator<T> {
        private int index;

        LI(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < ReadOnlyArrayList.this.last;
        }

        @Override
        public T next() {
            if (this.index >= ReadOnlyArrayList.this.last) {
                throw new NoSuchElementException();
            }
            return ReadOnlyArrayList.this.arr[this.index++];
        }

        @Override
        public boolean hasPrevious() {
            return this.index > ReadOnlyArrayList.this.first;
        }

        @Override
        public T previous() {
            if (ReadOnlyArrayList.this.first == this.index) {
                throw new NoSuchElementException();
            }
            return ReadOnlyArrayList.this.arr[--this.index];
        }

        @Override
        public int nextIndex() {
            return this.index - ReadOnlyArrayList.this.first;
        }

        @Override
        public int previousIndex() {
            return this.index - 1 - ReadOnlyArrayList.this.first;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object e2) {
            throw new UnsupportedOperationException();
        }
    }
}

