/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.Library;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.LibraryFactory;

public abstract class Message {
    private final String simpleName;
    private final String qualifiedName;
    private final int id;
    private final int hash;
    private final boolean deprecated;
    private final Class<?> returnType;
    private final Class<? extends Library> libraryClass;
    private final List<Class<?>> parameterTypes;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Class<?>[] parameterTypesArray;
    private final int parameterCount;
    @CompilerDirectives.CompilationFinal
    LibraryFactory<Library> library;

    protected Message(Class<? extends Library> libraryClass, String messageName, int id, Class<?> returnType, Class<?> ... parameterTypes) {
        this(libraryClass, messageName, id, false, returnType, parameterTypes);
    }

    protected Message(Class<? extends Library> libraryClass, String messageName, int id, boolean deprecated, Class<?> returnType, Class<?> ... parameterTypes) {
        this(libraryClass, id, messageName, deprecated, returnType, parameterTypes);
        if (id < 0) {
            throw new IllegalArgumentException("Id must be non-negative.");
        }
    }

    private Message(Class<? extends Library> libraryClass, int id, String messageName, boolean deprecated, Class<?> returnType, Class<?> ... parameterTypes) {
        Objects.requireNonNull(libraryClass);
        Objects.requireNonNull(messageName);
        Objects.requireNonNull(returnType);
        this.libraryClass = libraryClass;
        this.simpleName = messageName.intern();
        this.returnType = returnType;
        this.parameterTypesArray = parameterTypes;
        this.parameterTypes = Collections.unmodifiableList(Arrays.asList(parameterTypes));
        this.qualifiedName = (this.getLibraryName() + "." + this.simpleName + Message.parameters(parameterTypes)).intern();
        this.deprecated = deprecated;
        this.id = id;
        this.parameterCount = parameterTypes.length;
        this.hash = this.qualifiedName.hashCode();
    }

    private static String parameters(Class<?> ... parameterTypes) {
        if (parameterTypes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> c2 : parameterTypes) {
            sb.append(c2.getSimpleName());
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        return sb.toString();
    }

    public final int getId() {
        return this.id;
    }

    public final String getQualifiedName() {
        return this.qualifiedName;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final String getLibraryName() {
        return this.getLibraryClass().getName();
    }

    public final Class<?> getReturnType() {
        return this.returnType;
    }

    public final Class<?> getReceiverType() {
        return this.parameterTypesArray[0];
    }

    public final List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    public final Class<?> getParameterType(int index) {
        return this.parameterTypesArray[index];
    }

    public final int getParameterCount() {
        return this.parameterCount;
    }

    public final boolean isDeprecated() {
        return this.deprecated;
    }

    public final Class<? extends Library> getLibraryClass() {
        return this.libraryClass;
    }

    public final LibraryFactory<?> getFactory() {
        return this.library;
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return this.hash;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public final String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append("Message[");
        b2.append(this.getReturnType().getSimpleName());
        b2.append(" ").append(this.getQualifiedName());
        b2.append("(");
        String sep = "";
        for (Class<?> param : this.getParameterTypes()) {
            b2.append(sep);
            b2.append(param.getSimpleName());
            sep = ", ";
        }
        b2.append(")");
        return b2.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static Message resolve(Class<? extends Library> libraryClass, String messageName) {
        return LibraryFactory.resolveMessage(libraryClass, messageName, true);
    }

    @CompilerDirectives.TruffleBoundary
    public static Message resolve(Class<? extends Library> libraryClass, String messageName, boolean fail) {
        return LibraryFactory.resolveMessage(libraryClass, messageName, fail);
    }
}

