/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.AbstractTruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.DecodingErrorHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.JCodingsImpl;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringInternalNodes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TranscodingErrorHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.provider.JCodingsProvider;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
interface JCodings {
    public static final JCodingsProvider PROVIDER = JCodings.loadProvider();
    public static final boolean ENABLED = PROVIDER != null;
    public static final JCodings INSTANCE = ENABLED ? new JCodingsImpl(PROVIDER) : null;

    private static JCodingsProvider loadProvider() {
        if (TruffleOptions.AOT && !TStringAccessor.getNeedsAllEncodings()) {
            return null;
        }
        Iterator<JCodingsProvider> iterator = JCodings.loadService(JCodingsProvider.class).iterator();
        if (iterator.hasNext()) {
            JCodingsProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    private static <S> Iterable<S> loadService(Class<S> service) {
        return TStringAccessor.ACCESSOR.engineSupport().loadServices(service);
    }

    public static JCodings getInstance() {
        if (INSTANCE == null) {
            throw CompilerDirectives.shouldNotReachHere("TruffleStrings: JCodings is disabled!");
        }
        return INSTANCE;
    }

    public static byte[] asByteArray(Object array) {
        if (array instanceof AbstractTruffleString.NativePointer) {
            return ((AbstractTruffleString.NativePointer)array).getBytes();
        }
        return (byte[])array;
    }

    public int minLength(TruffleString.Encoding var1);

    public int maxLength(TruffleString.Encoding var1);

    public boolean isFixedWidth(TruffleString.Encoding var1);

    public boolean isSingleByte(TruffleString.Encoding var1);

    @CompilerDirectives.TruffleBoundary
    public int getCodePointLength(TruffleString.Encoding var1, int var2);

    @CompilerDirectives.TruffleBoundary
    public int getPreviousCodePointIndex(TruffleString.Encoding var1, byte[] var2, int var3, int var4, int var5);

    @CompilerDirectives.TruffleBoundary
    public int getCodePointLength(TruffleString.Encoding var1, byte[] var2, int var3, int var4);

    @CompilerDirectives.TruffleBoundary
    public int readCodePoint(TruffleString.Encoding var1, byte[] var2, int var3, int var4, DecodingErrorHandler var5);

    @CompilerDirectives.TruffleBoundary
    public boolean isValidCodePoint(TruffleString.Encoding var1, int var2);

    @CompilerDirectives.TruffleBoundary
    public int writeCodePoint(TruffleString.Encoding var1, int var2, byte[] var3, int var4);

    @CompilerDirectives.TruffleBoundary
    public int codePointIndexToRaw(Node var1, AbstractTruffleString var2, byte[] var3, int var4, int var5, boolean var6, TruffleString.Encoding var7);

    public int decode(AbstractTruffleString var1, byte[] var2, int var3, TruffleString.Encoding var4, TruffleString.ErrorHandling var5);

    public long calcStringAttributes(Node var1, Object var2, int var3, int var4, TruffleString.Encoding var5, int var6, InlinedConditionProfile var7, InlinedConditionProfile var8);

    public TruffleString transcode(Node var1, AbstractTruffleString var2, Object var3, int var4, TruffleString.Encoding var5, TStringInternalNodes.FromBufferWithStringCompactionNode var6, TranscodingErrorHandler var7);

    public static TruffleString.Encoding fromJCodingsName(String jCodingsName) {
        final class Lazy {
            static final Map<String, TruffleString.Encoding> JCODINGS_NAME_MAP;

            private Lazy() {
            }

            static {
                TruffleString.Encoding[] encodingValues = TruffleString.Encoding.values();
                HashMap<String, TruffleString.Encoding> jcodingsNameMap = new HashMap<String, TruffleString.Encoding>(encodingValues.length + encodingValues.length / 3);
                for (TruffleString.Encoding encoding : encodingValues) {
                    jcodingsNameMap.put(encoding.jCodingName, encoding);
                }
                JCODINGS_NAME_MAP = Map.copyOf(jcodingsNameMap);
            }
        }
        return Lazy.JCODINGS_NAME_MAP.get(jCodingsName);
    }
}

