/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.AbstractTruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.DecodingErrorHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.Encodings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.InternalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.JCodings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.StringAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TSCodeRange;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringInternalNodes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TStringOps;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TranscodingErrorHandler;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.provider.JCodingsProvider;

final class JCodingsImpl
implements JCodings {
    private final JCodingsProvider provider;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final JCodingsProvider.Encoding[] jcodingsEncodings;
    private static final byte[] CONVERSION_REPLACEMENT;
    private static final byte[] CONVERSION_REPLACEMENT_UTF_16;
    private static final byte[] CONVERSION_REPLACEMENT_UTF_32;

    JCodingsImpl(JCodingsProvider provider) {
        this.provider = provider;
        TruffleString.Encoding[] encodingValues = TruffleString.Encoding.values();
        this.jcodingsEncodings = new JCodingsProvider.Encoding[encodingValues.length];
        for (TruffleString.Encoding e2 : encodingValues) {
            JCodingsProvider.Encoding jcodingsEncoding;
            this.jcodingsEncodings[e2.id] = jcodingsEncoding = provider.get(e2.jCodingName);
            assert (jcodingsEncoding.isSingleByte() == e2.isSingleByte()) : e2;
        }
    }

    private JCodingsProvider.Encoding get(TruffleString.Encoding encoding) {
        return this.jcodingsEncodings[encoding.id];
    }

    @Override
    public int minLength(TruffleString.Encoding encoding) {
        return this.get(encoding).minLength();
    }

    @Override
    public int maxLength(TruffleString.Encoding encoding) {
        return this.get(encoding).maxLength();
    }

    @Override
    public boolean isFixedWidth(TruffleString.Encoding encoding) {
        JCodingsProvider.Encoding jCoding = this.get(encoding);
        return jCoding.isFixedWidth() && jCoding.isSingleByte();
    }

    @Override
    public boolean isSingleByte(TruffleString.Encoding encoding) {
        return this.get(encoding).isSingleByte();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getCodePointLength(TruffleString.Encoding encoding, int codepoint) {
        return this.get(encoding).codeToMbcLength(codepoint);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getPreviousCodePointIndex(TruffleString.Encoding encoding, byte[] array, int arrayBegin, int index, int arrayEnd) {
        return this.get(encoding).prevCharHead(array, arrayBegin, index, arrayEnd);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getCodePointLength(TruffleString.Encoding encoding, byte[] array, int index, int arrayLength) {
        return this.get(encoding).length(array, index, arrayLength);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int readCodePoint(TruffleString.Encoding encoding, byte[] array, int index, int arrayEnd, DecodingErrorHandler errorHandler) {
        JCodingsProvider.Encoding jCoding = this.get(encoding);
        int codePoint = jCoding.mbcToCode(array, index, arrayEnd);
        if (jCoding.isUnicode() && Encodings.isUTF16Surrogate(codePoint)) {
            return TStringGuards.isReturnNegative(errorHandler) ? -1 : Encodings.invalidCodepoint();
        }
        return codePoint;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isValidCodePoint(TruffleString.Encoding encoding, int codepoint) {
        return !this.get(encoding).isUnicode() || !Encodings.isUTF16Surrogate(codepoint);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int writeCodePoint(TruffleString.Encoding encoding, int codepoint, byte[] array, int index) {
        return this.get(encoding).codeToMbc(codepoint, array, index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int codePointIndexToRaw(Node location, AbstractTruffleString a2, byte[] arrayA, int extraOffsetRaw, int index, boolean isLength, TruffleString.Encoding encoding) {
        JCodingsProvider.Encoding jCoding = this.get(encoding);
        int minLength = jCoding.minLength();
        if (jCoding.isFixedWidth()) {
            return index * minLength;
        }
        int offset = a2.byteArrayOffset() + extraOffsetRaw;
        int end = a2.byteArrayOffset() + a2.length();
        int cpi = 0;
        int i2 = 0;
        while (i2 < a2.length() - extraOffsetRaw) {
            if (cpi == index) {
                return i2;
            }
            int length = jCoding.length(arrayA, offset + i2, end);
            if (length < 1) {
                if (length < -1) {
                    if (isLength) {
                        return a2.length() - extraOffsetRaw;
                    }
                    throw InternalErrors.indexOutOfBounds();
                }
                i2 += minLength;
            } else {
                i2 += length;
            }
            TStringConstants.truffleSafePointPoll(location, ++cpi);
        }
        return TStringInternalNodes.CodePointIndexToRawNode.atEnd(a2, extraOffsetRaw, index, isLength, cpi);
    }

    @Override
    public int decode(AbstractTruffleString a2, byte[] arrayA, int rawIndex, TruffleString.Encoding encoding, TruffleString.ErrorHandling errorHandling) {
        int end;
        int p2 = a2.byteArrayOffset() + rawIndex;
        int length = this.getCodePointLength(encoding, arrayA, p2, end = a2.byteArrayOffset() + a2.length());
        if (length < 1) {
            return Encodings.invalidCodepointReturnValue(errorHandling);
        }
        return this.readCodePoint(encoding, arrayA, p2, end, errorHandling.errorHandler);
    }

    @Override
    public long calcStringAttributes(Node location, Object array, int offset, int length, TruffleString.Encoding encoding, int fromIndex, InlinedConditionProfile validCharacterProfile, InlinedConditionProfile fixedWidthProfile) {
        if (TStringGuards.is7BitCompatible(encoding) && TStringOps.calcStringAttributesLatin1(location, array, offset + fromIndex, length) == TSCodeRange.get7Bit()) {
            return StringAttributes.create(length, TSCodeRange.get7Bit());
        }
        byte[] bytes = JCodings.asByteArray(array);
        int offsetBytes = array instanceof AbstractTruffleString.NativePointer ? fromIndex : offset + fromIndex;
        JCodingsProvider.Encoding enc = this.get(encoding);
        int codeRange = TSCodeRange.getValid(enc.isSingleByte());
        int characters = 0;
        int p2 = offsetBytes;
        int end = offsetBytes + length;
        int loopCount = 0;
        while (p2 < end) {
            int lengthOfCurrentCharacter = enc.length(bytes, p2, end);
            if (validCharacterProfile.profile(location, lengthOfCurrentCharacter > 0 && p2 + lengthOfCurrentCharacter <= end)) {
                p2 += lengthOfCurrentCharacter;
            } else {
                codeRange = TSCodeRange.getBroken(enc.isSingleByte());
                if (fixedWidthProfile.profile(location, enc.isFixedWidth())) {
                    characters = (length + enc.minLength() - 1) / enc.minLength();
                    return StringAttributes.create(characters, codeRange);
                }
                p2 += enc.minLength();
            }
            TStringConstants.truffleSafePointPoll(location, ++loopCount);
            ++characters;
        }
        return StringAttributes.create(characters, codeRange);
    }

    private static byte[] getConversionReplacement(TruffleString.Encoding targetEncoding) {
        if (TStringGuards.isUTF8(targetEncoding)) {
            return Encodings.CONVERSION_REPLACEMENT_UTF_8;
        }
        if (TStringGuards.isUTF16(targetEncoding)) {
            return CONVERSION_REPLACEMENT_UTF_16;
        }
        if (TStringGuards.isUTF32(targetEncoding)) {
            return CONVERSION_REPLACEMENT_UTF_32;
        }
        return CONVERSION_REPLACEMENT;
    }

    private static JCodingsProvider.Encoding getBytesEncoding(AbstractTruffleString a2) {
        JCodingsImpl impl = (JCodingsImpl)JCodings.getInstance();
        if (TStringGuards.isUTF16Or32(a2.encoding()) && TStringGuards.isStride0(a2)) {
            return impl.get(TruffleString.Encoding.ISO_8859_1);
        }
        if (TStringGuards.isUTF32(a2.encoding()) && TStringGuards.isStride1(a2)) {
            return impl.get(TruffleString.Encoding.UTF_16);
        }
        return impl.get(TruffleString.Encoding.get(a2.encoding()));
    }

    @Override
    public TruffleString transcode(Node location, AbstractTruffleString a2, Object arrayA, int codePointLengthA, TruffleString.Encoding targetEncoding, TStringInternalNodes.FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode, TranscodingErrorHandler errorHandler) {
        JCodingsProvider.Encoding jCodingSrc = JCodingsImpl.getBytesEncoding(a2);
        JCodingsProvider.Encoding jCodingDst = this.get(targetEncoding);
        byte[] replacement = JCodingsImpl.getConversionReplacement(targetEncoding);
        JCodingsProvider.TranscodeResult result = this.provider.transcode(a2, codePointLengthA, a2.byteArrayOffset(), a2.length() << a2.stride(), targetEncoding, jCodingSrc, jCodingDst, replacement, errorHandler, JCodingsImpl::asBytesMaterializeNative, JCodingsImpl::getBytesEncoding);
        AbstractTruffleString.checkArrayRange(result.buffer(), 0, result.length());
        return fromBufferWithStringCompactionNode.execute(location, result.buffer(), 0, result.length(), targetEncoding, result.length() != result.buffer().length || targetEncoding.isSupported(), TStringGuards.isBroken(a2.codeRange()) || result.undefinedConversion() || a2.isMutable());
    }

    private static byte[] asBytesMaterializeNative(AbstractTruffleString replacementString) {
        return JCodingsImpl.asBytesMaterializeNative(replacementString, TruffleString.ToIndexableNode.getUncached().execute(null, replacementString, replacementString.data()));
    }

    private static byte[] asBytesMaterializeNative(AbstractTruffleString a2, Object arrayA) {
        if (arrayA instanceof AbstractTruffleString.NativePointer) {
            ((AbstractTruffleString.NativePointer)arrayA).materializeByteArray(null, a2, InlinedConditionProfile.getUncached());
        }
        return JCodings.asByteArray(arrayA);
    }

    static {
        byte[] byArray;
        byte[] byArray2;
        CONVERSION_REPLACEMENT = new byte[]{63};
        if (TStringGuards.littleEndian()) {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray2 = byArray3;
            byArray3[1] = -1;
        } else {
            byte[] byArray4 = new byte[2];
            byArray4[0] = -1;
            byArray2 = byArray4;
            byArray4[1] = -3;
        }
        CONVERSION_REPLACEMENT_UTF_16 = byArray2;
        if (TStringGuards.littleEndian()) {
            byte[] byArray5 = new byte[4];
            byArray5[0] = -3;
            byArray5[1] = -1;
            byArray5[2] = 0;
            byArray = byArray5;
            byArray5[3] = 0;
        } else {
            byte[] byArray6 = new byte[4];
            byArray6[0] = 0;
            byArray6[1] = 0;
            byArray6[2] = -1;
            byArray = byArray6;
            byArray6[3] = -3;
        }
        CONVERSION_REPLACEMENT_UTF_32 = byArray;
    }
}

