/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.utilities;

import java.util.Arrays;
import java.util.BitSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;

public final class FinalBitSet {
    public static final FinalBitSet EMPTY = new FinalBitSet(new long[0]);
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private long[] words;

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private FinalBitSet(long[] words) {
        this.words = words;
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.words, this.words.length);
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException(String.format("bitIndex < 0: %s", bitIndex));
        }
        int wordIndex = FinalBitSet.wordIndex(bitIndex);
        if (wordIndex >= this.words.length) {
            return false;
        }
        return (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public int length() {
        if (this.words.length == 0) {
            return 0;
        }
        return 64 * (this.words.length - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.words.length - 1]));
    }

    public boolean isEmpty() {
        return this.words.length == 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FinalBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FinalBitSet set = (FinalBitSet)obj;
        if (this.words.length != set.words.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.words.length; ++i2) {
            if (this.words[i2] == set.words[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long h2 = 1234L;
        int i2 = this.words.length;
        while (--i2 >= 0) {
            h2 ^= this.words[i2] * (long)(i2 + 1);
        }
        return (int)(h2 >> 32 ^ h2);
    }

    public int size() {
        return this.words.length * 64;
    }

    public int cardinality() {
        int sum = 0;
        for (int i2 = 0; i2 < this.words.length; ++i2) {
            sum += Long.bitCount(this.words[i2]);
        }
        return sum;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u2 = FinalBitSet.wordIndex(fromIndex);
        if (u2 >= this.words.length) {
            return -1;
        }
        long word = this.words[u2] & -1L << fromIndex;
        while (word == 0L) {
            if (++u2 == this.words.length) {
                return -1;
            }
            word = this.words[u2];
        }
        return u2 * 64 + Long.numberOfTrailingZeros(word);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u2 = FinalBitSet.wordIndex(fromIndex);
        if (u2 >= this.words.length) {
            return fromIndex;
        }
        long word = (this.words[u2] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        while (word == 0L) {
            if (++u2 == this.words.length) {
                return this.words.length * 64;
            }
            word = this.words[u2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return u2 * 64 + Long.numberOfTrailingZeros(word);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        int numBits = this.words.length > 128 ? this.cardinality() : this.words.length * 64;
        StringBuilder b2 = new StringBuilder(6 * numBits + 2);
        b2.append('{');
        int i2 = this.nextSetBit(0);
        if (i2 != -1) {
            b2.append(i2);
            while (++i2 >= 0 && (i2 = this.nextSetBit(i2)) >= 0) {
                int endOfRun = this.nextClearBit(i2);
                do {
                    b2.append(", ").append(i2);
                } while (++i2 != endOfRun);
            }
        }
        b2.append('}');
        return b2.toString();
    }

    public static FinalBitSet valueOf(long[] longs) {
        int n2;
        for (n2 = longs.length; n2 > 0 && longs[n2 - 1] == 0L; --n2) {
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return new FinalBitSet(Arrays.copyOf(longs, n2));
    }

    @CompilerDirectives.TruffleBoundary
    public static FinalBitSet valueOf(BitSet originalBitSet) {
        long[] array = originalBitSet.toLongArray();
        if (array.length == 0) {
            return EMPTY;
        }
        return new FinalBitSet(originalBitSet.toLongArray());
    }
}

