/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.host;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AllPermission;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Objects;
import java.util.function.Supplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostClassCache;

final class HostAdapterClassLoader {
    static final ProtectionDomain GENERATED_PROTECTION_DOMAIN = HostAdapterClassLoader.createGeneratedProtectionDomain();
    static final String SERVICE_CLASS_NAME = "org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.adapters.HostAdapterServices";
    private final String className;
    private final byte[] classBytes;

    HostAdapterClassLoader(String className, byte[] classBytes) {
        this.className = className.replace('/', '.');
        this.classBytes = classBytes;
    }

    Class<?> generateClass(HostClassCache cache, ClassLoader parentLoader, Object classOverrides) {
        try {
            Class<?> c2 = this.createClassLoader(cache, parentLoader, classOverrides).loadClass(this.className);
            return c2;
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalStateException(e2);
        }
    }

    private ClassLoader createClassLoader(HostClassCache cache, ClassLoader parentLoader, Object classOverrides) {
        return new GeneratedClassLoader(cache, parentLoader, classOverrides);
    }

    static boolean isAdapterInstance(Object adapter) {
        return HostAdapterClassLoader.isGeneratedClass(adapter.getClass());
    }

    static boolean isGeneratedClass(Class<?> clazz) {
        return HostAdapterClassLoader.isGeneratedClassLoader(clazz.getClassLoader());
    }

    static boolean isGeneratedClassLoader(ClassLoader classLoader) {
        return classLoader instanceof GeneratedClassLoader;
    }

    private static ProtectionDomain createGeneratedProtectionDomain() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return new ProtectionDomain(new CodeSource(null, (CodeSigner[])null), permissions);
    }

    static Object getClassOverrides(ClassLoader classLoader) {
        return ((Supplier)((Object)classLoader)).get();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] loadClassBytes(String className) {
        String classFileName = "/" + className.replace('.', '/') + ".class";
        try (InputStream in = Objects.requireNonNull(HostAdapterClassLoader.class.getResourceAsStream(classFileName), className);){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int n2;
                byte[] buf = new byte[4000];
                while ((n2 = in.read(buf)) > 0) {
                    out.write(buf, 0, n2);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    final class GeneratedClassLoader
    extends SecureClassLoader
    implements Supplier<Object> {
        private final Object classOverrides;
        private final HostClassCache cache;

        private GeneratedClassLoader(HostClassCache cache, ClassLoader parentLoader, Object classOverrides) {
            super(parentLoader);
            this.cache = cache;
            this.classOverrides = classOverrides;
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.isGeneratedClassName(name)) {
                return this.loadGeneratedClass(name, resolve);
            }
            return super.loadClass(name, resolve);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> loadGeneratedClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c2 = this.findLoadedClass(name);
                if (c2 == null) {
                    c2 = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c2);
                }
                return c2;
            }
        }

        private boolean isGeneratedClassName(String name) {
            return name.equals(HostAdapterClassLoader.this.className) || name.equals(HostAdapterClassLoader.SERVICE_CLASS_NAME);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.equals(HostAdapterClassLoader.this.className)) {
                return this.defineClass(name, HostAdapterClassLoader.this.classBytes, 0, HostAdapterClassLoader.this.classBytes.length, GENERATED_PROTECTION_DOMAIN);
            }
            if (name.equals(HostAdapterClassLoader.SERVICE_CLASS_NAME)) {
                byte[] bytes = LazyClassBytes.SERVICE_CLASS_BYTES;
                return this.defineClass(name, bytes, 0, bytes.length, GENERATED_PROTECTION_DOMAIN);
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public Object get() {
            Object current = this.cache.apiAccess.callContextGetCurrent();
            return this.cache.apiAccess.callContextAsValue(current, this.classOverrides);
        }
    }

    static interface LazyClassBytes {
        public static final byte[] SERVICE_CLASS_BYTES = HostAdapterClassLoader.loadClassBytes("org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.adapters.HostAdapterServices");
    }
}

