/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.host;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.Message;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ReflectionLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostEngineException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodDesc;
import sun.misc.Unsafe;

final class HostMethodScope {
    private static final ScopedObject[] EMTPY_SCOPE_ARRAY = new ScopedObject[0];
    private static final Unsafe UNSAFE = HostMethodScope.getUnsafe();
    private ScopedObject[] scope;
    private int nextDynamicIndex;

    HostMethodScope(ScopedObject[] staticScope) {
        this.scope = staticScope;
        this.nextDynamicIndex = staticScope.length;
    }

    HostMethodScope(int initialDynamicCapacity) {
        this.scope = new ScopedObject[initialDynamicCapacity];
        this.nextDynamicIndex = 0;
    }

    static HostMethodScope openDynamic(Node node, HostMethodDesc.SingleMethod method, int argumentCount, InlinedBranchProfile seenScope) {
        if (method.hasScopedParameters()) {
            seenScope.enter(node);
            return new HostMethodScope(argumentCount);
        }
        return null;
    }

    static HostMethodScope openStatic(HostMethodDesc.SingleMethod method) {
        CompilerAsserts.partialEvaluationConstant(method);
        if (method.hasScopedParameters()) {
            int[] scopePos = method.getScopedParameters();
            ScopedObject[] scopeArray = scopePos.length > 0 ? new ScopedObject[scopePos.length] : EMTPY_SCOPE_ARRAY;
            return new HostMethodScope(scopeArray);
        }
        return null;
    }

    static Object addToScopeDynamic(HostMethodScope scope, Object value) {
        if (scope != null) {
            assert (!(value instanceof ScopedObject));
            return scope.addToScopeDynamicImpl(value);
        }
        return value;
    }

    static Object addToScopeStatic(HostMethodScope scope, HostMethodDesc.SingleMethod method, int argumentIndex, Object value) {
        CompilerAsserts.partialEvaluationConstant(method);
        if (scope != null) {
            assert (!(value instanceof ScopedObject));
            int[] scopePos = method.getScopedParameters();
            int targetIndex = scopePos[argumentIndex];
            if (targetIndex != -1) {
                scope.scope[targetIndex] = new ScopedObject(scope, value, targetIndex);
                return scope.scope[targetIndex];
            }
        }
        return value;
    }

    static void pin(Object value) {
        if (value instanceof ScopedObject) {
            ((ScopedObject)value).pin();
        }
    }

    static void closeStatic(Node node, HostMethodScope scope, HostMethodDesc.SingleMethod method, InlinedBranchProfile seenDynamicScope) {
        if (method.hasScopedParameters()) {
            ScopedObject o2;
            int i2;
            int[] scopePos = method.getScopedParameters();
            ScopedObject[] array = scope.scope;
            for (i2 = 0; i2 < scopePos.length; ++i2) {
                o2 = array[i2];
                if (o2 == null) continue;
                o2.release();
            }
            for (i2 = scopePos.length; i2 < array.length; ++i2) {
                seenDynamicScope.enter(node);
                o2 = array[i2];
                if (o2 == null) continue;
                o2.release();
            }
        } else assert (scope == null);
    }

    static void closeDynamic(HostMethodScope scope, HostMethodDesc.SingleMethod method) {
        if (method.hasScopedParameters()) {
            ScopedObject[] array = scope.scope;
            for (int i2 = 0; i2 < array.length; ++i2) {
                ScopedObject o2 = array[i2];
                if (o2 == null) continue;
                o2.release();
            }
        } else assert (scope == null);
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized Object addToScopeDynamicImpl(Object argument) {
        int index = this.nextDynamicIndex;
        ScopedObject[] localScope = this.scope;
        if (index >= localScope.length) {
            this.scope = localScope = Arrays.copyOf(localScope, localScope.length << 1);
        }
        if (index < 0) {
            throw HostMethodScope.createReleaseException("Too many scoped values created for scoped method instance.");
        }
        ScopedObject newArgument = localScope[index] = new ScopedObject(this, argument, index);
        this.nextDynamicIndex = index + 1;
        return newArgument;
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException createReleaseException(String message) {
        return HostEngineException.toEngineException(HostLanguage.get(null).access, new IllegalStateException("This scoped object has already been released. " + message));
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e2) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e2);
            }
        }
    }

    @ExportLibrary(value=ReflectionLibrary.class)
    static final class ScopedObject
    implements TruffleObject {
        static final Object OTHER_VALUE;
        static final ReflectionLibrary OTHER_VALUE_UNCACHED;
        static final long DELEGATE_OFFSET;
        volatile Object delegate;
        volatile HostMethodScope scope;
        private final int index;

        ScopedObject(HostMethodScope scope, Object delegate, int index) {
            this.delegate = delegate;
            this.scope = scope;
            this.index = index;
        }

        @ExportMessage
        Object send(Message message, Object[] args, @Bind(value="$node") Node node, @CachedLibrary(limit="5") ReflectionLibrary library, @Cached InlinedBranchProfile seenError, @Cached InlinedBranchProfile seenOther) throws Exception {
            if (message.getLibraryClass() != InteropLibrary.class) {
                seenOther.enter(node);
                return ScopedObject.fallbackSend(message, args);
            }
            Object d2 = this.delegate;
            if (d2 == null) {
                seenError.enter(node);
                throw HostMethodScope.createReleaseException("Released objects cannot be accessed. Avoid accessing scoped objects after their corresponding method has finished execution. Alternatively, use Value.pin() to prevent a scoped object from being released after the host call completed.");
            }
            assert (d2 != null) : "delegate must not be null here";
            Object returnValue = library.send(d2, message, args);
            if (message.getReturnType() == Object.class && !(d2 instanceof PinnedObject)) {
                return HostMethodScope.addToScopeDynamic(this.scope, returnValue);
            }
            return returnValue;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object fallbackSend(Message message, Object[] args) throws Exception {
            return OTHER_VALUE_UNCACHED.send(OTHER_VALUE, message, args);
        }

        void release() {
            Object d2 = this.delegate;
            assert (d2 != null);
            if (d2 instanceof PinnedObject || !UNSAFE.compareAndSwapObject(this, DELEGATE_OFFSET, d2, null)) {
                return;
            }
            assert (this.delegate == null) : "Scoped objects can only be released once.";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pin() {
            HostMethodScope s2;
            PinnedObject update;
            Object expect;
            do {
                s2 = this.scope;
                expect = this.delegate;
                if (expect instanceof PinnedObject) {
                    return;
                }
                if (expect != null) continue;
                throw HostMethodScope.createReleaseException("Released objects cannot be pinned.");
            } while (!UNSAFE.compareAndSwapObject(this, DELEGATE_OFFSET, expect, update = new PinnedObject(expect)));
            this.scope = null;
            HostMethodScope hostMethodScope = s2;
            synchronized (hostMethodScope) {
                s2.scope[this.index] = null;
            }
            assert (this.delegate != null) : "delegate must not be set to null after pinning ";
        }

        Object unwrapForGuest() {
            Object d2 = this.delegate;
            if (d2 == null) {
                throw HostMethodScope.createReleaseException("Released objects cannot be converted to a guest value.");
            }
            if (d2 instanceof PinnedObject) {
                return ((PinnedObject)d2).delegate;
            }
            return d2;
        }

        static {
            Field f2;
            OTHER_VALUE = new Object();
            OTHER_VALUE_UNCACHED = ReflectionLibrary.getFactory().getUncached(OTHER_VALUE);
            try {
                f2 = ScopedObject.class.getDeclaredField("delegate");
            }
            catch (NoSuchFieldException | SecurityException e2) {
                throw CompilerDirectives.shouldNotReachHere(e2);
            }
            DELEGATE_OFFSET = UNSAFE.objectFieldOffset(f2);
        }
    }

    @ExportLibrary(value=InteropLibrary.class, delegateTo="delegate")
    static final class PinnedObject
    implements TruffleObject {
        final Object delegate;

        PinnedObject(Object delegate) {
            this.delegate = delegate;
        }
    }
}

