/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.host;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.sql.Time;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleStackTrace;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ArityException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ExceptionType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.StopIterationException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownIdentifierException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownKeyException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedTypeException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.utilities.TriState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostAccessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostAdapterFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostClassCache;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostClassDesc;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostContextFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostExecuteNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostFieldDesc;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostInteropErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostInteropReflect;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostMethodDesc;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostTargetMappingNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostToTypeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.host.HostToTypeNodeGen;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

@ExportLibrary(value=InteropLibrary.class)
final class HostObject
implements TruffleObject {
    static final int LIMIT = 5;
    private static final Class<? extends ByteBuffer> HEAP_BYTE_BUFFER_CLASS = ByteBuffer.allocate(0).getClass();
    private static final Class<? extends ByteBuffer> HEAP_BYTE_BUFFER_R_CLASS = ByteBuffer.allocate(0).asReadOnlyBuffer().getClass();
    private static final Class<? extends ByteBuffer> DIRECT_BYTE_BUFFER_CLASS = ByteBuffer.allocateDirect(0).getClass();
    private static final Class<? extends ByteBuffer> DIRECT_BYTE_BUFFER_R_CLASS = ByteBuffer.allocateDirect(0).asReadOnlyBuffer().getClass();
    private static final ZoneId UTC = ZoneId.of("UTC");
    static final HostObject NULL = new HostObject(null, null, null);
    final Object obj;
    final HostContext context;
    private final Object extraInfo;

    private HostObject(Object obj, HostContext context, Object extraInfo) {
        this.obj = obj;
        this.context = context;
        this.extraInfo = extraInfo;
    }

    static HostObject forClass(Class<?> clazz, HostContext context) {
        assert (clazz != null);
        return new HostObject(clazz, context, null);
    }

    static HostObject forStaticClass(Class<?> clazz, HostContext context) {
        assert (clazz != null);
        return new HostObject(clazz, context, clazz);
    }

    static HostObject forObject(Object object, HostContext context) {
        assert (object != null && !(object instanceof Class));
        return new HostObject(object, context, null);
    }

    static HostObject forException(Throwable object, HostContext context, HostException hostException) {
        Objects.requireNonNull(object);
        return new HostObject(object, context, hostException);
    }

    static boolean isInstance(HostLanguage language, Object v2) {
        Object obj = HostLanguage.unwrapIfScoped(language, v2);
        return obj instanceof HostObject || obj instanceof HostException;
    }

    static Object withContext(HostLanguage language, Object originalValue, HostContext context) {
        assert (context != null);
        Object obj = HostLanguage.unwrapIfScoped(language, originalValue);
        if (obj instanceof HostObject) {
            HostObject hostObject = (HostObject)obj;
            return new HostObject(hostObject.obj, context, hostObject.extraInfo);
        }
        if (obj instanceof HostException) {
            return ((HostException)obj).withContext(context);
        }
        throw CompilerDirectives.shouldNotReachHere("Parameter must be HostObject or HostException.");
    }

    static boolean isJavaInstance(HostLanguage language, Class<?> targetType, Object javaObject) {
        Object unboxed = HostObject.unboxHostObject(language, javaObject);
        if (unboxed != null) {
            return targetType.isInstance(unboxed);
        }
        return false;
    }

    static Object unboxHostObject(HostLanguage language, Object value) {
        Object v2 = HostLanguage.unwrapIfScoped(language, value);
        if (v2 instanceof HostObject) {
            return ((HostObject)v2).obj;
        }
        if (v2 instanceof HostException) {
            return ((HostException)v2).delegate.obj;
        }
        return null;
    }

    static Object valueOf(HostLanguage language, Object value) {
        Object v2 = HostLanguage.unwrapIfScoped(language, value);
        if (v2 instanceof HostObject) {
            return ((HostObject)v2).obj;
        }
        if (v2 instanceof HostException) {
            return ((HostException)v2).delegate.obj;
        }
        return v2;
    }

    public int hashCode() {
        return System.identityHashCode(this.obj);
    }

    boolean isClass() {
        return this.obj instanceof Class;
    }

    boolean isArrayClass() {
        return this.isClass() && this.asClass().isArray();
    }

    boolean isDefaultClass() {
        return this.isClass() && !this.asClass().isArray();
    }

    private static RuntimeException unboxEngineException(HostObject receiver, RuntimeException e2) {
        AbstractPolyglotImpl.AbstractHostAccess access = receiver.context.language.access;
        if (access.isEngineException(e2)) {
            return access.unboxEngineException(e2);
        }
        return null;
    }

    @ExportMessage
    boolean hasMembers() {
        return !this.isNull();
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) throws UnsupportedMessageException {
        if (this.isNull()) {
            throw UnsupportedMessageException.create();
        }
        String[] fields = HostInteropReflect.findUniquePublicMemberNames(this.context, this.getLookupClass(), this.isStaticClass(), this.isClass(), includeInternal);
        return new KeysArray(fields);
    }

    @ExportMessage
    Object readMember(String name, @Bind(value="$node") Node node, @Cached.Shared(value="lookupField") @Cached LookupFieldNode lookupField, @Cached.Shared(value="readField") @Cached ReadFieldNode readField, @Cached.Shared(value="lookupMethod") @Cached LookupMethodNode lookupMethod, @Cached LookupInnerClassNode lookupInnerClass, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, UnknownIdentifierException {
        if (this.isNull()) {
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
        boolean isStatic = this.isStaticClass();
        Class<?> lookupClass = this.getLookupClass();
        HostFieldDesc foundField = lookupField.execute(node, this, lookupClass, name, isStatic);
        if (foundField != null) {
            return readField.execute(node, foundField, this);
        }
        HostMethodDesc foundMethod = lookupMethod.execute(node, this, lookupClass, name, isStatic);
        if (foundMethod != null) {
            return new HostFunction(foundMethod, this.obj, this.context);
        }
        if (isStatic) {
            LookupInnerClassNode lookupInnerClassNode = lookupInnerClass;
            if ("class".equals(name)) {
                return HostObject.forClass(lookupClass, this.context);
            }
            Class<?> innerclass = lookupInnerClassNode.execute(node, lookupClass, name);
            if (innerclass != null) {
                return HostObject.forStaticClass(innerclass, this.context);
            }
        } else {
            if (this.isClass() && "static".equals(name)) {
                return HostObject.forStaticClass(this.asClass(), this.context);
            }
            if ("super".equals(name) && HostAdapterFactory.isAdapterInstance(this.obj)) {
                return HostAdapterFactory.getSuperAdapter(this);
            }
        }
        error.enter(node);
        throw UnknownIdentifierException.create(name);
    }

    @ExportMessage
    boolean isMemberInsertable(String member) {
        return false;
    }

    @ExportMessage
    void writeMember(String member, Object value, @Bind(value="$node") Node node, @Cached.Shared(value="lookupField") @Cached LookupFieldNode lookupField, @Cached WriteFieldNode writeField, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
        if (this.isNull()) {
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
        HostFieldDesc f2 = lookupField.execute(node, this, this.getLookupClass(), member, this.isStaticClass());
        if (f2 == null) {
            error.enter(node);
            throw UnknownIdentifierException.create(member);
        }
        try {
            writeField.execute(node, f2, this, value);
        }
        catch (ClassCastException | NullPointerException e2) {
            error.enter(node);
            throw UnsupportedTypeException.create(new Object[]{value}, HostObject.getMessage(e2));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String getMessage(RuntimeException e2) {
        return e2.getMessage();
    }

    @ExportMessage
    Object invokeMember(String name, Object[] args, @Bind(value="$node") Node node, @Cached.Shared(value="lookupMethod") @Cached LookupMethodNode lookupMethod, @Cached.Shared(value="hostExecute") @Cached HostExecuteNode executeMethod, @Cached.Shared(value="lookupField") @Cached LookupFieldNode lookupField, @Cached.Shared(value="readField") @Cached ReadFieldNode readField, @CachedLibrary(limit="5") InteropLibrary fieldValues, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
        Object fieldValue;
        if (this.isNull()) {
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
        boolean isStatic = this.isStaticClass();
        Class<?> lookupClass = this.getLookupClass();
        HostMethodDesc foundMethod = lookupMethod.execute(node, this, lookupClass, name, isStatic);
        if (foundMethod != null) {
            return executeMethod.execute(node, foundMethod, this.obj, args, this.context);
        }
        HostFieldDesc foundField = lookupField.execute(node, this, lookupClass, name, isStatic);
        if (foundField != null && fieldValues.isExecutable(fieldValue = readField.execute(node, foundField, this))) {
            return fieldValues.execute(fieldValue, args);
        }
        error.enter(node);
        throw UnknownIdentifierException.create(name);
    }

    boolean isByteSequence() {
        return this.context.language.api.isByteSequence(this.obj);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isBufferWritableBoundary(ByteBuffer buffer) {
        return !buffer.isReadOnly();
    }

    @CompilerDirectives.TruffleBoundary
    private static long getByteSequenceLengthBoundary(AbstractPolyglotImpl.APIAccess apiAccess, Object byteSequence) {
        return apiAccess.byteSequenceLength(byteSequence);
    }

    @CompilerDirectives.TruffleBoundary
    private static long getBufferSizeBoundary(ByteBuffer buffer) {
        return buffer.limit();
    }

    private static boolean isPEFriendlyBuffer(ByteBuffer buffer) {
        boolean result;
        Class<?> clazz = buffer.getClass();
        boolean bl = result = CompilerDirectives.isPartialEvaluationConstant(clazz) && (clazz == HEAP_BYTE_BUFFER_CLASS || clazz == HEAP_BYTE_BUFFER_R_CLASS || clazz == DIRECT_BYTE_BUFFER_CLASS || clazz == DIRECT_BYTE_BUFFER_R_CLASS);
        assert (result) : "Unexpected Buffer subclass";
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private static byte getByteSequenceByteBoundary(AbstractPolyglotImpl.APIAccess apiAccess, Object byteSequence, int index) {
        return apiAccess.byteSequenceByteAt(byteSequence, index);
    }

    @CompilerDirectives.TruffleBoundary
    private static byte getBufferByteBoundary(ByteBuffer buffer, int index) {
        return buffer.get(index);
    }

    @CompilerDirectives.TruffleBoundary
    private static void putBufferByteBoundary(ByteBuffer buffer, int index, byte value) {
        buffer.put(index, value);
    }

    @CompilerDirectives.TruffleBoundary
    private static short getByteSequenceShortBoundary(AbstractPolyglotImpl.APIAccess apiAccess, Object byteSequence, int index, ByteOrder order) {
        int b1 = apiAccess.byteSequenceByteAt(byteSequence, index) & 0xFF;
        int b2 = apiAccess.byteSequenceByteAt(byteSequence, index + 1) & 0xFF;
        if (order == ByteOrder.BIG_ENDIAN) {
            return (short)(b1 << 8 | b2);
        }
        return (short)(b2 << 8 | b1);
    }

    @CompilerDirectives.TruffleBoundary
    private static short getBufferShortBoundary(ByteBuffer buffer, int index) {
        return buffer.getShort(index);
    }

    @CompilerDirectives.TruffleBoundary
    private static void putBufferShortBoundary(ByteBuffer buffer, int index, short value) {
        buffer.putShort(index, value);
    }

    @CompilerDirectives.TruffleBoundary
    private static int getBufferIntBoundary(ByteBuffer buffer, int index) {
        return buffer.getInt(index);
    }

    @CompilerDirectives.TruffleBoundary
    private static int getByteSequenceIntBoundary(AbstractPolyglotImpl.APIAccess apiAccess, Object byteSequence, int index, ByteOrder order) {
        int b1 = apiAccess.byteSequenceByteAt(byteSequence, index) & 0xFF;
        int b2 = apiAccess.byteSequenceByteAt(byteSequence, index + 1) & 0xFF;
        int b3 = apiAccess.byteSequenceByteAt(byteSequence, index + 2) & 0xFF;
        int b4 = apiAccess.byteSequenceByteAt(byteSequence, index + 3) & 0xFF;
        if (order == ByteOrder.BIG_ENDIAN) {
            return b1 << 24 | b2 << 16 | b3 << 8 | b4;
        }
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    @CompilerDirectives.TruffleBoundary
    private static void putBufferIntBoundary(ByteBuffer buffer, int index, int value) {
        buffer.putInt(index, value);
    }

    @CompilerDirectives.TruffleBoundary
    private static long getBufferLongBoundary(ByteBuffer buffer, int index) {
        return buffer.getLong(index);
    }

    @CompilerDirectives.TruffleBoundary
    private static long getByteSequenceLongBoundary(AbstractPolyglotImpl.APIAccess apiAccess, Object byteSequence, int index, ByteOrder order) {
        long b1 = apiAccess.byteSequenceByteAt(byteSequence, index) & 0xFF;
        long b2 = apiAccess.byteSequenceByteAt(byteSequence, index + 1) & 0xFF;
        long b3 = apiAccess.byteSequenceByteAt(byteSequence, index + 2) & 0xFF;
        long b4 = apiAccess.byteSequenceByteAt(byteSequence, index + 3) & 0xFF;
        long b5 = apiAccess.byteSequenceByteAt(byteSequence, index + 4) & 0xFF;
        long b6 = apiAccess.byteSequenceByteAt(byteSequence, index + 5) & 0xFF;
        long b7 = apiAccess.byteSequenceByteAt(byteSequence, index + 6) & 0xFF;
        long b8 = apiAccess.byteSequenceByteAt(byteSequence, index + 7) & 0xFF;
        if (order == ByteOrder.BIG_ENDIAN) {
            return b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8;
        }
        return b8 << 56 | b7 << 48 | b6 << 40 | b5 << 32 | b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    @CompilerDirectives.TruffleBoundary
    private static void putBufferLongBoundary(ByteBuffer buffer, int index, long value) {
        buffer.putLong(index, value);
    }

    @CompilerDirectives.TruffleBoundary
    private static float getBufferFloatBoundary(ByteBuffer buffer, int index) {
        return buffer.getFloat(index);
    }

    @CompilerDirectives.TruffleBoundary
    private static float getByteSequenceFloatBoundary(AbstractPolyglotImpl.APIAccess apiAccess, Object byteSequence, int index, ByteOrder order) {
        return Float.intBitsToFloat(HostObject.getByteSequenceIntBoundary(apiAccess, byteSequence, index, order));
    }

    @CompilerDirectives.TruffleBoundary
    private static void putBufferFloatBoundary(ByteBuffer buffer, int index, float value) {
        buffer.putFloat(index, value);
    }

    @CompilerDirectives.TruffleBoundary
    private static double getBufferDoubleBoundary(ByteBuffer buffer, int index) {
        return buffer.getDouble(index);
    }

    @CompilerDirectives.TruffleBoundary
    private static double getByteSequenceDoubleBoundary(AbstractPolyglotImpl.APIAccess apiAccess, Object byteSequence, int index, ByteOrder order) {
        return Double.longBitsToDouble(HostObject.getByteSequenceLongBoundary(apiAccess, byteSequence, index, order));
    }

    @CompilerDirectives.TruffleBoundary
    private static void putBufferDoubleBoundary(ByteBuffer buffer, int index, double value) {
        buffer.putDouble(index, value);
    }

    @CompilerDirectives.TruffleBoundary
    private static void getByteSequenceBytesBoundary(AbstractPolyglotImpl.APIAccess apiAccess, Object byteSequence, int index, byte[] destination, int destinationOffset, int byteLength) {
        for (int i2 = index; i2 < index + byteLength; ++i2) {
            destination[destinationOffset + (i2 - index)] = apiAccess.byteSequenceByteAt(byteSequence, i2);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void getBufferBytesBoundary(ByteBuffer buffer, int index, byte[] destination, int destinationOffset, int byteLength) {
        buffer.get(index, destination, destinationOffset, byteLength);
    }

    @ExportMessage
    boolean isNull() {
        return this.obj == null;
    }

    @ExportMessage
    boolean isExecutable(@Bind(value="$node") Node node, @Cached.Shared(value="lookupFunctionalMethod") @Cached LookupFunctionalMethodNode lookupMethod) {
        return !this.isNull() && !this.isClass() && lookupMethod.execute(node, this, this.getLookupClass()) != null;
    }

    @ExportMessage
    Object execute(Object[] args, @Bind(value="$node") Node node, @Cached.Shared(value="hostExecute") @Cached HostExecuteNode doExecute, @Cached.Shared(value="lookupFunctionalMethod") @Cached LookupFunctionalMethodNode lookupMethod, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
        HostMethodDesc method;
        if (!this.isNull() && !this.isClass() && (method = lookupMethod.execute(node, this, this.getLookupClass())) != null) {
            return doExecute.execute(node, method, this.obj, args, this.context);
        }
        error.enter(node);
        throw UnsupportedMessageException.create();
    }

    private static boolean isJavaSupportedNumber(Object value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigInteger;
    }

    boolean isBigInteger() {
        return CompilerDirectives.isExact(this.obj, BigInteger.class);
    }

    @CompilerDirectives.TruffleBoundary
    boolean bigIntegerFitsInByte() {
        return ((BigInteger)this.obj).bitLength() < 8;
    }

    @CompilerDirectives.TruffleBoundary
    boolean bigIntegerFitsInShort() {
        return ((BigInteger)this.obj).bitLength() < 16;
    }

    @CompilerDirectives.TruffleBoundary
    boolean bigIntegerFitsInInt() {
        return ((BigInteger)this.obj).bitLength() < 32;
    }

    @CompilerDirectives.TruffleBoundary
    boolean bigIntegerFitsInLong() {
        return ((BigInteger)this.obj).bitLength() < 64;
    }

    @CompilerDirectives.TruffleBoundary
    boolean bigIntegerFitsInFloat() {
        BigInteger b2 = (BigInteger)this.obj;
        return HostObject.bigIntegerFitsInFloat(b2);
    }

    static boolean bigIntegerFitsInFloat(BigInteger b2) {
        if (b2.bitLength() <= 24) {
            return true;
        }
        float floatValue = b2.floatValue();
        if (!Float.isFinite(floatValue)) {
            return false;
        }
        try {
            return new BigDecimal(floatValue).toBigIntegerExact().equals(b2);
        }
        catch (ArithmeticException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
    }

    @CompilerDirectives.TruffleBoundary
    boolean bigIntegerFitsInDouble() {
        BigInteger b2 = (BigInteger)this.obj;
        return HostObject.bigIntegerFitsInDouble(b2);
    }

    static boolean bigIntegerFitsInDouble(BigInteger b2) {
        if (b2.bitLength() <= 53) {
            return true;
        }
        double doubleValue = b2.doubleValue();
        if (!Double.isFinite(doubleValue)) {
            return false;
        }
        try {
            return new BigDecimal(doubleValue).toBigIntegerExact().equals(b2);
        }
        catch (ArithmeticException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
    }

    @CompilerDirectives.TruffleBoundary
    byte bigIntegerAsByte() throws UnsupportedMessageException {
        try {
            return ((BigInteger)this.obj).byteValueExact();
        }
        catch (ArithmeticException e2) {
            throw UnsupportedMessageException.create();
        }
    }

    @CompilerDirectives.TruffleBoundary
    short bigIntegerAsShort() throws UnsupportedMessageException {
        try {
            return ((BigInteger)this.obj).shortValueExact();
        }
        catch (ArithmeticException e2) {
            throw UnsupportedMessageException.create();
        }
    }

    @CompilerDirectives.TruffleBoundary
    int bigIntegerAsInt() throws UnsupportedMessageException {
        try {
            return ((BigInteger)this.obj).intValueExact();
        }
        catch (ArithmeticException e2) {
            throw UnsupportedMessageException.create();
        }
    }

    @CompilerDirectives.TruffleBoundary
    long bigIntegerAsLong() throws UnsupportedMessageException {
        try {
            return ((BigInteger)this.obj).longValueExact();
        }
        catch (ArithmeticException e2) {
            throw UnsupportedMessageException.create();
        }
    }

    @CompilerDirectives.TruffleBoundary
    float bigIntegerAsFloat() throws UnsupportedMessageException {
        if (this.bigIntegerFitsInFloat()) {
            return ((BigInteger)this.obj).floatValue();
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    double bigIntegerAsDouble() throws UnsupportedMessageException {
        if (this.bigIntegerFitsInDouble()) {
            return ((BigInteger)this.obj).doubleValue();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isString(@Bind(value="$node") Node node, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) {
        if (this.isNull()) {
            return false;
        }
        Class<?> c2 = classProfile.profile(node, this.obj).getClass();
        return c2 == String.class || c2 == Character.class;
    }

    @ExportMessage
    String asString(@Bind(value="$node") Node node, @CachedLibrary(value="this") InteropLibrary thisLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary strings, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
        if (thisLibrary.isString(this)) {
            return strings.asString(this.obj);
        }
        error.enter(node);
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isBoolean() {
        if (this.isNull()) {
            return false;
        }
        return this.obj.getClass() == Boolean.class;
    }

    @ExportMessage
    boolean asBoolean(@Bind(value="$node") Node node, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
        if (this.isBoolean()) {
            return (Boolean)this.obj;
        }
        error.enter(node);
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isDate() {
        return this.obj instanceof LocalDate || this.obj instanceof LocalDateTime || this.obj instanceof Instant || this.obj instanceof ZonedDateTime || this.obj instanceof java.sql.Date || HostObject.isInstantDate(this.obj);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate() throws UnsupportedMessageException {
        if (this.obj instanceof LocalDate) {
            return (LocalDate)this.obj;
        }
        if (this.obj instanceof LocalDateTime) {
            return ((LocalDateTime)this.obj).toLocalDate();
        }
        if (this.obj instanceof Instant) {
            return ((Instant)this.obj).atZone(UTC).toLocalDate();
        }
        if (this.obj instanceof ZonedDateTime) {
            return ((ZonedDateTime)this.obj).toLocalDate();
        }
        if (this.obj instanceof java.sql.Date) {
            return ((java.sql.Date)this.obj).toLocalDate();
        }
        if (HostObject.isInstantDate(this.obj)) {
            return ((Date)this.obj).toInstant().atZone(UTC).toLocalDate();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isTime() {
        return this.obj instanceof LocalTime || this.obj instanceof LocalDateTime || this.obj instanceof Instant || this.obj instanceof ZonedDateTime || this.obj instanceof Time || HostObject.isInstantDate(this.obj);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime() throws UnsupportedMessageException {
        if (this.obj instanceof LocalTime) {
            return (LocalTime)this.obj;
        }
        if (this.obj instanceof LocalDateTime) {
            return ((LocalDateTime)this.obj).toLocalTime();
        }
        if (this.obj instanceof ZonedDateTime) {
            return ((ZonedDateTime)this.obj).toLocalTime();
        }
        if (this.obj instanceof Instant) {
            return ((Instant)this.obj).atZone(UTC).toLocalTime();
        }
        if (this.obj instanceof Time) {
            return ((Time)this.obj).toLocalTime();
        }
        if (HostObject.isInstantDate(this.obj)) {
            return ((Date)this.obj).toInstant().atZone(UTC).toLocalTime();
        }
        throw UnsupportedMessageException.create();
    }

    private static boolean isInstantDate(Object v2) {
        return v2 instanceof Date && !(v2 instanceof Time) && !(v2 instanceof java.sql.Date);
    }

    @ExportMessage
    boolean isTimeZone() {
        return this.obj instanceof ZoneId || this.obj instanceof Instant || this.obj instanceof ZonedDateTime || HostObject.isInstantDate(this.obj);
    }

    @ExportMessage
    ZoneId asTimeZone() throws UnsupportedMessageException {
        if (this.obj instanceof ZoneId) {
            return (ZoneId)this.obj;
        }
        if (this.obj instanceof ZonedDateTime) {
            return ((ZonedDateTime)this.obj).getZone();
        }
        if (this.obj instanceof Instant) {
            return UTC;
        }
        if (HostObject.isInstantDate(this.obj)) {
            return UTC;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Instant asInstant() throws UnsupportedMessageException {
        if (this.obj instanceof ZonedDateTime) {
            return ((ZonedDateTime)this.obj).toInstant();
        }
        if (this.obj instanceof Instant) {
            return (Instant)this.obj;
        }
        if (HostObject.isInstantDate(this.obj)) {
            return ((Date)this.obj).toInstant();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isDuration() {
        return this.obj instanceof Duration;
    }

    @ExportMessage
    Duration asDuration() throws UnsupportedMessageException {
        if (this.isDuration()) {
            return (Duration)this.obj;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isException() {
        return this.obj instanceof Throwable;
    }

    @ExportMessage
    ExceptionType getExceptionType(@Bind(value="$node") Node node, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
        if (this.isException()) {
            return this.obj instanceof InterruptedException ? ExceptionType.INTERRUPT : ExceptionType.RUNTIME_ERROR;
        }
        error.enter(node);
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isExceptionIncompleteSource(@Bind(value="$node") Node node, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
        if (this.isException()) {
            return false;
        }
        error.enter(node);
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    int getExceptionExitStatus(@Bind(value="$node") Node node, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
        error.enter(node);
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasExceptionMessage() {
        return this.isException() && ((Throwable)this.obj).getMessage() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getExceptionMessage(@Bind(value="$node") Node node, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
        String message;
        String string = message = this.isException() ? ((Throwable)this.obj).getMessage() : null;
        if (message != null) {
            return message;
        }
        error.enter(node);
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasExceptionCause() {
        Throwable cause;
        return this.isException() && (cause = ((Throwable)this.obj).getCause()) != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getExceptionCause() throws UnsupportedMessageException {
        Throwable cause;
        if (this.isException() && (cause = ((Throwable)this.obj).getCause()) != null) {
            if (cause instanceof AbstractTruffleException) {
                return cause;
            }
            return HostException.wrap(cause, this.context);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasExceptionStackTrace() {
        if (this.isException()) {
            Object hostExceptionOrOriginal = this.extraInfo != null ? this.extraInfo : this.obj;
            return TruffleStackTrace.fillIn((Throwable)hostExceptionOrOriginal) != null;
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getExceptionStackTrace() throws UnsupportedMessageException {
        if (this.isException()) {
            Object hostExceptionOrOriginal = this.extraInfo != null ? this.extraInfo : this.obj;
            return HostAccessor.EXCEPTION.getExceptionStackTrace(hostExceptionOrOriginal, this.context.internalContext);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    RuntimeException throwException(@Bind(value="$node") Node node, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
        if (this.isException()) {
            RuntimeException ex = (HostException)this.extraInfo;
            if (ex == null) {
                ex = this.context.hostToGuestException((Throwable)this.obj, node);
            }
            throw ex;
        }
        error.enter(node);
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return HostLanguage.class;
    }

    @ExportMessage
    String toDisplayString(boolean allowSideEffects) {
        return HostObject.toStringImpl(this.context, this.obj, 0, allowSideEffects);
    }

    @CompilerDirectives.TruffleBoundary
    private static String toStringImpl(HostContext context, Object javaObject, int level, boolean allowSideEffects) {
        try {
            if (javaObject == null) {
                return "null";
            }
            if (javaObject.getClass().isArray()) {
                return HostObject.arrayToString(context, javaObject, level, allowSideEffects);
            }
            if (javaObject instanceof Class) {
                return HostObject.getTypeNameSafe((Class)javaObject);
            }
            if (allowSideEffects && context != null) {
                HostObject hostObject = HostObject.forObject(javaObject, context);
                try {
                    InteropLibrary thisLib = InteropLibrary.getUncached(hostObject);
                    if (thisLib.isBoolean(hostObject)) {
                        return Boolean.toString(thisLib.asBoolean(hostObject));
                    }
                    if (thisLib.isString(hostObject)) {
                        return thisLib.asString(hostObject);
                    }
                    if (thisLib.isNumber(hostObject)) {
                        assert (HostObject.isJavaSupportedNumber(javaObject)) : javaObject;
                        return javaObject.toString();
                    }
                    if (thisLib.isMemberInvocable(hostObject, "toString")) {
                        Object result = thisLib.invokeMember(hostObject, "toString", new Object[0]);
                        return InteropLibrary.getUncached().asString(result);
                    }
                }
                catch (InteropException interopException) {
                    // empty catch block
                }
            }
            return HostObject.getTypeNameSafe(javaObject.getClass());
        }
        catch (Throwable t2) {
            throw context.hostToGuestException(t2);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static String getTypeNameSafe(Class<?> type) {
        String typeName = type.getTypeName();
        int slash = typeName.indexOf(47);
        if (slash != -1) {
            return typeName.substring(0, slash);
        }
        return typeName;
    }

    private static String arrayToString(HostContext context, Object array, int level, boolean allowSideEffects) {
        CompilerAsserts.neverPartOfCompilation();
        if (array == null) {
            return "null";
        }
        if (level > 0) {
            return "[...]";
        }
        int iMax = Array.getLength(array) - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b2 = new StringBuilder();
        b2.append('[');
        int i2 = 0;
        while (true) {
            Object arrayValue = Array.get(array, i2);
            b2.append(HostObject.toStringImpl(context, arrayValue, level + 1, allowSideEffects));
            if (i2 == iMax) {
                return b2.append(']').toString();
            }
            b2.append(", ");
            ++i2;
        }
    }

    @ExportMessage
    boolean hasMetaObject() {
        return !this.isNull();
    }

    @ExportMessage
    Object getMetaObject() throws UnsupportedMessageException {
        if (this.hasMetaObject()) {
            Object javaObject = this.obj;
            Class<?> javaType = javaObject.getClass();
            return HostObject.forClass(javaType, this.context);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isMetaObject() {
        return this.isClass();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMetaQualifiedName() throws UnsupportedMessageException {
        if (this.isClass()) {
            return this.asClass().getTypeName();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMetaSimpleName() throws UnsupportedMessageException {
        if (this.isClass()) {
            return this.asClass().getSimpleName();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMetaInstance(Object other, @Bind(value="$node") Node node, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
        if (this.isClass()) {
            HostLanguage language;
            Class<?> c2 = this.asClass();
            HostLanguage hostLanguage = language = this.context != null ? HostLanguage.get(library) : null;
            if (HostObject.isInstance(language, other)) {
                Object otherHostObj = HostObject.valueOf(language, other);
                if (otherHostObj == null) {
                    return false;
                }
                return c2.isInstance(otherHostObj);
            }
            if (HostProxy.isProxyGuestObject(language, other)) {
                Object otherHost = HostProxy.toProxyHostObject(language, other);
                return c2.isInstance(otherHost);
            }
            boolean canConvert = HostToTypeNode.canConvert(null, other, c2, c2, HostToTypeNode.allowsImplementation(this.context, c2), this.context, 8, InteropLibrary.getFactory().getUncached(other), HostTargetMappingNode.getUncached());
            return canConvert;
        }
        error.enter(node);
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasMetaParents() {
        return this.isClass() && (this.asClass().getSuperclass() != null || this.asClass().getInterfaces().length > 0);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMetaParents() throws UnsupportedMessageException {
        if (!this.hasMetaParents()) {
            throw UnsupportedMessageException.create();
        }
        Class<?> superClass = this.asClass().getSuperclass();
        Class<?>[] interfaces = this.asClass().getInterfaces();
        HostObject[] metaObjects = new HostObject[superClass == null ? interfaces.length : interfaces.length + 1];
        int i2 = 0;
        if (superClass != null) {
            metaObjects[i2++] = HostObject.forClass(superClass, this.context);
        }
        for (int j2 = 0; j2 < interfaces.length; ++j2) {
            metaObjects[i2++] = HostObject.forClass(interfaces[j2], this.context);
        }
        return new TypesArray(metaObjects);
    }

    boolean isStaticClass() {
        return this.extraInfo instanceof Class;
    }

    Class<?> getObjectClass() {
        return this.obj == null ? null : this.obj.getClass();
    }

    Class<?> asStaticClass() {
        assert (this.isStaticClass());
        return (Class)this.obj;
    }

    Class<?> asClass() {
        assert (this.isClass());
        return (Class)this.obj;
    }

    Class<?> getLookupClass() {
        if (this.obj == null) {
            return null;
        }
        if (this.isStaticClass()) {
            return this.asStaticClass();
        }
        return this.obj.getClass();
    }

    @NeverDefault
    HostClassCache getHostClassCache() {
        assert (this.context != null) : "host cache must not be used for null";
        return HostClassCache.forInstance(this);
    }

    @ExportMessage
    static int identityHashCode(HostObject receiver) {
        return System.identityHashCode(receiver.obj);
    }

    public boolean equals(Object o2) {
        if (o2 instanceof HostObject) {
            HostObject other = (HostObject)o2;
            return this.obj == other.obj && this.extraInfo == other.extraInfo && this.context == other.context;
        }
        return false;
    }

    public String toString() {
        if (this.obj == null) {
            return "null";
        }
        if (this.isClass()) {
            return "JavaClass[" + this.asClass().getTypeName() + "]";
        }
        return "JavaObject[" + String.valueOf(this.obj) + " (" + this.getObjectClass().getTypeName() + ")]";
    }

    boolean isList(HostClassCache hostClassCache) {
        return hostClassCache.isListAccess() && this.obj instanceof List;
    }

    boolean isArray(HostClassCache hostClassCache) {
        return hostClassCache.isArrayAccess() && this.obj.getClass().isArray();
    }

    boolean isBuffer(HostClassCache hostClassCache) {
        return hostClassCache.isBufferAccess() && ByteBuffer.class.isAssignableFrom(this.obj.getClass());
    }

    boolean isIterable(HostClassCache hostClassCache) {
        return hostClassCache.isIterableAccess() && this.obj instanceof Iterable;
    }

    boolean isIteratorLocal(HostClassCache hostClassCache) {
        return hostClassCache.isIteratorAccess() && this.obj instanceof Iterator;
    }

    boolean isMap(HostClassCache hostClassCache) {
        return hostClassCache.isMapAccess() && this.obj instanceof Map;
    }

    boolean isMapEntry(HostClassCache hostClassCache) {
        return hostClassCache.isMapAccess() && this.obj instanceof Map.Entry;
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class KeysArray
    implements TruffleObject {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final String[] keys;

        KeysArray(String[] keys) {
            this.keys = keys;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.keys.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return 0L <= idx && idx < (long)this.keys.length;
        }

        @ExportMessage
        String readArrayElement(long idx, @Bind(value="$node") Node node, @Cached InlinedBranchProfile error) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(idx)) {
                error.enter(node);
                throw InvalidArrayIndexException.create(idx);
            }
            return this.keys[(int)idx];
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class LookupFieldNode
    extends Node {
        static final int LIMIT = 3;

        LookupFieldNode() {
        }

        public abstract HostFieldDesc execute(Node var1, HostObject var2, Class<?> var3, String var4, boolean var5);

        @Specialization(guards={"onlyStatic == cachedStatic", "clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        HostFieldDesc doCached(HostObject receiver, Class<?> clazz, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, clazz, name, onlyStatic)") HostFieldDesc cachedField) {
            assert (cachedField == this.doUncached(receiver, clazz, name, onlyStatic));
            return cachedField;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        HostFieldDesc doUncached(HostObject receiver, Class<?> clazz, String name, boolean onlyStatic) {
            return HostInteropReflect.findField(receiver.context, clazz, name, onlyStatic);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ReadFieldNode
    extends Node {
        static final int LIMIT = 3;

        ReadFieldNode() {
        }

        public abstract Object execute(Node var1, HostFieldDesc var2, HostObject var3);

        @Specialization(guards={"field == cachedField"}, limit="LIMIT")
        static Object doCached(Node node, HostFieldDesc field, HostObject object, @Cached(value="field") HostFieldDesc cachedField, @Cached HostContext.ToGuestValueNode toGuest) {
            Object val = cachedField.get(object.obj);
            return toGuest.execute(node, object.context, val);
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static Object doUncached(HostFieldDesc field, HostObject object) {
            Object val = field.get(object.obj);
            return HostContextFactory.ToGuestValueNodeGen.getUncached().execute(null, object.context, val);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class LookupMethodNode
    extends Node {
        static final int LIMIT = 3;

        LookupMethodNode() {
        }

        public abstract HostMethodDesc execute(Node var1, HostObject var2, Class<?> var3, String var4, boolean var5);

        @Specialization(guards={"onlyStatic == cachedStatic", "clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        HostMethodDesc doCached(HostObject receiver, Class<?> clazz, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, clazz, name, onlyStatic)") HostMethodDesc cachedMethod) {
            assert (cachedMethod == this.doUncached(receiver, clazz, name, onlyStatic));
            return cachedMethod;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        HostMethodDesc doUncached(HostObject receiver, Class<?> clazz, String name, boolean onlyStatic) {
            return HostInteropReflect.findMethod(receiver.context, clazz, name, onlyStatic);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class LookupInnerClassNode
    extends Node {
        static final int LIMIT = 3;

        LookupInnerClassNode() {
        }

        public abstract Class<?> execute(Node var1, Class<?> var2, String var3);

        @Specialization(guards={"clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        Class<?> doCached(Class<?> clazz, String name, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(clazz, name)") Class<?> cachedInnerClass) {
            assert (cachedInnerClass == this.doUncached(clazz, name));
            return cachedInnerClass;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        Class<?> doUncached(Class<?> clazz, String name) {
            return HostInteropReflect.findInnerClass(clazz, name);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class WriteFieldNode
    extends Node {
        static final int LIMIT = 3;

        WriteFieldNode() {
        }

        public abstract void execute(Node var1, HostFieldDesc var2, HostObject var3, Object var4) throws UnsupportedTypeException, UnknownIdentifierException;

        @Specialization(guards={"field == cachedField"}, limit="LIMIT")
        static void doCached(Node node, HostFieldDesc field, HostObject object, Object rawValue, @Cached(value="field") HostFieldDesc cachedField, @Cached HostToTypeNode toHost, @Cached InlinedBranchProfile error) throws UnsupportedTypeException, UnknownIdentifierException {
            if (field.isFinal()) {
                error.enter(node);
                throw UnknownIdentifierException.create(field.getName());
            }
            try {
                Object value = toHost.execute(node, object.context, rawValue, cachedField.getType(), cachedField.getGenericType(), true);
                cachedField.set(object.obj, value);
            }
            catch (RuntimeException e2) {
                error.enter(node);
                RuntimeException ee = HostObject.unboxEngineException(object, e2);
                if (ee != null) {
                    throw HostInteropErrors.unsupportedTypeException(rawValue, (Throwable)ee);
                }
                throw e2;
            }
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static void doUncached(HostFieldDesc field, HostObject object, Object rawValue) throws UnsupportedTypeException, UnknownIdentifierException {
            if (field.isFinal()) {
                throw UnknownIdentifierException.create(field.getName());
            }
            try {
                Object val = HostToTypeNodeGen.getUncached().execute(null, object.context, rawValue, field.getType(), field.getGenericType(), true);
                field.set(object.obj, val);
            }
            catch (RuntimeException e2) {
                RuntimeException ee = HostObject.unboxEngineException(object, e2);
                if (ee != null) {
                    throw HostInteropErrors.unsupportedTypeException(rawValue, (Throwable)ee);
                }
                throw e2;
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class LookupFunctionalMethodNode
    extends Node {
        static final int LIMIT = 3;

        LookupFunctionalMethodNode() {
        }

        public abstract HostMethodDesc execute(Node var1, HostObject var2, Class<?> var3);

        @Specialization(guards={"clazz == cachedClazz"}, limit="LIMIT")
        HostMethodDesc doCached(HostObject object, Class<?> clazz, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="doUncached(object, clazz)") HostMethodDesc cachedMethod) {
            assert (cachedMethod == LookupFunctionalMethodNode.doUncached(object, clazz));
            return cachedMethod;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static HostMethodDesc doUncached(HostObject object, Class<?> clazz) {
            return HostClassDesc.forClass(object.context, clazz).getFunctionalMethod();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class TypesArray
    implements TruffleObject {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final HostObject[] types;

        TypesArray(HostObject[] types) {
            this.types = types;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.types.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return 0L <= idx && idx < (long)this.types.length;
        }

        @ExportMessage
        Object readArrayElement(long idx, @Bind(value="$node") Node node, @Cached InlinedBranchProfile error) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(idx)) {
                error.enter(node);
                throw InvalidArrayIndexException.create(idx);
            }
            return this.types[(int)idx];
        }
    }

    static abstract class GuestToHostCalls {
        private GuestToHostCalls() {
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        static int getListSize(HostObject hostObject) {
            return ((List)hostObject.obj).size();
        }

        @CompilerDirectives.TruffleBoundary
        static void setListElement(HostObject receiver, long index, Object hostValue) {
            List list = (List)receiver.obj;
            if (index == (long)list.size()) {
                list.add(hostValue);
            } else {
                list.set((int)index, hostValue);
            }
        }

        @CompilerDirectives.TruffleBoundary
        static Object removeListElement(HostObject receiver, long index) {
            return ((List)receiver.obj).remove((int)index);
        }

        @CompilerDirectives.TruffleBoundary
        static Object readListElement(HostObject receiver, long index) {
            return ((List)receiver.obj).get((int)index);
        }

        @CompilerDirectives.TruffleBoundary
        static Object setMapEntryValue(HostObject receiver, Object value) {
            return ((Map.Entry)receiver.obj).setValue(value);
        }

        @CompilerDirectives.TruffleBoundary
        static Object getMapEntryKey(HostObject receiver) {
            return ((Map.Entry)receiver.obj).getKey();
        }

        @CompilerDirectives.TruffleBoundary
        static Object getMapEntryValue(HostObject receiver) {
            return ((Map.Entry)receiver.obj).getValue();
        }

        @CompilerDirectives.TruffleBoundary
        static Object getIterator(HostObject receiver) {
            return ((Iterable)receiver.obj).iterator();
        }

        @CompilerDirectives.TruffleBoundary
        static boolean hasIteratorNext(HostObject receiver) {
            return ((Iterator)receiver.obj).hasNext();
        }

        @CompilerDirectives.TruffleBoundary
        static Object getIteratorNext(HostObject receiver) {
            return ((Iterator)receiver.obj).next();
        }

        @CompilerDirectives.TruffleBoundary
        static int getMapSize(HostObject receiver) {
            return ((Map)receiver.obj).size();
        }

        @CompilerDirectives.TruffleBoundary
        static Object getMapValue(HostObject receiver, Object key, Object defaultValue) {
            return ((Map)receiver.obj).getOrDefault(key, defaultValue);
        }

        @CompilerDirectives.TruffleBoundary
        static void putMapValue(HostObject receiver, Object key, Object value) {
            ((Map)receiver.obj).put(key, value);
        }

        @CompilerDirectives.TruffleBoundary
        static boolean removeMapValue(HostObject receiver, Object key) {
            Map map = (Map)receiver.obj;
            if (map.containsKey(key)) {
                map.remove(key);
                return true;
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        static Object getEntriesIterator(HostObject receiver) {
            return ((Map)receiver.obj).entrySet().iterator();
        }

        @CompilerDirectives.TruffleBoundary
        static boolean containsMapKey(HostObject receiver, Object key) {
            return ((Map)receiver.obj).containsKey(key);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ContainsKeyNode
    extends Node {
        ContainsKeyNode() {
        }

        public abstract boolean execute(Node var1, HostObject var2, Object var3, HostClassCache var4);

        @Specialization(guards={"!receiver.isNull()", "receiver.isMap(hostClassCache)"})
        protected static boolean doMap(Node node, HostObject receiver, Object key, HostClassCache hostClassCache, @Cached HostToTypeNode toHost, @Cached InlinedBranchProfile error) {
            Object hostKey;
            try {
                hostKey = toHost.execute(node, receiver.context, key, Object.class, null, true);
            }
            catch (RuntimeException e2) {
                error.enter(node);
                RuntimeException ee = HostObject.unboxEngineException(receiver, e2);
                if (ee != null) {
                    return false;
                }
                throw e2;
            }
            try {
                return GuestToHostCalls.containsMapKey(receiver, hostKey);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isMap(hostClassCache)"})
        protected static boolean doNotMap(Node node, HostObject receiver, Object key, HostClassCache hostClassCache) {
            return false;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class LookupConstructorNode
    extends Node {
        static final int LIMIT = 3;

        LookupConstructorNode() {
        }

        public abstract HostMethodDesc execute(Node var1, HostObject var2, Class<?> var3);

        @Specialization(guards={"clazz == cachedClazz"}, limit="LIMIT")
        HostMethodDesc doCached(HostObject receiver, Class<?> clazz, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="doUncached(receiver, clazz)") HostMethodDesc cachedMethod) {
            assert (cachedMethod == this.doUncached(receiver, clazz));
            return cachedMethod;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        HostMethodDesc doUncached(HostObject receiver, Class<?> clazz) {
            return HostClassDesc.forClass(receiver.context, clazz).lookupConstructor();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ArrayGet
    extends Node {
        ArrayGet() {
        }

        protected abstract Object execute(Node var1, Object var2, int var3);

        @Specialization
        static boolean doBoolean(boolean[] array, int index) {
            return array[index];
        }

        @Specialization
        static byte doByte(byte[] array, int index) {
            return array[index];
        }

        @Specialization
        static short doShort(short[] array, int index) {
            return array[index];
        }

        @Specialization
        static char doChar(char[] array, int index) {
            return array[index];
        }

        @Specialization
        static int doInt(int[] array, int index) {
            return array[index];
        }

        @Specialization
        static long doLong(long[] array, int index) {
            return array[index];
        }

        @Specialization
        static float doFloat(float[] array, int index) {
            return array[index];
        }

        @Specialization
        static double doDouble(double[] array, int index) {
            return array[index];
        }

        @Specialization
        static Object doObject(Object[] array, int index) {
            return array[index];
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ArraySet
    extends Node {
        ArraySet() {
        }

        protected abstract void execute(Node var1, Object var2, int var3, Object var4);

        @Specialization
        static void doBoolean(boolean[] array, int index, boolean value) {
            array[index] = value;
        }

        @Specialization
        static void doByte(byte[] array, int index, byte value) {
            array[index] = value;
        }

        @Specialization
        static void doShort(short[] array, int index, short value) {
            array[index] = value;
        }

        @Specialization
        static void doChar(char[] array, int index, char value) {
            array[index] = value;
        }

        @Specialization
        static void doInt(int[] array, int index, int value) {
            array[index] = value;
        }

        @Specialization
        static void doLong(long[] array, int index, long value) {
            array[index] = value;
        }

        @Specialization
        static void doFloat(float[] array, int index, float value) {
            array[index] = value;
        }

        @Specialization
        static void doDouble(double[] array, int index, double value) {
            array[index] = value;
        }

        @Specialization
        static void doObject(Object[] array, int index, Object value) {
            array[index] = value;
        }
    }

    @ExportMessage
    static final class IsIdenticalOrUndefined {
        IsIdenticalOrUndefined() {
        }

        @Specialization
        static TriState doHostObject(HostObject receiver, HostObject other) {
            return TriState.valueOf(receiver.obj == other.obj && receiver.isStaticClass() == other.isStaticClass());
        }

        @Fallback
        static TriState doOther(HostObject receiver, Object other) {
            return TriState.UNDEFINED;
        }
    }

    @ExportMessage
    static abstract class GetHashEntriesIterator {
        GetHashEntriesIterator() {
        }

        @Specialization(guards={"receiver.isNull()"})
        protected static Object doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isMap(hostClassCache)"})
        protected static Object doMap(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toGuest") @Cached(inline=true) HostContext.ToGuestValueNode toGuest, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) {
            Object hostValue;
            try {
                hostValue = GuestToHostCalls.getEntriesIterator(receiver);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
            return toGuest.execute(node, receiver.context, hostValue);
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isMap(hostClassCache)"})
        protected static Object doNotMap(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static abstract class RemoveHashEntry {
        RemoveHashEntry() {
        }

        @Specialization(guards={"receiver.isNull()"})
        protected static void doNull(HostObject receiver, Object key) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isMap(hostClassCache)"})
        protected static void doMap(HostObject receiver, Object key, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toHost") @Cached(inline=true) HostToTypeNode toHost, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnknownKeyException {
            boolean removed;
            Object hostKey;
            try {
                hostKey = toHost.execute(node, receiver.context, key, Object.class, null, true);
            }
            catch (RuntimeException e2) {
                error.enter(node);
                RuntimeException ee = HostObject.unboxEngineException(receiver, e2);
                if (ee != null) {
                    throw UnknownKeyException.create(key);
                }
                throw e2;
            }
            try {
                removed = GuestToHostCalls.removeMapValue(receiver, hostKey);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
            if (!removed) {
                error.enter(node);
                throw UnknownKeyException.create(key);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isMap(hostClassCache)"})
        protected static void doNotMap(HostObject receiver, Object key, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static abstract class WriteHashEntry {
        WriteHashEntry() {
        }

        @Specialization(guards={"receiver.isNull()"})
        protected static void doNull(HostObject receiver, Object key, Object value) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isMap(hostClassCache)"})
        protected static void doMap(HostObject receiver, Object key, Object value, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toHost") @Cached(inline=true) HostToTypeNode toHost, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedTypeException {
            Object hostValue;
            Object hostKey;
            try {
                hostKey = toHost.execute(node, receiver.context, key, Object.class, null, true);
            }
            catch (RuntimeException e2) {
                error.enter(node);
                RuntimeException ee = HostObject.unboxEngineException(receiver, e2);
                if (ee != null) {
                    throw UnsupportedTypeException.create(new Object[]{key}, HostObject.getMessage(ee));
                }
                throw e2;
            }
            try {
                hostValue = toHost.execute(node, receiver.context, value, Object.class, null, true);
            }
            catch (RuntimeException e3) {
                error.enter(node);
                RuntimeException ee = HostObject.unboxEngineException(receiver, e3);
                if (ee != null) {
                    throw UnsupportedTypeException.create(new Object[]{value}, HostObject.getMessage(ee));
                }
                throw e3;
            }
            try {
                GuestToHostCalls.putMapValue(receiver, hostKey, hostValue);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isMap(hostClassCache)"})
        protected static void doNotMap(HostObject receiver, Object key, Object value, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class IsHashEntryInsertable {
        IsHashEntryInsertable() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver, Object key) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()"})
        static boolean doNonNull(HostObject receiver, Object key, @Bind(value="$node") Node node, @Cached.Shared(value="containsKey") @Cached ContainsKeyNode containsKey, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return receiver.isMap(hostClassCache) && !containsKey.execute(node, receiver, key, hostClassCache);
        }
    }

    @ExportMessage
    static abstract class ReadHashValue {
        private static final Object UNDEFINED = new Object();

        ReadHashValue() {
        }

        @Specialization(guards={"receiver.isNull()"})
        protected static Object doNull(HostObject receiver, Object key) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isMap(hostClassCache)"})
        protected static Object doMap(HostObject receiver, Object key, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toHost") @Cached(inline=true) HostToTypeNode toHost, @Cached.Shared(value="toGuest") @Cached(inline=true) HostContext.ToGuestValueNode toGuest, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnknownKeyException {
            Object hostResult;
            Object hostKey;
            try {
                hostKey = toHost.execute(node, receiver.context, key, Object.class, null, true);
            }
            catch (RuntimeException e2) {
                error.enter(node);
                RuntimeException ee = HostObject.unboxEngineException(receiver, e2);
                if (ee != null) {
                    throw UnknownKeyException.create(key);
                }
                throw e2;
            }
            try {
                hostResult = GuestToHostCalls.getMapValue(receiver, hostKey, UNDEFINED);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
            if (hostResult == UNDEFINED) {
                error.enter(node);
                throw UnknownKeyException.create(key);
            }
            return toGuest.execute(node, receiver.context, hostResult);
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isMap(hostClassCache)"})
        protected static Object doNotMap(HostObject receiver, Object key, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isHashEntryReadable"), @ExportMessage(name="isHashEntryModifiable"), @ExportMessage(name="isHashEntryRemovable")})
    static class IsHashEntryReadable {
        IsHashEntryReadable() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver, Object key) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()"})
        static boolean doNonNull(HostObject receiver, Object key, @Bind(value="$node") Node node, @Cached.Shared(value="containsKey") @Cached ContainsKeyNode containsKey, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return receiver.isMap(hostClassCache) && containsKey.execute(node, receiver, key, hostClassCache);
        }
    }

    @ExportMessage
    static abstract class GetHashSize {
        GetHashSize() {
        }

        @Specialization(guards={"receiver.isNull()"})
        protected static long doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isMap(hostClassCache)"})
        protected static long doMap(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) {
            try {
                return GuestToHostCalls.getMapSize(receiver);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isMap(hostClassCache)"})
        protected static long doNotMap(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class HasHashEntries {
        HasHashEntries() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()"})
        static boolean doNonNull(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return receiver.isMap(hostClassCache);
        }
    }

    @ExportMessage
    static abstract class GetIteratorNextElement {
        GetIteratorNextElement() {
        }

        @Specialization(guards={"receiver.isNull()"})
        protected static boolean doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isIteratorLocal(hostClassCache)"})
        protected static Object doIterator(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toGuest") @Cached(inline=true) HostContext.ToGuestValueNode toGuest, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Exclusive @Cached InlinedBranchProfile stopIteration) throws StopIterationException {
            Object next;
            try {
                next = GuestToHostCalls.getIteratorNext(receiver);
            }
            catch (NoSuchElementException e2) {
                stopIteration.enter(node);
                throw StopIterationException.create();
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
            return toGuest.execute(node, receiver.context, next);
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isIteratorLocal(hostClassCache)"})
        protected static Object doNotIterator(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static abstract class HasIteratorNextElement {
        HasIteratorNextElement() {
        }

        @Specialization(guards={"receiver.isNull()"})
        protected static boolean doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isIteratorLocal(hostClassCache)"})
        protected static boolean doIterator(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) {
            try {
                return GuestToHostCalls.hasIteratorNext(receiver);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isIteratorLocal(hostClassCache)"})
        protected static boolean doNotIterator(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class IsIterator {
        IsIterator() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()"})
        static boolean doNonNull(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return receiver.isIteratorLocal(hostClassCache);
        }
    }

    @ExportMessage
    static abstract class GetIterator {
        GetIterator() {
        }

        @Specialization(guards={"receiver.isNull()"})
        protected static boolean doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isArray(hostClassCache)"})
        protected static Object doArray(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toGuest") @Cached(inline=true) HostContext.ToGuestValueNode toGuest) {
            return toGuest.execute(node, receiver.context, GetIterator.arrayIteratorImpl(receiver));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object arrayIteratorImpl(Object receiver) {
            return HostAccessor.INTEROP.createDefaultIterator(receiver);
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isIterable(hostClassCache)"})
        protected static Object doIterable(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toGuest") @Cached(inline=true) HostContext.ToGuestValueNode toGuest, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) {
            Object hostValue;
            try {
                hostValue = GuestToHostCalls.getIterator(receiver);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
            return toGuest.execute(node, receiver.context, hostValue);
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isArray(hostClassCache)", "!receiver.isIterable(hostClassCache)"})
        protected static Object doNotArrayOrIterable(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class HasIterator {
        HasIterator() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()"})
        static boolean doNonNull(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return receiver.isIterable(hostClassCache) || receiver.isArray(hostClassCache);
        }
    }

    @ExportMessage
    static class AsDouble {
        AsDouble() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static double doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static double doBigInteger(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerAsDouble();
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static double doOther(HostObject receiver, @Bind(value="$node") Node node, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.asDouble(receiver.obj);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class AsFloat {
        AsFloat() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static float doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static float doBigInteger(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerAsFloat();
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static float doOther(HostObject receiver, @Bind(value="$node") Node node, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.asFloat(receiver.obj);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class AsBigInteger {
        AsBigInteger() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static BigInteger doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static BigInteger doBigInteger(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return (BigInteger)receiver.obj;
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static BigInteger doOther(HostObject receiver, @Bind(value="$node") Node node, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.asBigInteger(receiver.obj);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class AsLong {
        AsLong() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static long doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static long doBigInteger(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerAsLong();
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static long doOther(HostObject receiver, @Bind(value="$node") Node node, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.asLong(receiver.obj);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class AsInt {
        AsInt() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static int doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static int doBigInteger(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerAsInt();
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static int doOther(HostObject receiver, @Bind(value="$node") Node node, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.asInt(receiver.obj);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class AsShort {
        AsShort() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static short doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static short doBigInteger(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerAsShort();
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static short doOther(HostObject receiver, @Bind(value="$node") Node node, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.asShort(receiver.obj);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class AsByte {
        AsByte() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static byte doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static byte doBigInteger(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerAsByte();
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static byte doOther(HostObject receiver, @Bind(value="$node") Node node, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.asByte(receiver.obj);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class FitsInDouble {
        FitsInDouble() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static boolean doBigInteger(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerFitsInDouble();
            }
            return false;
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static boolean doOther(HostObject receiver, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.fitsInDouble(receiver.obj);
            }
            return false;
        }
    }

    @ExportMessage
    static class FitsInFloat {
        FitsInFloat() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static boolean doBigInteger(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerFitsInFloat();
            }
            return false;
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static boolean doOther(HostObject receiver, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.fitsInFloat(receiver.obj);
            }
            return false;
        }
    }

    @ExportMessage
    static class FitsInBigInteger {
        FitsInBigInteger() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static boolean doBigInteger(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return hostClassCache.isBigIntegerNumberAccess();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static boolean doOther(HostObject receiver, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.fitsInBigInteger(receiver.obj);
            }
            return false;
        }
    }

    @ExportMessage
    static class FitsInLong {
        FitsInLong() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static boolean doBigInteger(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerFitsInLong();
            }
            return false;
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static boolean doOther(HostObject receiver, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.fitsInLong(receiver.obj);
            }
            return false;
        }
    }

    @ExportMessage
    static class FitsInInt {
        FitsInInt() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static boolean doBigInteger(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerFitsInInt();
            }
            return false;
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static boolean doOther(HostObject receiver, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.fitsInInt(receiver.obj);
            }
            return false;
        }
    }

    @ExportMessage
    static class FitsInShort {
        FitsInShort() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static boolean doBigInteger(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerFitsInShort();
            }
            return false;
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static boolean doOther(HostObject receiver, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.fitsInShort(receiver.obj);
            }
            return false;
        }
    }

    @ExportMessage
    static class FitsInByte {
        FitsInByte() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static boolean doBigInteger(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            if (hostClassCache.isBigIntegerNumberAccess()) {
                return receiver.bigIntegerFitsInByte();
            }
            return false;
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static boolean doOther(HostObject receiver, @CachedLibrary(value="receiver") InteropLibrary receiverLibrary, @Cached.Shared(value="numbers") @CachedLibrary(limit="LIMIT") InteropLibrary numbers) {
            if (receiverLibrary.isNumber(receiver)) {
                return numbers.fitsInByte(receiver.obj);
            }
            return false;
        }
    }

    @ExportMessage
    static class IsNumber {
        IsNumber() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isBigInteger()"})
        static boolean doBigInteger(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return hostClassCache.isBigIntegerNumberAccess();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isBigInteger()"})
        static boolean doOther(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) {
            Class<?> c2 = classProfile.profile(node, receiver.obj).getClass();
            return c2 == Byte.class || c2 == Short.class || c2 == Integer.class || c2 == Long.class || c2 == Float.class || c2 == Double.class;
        }
    }

    @ExportMessage
    static class Instantiate {
        Instantiate() {
        }

        @Specialization(guards={"!receiver.isClass()"})
        static Object doUnsupported(HostObject receiver, Object[] args) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isArrayClass()"})
        static Object doArrayCached(HostObject receiver, Object[] args, @Bind(value="$node") Node node, @CachedLibrary(limit="1") InteropLibrary indexes, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
            if (args.length != 1) {
                error.enter(node);
                throw ArityException.create(1, 1, args.length);
            }
            Object arg0 = args[0];
            if (!indexes.fitsInInt(arg0)) {
                error.enter(node);
                throw UnsupportedTypeException.create(args);
            }
            int length = indexes.asInt(arg0);
            Object array = Array.newInstance(receiver.asClass().getComponentType(), length);
            return HostObject.forObject(array, receiver.context);
        }

        @Specialization(guards={"receiver.isDefaultClass()"})
        static Object doObjectCached(HostObject receiver, Object[] arguments, @Bind(value="$node") Node node, @Cached.Shared(value="lookupConstructor") @Cached LookupConstructorNode lookupConstructor, @Cached.Shared(value="hostExecute") @Cached HostExecuteNode executeMethod, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
            assert (!receiver.isArrayClass());
            HostMethodDesc constructor = lookupConstructor.execute(node, receiver, receiver.asClass());
            if (constructor != null) {
                return executeMethod.execute(node, constructor, null, arguments, receiver.context);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class IsInstantiable {
        IsInstantiable() {
        }

        @Specialization(guards={"!receiver.isClass()"})
        static boolean doUnsupported(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isArrayClass()"})
        static boolean doArrayCached(HostObject receiver) {
            return true;
        }

        @Specialization(guards={"receiver.isDefaultClass()"})
        static boolean doObjectCached(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared(value="lookupConstructor") @Cached LookupConstructorNode lookupConstructor) {
            return lookupConstructor.execute(node, receiver, receiver.asClass()) != null;
        }
    }

    @ExportMessage
    static class ReadBuffer {
        ReadBuffer() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static void doNull(HostObject receiver, long bufferByteOffset, byte[] destination, int destinationOffset, int byteLength) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isByteSequence()"})
        static void doByteSequence(HostObject receiver, long bufferByteOffset, byte[] destination, int destinationOffset, int byteLength, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!hostClassCache.isBufferAccess()) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (bufferByteOffset < 0L || Integer.MAX_VALUE < bufferByteOffset + (long)byteLength) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(bufferByteOffset, byteLength);
            }
            try {
                HostObject.getByteSequenceBytesBoundary(receiver.context.language.api, receiver.obj, (int)bufferByteOffset, destination, destinationOffset, byteLength);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(bufferByteOffset, byteLength);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isByteSequence()"})
        static void doOther(HostObject receiver, long bufferByteOffset, byte[] destination, int destinationOffset, int byteLength, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (bufferByteOffset < 0L || Integer.MAX_VALUE < bufferByteOffset + (long)byteLength) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(bufferByteOffset, byteLength);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                HostObject.getBufferBytesBoundary(buffer, (int)bufferByteOffset, destination, destinationOffset, byteLength);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(bufferByteOffset, byteLength);
            }
        }
    }

    @ExportMessage
    static class WriteBufferDouble {
        WriteBufferDouble() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static void doNull(HostObject receiver, ByteOrder order, long index, double value) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()"})
        static void doNonNull(HostObject receiver, ByteOrder order, long index, double value, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws InvalidBufferOffsetException, UnsupportedMessageException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                ByteOrder originalOrder = buffer.order();
                buffer.order(order);
                if (HostObject.isPEFriendlyBuffer(buffer)) {
                    buffer.putDouble((int)index, value);
                } else {
                    HostObject.putBufferDoubleBoundary(buffer, (int)index, value);
                }
                buffer.order(originalOrder);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
            catch (ReadOnlyBufferException e3) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
        }
    }

    @ExportMessage
    static class ReadBufferDouble {
        ReadBufferDouble() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static double doNull(HostObject receiver, ByteOrder order, long index) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isByteSequence()"})
        static double doByteSequence(HostObject receiver, ByteOrder order, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!hostClassCache.isBufferAccess()) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
            try {
                return HostObject.getByteSequenceDoubleBoundary(receiver.context.language.api, receiver.obj, (int)index, order);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isByteSequence()"})
        static double doOther(HostObject receiver, ByteOrder order, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                ByteOrder originalOrder = buffer.order();
                buffer.order(order);
                double result = HostObject.isPEFriendlyBuffer(buffer) ? buffer.getDouble((int)index) : HostObject.getBufferDoubleBoundary(buffer, (int)index);
                buffer.order(originalOrder);
                return result;
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
        }
    }

    @ExportMessage
    static class WriteBufferFloat {
        WriteBufferFloat() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static void doNull(HostObject receiver, ByteOrder order, long index, float value) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()"})
        static void doNonNull(HostObject receiver, ByteOrder order, long index, float value, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws InvalidBufferOffsetException, UnsupportedMessageException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                ByteOrder originalOrder = buffer.order();
                buffer.order(order);
                if (HostObject.isPEFriendlyBuffer(buffer)) {
                    buffer.putFloat((int)index, value);
                } else {
                    HostObject.putBufferFloatBoundary(buffer, (int)index, value);
                }
                buffer.order(originalOrder);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
            catch (ReadOnlyBufferException e3) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
        }
    }

    @ExportMessage
    static class ReadBufferFloat {
        ReadBufferFloat() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static float doNull(HostObject receiver, ByteOrder order, long index) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isByteSequence()"})
        static float doByteSequence(HostObject receiver, ByteOrder order, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!hostClassCache.isBufferAccess()) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
            try {
                return HostObject.getByteSequenceFloatBoundary(receiver.context.language.api, receiver.obj, (int)index, order);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isByteSequence()"})
        static float doOther(HostObject receiver, ByteOrder order, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                ByteOrder originalOrder = buffer.order();
                buffer.order(order);
                float result = HostObject.isPEFriendlyBuffer(buffer) ? buffer.getFloat((int)index) : HostObject.getBufferFloatBoundary(buffer, (int)index);
                buffer.order(originalOrder);
                return result;
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
        }
    }

    @ExportMessage
    static class WriteBufferLong {
        WriteBufferLong() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static void doNull(HostObject receiver, ByteOrder order, long index, long value) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()"})
        static void doNonNull(HostObject receiver, ByteOrder order, long index, long value, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws InvalidBufferOffsetException, UnsupportedMessageException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                ByteOrder originalOrder = buffer.order();
                buffer.order(order);
                if (HostObject.isPEFriendlyBuffer(buffer)) {
                    buffer.putLong((int)index, value);
                } else {
                    HostObject.putBufferLongBoundary(buffer, (int)index, value);
                }
                buffer.order(originalOrder);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
            catch (ReadOnlyBufferException e3) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
        }
    }

    @ExportMessage
    static class ReadBufferLong {
        ReadBufferLong() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static long doNull(HostObject receiver, ByteOrder order, long index) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isByteSequence()"})
        static long doByteSequence(HostObject receiver, ByteOrder order, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!hostClassCache.isBufferAccess()) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
            try {
                return HostObject.getByteSequenceLongBoundary(receiver.context.language.api, receiver.obj, (int)index, order);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isByteSequence()"})
        static long doOther(HostObject receiver, ByteOrder order, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                ByteOrder originalOrder = buffer.order();
                buffer.order(order);
                long result = HostObject.isPEFriendlyBuffer(buffer) ? buffer.getLong((int)index) : HostObject.getBufferLongBoundary(buffer, (int)index);
                buffer.order(originalOrder);
                return result;
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 8L);
            }
        }
    }

    @ExportMessage
    static class WriteBufferInt {
        WriteBufferInt() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static void doNull(HostObject receiver, ByteOrder order, long index, int value) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()"})
        static void doNonNull(HostObject receiver, ByteOrder order, long index, int value, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws InvalidBufferOffsetException, UnsupportedMessageException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                ByteOrder originalOrder = buffer.order();
                buffer.order(order);
                if (HostObject.isPEFriendlyBuffer(buffer)) {
                    buffer.putInt((int)index, value);
                } else {
                    HostObject.putBufferIntBoundary(buffer, (int)index, value);
                }
                buffer.order(originalOrder);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
            catch (ReadOnlyBufferException e3) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
        }
    }

    @ExportMessage
    static class ReadBufferInt {
        ReadBufferInt() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static int doNull(HostObject receiver, ByteOrder order, long index) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isByteSequence()"})
        static int doByteSequence(HostObject receiver, ByteOrder order, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!hostClassCache.isBufferAccess()) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
            try {
                return HostObject.getByteSequenceIntBoundary(receiver.context.language.api, receiver.obj, (int)index, order);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isByteSequence()"})
        static int doOther(HostObject receiver, ByteOrder order, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                ByteOrder originalOrder = buffer.order();
                buffer.order(order);
                int result = HostObject.isPEFriendlyBuffer(buffer) ? buffer.getInt((int)index) : HostObject.getBufferIntBoundary(buffer, (int)index);
                buffer.order(originalOrder);
                return result;
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 4L);
            }
        }
    }

    @ExportMessage
    static class WriteBufferShort {
        WriteBufferShort() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static void doNull(HostObject receiver, ByteOrder order, long index, short value) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()"})
        static void doNonNull(HostObject receiver, ByteOrder order, long index, short value, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws InvalidBufferOffsetException, UnsupportedMessageException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 2L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                ByteOrder originalOrder = buffer.order();
                buffer.order(order);
                if (HostObject.isPEFriendlyBuffer(buffer)) {
                    buffer.putShort((int)index, value);
                } else {
                    HostObject.putBufferShortBoundary(buffer, (int)index, value);
                }
                buffer.order(originalOrder);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 2L);
            }
            catch (ReadOnlyBufferException e3) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
        }
    }

    @ExportMessage
    static class ReadBufferShort {
        ReadBufferShort() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static short doNull(HostObject receiver, ByteOrder order, long index) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isByteSequence()"})
        static short doByteSequence(HostObject receiver, ByteOrder order, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!hostClassCache.isBufferAccess()) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 2L);
            }
            try {
                return HostObject.getByteSequenceShortBoundary(receiver.context.language.api, receiver.obj, (int)index, order);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 2L);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isByteSequence()"})
        static short doOther(HostObject receiver, ByteOrder order, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 2L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                ByteOrder originalOrder = buffer.order();
                buffer.order(order);
                short result = HostObject.isPEFriendlyBuffer(buffer) ? buffer.getShort((int)index) : HostObject.getBufferShortBoundary(buffer, (int)index);
                buffer.order(originalOrder);
                return result;
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 2L);
            }
        }
    }

    @ExportMessage
    static class WriteBufferByte {
        WriteBufferByte() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static void doNull(HostObject receiver, long index, byte value) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()"})
        static void doNonNull(HostObject receiver, long index, byte value, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws InvalidBufferOffsetException, UnsupportedMessageException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 1L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                if (HostObject.isPEFriendlyBuffer(buffer)) {
                    buffer.put((int)index, value);
                } else {
                    HostObject.putBufferByteBoundary(buffer, (int)index, value);
                }
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 1L);
            }
            catch (ReadOnlyBufferException e3) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
        }
    }

    @ExportMessage
    static class ReadBufferByte {
        ReadBufferByte() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static byte doNull(HostObject receiver, long index) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isByteSequence()"})
        static byte doByteSequence(HostObject receiver, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!hostClassCache.isBufferAccess()) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 1L);
            }
            try {
                return HostObject.getByteSequenceByteBoundary(receiver.context.language.api, receiver.obj, (int)index);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 1L);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isByteSequence()"})
        static byte doOther(HostObject receiver, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error, @Cached.Shared(value="classProfile") @Cached InlinedExactClassProfile classProfile) throws UnsupportedMessageException, InvalidBufferOffsetException {
            if (!receiver.isBuffer(hostClassCache)) {
                error.enter(node);
                throw UnsupportedMessageException.create();
            }
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 1L);
            }
            try {
                ByteBuffer buffer = (ByteBuffer)classProfile.profile(node, receiver.obj);
                return HostObject.isPEFriendlyBuffer(buffer) ? buffer.get((int)index) : HostObject.getBufferByteBoundary(buffer, (int)index);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidBufferOffsetException.create(index, 1L);
            }
        }
    }

    @ExportMessage
    static class GetBufferSize {
        GetBufferSize() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static long doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isByteSequence()"})
        static long doByteSequence(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (hostClassCache.isBufferAccess()) {
                return HostObject.getByteSequenceLengthBoundary(receiver.context.language.api, receiver.obj);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isByteSequence()"})
        static long doOther(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (receiver.isBuffer(hostClassCache)) {
                ByteBuffer buffer = (ByteBuffer)receiver.obj;
                return HostObject.isPEFriendlyBuffer(buffer) ? (long)buffer.limit() : HostObject.getBufferSizeBoundary(buffer);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class IsBufferWritable {
        IsBufferWritable() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"receiver.isByteSequence()"})
        static boolean doByteSequence(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isByteSequence()"})
        static boolean doOther(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws UnsupportedMessageException {
            if (receiver.isBuffer(hostClassCache)) {
                ByteBuffer buffer = (ByteBuffer)receiver.obj;
                return HostObject.isPEFriendlyBuffer(buffer) ? !buffer.isReadOnly() : HostObject.isBufferWritableBoundary(buffer);
            }
            error.enter(node);
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class HasBufferElements {
        HasBufferElements() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"receiver.isByteSequence()"})
        static boolean doByteSequence(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return hostClassCache.isBufferAccess();
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isByteSequence()"})
        static boolean doOther(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return receiver.isBuffer(hostClassCache);
        }
    }

    @ExportMessage
    static abstract class GetArraySize {
        GetArraySize() {
        }

        @Specialization(guards={"receiver.isNull()"})
        protected static long doNull(HostObject receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isArray(hostClassCache)"})
        protected static long doArray(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return Array.getLength(receiver.obj);
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isList(hostClassCache)"})
        protected static long doList(HostObject receiver, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) {
            try {
                return GuestToHostCalls.getListSize(receiver);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isMapEntry(hostClassCache)"})
        protected static long doMapEntry(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return 2L;
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isArray(hostClassCache)", "!receiver.isList(hostClassCache)", "!receiver.isMapEntry(hostClassCache)"})
        protected static long doNotArrayOrList(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static abstract class ReadArrayElement {
        ReadArrayElement() {
        }

        @Specialization(guards={"receiver.isNull()"})
        protected static Object doNull(HostObject receiver, long index) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isArray(hostClassCache)"})
        protected static Object doArray(HostObject receiver, long index, @Bind(value="$node") Node node, @Cached ArrayGet arrayGet, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toGuest") @Cached(inline=true) HostContext.ToGuestValueNode toGuest, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws InvalidArrayIndexException {
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
            Object obj = receiver.obj;
            Object val = null;
            try {
                val = arrayGet.execute(node, obj, (int)index);
            }
            catch (ArrayIndexOutOfBoundsException outOfBounds) {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
            return toGuest.execute(node, receiver.context, val);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!receiver.isNull()", "receiver.isList(hostClassCache)"})
        protected static Object doList(HostObject receiver, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toGuest") @Cached(inline=true) HostContext.ToGuestValueNode toGuest, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws InvalidArrayIndexException {
            Object hostValue;
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
            try {
                hostValue = GuestToHostCalls.readListElement(receiver, index);
            }
            catch (IndexOutOfBoundsException e2) {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
            return toGuest.execute(node, receiver.context, hostValue);
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isMapEntry(hostClassCache)"})
        protected static Object doMapEntry(HostObject receiver, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toGuest") @Cached(inline=true) HostContext.ToGuestValueNode toGuest, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws InvalidArrayIndexException {
            Object hostResult;
            if (index == 0L) {
                try {
                    hostResult = GuestToHostCalls.getMapEntryKey(receiver);
                }
                catch (Throwable t2) {
                    error.enter(node);
                    throw receiver.context.hostToGuestException(t2);
                }
            } else if (index == 1L) {
                try {
                    hostResult = GuestToHostCalls.getMapEntryValue(receiver);
                }
                catch (Throwable t3) {
                    error.enter(node);
                    throw receiver.context.hostToGuestException(t3);
                }
            } else {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
            return toGuest.execute(node, receiver.context, hostResult);
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isArray(hostClassCache)", "!receiver.isList(hostClassCache)", "!receiver.isMapEntry(hostClassCache)"})
        protected static Object doNotArrayOrList(HostObject receiver, long index, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class HasArrayElements {
        HasArrayElements() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()"})
        static boolean doNotNull(HostObject receiver, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return receiver.isList(hostClassCache) || receiver.isArray(hostClassCache) || receiver.isMapEntry(hostClassCache);
        }
    }

    @ExportMessage
    static class RemoveArrayElement {
        RemoveArrayElement() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static void doNull(HostObject receiver, long index) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isList(hostClassCache)"})
        static void doList(HostObject receiver, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws InvalidArrayIndexException {
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
            try {
                GuestToHostCalls.removeListElement(receiver, index);
            }
            catch (IndexOutOfBoundsException outOfBounds) {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isList(hostClassCache)"})
        static void doOther(HostObject receiver, long index, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class IsArrayElementRemovable {
        IsArrayElementRemovable() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver, long index) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isList(hostClassCache)"})
        static boolean doList(HostObject receiver, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) {
            try {
                return index >= 0L && index < (long)GuestToHostCalls.getListSize(receiver);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isList(hostClassCache)"})
        static boolean doOther(HostObject receiver, long index, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return false;
        }
    }

    @ExportMessage
    static class WriteArrayElement {
        WriteArrayElement() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static void doNull(HostObject receiver, long index, Object value) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isArray(hostClassCache)"})
        static void doArray(HostObject receiver, long index, Object value, @Bind(value="$node") Node node, @Cached.Shared(value="toHost") @Cached(inline=true) HostToTypeNode toHostNode, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached ArraySet arraySet, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
            Object javaValue;
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
            Object obj = receiver.obj;
            try {
                javaValue = toHostNode.execute(node, receiver.context, value, obj.getClass().getComponentType(), null, true);
            }
            catch (RuntimeException e2) {
                error.enter(node);
                RuntimeException ee = HostObject.unboxEngineException(receiver, e2);
                if (ee != null) {
                    throw UnsupportedTypeException.create(new Object[]{value}, HostObject.getMessage(ee));
                }
                throw e2;
            }
            try {
                arraySet.execute(node, obj, (int)index, javaValue);
            }
            catch (ArrayIndexOutOfBoundsException e3) {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isList(hostClassCache)"})
        static void doList(HostObject receiver, long index, Object value, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toHost") @Cached(inline=true) HostToTypeNode toHostNode, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
            Object javaValue;
            if (index < 0L || Integer.MAX_VALUE < index) {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
            try {
                javaValue = toHostNode.execute(node, receiver.context, value, Object.class, null, true);
            }
            catch (RuntimeException e2) {
                error.enter(node);
                RuntimeException ee = HostObject.unboxEngineException(receiver, e2);
                if (ee != null) {
                    throw UnsupportedTypeException.create(new Object[]{value}, HostObject.getMessage(ee));
                }
                throw e2;
            }
            try {
                GuestToHostCalls.setListElement(receiver, index, javaValue);
            }
            catch (IndexOutOfBoundsException e3) {
                error.enter(node);
                throw InvalidArrayIndexException.create(index);
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isMapEntry(hostClassCache)"})
        static void doMapEntry(HostObject receiver, long index, Object value, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="toHost") @Cached(inline=true) HostToTypeNode toHostNode, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) throws InvalidArrayIndexException, UnsupportedTypeException {
            if (index == 1L) {
                Object hostValue;
                try {
                    hostValue = toHostNode.execute(node, receiver.context, value, Object.class, null, true);
                }
                catch (RuntimeException e2) {
                    error.enter(node);
                    RuntimeException ee = HostObject.unboxEngineException(receiver, e2);
                    if (ee != null) {
                        throw UnsupportedTypeException.create(new Object[]{value}, HostObject.getMessage(ee));
                    }
                    throw e2;
                }
                try {
                    GuestToHostCalls.setMapEntryValue(receiver, hostValue);
                }
                catch (Throwable t2) {
                    error.enter(node);
                    throw receiver.context.hostToGuestException(t2);
                }
            }
            throw InvalidArrayIndexException.create(index);
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isList(hostClassCache)", "!receiver.isArray(hostClassCache)", "!receiver.isMapEntry(hostClassCache)"})
        static void doNotArrayOrList(HostObject receiver, long index, Object value, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    static class IsArrayElementInsertable {
        IsArrayElementInsertable() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver, long index) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()"})
        static boolean doNonNull(HostObject receiver, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) {
            try {
                return receiver.isList(hostClassCache) && (long)GuestToHostCalls.getListSize(receiver) == index;
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }
    }

    @ExportMessage
    static class IsArrayElementModifiable {
        IsArrayElementModifiable() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver, long index) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isArray(hostClassCache)"})
        static boolean doArray(HostObject receiver, long index, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            long size = Array.getLength(receiver.obj);
            return index >= 0L && index < size;
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isList(hostClassCache)"})
        static boolean doList(HostObject receiver, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) {
            try {
                long size = GuestToHostCalls.getListSize(receiver);
                return index >= 0L && index < size;
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isMapEntry(hostClassCache)"})
        static boolean doMapEntry(HostObject receiver, long index, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return index == 1L;
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isList(hostClassCache)", "!receiver.isArray(hostClassCache)", "!receiver.isMapEntry(hostClassCache)"})
        static boolean doNotArrayOrList(HostObject receiver, long index, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return false;
        }
    }

    @ExportMessage
    static class IsArrayElementReadable {
        IsArrayElementReadable() {
        }

        @Specialization(guards={"receiver.isNull()"})
        static boolean doNull(HostObject receiver, long index) {
            return false;
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isArray(hostClassCache)"})
        static boolean doArray(HostObject receiver, long index, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            long size = Array.getLength(receiver.obj);
            return index >= 0L && index < size;
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isList(hostClassCache)"})
        static boolean doList(HostObject receiver, long index, @Bind(value="$node") Node node, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache, @Cached.Shared(value="error") @Cached InlinedBranchProfile error) {
            try {
                long size = GuestToHostCalls.getListSize(receiver);
                return index >= 0L && index < size;
            }
            catch (Throwable t2) {
                error.enter(node);
                throw receiver.context.hostToGuestException(t2);
            }
        }

        @Specialization(guards={"!receiver.isNull()", "receiver.isMapEntry(hostClassCache)"})
        static boolean doMapEntry(HostObject receiver, long index, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return index >= 0L && index < 2L;
        }

        @Specialization(guards={"!receiver.isNull()", "!receiver.isList(hostClassCache)", "!receiver.isArray(hostClassCache)", "!receiver.isMapEntry(hostClassCache)"})
        static boolean doNotArrayOrList(HostObject receiver, long index, @Cached.Shared @Cached(value="receiver.getHostClassCache()", allowUncached=true) HostClassCache hostClassCache) {
            return false;
        }
    }

    @ExportMessage
    static class IsMemberInvocable {
        IsMemberInvocable() {
        }

        @Specialization(guards={"receiver.isStaticClass()", "receiver.isStaticClass() == cachedStatic", "receiver.getLookupClass() == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static boolean doCached(HostObject receiver, String name, @Cached(value="receiver.isStaticClass()") boolean cachedStatic, @Cached(value="receiver.getLookupClass()") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, name)") boolean cachedInvokable) {
            assert (cachedInvokable == IsMemberInvocable.doUncached(receiver, name));
            return cachedInvokable;
        }

        @Specialization(replaces={"doCached"})
        static boolean doUncached(HostObject receiver, String name) {
            if (receiver.isNull()) {
                return false;
            }
            return HostInteropReflect.isInvokable(receiver, receiver.getLookupClass(), name, receiver.isStaticClass());
        }
    }

    @ExportMessage
    static class IsMemberInternal {
        IsMemberInternal() {
        }

        @Specialization(guards={"receiver.isStaticClass()", "receiver.isStaticClass() == cachedStatic", "receiver.getLookupClass() == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static boolean doCached(HostObject receiver, String name, @Cached(value="receiver.isStaticClass()") boolean cachedStatic, @Cached(value="receiver.getLookupClass()") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, name)") boolean cachedInternal) {
            assert (cachedInternal == IsMemberInternal.doUncached(receiver, name));
            return cachedInternal;
        }

        @Specialization(replaces={"doCached"})
        static boolean doUncached(HostObject receiver, String name) {
            if (receiver.isNull()) {
                return false;
            }
            return HostInteropReflect.isInternal(receiver, receiver.getLookupClass(), name, receiver.isStaticClass());
        }
    }

    @ExportMessage
    static class IsMemberModifiable {
        IsMemberModifiable() {
        }

        @Specialization(guards={"receiver.isStaticClass()", "receiver.isStaticClass() == cachedStatic", "receiver.getLookupClass() == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static boolean doCached(HostObject receiver, String name, @Cached(value="receiver.isStaticClass()") boolean cachedStatic, @Cached(value="receiver.getLookupClass()") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, name)") boolean cachedModifiable) {
            assert (cachedModifiable == IsMemberModifiable.doUncached(receiver, name));
            return cachedModifiable;
        }

        @Specialization(replaces={"doCached"})
        static boolean doUncached(HostObject receiver, String name) {
            if (receiver.isNull()) {
                return false;
            }
            return HostInteropReflect.isModifiable(receiver, receiver.getLookupClass(), name, receiver.isStaticClass());
        }
    }

    @ExportMessage
    static class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"receiver.isStaticClass()", "receiver.isStaticClass() == cachedStatic", "receiver.getLookupClass() == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static boolean doCached(HostObject receiver, String name, @Cached(value="receiver.isStaticClass()") boolean cachedStatic, @Cached(value="receiver.getLookupClass()") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(receiver, name)") boolean cachedReadable) {
            assert (cachedReadable == IsMemberReadable.doUncached(receiver, name));
            return cachedReadable;
        }

        @Specialization(replaces={"doCached"})
        static boolean doUncached(HostObject receiver, String name) {
            if (receiver.isNull()) {
                return false;
            }
            return HostInteropReflect.isReadable(receiver, receiver.getLookupClass(), name, receiver.isStaticClass(), receiver.isClass());
        }
    }
}

