/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import java.util.ArrayDeque;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.HiddenKey;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.AsyncIteratorHelperPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.AsyncIteratorPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.AsyncGeneratorAwaitReturnNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.TryCatchNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.InternalCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAsyncGenerator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Completion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class AsyncIteratorHelperPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<HelperIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new AsyncIteratorHelperPrototypeBuiltins();
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("AsyncIteratorHelper.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Async Iterator Helper");
    private static final HiddenKey ITERATED_ID = new HiddenKey("Iterated");
    public static final HiddenKey IMPL_ID = new HiddenKey("ResumptionTarget");
    static final HiddenKey GENERATOR_BRAND = new HiddenKey("Async Iterator Helper");

    protected AsyncIteratorHelperPrototypeBuiltins() {
        super(PROTOTYPE_NAME, HelperIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, HelperIteratorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return AsyncIteratorHelperPrototypeBuiltinsFactory.AsyncIteratorHelperNextNodeGen.create(context, builtin, AsyncIteratorHelperPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return AsyncIteratorHelperPrototypeBuiltinsFactory.IteratorHelperReturnNodeGen.create(context, builtin, AsyncIteratorHelperPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum HelperIteratorPrototype implements BuiltinEnum<HelperIteratorPrototype>
    {
        next(0),
        return_(0);

        private final int length;

        private HelperIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class AsyncIteratorHelperNextNode
    extends AsyncIteratorHelperResumeNode {
        @Node.Child
        private JSFunctionCallNode callResolveNode = JSFunctionCallNode.createCall();
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;

        protected AsyncIteratorHelperNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
        }

        @Override
        @Specialization
        protected final Object validateAndResume(VirtualFrame frame, Object thisObj) {
            return super.validateAndResume(frame, thisObj);
        }

        @Override
        protected final void performNextOrReturn(VirtualFrame frame, JSAsyncGeneratorObject generator, PromiseCapabilityRecord promiseCapability) {
            JSFunction.AsyncGeneratorState state = generator.getAsyncGeneratorState();
            if (state == JSFunction.AsyncGeneratorState.Completed) {
                JSObject iteratorResult = this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
                this.callResolveNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), iteratorResult));
            } else {
                Completion completion = Completion.forNormal(Undefined.instance);
                ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
                AsyncGeneratorRequest request = AsyncGeneratorRequest.create(completion, promiseCapability);
                Boundaries.queueAdd(queue, request);
                if (state == JSFunction.AsyncGeneratorState.SuspendedStart || state == JSFunction.AsyncGeneratorState.SuspendedYield) {
                    this.performResumeNext(generator, completion, state);
                } else assert (state == JSFunction.AsyncGeneratorState.Executing || state == JSFunction.AsyncGeneratorState.AwaitingReturn);
            }
        }
    }

    public static abstract class IteratorHelperReturnNode
    extends AsyncIteratorHelperResumeNode {
        @Node.Child
        private AsyncGeneratorAwaitReturnNode asyncGeneratorAwaitReturnNode;

        protected IteratorHelperReturnNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.asyncGeneratorAwaitReturnNode = AsyncGeneratorAwaitReturnNode.create(context);
        }

        @Override
        @Specialization
        protected final Object validateAndResume(VirtualFrame frame, Object thisObj) {
            return super.validateAndResume(frame, thisObj);
        }

        @Override
        protected final void performNextOrReturn(VirtualFrame frame, JSAsyncGeneratorObject generator, PromiseCapabilityRecord promiseCapability) {
            Completion completion = Completion.forReturn(Undefined.instance);
            ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
            AsyncGeneratorRequest request = AsyncGeneratorRequest.create(completion, promiseCapability);
            Boundaries.queueAdd(queue, request);
            JSFunction.AsyncGeneratorState state = generator.getAsyncGeneratorState();
            if (state == JSFunction.AsyncGeneratorState.SuspendedStart || state == JSFunction.AsyncGeneratorState.Completed) {
                this.asyncGeneratorAwaitReturnNode.executeAsyncGeneratorAwaitReturn(frame, generator, queue);
            } else if (state == JSFunction.AsyncGeneratorState.SuspendedYield) {
                this.performResumeNext(generator, completion, state);
            } else assert (state == JSFunction.AsyncGeneratorState.Executing || state == JSFunction.AsyncGeneratorState.AwaitingReturn);
        }
    }

    protected static abstract class AsyncIteratorHelperResumeNode
    extends JSBuiltinNode {
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        private PropertyGetNode getGeneratorResumptionTargetNode;
        @Node.Child
        private InternalCallNode internalCallNode;
        @Node.Child
        private JSFunctionCallNode callNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        protected AsyncIteratorHelperResumeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
            this.getGeneratorResumptionTargetNode = PropertyGetNode.createGetHidden(IMPL_ID, context);
            this.internalCallNode = InternalCallNode.create();
            this.callNode = JSFunctionCallNode.createCall();
        }

        protected Object validateAndResume(VirtualFrame frame, Object thisObj) {
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.executeDefault();
            try {
                JSAsyncGeneratorObject generator;
                if (!(thisObj instanceof JSAsyncGeneratorObject) || (generator = (JSAsyncGeneratorObject)thisObj).getGeneratorBrand() != GENERATOR_BRAND) {
                    throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getName(), thisObj);
                }
                this.performNextOrReturn(frame, generator, promiseCapability);
            }
            catch (AbstractTruffleException ex) {
                if (this.getErrorObjectNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
                }
                Object error = this.getErrorObjectNode.execute(ex);
                this.callNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), error));
            }
            return promiseCapability.getPromise();
        }

        protected abstract void performNextOrReturn(VirtualFrame var1, JSAsyncGeneratorObject var2, PromiseCapabilityRecord var3);

        protected final void performResumeNext(JSAsyncGeneratorObject iterator, Completion completion, JSFunction.AsyncGeneratorState state) {
            assert (state == JSFunction.AsyncGeneratorState.SuspendedStart || state == JSFunction.AsyncGeneratorState.SuspendedYield) : state;
            JSFunctionObject resumptionClosure = (JSFunctionObject)this.getGeneratorResumptionTargetNode.getValue(iterator);
            ArrayDeque<AsyncGeneratorRequest> queue = iterator.getAsyncGeneratorQueue();
            assert (!queue.isEmpty());
            CallTarget resumptionTarget = JSFunction.getCallTarget(resumptionClosure);
            this.internalCallNode.execute(resumptionTarget, JSArguments.createOneArg(iterator, resumptionClosure, completion));
        }
    }

    protected static class CreateAsyncIteratorHelperNode
    extends JavaScriptBaseNode {
        private final JSContext context;
        @Node.Child
        private PropertySetNode setIteratedNode;
        @Node.Child
        private PropertySetNode setGeneratorResumptionTargetNode;
        @Node.Child
        private PropertySetNode setThisNode;

        public CreateAsyncIteratorHelperNode(JSContext context) {
            this.context = context;
            this.setIteratedNode = PropertySetNode.createSetHidden(ITERATED_ID, context);
            this.setGeneratorResumptionTargetNode = PropertySetNode.createSetHidden(IMPL_ID, context);
            this.setThisNode = PropertySetNode.createSetHidden(AsyncIteratorPrototypeBuiltins.AsyncIteratorAwaitNode.THIS_ID, context);
        }

        public JSDynamicObject execute(IteratorRecord iterated, JSFunctionObject start) {
            JSAsyncGeneratorObject iterator = JSAsyncGenerator.create(this.context.getAsyncIteratorHelperObjectFactory(), this.getRealm());
            this.setIteratedNode.setValue(iterator, iterated);
            this.setGeneratorResumptionTargetNode.setValue(iterator, start);
            iterator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.SuspendedStart);
            iterator.setAsyncGeneratorQueue(new ArrayDeque<AsyncGeneratorRequest>(4));
            iterator.setGeneratorBrand(GENERATOR_BRAND);
            this.setThisNode.setValue(start, iterator);
            return iterator;
        }

        public static CreateAsyncIteratorHelperNode create(JSContext context) {
            return new CreateAsyncIteratorHelperNode(context);
        }
    }
}

