/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ArrayFunctionBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.TypedArrayFunctionBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetIteratorFromMethodNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.SimpleArrayList;

public final class TypedArrayFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<TypedArrayFunction> {
    public static final JSBuiltinsContainer BUILTINS = new TypedArrayFunctionBuiltins();

    protected TypedArrayFunctionBuiltins() {
        super(JSArrayBufferView.CLASS_NAME, TypedArrayFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TypedArrayFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TypedArrayFunctionBuiltinsFactory.TypedArrayOfNodeGen.create(context, builtin, TypedArrayFunctionBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 1: {
                return TypedArrayFunctionBuiltinsFactory.TypedArrayFromNodeGen.create(context, builtin, TypedArrayFunctionBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TypedArrayFunction implements BuiltinEnum<TypedArrayFunction>
    {
        of(0),
        from(1);

        private final int length;

        private TypedArrayFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class TypedArrayOfNode
    extends ArrayFunctionBuiltins.JSArrayFunctionOperation {
        public TypedArrayOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, true);
        }

        @Specialization(guards={"isConstructor.executeBoolean(thisObj)"})
        protected JSTypedArrayObject arrayOf(Object thisObj, Object[] args) {
            int len = args.length;
            JSTypedArrayObject newObj = this.getArraySpeciesConstructorNode().typedArrayCreate(thisObj, len);
            for (int k2 = 0; k2 < len; ++k2) {
                Object kValue = args[k2];
                this.write((Object)newObj, k2, kValue);
            }
            return newObj;
        }

        @Fallback
        protected Object notConstructor(Object thisObj, Object args) {
            throw Errors.createTypeErrorNotAConstructor(thisObj, this.getContext());
        }
    }

    public static abstract class TypedArrayFromNode
    extends ArrayFunctionBuiltins.JSArrayFromNode {
        public TypedArrayFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, true);
        }

        @Override
        @Specialization(guards={"isConstructor.executeBoolean(thisObj)"})
        protected Object arrayFrom(Object thisObj, Object source, Object mapFn, Object thisArg, @Cached GetIteratorFromMethodNode getIteratorFromMethod, @Cached InlinedBranchProfile growBranch) {
            return this.arrayFromCommon(thisObj, source, mapFn, thisArg, false, getIteratorFromMethod, growBranch);
        }

        @Fallback
        protected Object notConstructor(Object thisObj, Object source, Object mapFn, Object thisArg) {
            throw Errors.createTypeErrorNotAConstructor(thisObj, this.getContext());
        }

        @Override
        protected JSDynamicObject arrayFromIterable(Object thisObj, Object items, Object usingIterator, Object mapFn, Object thisArg, boolean mapping, GetIteratorFromMethodNode getIteratorFromMethod, InlinedBranchProfile growProfile) {
            Object next;
            SimpleArrayList<Object> values = new SimpleArrayList<Object>();
            IteratorRecord iteratorRecord = getIteratorFromMethod.execute(this, items, usingIterator);
            while ((next = this.iteratorStep(iteratorRecord)) != Boolean.FALSE) {
                Object nextValue = this.getIteratorValue(next);
                values.add(nextValue, this, growProfile);
            }
            int len = values.size();
            JSTypedArrayObject obj = this.getArraySpeciesConstructorNode().typedArrayCreate(thisObj, len);
            for (int k2 = 0; k2 < len; ++k2) {
                Object mapped = values.get(k2);
                if (mapping) {
                    mapped = this.callMapFn(thisArg, mapFn, mapped, k2);
                }
                this.write((Object)obj, k2, mapped);
            }
            return obj;
        }
    }
}

