/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleSafepoint;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.ConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.ValueProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ArrayBufferPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.ArrayPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.TypedArrayPrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.sort.SortComparator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ForEachIndexCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSTypedArraySortNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.TypedArrayLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.DeletePropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ByteBufferAccess;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayIterator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.JSClassProfile;

public final class TypedArrayPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TypedArrayPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TypedArrayPrototypeBuiltins();

    protected TypedArrayPrototypeBuiltins() {
        super(JSArrayBufferView.PROTOTYPE_NAME, TypedArrayPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TypedArrayPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewSubarrayNodeGen.create(context, builtin, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 1: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewSetNodeGen.create(context, builtin, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 2: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewForEachNodeGen.create(context, builtin, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 3: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindNodeGen.create(context, builtin, true, false, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 4: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindIndexNodeGen.create(context, builtin, true, false, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 30: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindNodeGen.create(context, builtin, true, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 31: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFindIndexNodeGen.create(context, builtin, true, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 5: {
                return context.getEcmaScriptVersion() >= 9 ? TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewFillNodeGen.create(context, builtin, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context)) : ArrayPrototypeBuiltinsFactory.JSArrayFillNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 6: {
                return ArrayPrototypeBuiltinsFactory.JSArrayReduceNodeGen.create(context, builtin, true, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case 7: {
                return ArrayPrototypeBuiltinsFactory.JSArrayReduceNodeGen.create(context, builtin, true, false, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case 9: {
                return ArrayPrototypeBuiltinsFactory.JSArraySliceNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 10: {
                return ArrayPrototypeBuiltinsFactory.JSArrayEveryNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 11: {
                return ArrayPrototypeBuiltinsFactory.JSArrayCopyWithinNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 12: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIndexOfNodeGen.create(context, builtin, true, true, TypedArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 13: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIndexOfNodeGen.create(context, builtin, true, false, TypedArrayPrototypeBuiltins.args().withThis().varArgs().createArgumentNodes(context));
            }
            case 14: {
                return ArrayPrototypeBuiltinsFactory.JSArrayFilterNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 15: {
                return ArrayPrototypeBuiltinsFactory.JSArraySomeNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 16: {
                return ArrayPrototypeBuiltinsFactory.JSArrayMapNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 17: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToLocaleStringNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 18: {
                return ArrayPrototypeBuiltinsFactory.JSArrayJoinNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 19: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewReverseNodeGen.create(context, builtin, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 20: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewIteratorNodeGen.create(context, builtin, 1, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 21: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewIteratorNodeGen.create(context, builtin, 2, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 22: {
                return TypedArrayPrototypeBuiltinsFactory.JSArrayBufferViewIteratorNodeGen.create(context, builtin, 3, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 28: {
                return ArrayPrototypeBuiltinsFactory.JSArrayIncludesNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 29: {
                return ArrayPrototypeBuiltinsFactory.JSArrayAtNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 23: 
            case 25: 
            case 26: {
                return TypedArrayPrototypeBuiltinsFactory.GetTypedArrayLengthOrOffsetNodeGen.create(context, builtin, builtinEnum, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 24: 
            case 27: {
                return TypedArrayPrototypeBuiltinsFactory.GetTypedArrayBufferOrNameNodeGen.create(context, builtin, builtinEnum, TypedArrayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 32: {
                return ArrayPrototypeBuiltinsFactory.JSArrayToReversedNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 8: 
            case 33: {
                return TypedArrayPrototypeBuiltinsFactory.TypedArraySortMethodNodeGen.create(context, builtin, builtinEnum == TypedArrayPrototype.toSorted, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 34: {
                return ArrayPrototypeBuiltinsFactory.JSArrayWithNodeGen.create(context, builtin, true, TypedArrayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TypedArrayPrototype implements BuiltinEnum<TypedArrayPrototype>
    {
        subarray(2),
        set(1),
        forEach(1),
        find(1),
        findIndex(1),
        fill(1),
        reduce(1),
        reduceRight(1),
        sort(1),
        slice(2),
        every(1),
        copyWithin(2),
        indexOf(1),
        lastIndexOf(1),
        filter(1),
        some(1),
        map(1),
        toLocaleString(0),
        join(1),
        reverse(0),
        keys(0),
        values(0),
        entries(0),
        length(0),
        buffer(0),
        byteLength(0),
        byteOffset(0),
        _toStringTag(0){

            @Override
            public Object getKey() {
                return Symbol.SYMBOL_TO_STRING_TAG;
            }
        }
        ,
        includes(1),
        at(1),
        findLast(1),
        findLastIndex(1),
        toReversed(0),
        toSorted(1),
        with(2);

        private final int functionLength;

        private TypedArrayPrototype(int length) {
            this.functionLength = length;
        }

        @Override
        public int getLength() {
            return this.functionLength;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 28 -> 7;
                case 29 -> 13;
                case 30, 31, 32, 33, 34 -> 14;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }

        @Override
        public boolean isGetter() {
            return EnumSet.range(length, _toStringTag).contains(this);
        }
    }

    public static abstract class JSArrayBufferViewSubarrayNode
    extends ArrayBufferPrototypeBuiltins.JSArrayBufferOperation {
        @Node.Child
        private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode arraySpeciesCreateNode;

        public JSArrayBufferViewSubarrayNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTypedArrayObject subarray(JSTypedArrayObject thisObj, Object start, Object end, @Cached InlinedConditionProfile negativeBegin, @Cached InlinedConditionProfile negativeEnd, @Cached InlinedConditionProfile smallerEnd) {
            Object newLength;
            TypedArray array = JSArrayBufferView.typedArrayGetArrayType(thisObj);
            long srcLength = JSArrayBufferView.isOutOfBounds(thisObj, this.getContext()) ? 0L : array.length(thisObj);
            long relativeStart = this.toInteger(start);
            long startIndex = negativeBegin.profile(this, relativeStart < 0L) ? Math.max(srcLength + relativeStart, 0L) : Math.min(relativeStart, srcLength);
            int srcByteOffset = thisObj.getOffset();
            long beginByteOffset = (long)srcByteOffset + startIndex * (long)array.bytesPerElement();
            if (thisObj.hasAutoLength() && end == Undefined.instance) {
                newLength = Undefined.instance;
            } else {
                long relativeEnd = end == Undefined.instance ? srcLength : this.toInteger(end);
                long endIndex = negativeEnd.profile(this, relativeEnd < 0L) ? Math.max(srcLength + relativeEnd, 0L) : Math.min(relativeEnd, srcLength);
                newLength = smallerEnd.profile(this, endIndex < startIndex) ? Integer.valueOf(0) : Integer.valueOf((int)(endIndex - startIndex));
            }
            return this.subarrayImpl(thisObj, (int)beginByteOffset, newLength);
        }

        @Specialization(guards={"!isJSArrayBufferView(thisObj)"})
        protected JSTypedArrayObject subarrayGeneric(Object thisObj, Object begin0, Object end0) {
            throw Errors.createTypeErrorArrayBufferViewExpected();
        }

        protected JSTypedArrayObject subarrayImpl(JSTypedArrayObject thisObj, int beginByteOffset, Object newLength) {
            JSArrayBufferObject arrayBuffer = JSArrayBufferView.getArrayBuffer(thisObj);
            return this.getArraySpeciesConstructorNode().typedArraySpeciesCreate(thisObj, arrayBuffer, beginByteOffset, newLength);
        }

        protected ArrayPrototypeBuiltins.ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
            if (this.arraySpeciesCreateNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arraySpeciesCreateNode = this.insert(ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(this.getContext(), true));
            }
            return this.arraySpeciesCreateNode;
        }
    }

    public static abstract class JSArrayBufferViewSetNode
    extends ArrayBufferPrototypeBuiltins.JSArrayBufferOperation {
        private final BranchProfile needErrorBranch = BranchProfile.create();
        private final ConditionProfile sameBufferProf = ConditionProfile.create();
        private final ValueProfile sourceArrayProf = ValueProfile.createIdentityProfile();
        private final ValueProfile targetArrayProf = ValueProfile.createIdentityProfile();
        private final JSClassProfile sourceArrayClassProfile = JSClassProfile.create();
        private final ConditionProfile srcIsJSObject = ConditionProfile.create();
        private final ConditionProfile arrayIsFastArray = ConditionProfile.create();
        private final ConditionProfile arrayIsArrayBufferView = ConditionProfile.create();
        private final ConditionProfile isDirectProfile = ConditionProfile.create();
        private final ConditionProfile sourceInteropBufferProfile = ConditionProfile.create();
        private final ConditionProfile targetInteropBufferProfile = ConditionProfile.create();
        private final BranchProfile intToIntBranch = BranchProfile.create();
        private final BranchProfile floatToFloatBranch = BranchProfile.create();
        private final BranchProfile bigIntToBigIntBranch = BranchProfile.create();
        private final BranchProfile objectToObjectBranch = BranchProfile.create();
        private final ValueProfile sourceTypeProfile = ValueProfile.createClassProfile();
        private final ValueProfile targetTypeProfile = ValueProfile.createClassProfile();
        private final ValueProfile sourceElemTypeProfile = ValueProfile.createIdentityProfile();
        private final ValueProfile targetElemTypeProfile = ValueProfile.createIdentityProfile();
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private JSGetLengthNode getLengthNode;
        @Node.Child
        private InteropLibrary interopLibrary;
        @Node.Child
        private InteropLibrary getByteBufferInterop;
        @Node.Child
        private JSToNumberNode toNumberNode;
        @Node.Child
        private JSToBigIntNode toBigIntNode;

        public JSArrayBufferViewSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object set(JSTypedArrayObject targetObj, Object array, Object offset) {
            long targetOffsetLong = this.toInteger(offset);
            if (targetOffsetLong < 0L || targetOffsetLong > Integer.MAX_VALUE) {
                this.needErrorBranch.enter();
                throw Errors.createRangeError("out of bounds");
            }
            this.checkOutOfBounds(targetObj);
            int targetOffset = (int)targetOffsetLong;
            if (this.arrayIsArrayBufferView.profile(array instanceof JSTypedArrayObject)) {
                this.setArrayBufferView(targetObj, (JSTypedArrayObject)array, targetOffset);
            } else if (this.arrayIsFastArray.profile(JSArray.isJSFastArray(array))) {
                this.setFastArray(targetObj, (JSArrayObject)array, targetOffset);
            } else {
                this.setOther(targetObj, array, targetOffset);
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSArrayBufferView(thisObj)"})
        protected Object set(Object thisObj, Object array, Object offset) {
            throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
        }

        private void setFastArray(JSTypedArrayObject thisObj, JSArrayObject array, int offset) {
            assert (JSArrayBufferView.isJSArrayBufferView(thisObj));
            assert (JSArray.isJSFastArray(array));
            ScriptArray sourceArray = this.sourceArrayProf.profile(array.getArrayType());
            TypedArray targetArray = this.targetArrayProf.profile(thisObj.getArrayType());
            long sourceLen = sourceArray.length(array);
            this.rangeCheck(0L, sourceLen, offset, targetArray.length(thisObj));
            boolean isBigInt = JSArrayBufferView.isBigIntArrayBufferView(thisObj);
            int i2 = 0;
            int j2 = offset;
            while ((long)i2 < sourceLen) {
                Object numValue;
                sourceArray = this.sourceArrayProf.profile(array.getArrayType());
                Object value = sourceArray.getElement(array, i2);
                Object object = numValue = isBigInt ? this.toBigInt(value) : this.toNumber(value);
                if (!JSArrayBufferView.isOutOfBounds(thisObj, this.getContext())) {
                    targetArray.setElement(thisObj, j2, numValue, false);
                }
                TruffleSafepoint.poll(this);
                ++i2;
                ++j2;
            }
        }

        private void setOther(JSTypedArrayObject thisObj, Object array, int offset) {
            assert (JSArrayBufferView.isJSArrayBufferView(thisObj));
            assert (!JSArray.isJSFastArray(array));
            TypedArray targetArray = this.targetArrayProf.profile(thisObj.getArrayType());
            long targetLength = targetArray.length(thisObj);
            Object src = this.toObject(array);
            long srcLength = this.objectGetLength(src);
            if (srcLength + (long)offset > targetLength) {
                throw Errors.createRangeError("out of bounds");
            }
            boolean isJSObject = JSDynamicObject.isJSDynamicObject(src);
            boolean isBigInt = JSArrayBufferView.isBigIntArrayBufferView(thisObj);
            int i2 = 0;
            int j2 = offset;
            while ((long)i2 < srcLength) {
                Object numValue;
                Object value = this.srcIsJSObject.profile(isJSObject) ? JSObject.get((JSDynamicObject)src, i2, this.sourceArrayClassProfile) : JSInteropUtil.readArrayElementOrDefault(src, i2, Undefined.instance);
                Object object = numValue = isBigInt ? this.toBigInt(value) : this.toNumber(value);
                if (!JSArrayBufferView.isOutOfBounds(thisObj, this.getContext())) {
                    targetArray.setElement(thisObj, j2, numValue, false);
                }
                TruffleSafepoint.poll(this);
                ++i2;
                ++j2;
            }
        }

        protected Object toNumber(Object value) {
            if (this.toNumberNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNumberNode = this.insert(JSToNumberNode.create());
            }
            return this.toNumberNode.execute(value);
        }

        protected Object toBigInt(Object value) {
            if (this.toBigIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBigIntNode = this.insert(JSToBigIntNode.create());
            }
            return this.toBigIntNode.execute(value);
        }

        private void setArrayBufferView(JSTypedArrayObject targetView, JSTypedArrayObject sourceView, int offset) {
            int srcByteIndex;
            this.checkOutOfBounds(sourceView);
            TypedArray sourceArray = this.sourceArrayProf.profile(sourceView.getArrayType());
            TypedArray targetArray = this.targetArrayProf.profile(targetView.getArrayType());
            long sourceLength = sourceArray.length(sourceView);
            this.rangeCheck(0L, sourceLength, offset, targetArray.length(targetView));
            int sourceLen = (int)sourceLength;
            JSArrayBufferObject sourceBuffer = JSArrayBufferView.getArrayBuffer(sourceView);
            JSArrayBufferObject targetBuffer = JSArrayBufferView.getArrayBuffer(targetView);
            int srcByteOffset = sourceView.getOffset();
            int targetByteOffset = targetView.getOffset();
            if (this.sameBufferProf.profile(sourceBuffer == targetBuffer)) {
                int targetByteIndex;
                boolean cloneNotNeeded;
                int srcByteLength = sourceLen * sourceArray.bytesPerElement();
                boolean bl = cloneNotNeeded = srcByteOffset + srcByteLength <= (targetByteIndex = targetByteOffset + offset * targetArray.bytesPerElement()) || targetByteIndex + srcByteLength <= srcByteOffset;
                if (cloneNotNeeded) {
                    srcByteIndex = srcByteOffset;
                } else {
                    sourceBuffer = this.cloneArrayBuffer(sourceBuffer, sourceArray, srcByteLength, srcByteOffset);
                    if (sourceArray.isInterop()) {
                        sourceArray = sourceArray.getFactory().createArrayType(this.getContext().isOptionDirectByteBuffer() ? (byte)1 : 0, false, true);
                    }
                    srcByteIndex = 0;
                }
            } else {
                srcByteIndex = srcByteOffset;
            }
            this.copyTypedArrayElementsDistinctBuffers(targetBuffer, sourceBuffer, targetArray, sourceArray, offset, targetByteOffset, sourceLen, srcByteIndex);
        }

        private void copyTypedArrayElementsDistinctBuffers(JSArrayBufferObject targetBuffer, JSArrayBufferObject sourceBuffer, TypedArray targetType, TypedArray sourceType, int targetOffset, int targetByteOffset, int sourceLength, int sourceByteIndex) {
            int targetElementSize = targetType.bytesPerElement();
            int sourceElementSize = sourceType.bytesPerElement();
            int targetByteIndex = targetByteOffset + targetOffset * targetElementSize;
            TypedArray.ElementType sourceElemType = sourceType.getElementType();
            TypedArray.ElementType targetElemType = targetType.getElementType();
            ByteBuffer sourceInteropByteBuffer = null;
            if (sourceType.isInterop()) {
                sourceInteropByteBuffer = this.getByteBufferFromInteropBuffer(sourceBuffer);
            }
            ByteBuffer targetInteropByteBuffer = null;
            if (targetType.isInterop()) {
                targetInteropByteBuffer = this.getByteBufferFromInteropBuffer(targetBuffer);
            }
            if (sourceElemType == targetElemType) {
                ByteBuffer sourceByteBuffer = null;
                ByteBuffer targetByteBuffer = null;
                byte[] sourceByteArray = null;
                byte[] targetByteArray = null;
                if (sourceType.isDirect()) {
                    sourceByteBuffer = JSArrayBuffer.getDirectByteBuffer(sourceBuffer);
                } else if (sourceType.isInterop()) {
                    sourceByteBuffer = sourceInteropByteBuffer;
                } else {
                    sourceByteArray = JSArrayBuffer.getByteArray(sourceBuffer);
                }
                if (targetType.isDirect()) {
                    targetByteBuffer = JSArrayBuffer.getDirectByteBuffer(targetBuffer);
                } else if (targetType.isInterop()) {
                    targetByteBuffer = targetInteropByteBuffer;
                } else {
                    targetByteArray = JSArrayBuffer.getByteArray(targetBuffer);
                }
                int sourceByteLength = sourceLength * sourceElementSize;
                if (sourceByteBuffer != null && targetByteBuffer != null) {
                    Boundaries.byteBufferPutSlice(targetByteBuffer, targetByteIndex, sourceByteBuffer, sourceByteIndex, sourceByteIndex + sourceByteLength);
                    return;
                }
                if (sourceByteArray != null && targetByteArray != null) {
                    System.arraycopy(sourceByteArray, sourceByteIndex, targetByteArray, targetByteIndex, sourceByteLength);
                    return;
                }
            }
            if (sourceType instanceof TypedArray.TypedBigIntArray != targetType instanceof TypedArray.TypedBigIntArray) {
                this.needErrorBranch.enter();
                throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
            }
            InteropLibrary interop = sourceType.isInterop() || targetType.isInterop() ? this.getInterop() : null;
            boolean hasSourceInteropByteBuffer = this.sourceInteropBufferProfile.profile(sourceInteropByteBuffer != null);
            boolean hasTargetInteropByteBuffer = this.targetInteropBufferProfile.profile(targetInteropByteBuffer != null);
            if (hasSourceInteropByteBuffer || hasTargetInteropByteBuffer) {
                boolean littleEndian = ByteOrder.LITTLE_ENDIAN == ByteOrder.nativeOrder();
                ByteBufferAccess bufferAccess = ByteBufferAccess.forOrder(littleEndian);
                for (int i2 = 0; i2 < sourceLength; ++i2) {
                    int sourceIndex = sourceByteIndex + i2 * sourceElementSize;
                    Object value = hasSourceInteropByteBuffer ? JSRuntime.getBufferElementDirect(bufferAccess, sourceInteropByteBuffer, this.sourceElemTypeProfile.profile(sourceElemType), sourceIndex) : this.sourceTypeProfile.profile(sourceType).getBufferElement(sourceBuffer, sourceIndex, littleEndian, interop);
                    int targetIndex = targetByteIndex + i2 * targetElementSize;
                    if (hasTargetInteropByteBuffer) {
                        JSRuntime.setBufferElementDirect(bufferAccess, targetInteropByteBuffer, this.targetElemTypeProfile.profile(targetElemType), targetIndex, value);
                    } else {
                        this.targetTypeProfile.profile(targetType).setBufferElement(targetBuffer, targetIndex, littleEndian, value, interop);
                    }
                    TruffleSafepoint.poll(this);
                }
                return;
            }
            if (sourceType instanceof TypedArray.TypedIntArray && targetType instanceof TypedArray.TypedIntArray && (sourceElemType != TypedArray.ElementType.Uint32 || targetElemType != TypedArray.ElementType.Uint8Clamped)) {
                this.intToIntBranch.enter();
                for (int i3 = 0; i3 < sourceLength; ++i3) {
                    int value = ((TypedArray.TypedIntArray)sourceType).getIntImpl(sourceBuffer, sourceByteIndex, i3, interop);
                    ((TypedArray.TypedIntArray)targetType).setIntImpl(targetBuffer, targetByteOffset, i3 + targetOffset, value, interop);
                    TruffleSafepoint.poll(this);
                }
            } else if (sourceType instanceof TypedArray.TypedFloatArray && targetType instanceof TypedArray.TypedFloatArray) {
                this.floatToFloatBranch.enter();
                for (int i4 = 0; i4 < sourceLength; ++i4) {
                    double value = ((TypedArray.TypedFloatArray)sourceType).getDoubleImpl(sourceBuffer, sourceByteIndex, i4, interop);
                    ((TypedArray.TypedFloatArray)targetType).setDoubleImpl(targetBuffer, targetByteOffset, i4 + targetOffset, value, interop);
                    TruffleSafepoint.poll(this);
                }
            } else if (sourceType instanceof TypedArray.TypedBigIntArray && targetType instanceof TypedArray.TypedBigIntArray) {
                this.bigIntToBigIntBranch.enter();
                for (int i5 = 0; i5 < sourceLength; ++i5) {
                    long value = ((TypedArray.TypedBigIntArray)sourceType).getLongImpl(sourceBuffer, sourceByteIndex, i5, interop);
                    ((TypedArray.TypedBigIntArray)targetType).setLongImpl(targetBuffer, targetByteOffset, i5 + targetOffset, value, interop);
                    TruffleSafepoint.poll(this);
                }
            } else {
                this.objectToObjectBranch.enter();
                boolean littleEndian = ByteOrder.LITTLE_ENDIAN == ByteOrder.nativeOrder();
                for (int i6 = 0; i6 < sourceLength; ++i6) {
                    Object value = sourceType.getBufferElement(sourceBuffer, sourceByteIndex + i6 * sourceElementSize, littleEndian, interop);
                    targetType.setBufferElement(targetBuffer, targetByteIndex + i6 * targetElementSize, littleEndian, value, interop);
                    TruffleSafepoint.poll(this);
                }
            }
        }

        private ByteBuffer getByteBufferFromInteropBuffer(JSArrayBufferObject interopBuffer) {
            if (this.getByteBufferInterop == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getByteBufferInterop = this.insert(InteropLibrary.getFactory().createDispatched(1));
            }
            return JSInteropUtil.jsInteropBufferAsByteBuffer(interopBuffer, this.getByteBufferInterop, this.getRealm());
        }

        private JSArrayBufferObject cloneArrayBuffer(JSArrayBufferObject sourceBuffer, TypedArray sourceArray, int srcByteLength, int srcByteOffset) {
            JSArrayBufferObject clonedArrayBuffer;
            if (sourceArray.isInterop()) {
                InteropLibrary interop = this.getInterop();
                clonedArrayBuffer = this.cloneInteropArrayBuffer(sourceBuffer, srcByteLength, srcByteOffset, interop);
            } else if (this.isDirectProfile.profile(sourceArray.isDirect())) {
                clonedArrayBuffer = JSArrayBuffer.createDirectArrayBuffer(this.getContext(), this.getRealm(), srcByteLength);
                ByteBuffer clonedBackingBuffer = JSArrayBuffer.getDirectByteBuffer(clonedArrayBuffer);
                ByteBuffer sourceBackingBuffer = JSArrayBuffer.getDirectByteBuffer(sourceBuffer);
                Boundaries.byteBufferPutSlice(clonedBackingBuffer, 0, sourceBackingBuffer, srcByteOffset, srcByteOffset + srcByteLength);
            } else {
                clonedArrayBuffer = JSArrayBuffer.createArrayBuffer(this.getContext(), this.getRealm(), srcByteLength);
                byte[] clonedBackingBuffer = JSArrayBuffer.getByteArray(clonedArrayBuffer);
                byte[] sourceBackingBuffer = JSArrayBuffer.getByteArray(sourceBuffer);
                System.arraycopy(sourceBackingBuffer, srcByteOffset, clonedBackingBuffer, 0, srcByteLength);
            }
            return clonedArrayBuffer;
        }

        private JSArrayBufferObject cloneInteropArrayBuffer(JSArrayBufferObject sourceBuffer, int srcByteLength, int srcByteOffset, InteropLibrary interop) {
            assert (JSArrayBuffer.isJSInteropArrayBuffer(sourceBuffer));
            boolean direct = this.getContext().isOptionDirectByteBuffer();
            TypedArray sourceType = TypedArrayFactory.Int8Array.createArrayType((byte)-1, false, true);
            TypedArray clonedType = TypedArrayFactory.Int8Array.createArrayType(direct ? (byte)1 : 0, false, true);
            JSArrayBufferObject clonedArrayBuffer = direct ? JSArrayBuffer.createDirectArrayBuffer(this.getContext(), this.getRealm(), srcByteLength) : JSArrayBuffer.createArrayBuffer(this.getContext(), this.getRealm(), srcByteLength);
            for (int i2 = 0; i2 < srcByteLength; ++i2) {
                int value = ((TypedArray.TypedIntArray)sourceType).getIntImpl(sourceBuffer, srcByteOffset, i2, interop);
                ((TypedArray.TypedIntArray)clonedType).setIntImpl(clonedArrayBuffer, 0, i2, value, interop);
                TruffleSafepoint.poll(this);
            }
            return clonedArrayBuffer;
        }

        private void rangeCheck(long sourceStart, long sourceLength, long targetStart, long targetLength) {
            if (sourceStart < 0L || targetStart < 0L || sourceStart > sourceLength || targetStart > targetLength || sourceLength - sourceStart > targetLength - targetStart) {
                this.needErrorBranch.enter();
                throw Errors.createRangeError("out of bounds");
            }
        }

        private Object toObject(Object array) {
            if (this.toObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = this.insert(JSToObjectNode.create());
            }
            return this.toObjectNode.execute(array);
        }

        private long objectGetLength(Object thisObject) {
            if (this.getLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLengthNode = this.insert(JSGetLengthNode.create(this.getContext()));
            }
            return this.getLengthNode.executeLong(thisObject);
        }

        private void checkOutOfBounds(JSTypedArrayObject view) {
            if (JSArrayBufferView.isOutOfBounds(view, this.getContext())) {
                this.needErrorBranch.enter();
                throw Errors.createTypeErrorOutOfBoundsTypedArray();
            }
        }

        private InteropLibrary getInterop() {
            InteropLibrary lib = this.interopLibrary;
            if (lib == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopLibrary = lib = this.insert(InteropLibrary.getFactory().createDispatched(5));
            }
            return lib;
        }
    }

    public static abstract class JSArrayBufferViewForEachNode
    extends ArrayPrototypeBuiltins.ArrayForEachIndexCallOperation {
        public JSArrayBufferViewForEachNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object forEach(JSTypedArrayObject thisJSObj, Object callback, Object thisArg) {
            this.checkOutOfBounds(thisJSObj);
            long length = JSArrayBufferView.typedArrayGetArrayType(thisJSObj).length(thisJSObj);
            Object callbackFn = this.checkCallbackIsFunction(callback);
            return this.forEachIndexCall(thisJSObj, callbackFn, thisArg, 0L, length, Undefined.instance);
        }

        @Specialization(guards={"!isJSArrayBufferView(thisJSObj)"})
        protected Object forEachNonTypedArray(Object thisJSObj, Object callback, Object thisArg) {
            throw Errors.createTypeErrorArrayBufferViewExpected();
        }

        @Override
        protected ForEachIndexCallNode.MaybeResultNode makeMaybeResultNode() {
            return new ForEachIndexCallNode.MaybeResultNode(){

                @Override
                public ForEachIndexCallNode.MaybeResult<Object> apply(long index, Object value, Object callbackResult, Object currentResult) {
                    return ForEachIndexCallNode.MaybeResult.continueResult(currentResult);
                }
            };
        }

        @Override
        protected boolean shouldCheckHasProperty() {
            return false;
        }
    }

    public static abstract class JSArrayBufferViewFillNode
    extends ArrayPrototypeBuiltins.JSArrayOperationWithToInt {
        public JSArrayBufferViewFillNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, true);
        }

        @Specialization
        protected JSDynamicObject fill(Object thisObj, Object value, Object start, Object end, @Cached JSToNumberNode toNumberNode, @Cached JSToBigIntNode toBigIntNode, @Cached InlinedConditionProfile offsetProfile1, @Cached InlinedConditionProfile offsetProfile2) {
            JSTypedArrayObject thisJSObj = this.validateTypedArray(thisObj);
            long len = this.getLength(thisJSObj);
            Object convValue = JSArrayBufferView.isBigIntArrayBufferView(thisJSObj) ? toBigIntNode.execute(value) : toNumberNode.execute(value);
            long lStart = JSRuntime.getOffset(this.toIntegerAsLong(start), len, (Node)this, offsetProfile1);
            long lEnd = end == Undefined.instance ? len : JSRuntime.getOffset(this.toIntegerAsLong(end), len, (Node)this, offsetProfile2);
            this.checkOutOfBounds(thisJSObj);
            for (long idx = lStart; idx < lEnd; ++idx) {
                this.write((Object)thisJSObj, idx, convValue);
                TruffleSafepoint.poll(this);
            }
            return thisJSObj;
        }
    }

    public static abstract class JSArrayBufferViewReverseNode
    extends ArrayPrototypeBuiltins.JSArrayOperation {
        public JSArrayBufferViewReverseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, true);
        }

        @Specialization
        protected JSDynamicObject reverse(JSTypedArrayObject thisObj, @Cached(value="create(THROW_ERROR)") DeletePropertyNode deletePropertyNode) {
            this.checkOutOfBounds(thisObj);
            long len = this.getLength(thisObj);
            long middle = len / 2L;
            long lower = 0L;
            while (lower != middle) {
                boolean upperExists;
                long upper = len - lower - 1L;
                Object lowerValue = null;
                Object upperValue = null;
                boolean lowerExists = this.hasProperty(thisObj, lower);
                if (lowerExists) {
                    lowerValue = this.read((Object)thisObj, lower);
                }
                if (upperExists = this.hasProperty(thisObj, upper)) {
                    upperValue = this.read((Object)thisObj, upper);
                }
                if (lowerExists && upperExists) {
                    this.write((Object)thisObj, lower, upperValue);
                    this.write((Object)thisObj, upper, lowerValue);
                } else if (upperExists) {
                    this.write((Object)thisObj, lower, upperValue);
                    deletePropertyNode.executeEvaluated(thisObj, upper);
                } else if (lowerExists) {
                    deletePropertyNode.executeEvaluated(thisObj, lower);
                    this.write((Object)thisObj, upper, lowerValue);
                }
                long nextLower = this.nextElementIndex(thisObj, lower, len);
                long nextUpper = this.previousElementIndex(thisObj, upper);
                lower = len - nextLower - 1L >= nextUpper ? nextLower : len - nextUpper - 1L;
                TruffleSafepoint.poll(this);
            }
            return thisObj;
        }

        @Specialization(guards={"!isJSArrayBufferView(thisJSObj)"})
        protected Object reverse(Object thisJSObj) {
            throw Errors.createTypeErrorArrayBufferViewExpected();
        }
    }

    public static abstract class JSArrayBufferViewIteratorNode
    extends JSBuiltinNode {
        private final int iterationKind;

        public JSArrayBufferViewIteratorNode(JSContext context, JSBuiltin builtin, int iterationKind) {
            super(context, builtin);
            this.iterationKind = iterationKind;
        }

        private JSObject createArrayIterator(Object thisObj) {
            return JSArrayIterator.create(this.getContext(), this.getRealm(), thisObj, 0L, this.iterationKind);
        }

        @Specialization
        protected final JSObject doObject(JSTypedArrayObject thisObj, @Cached InlinedBranchProfile errorBranch) {
            if (JSArrayBufferView.isOutOfBounds(thisObj, this.getContext())) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorOutOfBoundsTypedArray();
            }
            return this.createArrayIterator(thisObj);
        }

        @Specialization(guards={"!isJSArrayBufferView(thisObj)"})
        protected static JSObject doNotObject(Object thisObj) {
            throw Errors.createTypeErrorArrayBufferViewExpected();
        }
    }

    @ImportStatic(value={JSArrayBufferView.class})
    public static abstract class GetTypedArrayLengthOrOffsetNode
    extends JSBuiltinNode {
        private final TypedArrayPrototype getter;

        protected GetTypedArrayLengthOrOffsetNode(JSContext context, JSBuiltin builtin, TypedArrayPrototype getter) {
            super(context, builtin);
            this.getter = getter;
        }

        @Specialization(guards={"!isOutOfBounds(typedArray, getContext())"})
        protected final int doTypedArray(JSTypedArrayObject typedArray, @Cached TypedArrayLengthNode typedArrayLengthNode) {
            switch (this.getter.ordinal()) {
                case 23: {
                    return typedArrayLengthNode.execute(this, typedArray, this.getContext());
                }
                case 25: {
                    return typedArrayLengthNode.execute(this, typedArray, this.getContext()) << typedArray.getArrayType().bytesPerElementShift();
                }
                case 26: {
                    return typedArray.getOffset();
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"isOutOfBounds(typedArray, getContext())"})
        protected static int doTypedArrayOutOfBounds(JSTypedArrayObject typedArray) {
            return 0;
        }

        @Specialization(guards={"!isJSArrayBufferView(thisObj)"})
        protected int doIncompatibleReceiver(Object thisObj) {
            throw Errors.createTypeErrorArrayBufferViewExpected();
        }
    }

    public static abstract class GetTypedArrayBufferOrNameNode
    extends JSBuiltinNode {
        private final TypedArrayPrototype getter;

        protected GetTypedArrayBufferOrNameNode(JSContext context, JSBuiltin builtin, TypedArrayPrototype getter) {
            super(context, builtin);
            this.getter = getter;
        }

        @Specialization
        protected final Object doTypedArray(JSTypedArrayObject typedArray) {
            switch (this.getter.ordinal()) {
                case 24: {
                    return typedArray.getArrayBuffer();
                }
                case 27: {
                    return JSArrayBufferView.typedArrayGetName(typedArray);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSArrayBufferView(thisObj)"})
        protected Object doIncompatibleReceiver(Object thisObj) {
            if (this.getter == TypedArrayPrototype._toStringTag) {
                return Undefined.instance;
            }
            throw Errors.createTypeErrorArrayBufferViewExpected();
        }
    }

    public static abstract class TypedArraySortMethodNode
    extends ArrayPrototypeBuiltins.AbstractArraySortNode {
        private final boolean toSorted;

        protected TypedArraySortMethodNode(JSContext context, JSBuiltin builtin, boolean toSorted) {
            super(context, builtin, true);
            this.toSorted = toSorted;
        }

        @Specialization
        protected final JSTypedArrayObject sortTypedArray(Object thisObj, Object compare, @Cached JSTypedArraySortNode typedArraySortNode, @Cached TypedArrayLengthNode typedArrayLengthNode, @Cached InlinedConditionProfile isCompareUndefined) {
            JSTypedArrayObject resultArray;
            this.checkCompareCallableOrUndefined(compare);
            JSTypedArrayObject thisArray = this.validateTypedArray(thisObj);
            int len = typedArrayLengthNode.execute(this, thisArray, this.getContext());
            if (this.toSorted) {
                resultArray = this.typedArrayCreateSameType(thisArray, len);
                if (len == 0) {
                    return resultArray;
                }
            } else {
                resultArray = thisArray;
                if (len <= 1) {
                    return resultArray;
                }
            }
            SortComparator comparator = isCompareUndefined.profile(this, compare == Undefined.instance) ? null : new SortComparator(compare);
            typedArraySortNode.execute(thisArray, resultArray, len, comparator);
            return resultArray;
        }
    }
}

