/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.foreign;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.foreign.ForeignIterablePrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;

public final class ForeignIterablePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<ForeignIterablePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new ForeignIterablePrototypeBuiltins();

    protected ForeignIterablePrototypeBuiltins() {
        super(null, ForeignIterablePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, ForeignIterablePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return ForeignIterablePrototypeBuiltinsFactory.IteratorNodeGen.create(context, builtin, ForeignIterablePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum ForeignIterablePrototype implements BuiltinEnum<ForeignIterablePrototype>
    {
        _iterator(0);

        private final int length;

        private ForeignIterablePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public Object getKey() {
            return this == _iterator ? Symbol.SYMBOL_ITERATOR : BuiltinEnum.super.getKey();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class IteratorNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertySetNode setEnumerateIteratorNode;

        public IteratorNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.setEnumerateIteratorNode = PropertySetNode.createSetHidden(JSRuntime.ENUMERATE_ITERATOR_ID, context);
        }

        @Specialization
        protected JSDynamicObject iterator(Object target, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached InlinedBranchProfile errorBranch) {
            Object iterator;
            if (!interop.hasIterator(target)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorNotIterable(target, null);
            }
            try {
                iterator = interop.getIterator(target);
            }
            catch (UnsupportedMessageException e2) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorInteropException(target, e2, "getIterator", null);
            }
            JSObject iteratorObj = JSOrdinary.create(this.getContext(), this.getContext().getEnumerateIteratorFactory(), this.getRealm());
            this.setEnumerateIteratorNode.setValue(iteratorObj, iterator);
            return iteratorObj;
        }
    }
}

