/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper.FloatParserNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

public final class FloatParser {
    private final TruffleString input;
    private int pos;
    private boolean isNaN;
    private final double value;

    public FloatParser(TruffleString s2, FloatParserNode node) {
        this.input = s2;
        this.pos = 0;
        this.isNaN = false;
        this.value = this.parse(node);
    }

    public double getResult() {
        return this.value;
    }

    private double parse(FloatParserNode node) {
        this.strDecimalLiteral(node);
        if (this.isNaN) {
            return Double.NaN;
        }
        return this.parseValidSubstring(node);
    }

    private double parseValidSubstring(FloatParserNode node) {
        TruffleString validSubstring = Strings.substring(true, node.substringNode, this.input, 0, this.pos);
        try {
            return Strings.parseDouble(node.parseDoubleNode, validSubstring);
        }
        catch (TruffleString.NumberFormatException e2) {
            this.isNaN = true;
            return Double.NaN;
        }
    }

    private void strDecimalLiteral(FloatParserNode node) {
        char currentChar = this.current(node);
        if (currentChar == '+' || currentChar == '-') {
            this.next();
            currentChar = this.current(node);
        }
        if (JSRuntime.isAsciiDigit(currentChar) || currentChar == '.') {
            this.strUnsignedDecimalLiteral(node);
        } else {
            this.isNaN = true;
        }
    }

    private void strUnsignedDecimalLiteral(FloatParserNode node) {
        if (JSRuntime.isAsciiDigit(this.current(node))) {
            this.decimalDigits(node);
        }
        int prevPos = this.pos;
        if (this.hasNext() && this.current(node) == '.') {
            this.next();
            if (JSRuntime.isAsciiDigit(this.current(node))) {
                this.decimalDigits(node);
            }
        }
        if (this.isNaN) {
            this.pos = prevPos;
            this.isNaN = false;
            return;
        }
        prevPos = this.pos;
        if (this.isExponentPart(node)) {
            this.exponentPart(node);
        }
        if (this.isNaN) {
            this.pos = prevPos;
            this.isNaN = false;
        }
    }

    private void next() {
        ++this.pos;
    }

    private char current(FloatParserNode node) {
        if (this.hasNext()) {
            return Strings.charAt(node.charAtNode, this.input, this.pos);
        }
        return '\u0000';
    }

    private boolean hasNext() {
        return this.pos < Strings.length(this.input);
    }

    private void exponentPart(FloatParserNode node) {
        node.exponentBranch.enter();
        assert (this.current(node) == 'e' || this.current(node) == 'E');
        this.next();
        char currentChar = this.current(node);
        if (JSRuntime.isAsciiDigit(currentChar)) {
            this.decimalDigits(node);
        } else if (currentChar == '+' || currentChar == '-') {
            this.next();
            this.decimalDigits(node);
        } else {
            this.isNaN = true;
        }
    }

    private boolean isExponentPart(FloatParserNode node) {
        if (this.hasNext()) {
            char firstChar = this.current(node);
            return firstChar == 'e' || firstChar == 'E';
        }
        return false;
    }

    private void decimalDigits(FloatParserNode node) {
        char currentChar = this.current(node);
        boolean valid = false;
        while (JSRuntime.isAsciiDigit(currentChar) && this.hasNext()) {
            valid = true;
            this.next();
            currentChar = this.current(node);
        }
        if (!valid) {
            this.isNaN = true;
        }
    }
}

