/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.json;

import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ECMAErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.JSErrorType;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.JSType;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.ParserException;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.Token;
import org.cyclops.integratedscripting.vendors.com.oracle.js.parser.TokenType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;

public class NashornJSONParser {
    private final TruffleString source;
    private final JSContext context;
    private final int length;
    private int pos = 0;
    private static final int EOF = -1;
    private static final String MSG_INVALID_ESCAPE_CHAR = "invalid.escape.char";
    private static final String MSG_INVALID_HEX = "invalid.hex";
    private static final String MSG_JSON_INVALID_NUMBER = "json.invalid.number";
    private static final String MSG_LEXER_ERROR = "lexer.error.";
    private static final String MSG_MISSING_CLOSE_QUOTE = "missing.close.quote";
    private static final String MSG_PARSER_ERROR = "parser.error.";
    private static final String MSG_SYNTAX_ERROR_INVALID_JSON = "syntax.error.invalid.json";
    private static final String MSG_TRAILING_COMMA_IN_JSON = "trailing.comma.in.json";
    private static final String ERR_COLON = ":";
    private static final String ERR_COMMA_OR_RBRACE = ", or }";
    private static final String ERR_COMMA_OR_RBRACKET = ", or ]";
    private static final String ERR_EOF_STR = "eof";
    private static final String ERR_EXPECTED = "expected";
    private static final String ERR_IDENT = "ident";
    private static final String ERR_JSON_LITERAL = "json literal";
    private static final String ERR_STRING_CONTAINS_CONTROL_CHARACTER = "String contains control character";
    private static final int STATE_EMPTY = 0;
    private static final int STATE_ELEMENT_PARSED = 1;
    private static final int STATE_COMMA_PARSED = 2;

    public NashornJSONParser(TruffleString source, JSContext context) {
        this.source = source;
        this.context = context;
        this.length = Strings.length(source);
    }

    public Object parse() {
        Object value = this.parseLiteral();
        this.skipWhiteSpace();
        if (this.pos < this.length) {
            throw this.expectedError(this.pos, ERR_EOF_STR, NashornJSONParser.toString(this.peek()));
        }
        return value;
    }

    private Object parseLiteral() {
        this.skipWhiteSpace();
        int c2 = this.peek();
        if (c2 == -1) {
            throw this.expectedError(this.pos, ERR_JSON_LITERAL, ERR_EOF_STR);
        }
        switch (c2) {
            case 123: {
                return this.parseObject();
            }
            case 91: {
                return this.parseArray();
            }
            case 34: {
                return this.parseString();
            }
            case 102: {
                return this.parseKeyword(Strings.FALSE, Boolean.FALSE);
            }
            case 116: {
                return this.parseKeyword(Strings.TRUE, Boolean.TRUE);
            }
            case 110: {
                return this.parseKeyword(Strings.NULL, Null.instance);
            }
        }
        if (NashornJSONParser.isDigit(c2) || c2 == 45) {
            return this.parseNumber();
        }
        if (c2 == 46) {
            throw this.numberError(this.pos);
        }
        throw this.expectedError(this.pos, ERR_JSON_LITERAL, NashornJSONParser.toString(c2));
    }

    private Object parseObject() {
        JSObject jsobject = JSOrdinary.create(this.context, JSRealm.get(null));
        int state = 0;
        assert (this.peek() == 123);
        ++this.pos;
        block5: while (this.pos < this.length) {
            this.skipWhiteSpace();
            int c2 = this.peek();
            switch (c2) {
                case 34: {
                    if (state == 1) {
                        throw this.expectedError(this.pos, ERR_COMMA_OR_RBRACE, NashornJSONParser.toString(c2));
                    }
                    TruffleString id = this.parseString();
                    this.expectColon();
                    Object value = this.parseLiteral();
                    this.addObjectProperty(jsobject, id, value);
                    state = 1;
                    continue block5;
                }
                case 44: {
                    if (state != 1) {
                        throw this.trailingCommaError(this.pos, NashornJSONParser.toString(c2));
                    }
                    state = 2;
                    ++this.pos;
                    continue block5;
                }
                case 125: {
                    if (state == 2) {
                        throw this.trailingCommaError(this.pos, NashornJSONParser.toString(c2));
                    }
                    ++this.pos;
                    return jsobject;
                }
            }
            throw this.expectedError(this.pos, ERR_COMMA_OR_RBRACE, NashornJSONParser.toString(c2));
        }
        throw this.expectedError(this.pos, ERR_COMMA_OR_RBRACE, ERR_EOF_STR);
    }

    private void addObjectProperty(JSDynamicObject object, Object idStr, Object value) {
        JSObjectUtil.defineDataProperty(this.context, object, idStr, value, JSAttributes.getDefault());
    }

    private void expectColon() {
        this.skipWhiteSpace();
        int n2 = this.next();
        if (n2 != 58) {
            throw this.expectedError(this.pos - 1, ERR_COLON, NashornJSONParser.toString(n2));
        }
    }

    private Object parseArray() {
        JSArrayObject jsarray = JSArray.createEmptyZeroLength(this.context, JSRealm.get(null));
        ScriptArray arrayData = JSAbstractArray.arrayGetArrayType(jsarray);
        int state = 0;
        assert (this.peek() == 91);
        ++this.pos;
        block4: while (this.pos < this.length) {
            this.skipWhiteSpace();
            int c2 = this.peek();
            switch (c2) {
                case 44: {
                    if (state != 1) {
                        throw this.trailingCommaError(this.pos, NashornJSONParser.toString(c2));
                    }
                    state = 2;
                    ++this.pos;
                    continue block4;
                }
                case 93: {
                    if (state == 2) {
                        throw this.trailingCommaError(this.pos, NashornJSONParser.toString(c2));
                    }
                    ++this.pos;
                    return jsarray;
                }
            }
            if (state == 1) {
                throw this.expectedError(this.pos, ERR_COMMA_OR_RBRACKET, NashornJSONParser.toString(c2));
            }
            long index = arrayData.length(jsarray);
            arrayData = arrayData.setElement(jsarray, index, this.parseLiteral(), true);
            JSAbstractArray.arraySetArrayType(jsarray, arrayData);
            state = 1;
        }
        throw this.expectedError(this.pos, ERR_COMMA_OR_RBRACKET, ERR_EOF_STR);
    }

    private TruffleString parseString() {
        int start = ++this.pos;
        TruffleStringBuilderUTF16 sb = null;
        while (this.pos < this.length) {
            int c2 = this.next();
            if (c2 <= 31) {
                throw this.syntaxError(this.pos, ERR_STRING_CONTAINS_CONTROL_CHARACTER);
            }
            if (c2 == 92) {
                if (sb == null) {
                    sb = Strings.builderCreate(this.pos - start + 16);
                }
                Strings.builderAppend(sb, this.source, start, this.pos - 1);
                Strings.builderAppend(sb, this.parseEscapeSequence());
                start = this.pos;
                continue;
            }
            if (c2 != 34) continue;
            if (sb != null) {
                Strings.builderAppend(sb, this.source, start, this.pos - 1);
                return Strings.builderToString(sb);
            }
            return Strings.substring(this.context, this.source, start, this.pos - 1 - start);
        }
        throw this.error(NashornJSONParser.lexerMessage(MSG_MISSING_CLOSE_QUOTE, new String[0]), this.pos, this.length);
    }

    private char parseEscapeSequence() {
        int c2 = this.next();
        switch (c2) {
            case 34: {
                return '\"';
            }
            case 92: {
                return '\\';
            }
            case 47: {
                return '/';
            }
            case 98: {
                return '\b';
            }
            case 102: {
                return '\f';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 117: {
                return this.parseUnicodeEscape();
            }
        }
        throw this.error(NashornJSONParser.lexerMessage(MSG_INVALID_ESCAPE_CHAR, new String[0]), this.pos - 1, this.length);
    }

    private char parseUnicodeEscape() {
        return (char)(this.parseHexDigit() << 12 | this.parseHexDigit() << 8 | this.parseHexDigit() << 4 | this.parseHexDigit());
    }

    private int parseHexDigit() {
        int c2 = this.next();
        if (c2 >= 48 && c2 <= 57) {
            return c2 - 48;
        }
        if (c2 >= 65 && c2 <= 70) {
            return c2 + 10 - 65;
        }
        if (c2 >= 97 && c2 <= 102) {
            return c2 + 10 - 97;
        }
        throw this.error(NashornJSONParser.lexerMessage(MSG_INVALID_HEX, new String[0]), this.pos - 1, this.length);
    }

    private static boolean isDigit(int c2) {
        return c2 >= 48 && c2 <= 57;
    }

    private void skipDigits() {
        int c2;
        while (this.pos < this.length && NashornJSONParser.isDigit(c2 = this.peek())) {
            ++this.pos;
        }
    }

    private Number parseNumber() {
        double d2;
        int start = this.pos;
        int c2 = this.next();
        if (c2 == 45) {
            c2 = this.next();
        }
        if (!NashornJSONParser.isDigit(c2)) {
            throw this.numberError(start);
        }
        if (c2 != 48) {
            this.skipDigits();
        }
        if (this.peek() == 46) {
            ++this.pos;
            if (!NashornJSONParser.isDigit(this.next())) {
                throw this.numberError(this.pos - 1);
            }
            this.skipDigits();
        }
        if ((c2 = this.peek()) == 101 || c2 == 69) {
            ++this.pos;
            c2 = this.next();
            if (c2 == 45 || c2 == 43) {
                c2 = this.next();
            }
            if (!NashornJSONParser.isDigit(c2)) {
                throw this.numberError(this.pos - 1);
            }
            this.skipDigits();
        }
        try {
            d2 = Strings.parseDouble(Strings.lazySubstring(this.source, start, this.pos - start));
        }
        catch (TruffleString.NumberFormatException e2) {
            throw this.numberError(start);
        }
        if (JSType.isRepresentableAsInt(d2)) {
            return (int)d2;
        }
        if (JSType.isRepresentableAsLong(d2)) {
            return (long)d2;
        }
        return d2;
    }

    private Object parseKeyword(TruffleString keyword, Object value) {
        if (!Strings.regionEquals(this.source, this.pos, keyword, 0, Strings.length(keyword))) {
            throw this.expectedError(this.pos, ERR_JSON_LITERAL, ERR_IDENT);
        }
        this.pos += Strings.length(keyword);
        return value;
    }

    private int peek() {
        if (this.pos >= this.length) {
            return -1;
        }
        return Strings.charAt(this.source, this.pos);
    }

    private int next() {
        int next = this.peek();
        ++this.pos;
        return next;
    }

    private void skipWhiteSpace() {
        block3: while (this.pos < this.length) {
            switch (this.peek()) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private static String toString(int c2) {
        return c2 == -1 ? ERR_EOF_STR : String.valueOf((char)c2);
    }

    ParserException error(String message, int start, int length) throws ParserException {
        long token = Token.toDesc(TokenType.STRING, start, length);
        int pos = Token.descPosition(token);
        Source src = Source.sourceFor("<json>", Strings.toJavaString(this.source));
        int lineNum = src.getLine(pos);
        int columnNum = src.getColumn(pos);
        return new ParserException(JSErrorType.SyntaxError, message, src, lineNum, columnNum, token);
    }

    private ParserException error(String message, int start) {
        return this.error(message, start, this.length);
    }

    private ParserException numberError(int start) {
        return this.error(NashornJSONParser.lexerMessage(MSG_JSON_INVALID_NUMBER, new String[0]), start);
    }

    private ParserException expectedError(int start, String expected, String found) {
        return this.context.isOptionNashornCompatibilityMode() ? this.error(NashornJSONParser.parserMessage(ERR_EXPECTED, expected, found), start) : NashornJSONParser.expectedErrorV8(start, found);
    }

    private static ParserException expectedErrorV8(int start, String found) {
        char c2 = found.charAt(0);
        String entity = c2 == '\"' ? "string" : (Character.isDigit(c2) ? "number" : String.format("token %s", found));
        String message = String.format("Unexpected %s in JSON at position %d", entity, start);
        return new ParserException(message);
    }

    private ParserException syntaxError(int start, String reason) {
        String message = ECMAErrors.getMessage(MSG_SYNTAX_ERROR_INVALID_JSON, reason);
        return this.error(message, start);
    }

    private static String lexerMessage(String msgId, String ... args) {
        return ECMAErrors.getMessage(MSG_LEXER_ERROR + msgId, args);
    }

    private static String parserMessage(String msgId, String ... args) {
        return ECMAErrors.getMessage(MSG_PARSER_ERROR + msgId, args);
    }

    private ParserException trailingCommaError(int start, String found) {
        return this.context.isOptionNashornCompatibilityMode() ? this.error(NashornJSONParser.parserMessage(MSG_TRAILING_COMMA_IN_JSON, new String[0]), start) : NashornJSONParser.expectedErrorV8(start, found);
    }
}

