/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal;

import java.util.EnumSet;
import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.TemporalZonedDateTimePrototypeBuiltinsFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.temporal.UnsupportedValueOfNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltin;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.DifferenceZonedDateTimeWithRoundingNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetDifferenceSettingsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetRoundingIncrementOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetTemporalUnitNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.IsPartialTemporalObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.SnapshotOwnPropertiesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalAddZonedDateTimeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarGetterNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalMonthDayFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToFractionalSecondDigitsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarSlotValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalDateNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneIdentifierNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneSlotValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalZonedDateTimeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPrecisionRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TemporalDurationWithTotalRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public class TemporalZonedDateTimePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalZonedDateTimePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalZonedDateTimePrototypeBuiltins();

    protected TemporalZonedDateTimePrototypeBuiltins() {
        super(JSTemporalZonedDateTime.PROTOTYPE_NAME, TemporalZonedDateTimePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalZonedDateTimePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeCalendarGetterNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeTimeZoneIdGetterNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeGetterNodeGen.create(context, builtin, builtinEnum, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 39: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToStringNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 40: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToLocaleStringNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 41: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToLocaleStringNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 42: {
                return UnsupportedValueOfNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 28: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 29: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithPlainTimeNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 30: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithPlainDateNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 31: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithTimeZoneNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 32: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeWithCalendarNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 33: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeAddSubNodeGen.create(context, builtin, 1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 34: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeAddSubNodeGen.create(context, builtin, -1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 35: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeUntilSinceNodeGen.create(context, builtin, 1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 36: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeUntilSinceNodeGen.create(context, builtin, -1, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 37: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeRoundNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 38: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeEqualsNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 43: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeStartOfDayNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 44: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToInstantNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 45: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainDateNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 46: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainTimeNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 47: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainDateTimeNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 48: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainYearMonthNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 49: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeToPlainMonthDayNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
            case 50: {
                return TemporalZonedDateTimePrototypeBuiltinsFactory.JSTemporalZonedDateTimeGetISOFieldsNodeGen.create(context, builtin, TemporalZonedDateTimePrototypeBuiltins.args().withThis().fixedArgs(0).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalZonedDateTimePrototype implements BuiltinEnum<TemporalZonedDateTimePrototype>
    {
        calendarId(0),
        timeZoneId(0),
        year(0),
        month(0),
        monthCode(0),
        day(0),
        hour(0),
        minute(0),
        second(0),
        millisecond(0),
        microsecond(0),
        nanosecond(0),
        epochSeconds(0),
        epochMilliseconds(0),
        epochMicroseconds(0),
        epochNanoseconds(0),
        dayOfWeek(0),
        dayOfYear(0),
        weekOfYear(0),
        yearOfWeek(0),
        hoursInDay(0),
        daysInWeek(0),
        daysInMonth(0),
        daysInYear(0),
        monthsInYear(0),
        inLeapYear(0),
        offsetNanoseconds(0),
        offset(0),
        with(1),
        withPlainTime(0),
        withPlainDate(1),
        withTimeZone(1),
        withCalendar(1),
        add(1),
        subtract(1),
        until(1),
        since(1),
        round(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0),
        startOfDay(0),
        toInstant(0),
        toPlainDate(0),
        toPlainTime(0),
        toPlainDateTime(0),
        toPlainYearMonth(0),
        toPlainMonthDay(0),
        getISOFields(0);

        private final int length;

        private TemporalZonedDateTimePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.range(calendarId, offset).contains(this);
        }
    }

    public static abstract class JSTemporalZonedDateTimeCalendarGetterNode
    extends JSBuiltinNode {
        protected JSTemporalZonedDateTimeCalendarGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString calendarId(JSTemporalZonedDateTimeObject zonedDateTime, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            return toCalendarIdentifier.executeString(zonedDateTime.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(zonedDateTime)"})
        static TruffleString invalidReceiver(Object zonedDateTime) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeTimeZoneIdGetterNode
    extends JSBuiltinNode {
        protected JSTemporalZonedDateTimeTimeZoneIdGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString timeZoneId(JSTemporalZonedDateTimeObject zonedDateTime, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier) {
            return toTimeZoneIdentifier.executeString(zonedDateTime.getTimeZone());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(zonedDateTime)"})
        static TruffleString invalidReceiver(Object zonedDateTime) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeGetterNode
    extends JSBuiltinNode {
        protected final TemporalZonedDateTimePrototype property;

        protected JSTemporalZonedDateTimeGetterNode(JSContext context, JSBuiltin builtin, TemporalZonedDateTimePrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected Object zonedDateTimeGetter(JSTemporalZonedDateTimeObject zdt, @Cached TemporalCalendarGetterNode calendarGetterNode, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            switch (this.property.ordinal()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    return this.getterCalendarDetails(zdt, calendarGetterNode, createTimeZoneMethodsRecord);
                }
                case 20: {
                    return this.getterHoursInDay(zdt, errorBranch, createTimeZoneMethodsRecord);
                }
                case 12: {
                    return JSTemporalZonedDateTimeGetterNode.getterEpoch(zdt, BigInt.valueOf(1000000000L)).doubleValue();
                }
                case 13: {
                    return JSTemporalZonedDateTimeGetterNode.getterEpoch(zdt, BigInt.valueOf(1000000L)).doubleValue();
                }
                case 14: {
                    return JSTemporalZonedDateTimeGetterNode.getterEpoch(zdt, BigInt.valueOf(1000L));
                }
                case 15: {
                    return JSTemporalZonedDateTimeGetterNode.getterEpoch(zdt, BigInt.ONE);
                }
                case 26: {
                    return this.getterOffsetNanoseconds(zdt, createTimeZoneMethodsRecord);
                }
                case 27: {
                    return this.getterOffset(zdt, createTimeZoneMethodsRecord);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        private Object getterOffset(JSTemporalZonedDateTimeObject zdt, CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            Object timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            return TemporalUtil.builtinTimeZoneGetOffsetStringFor(this.getContext(), realm, timeZoneRec, instant);
        }

        private Object getterOffsetNanoseconds(JSTemporalZonedDateTimeObject zdt, CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            Object timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            return TemporalUtil.getOffsetNanosecondsFor(this.getContext(), realm, timeZoneRec, instant);
        }

        private Object getterHoursInDay(JSTemporalZonedDateTimeObject zdt, InlinedBranchProfile errorBranch, CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            Object timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            JSTemporalCalendarObject isoCalendar = TemporalUtil.getISO8601Calendar(this.getContext(), realm);
            JSTemporalPlainDateTimeObject temporalDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, isoCalendar);
            int year = temporalDateTime.getYear();
            int month = temporalDateTime.getMonth();
            int day = temporalDateTime.getDay();
            JSTemporalPlainDateTimeObject today = JSTemporalPlainDateTime.create(this.getContext(), realm, year, month, day, 0, 0, 0, 0, 0, 0, isoCalendar, this, errorBranch);
            ISODateRecord tomorrowFields = TemporalUtil.addISODate(year, month, day, 0, 0, 0, 1, TemporalUtil.Overflow.REJECT);
            JSTemporalPlainDateTimeObject tomorrow = JSTemporalPlainDateTime.create(this.getContext(), realm, tomorrowFields.year(), tomorrowFields.month(), tomorrowFields.day(), 0, 0, 0, 0, 0, 0, isoCalendar, this, errorBranch);
            JSTemporalInstantObject todayInstant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, today, TemporalUtil.Disambiguation.COMPATIBLE);
            JSTemporalInstantObject tomorrowInstant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, tomorrow, TemporalUtil.Disambiguation.COMPATIBLE);
            BigInt diffNs = tomorrowInstant.getNanoseconds().subtract(todayInstant.getNanoseconds());
            return diffNs.divide(BigInt.valueOf(36000000000000L));
        }

        private static BigInt getterEpoch(JSTemporalZonedDateTimeObject zdt, BigInt factor) {
            BigInt ns = zdt.getNanoseconds();
            BigInt s2 = ns.divide(factor);
            return s2;
        }

        private Object getterCalendarDetails(JSTemporalZonedDateTimeObject zdt, TemporalCalendarGetterNode calendarGetterNode, CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            Object timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            Object calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject tdt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            switch (this.property.ordinal()) {
                case 2: {
                    return TemporalUtil.calendarYear(calendarGetterNode, calendar, tdt);
                }
                case 3: {
                    return TemporalUtil.calendarMonth(calendarGetterNode, calendar, tdt);
                }
                case 4: {
                    return TemporalUtil.calendarMonthCode(calendarGetterNode, calendar, tdt);
                }
                case 5: {
                    return TemporalUtil.calendarDay(calendarGetterNode, calendar, tdt);
                }
                case 6: {
                    return tdt.getHour();
                }
                case 7: {
                    return tdt.getMinute();
                }
                case 8: {
                    return tdt.getSecond();
                }
                case 9: {
                    return tdt.getMillisecond();
                }
                case 10: {
                    return tdt.getMicrosecond();
                }
                case 11: {
                    return tdt.getNanosecond();
                }
                case 16: {
                    return TemporalUtil.calendarDayOfWeek(calendarGetterNode, calendar, tdt);
                }
                case 17: {
                    return TemporalUtil.calendarDayOfYear(calendarGetterNode, calendar, tdt);
                }
                case 18: {
                    return TemporalUtil.calendarWeekOfYear(calendarGetterNode, calendar, tdt);
                }
                case 19: {
                    return TemporalUtil.calendarYearOfWeek(calendarGetterNode, calendar, tdt);
                }
                case 21: {
                    return TemporalUtil.calendarDaysInWeek(calendarGetterNode, calendar, tdt);
                }
                case 22: {
                    return TemporalUtil.calendarDaysInMonth(calendarGetterNode, calendar, tdt);
                }
                case 23: {
                    return TemporalUtil.calendarDaysInYear(calendarGetterNode, calendar, tdt);
                }
                case 24: {
                    return TemporalUtil.calendarMonthsInYear(calendarGetterNode, calendar, tdt);
                }
                case 25: {
                    return TemporalUtil.calendarInLeapYear(calendarGetterNode, calendar, tdt);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalZonedDateTimeObject zonedDateTime, Object optionsParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached ToFractionalSecondDigitsNode toFractionalSecondDigitsNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.ShowCalendar showCalendar = TemporalUtil.toShowCalendarOption(options, getOptionNode, equalNode);
            int digits = toFractionalSecondDigitsNode.execute(options);
            TruffleString showOffset = TemporalUtil.toShowOffsetOption(options, getOptionNode);
            TemporalUtil.RoundingMode roundingMode = JSTemporalZonedDateTimeToString.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(options, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTime, TemporalUtil.Unit.EMPTY);
            if (smallestUnit == TemporalUtil.Unit.HOUR) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorSmallestUnitOutOfRange();
            }
            TruffleString showTimeZone = TemporalUtil.toShowTimeZoneNameOption(options, getOptionNode);
            JSTemporalPrecisionRecord precision = TemporalUtil.toSecondsStringPrecisionRecord(smallestUnit, digits);
            return TemporalUtil.temporalZonedDateTimeToString(this.getContext(), this.getRealm(), zonedDateTime, precision.getPrecision(), showCalendar, showTimeZone, showOffset, precision.getIncrement(), precision.getUnit(), roundingMode);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toLocaleString(JSTemporalZonedDateTimeObject zonedDateTime) {
            return TemporalUtil.temporalZonedDateTimeToString(this.getContext(), this.getRealm(), zonedDateTime, TemporalConstants.AUTO, TemporalUtil.ShowCalendar.AUTO, TemporalConstants.AUTO, TemporalConstants.AUTO);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    @ImportStatic(value={TemporalConstants.class})
    public static abstract class JSTemporalZonedDateTimeWith
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWith(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object with(JSTemporalZonedDateTimeObject zonedDateTime, Object temporalZonedDateTimeLike, Object options, @Bind(value="this") Node node, @Cached IsPartialTemporalObjectNode isPartialTemporalObjectNode, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached(value="createDateFromFields()") CalendarMethodsRecordLookupNode lookupDateFromFields, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createMergeFields()") CalendarMethodsRecordLookupNode lookupMergeFields, @Cached TemporalGetOptionNode getOptionNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached(value="create(getContext(), HOUR)") CreateDataPropertyNode createHourDataPropertyNode, @Cached(value="create(getContext(), MINUTE)") CreateDataPropertyNode createMinuteDataPropertyNode, @Cached(value="create(getContext(), SECOND)") CreateDataPropertyNode createSecondDataPropertyNode, @Cached(value="create(getContext(), MILLISECOND)") CreateDataPropertyNode createMillisecondDataPropertyNode, @Cached(value="create(getContext(), MICROSECOND)") CreateDataPropertyNode createMicrosecondDataPropertyNode, @Cached(value="create(getContext(), NANOSECOND)") CreateDataPropertyNode createNanosecondDataPropertyNode, @Cached(value="create(getContext(), OFFSET)") CreateDataPropertyNode createOffsetDataPropertyNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            if (!isPartialTemporalObjectNode.execute(temporalZonedDateTimeLike)) {
                errorBranch.enter(node);
                throw TemporalErrors.createTypeErrorPartialTemporalObjectExpected();
            }
            JSObject resolvedOptions = snapshotOwnProperties.snapshot(this.getOptionsObject(options, node, errorBranch, optionUndefined), Null.instance);
            Object calendarSlotValue = zonedDateTime.getCalendar();
            Object dateFromFieldsMethod = lookupDateFromFields.execute(calendarSlotValue);
            Object fieldsMethod = lookupFields.execute(calendarSlotValue);
            Object mergeFieldsMethod = lookupMergeFields.execute(calendarSlotValue);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateFromFieldsAndFieldsAndMergeFields(calendarSlotValue, dateFromFieldsMethod, fieldsMethod, mergeFieldsMethod);
            Object timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(this.getContext(), realm, timeZoneRec, instant);
            JSTemporalPlainDateTimeObject dateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, instant, calendarRec.receiver(), offsetNanoseconds);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, Boundaries.listEditableCopy(TemporalUtil.listDMMCY));
            JSDynamicObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), dateTime, fieldNames, TemporalUtil.listEmpty);
            createHourDataPropertyNode.executeVoid(fields, dateTime.getHour());
            createMinuteDataPropertyNode.executeVoid(fields, dateTime.getMinute());
            createSecondDataPropertyNode.executeVoid(fields, dateTime.getSecond());
            createMillisecondDataPropertyNode.executeVoid(fields, dateTime.getMillisecond());
            createMicrosecondDataPropertyNode.executeVoid(fields, dateTime.getMicrosecond());
            createNanosecondDataPropertyNode.executeVoid(fields, dateTime.getNanosecond());
            createOffsetDataPropertyNode.executeVoid(fields, TemporalUtil.formatISOTimeZoneOffsetString(offsetNanoseconds));
            JSTemporalZonedDateTimeWith.addFieldNames(fieldNames);
            JSObject partialZonedDateTime = TemporalUtil.prepareTemporalFields(this.getContext(), temporalZonedDateTimeLike, fieldNames, null);
            fields = TemporalUtil.calendarMergeFields(this.getContext(), realm, calendarRec, fields, partialZonedDateTime, node, errorBranch);
            fields = TemporalUtil.prepareTemporalFields(this.getContext(), fields, fieldNames, TemporalUtil.listOffset);
            TemporalUtil.Disambiguation disambiguation = TemporalUtil.toTemporalDisambiguation(resolvedOptions, getOptionNode, equalNode);
            TemporalUtil.OffsetOption offset = TemporalUtil.toTemporalOffset(resolvedOptions, TemporalConstants.PREFER, getOptionNode, equalNode);
            JSTemporalDateTimeRecord dateTimeResult = TemporalUtil.interpretTemporalDateTimeFields(calendarRec, fields, resolvedOptions, getOptionNode, dateFromFieldsNode);
            Object offsetString = JSObject.get(fields, TemporalConstants.OFFSET);
            long newOffsetNanoseconds = TemporalUtil.parseTimeZoneOffsetString((TruffleString)offsetString);
            BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(this.getContext(), realm, dateTimeResult.getYear(), dateTimeResult.getMonth(), dateTimeResult.getDay(), dateTimeResult.getHour(), dateTimeResult.getMinute(), dateTimeResult.getSecond(), dateTimeResult.getMillisecond(), dateTimeResult.getMicrosecond(), dateTimeResult.getNanosecond(), TemporalUtil.OffsetBehaviour.OPTION, newOffsetNanoseconds, timeZoneRec, disambiguation, offset, TemporalUtil.MatchBehaviour.MATCH_EXACTLY);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, epochNanoseconds, timeZone, calendarRec.receiver());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object temporalZonedDateTimeLike, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }

        @CompilerDirectives.TruffleBoundary
        private static void addFieldNames(List<TruffleString> fieldNames) {
            fieldNames.add(TemporalConstants.HOUR);
            fieldNames.add(TemporalConstants.MICROSECOND);
            fieldNames.add(TemporalConstants.MILLISECOND);
            fieldNames.add(TemporalConstants.MINUTE);
            fieldNames.add(TemporalConstants.NANOSECOND);
            fieldNames.add(TemporalConstants.OFFSET);
            fieldNames.add(TemporalConstants.SECOND);
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithPlainTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithPlainTime(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject withPlainTime(JSTemporalZonedDateTimeObject zonedDateTime, Object plainTimeLike, @Cached ToTemporalTimeNode toTemporalTime, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSRealm realm = this.getRealm();
            JSTemporalPlainTimeObject plainTime = plainTimeLike == Undefined.instance ? JSTemporalPlainTime.create(this.getContext(), realm, 0, 0, 0, 0, 0, 0, this, errorBranch) : toTemporalTime.execute(plainTimeLike, null);
            Object timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            Object calendar = zonedDateTime.getCalendar();
            JSTemporalPlainDateTimeObject plainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            JSTemporalPlainDateTimeObject resultPlainDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, plainDateTime.getYear(), plainDateTime.getMonth(), plainDateTime.getDay(), plainTime.getHour(), plainTime.getMinute(), plainTime.getSecond(), plainTime.getMillisecond(), plainTime.getMicrosecond(), plainTime.getNanosecond(), calendar, this, errorBranch);
            instant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, resultPlainDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, instant.getNanoseconds(), timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object plainTimeLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithPlainDate
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithPlainDate(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject withPlainDate(JSTemporalZonedDateTimeObject zonedDateTime, Object plainDateLike, @Cached ToTemporalDateNode toTemporalDate, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSTemporalPlainDateObject plainDate = toTemporalDate.execute(plainDateLike);
            Object timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSTemporalPlainDateTimeObject plainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, zonedDateTime.getCalendar());
            Object calendar = TemporalUtil.consolidateCalendars(zonedDateTime.getCalendar(), plainDate.getCalendar(), toCalendarIdentifier);
            JSTemporalPlainDateTimeObject resultPlainDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, plainDate.getYear(), plainDate.getMonth(), plainDate.getDay(), plainDateTime.getHour(), plainDateTime.getMinute(), plainDateTime.getSecond(), plainDateTime.getMillisecond(), plainDateTime.getMicrosecond(), plainDateTime.getNanosecond(), calendar, this, errorBranch);
            instant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, resultPlainDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, instant.getNanoseconds(), timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object plainDateLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithTimeZone
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithTimeZone(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject withTimeZone(JSTemporalZonedDateTimeObject zonedDateTime, Object timeZoneLike, @Cached ToTemporalTimeZoneSlotValueNode toTimeZoneSlotValue) {
            Object timeZone = toTimeZoneSlotValue.execute(timeZoneLike);
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), zonedDateTime.getNanoseconds(), timeZone, zonedDateTime.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object timeZoneLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeWithCalendar
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeWithCalendar(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject withCalendar(JSTemporalZonedDateTimeObject zonedDateTime, Object calendarLike, @Cached ToTemporalCalendarSlotValueNode toCalendarSlotValue) {
            Object calendar = toCalendarSlotValue.execute(calendarLike);
            return JSTemporalZonedDateTime.create(this.getContext(), this.getRealm(), zonedDateTime.getNanoseconds(), zonedDateTime.getTimeZone(), calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object calendarLike) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalZonedDateTimeAddSubNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected JSTemporalZonedDateTimeObject addDurationToOrSubtractDurationFromZonedDateTime(JSTemporalZonedDateTimeObject zonedDateTime, Object temporalDurationLike, Object optionsParam, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined, @Cached(value="createDateAdd()") CalendarMethodsRecordLookupNode lookupDateAdd, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord, @Cached TemporalAddZonedDateTimeNode addZonedDateTimeNode) {
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            Object timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            Object calendar = zonedDateTime.getCalendar();
            Object dateAddMethod = lookupDateAdd.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateAdd(calendar, dateAddMethod);
            JSRealm realm = this.getRealm();
            BigInt norm = TemporalUtil.normalizeTimeDuration((double)this.sign * duration.getHours(), (double)this.sign * duration.getMinutes(), (double)this.sign * duration.getSeconds(), (double)this.sign * duration.getMilliseconds(), (double)this.sign * duration.getMicroseconds(), (double)this.sign * duration.getNanoseconds());
            BigInt epochNanoseconds = addZonedDateTimeNode.execute(zonedDateTime.getNanoseconds(), timeZoneRec, calendarRec, (double)this.sign * duration.getYears(), (double)this.sign * duration.getMonths(), (double)this.sign * duration.getWeeks(), (double)this.sign * duration.getDays(), norm, null, options);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, epochNanoseconds, timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object temporalDurationLike, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalZonedDateTimeUntilSinceNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected Object differenceTemporalZonedDateTime(JSTemporalZonedDateTimeObject zonedDateTime, Object otherParam, Object options, @Bind(value="this") Node node, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached ToTemporalZonedDateTimeNode toTemporalZonedDateTime, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier, @Cached GetDifferenceSettingsNode getDifferenceSettings, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord, @Cached(value="createDateAdd()") CalendarMethodsRecordLookupNode lookupDateAdd, @Cached(value="createDateUntil()") CalendarMethodsRecordLookupNode lookupDateUntil, @Cached DifferenceZonedDateTimeWithRoundingNode differenceZonedDateTimeWithRounding, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalZonedDateTimeObject other = toTemporalZonedDateTime.execute(otherParam, Undefined.instance);
            Object calendar = zonedDateTime.getCalendar();
            if (!TemporalUtil.calendarEquals(calendar, other.getCalendar(), toCalendarIdentifier)) {
                errorBranch.enter(node);
                throw TemporalErrors.createRangeErrorIdenticalCalendarExpected();
            }
            JSObject resolvedOptions = snapshotOwnProperties.snapshot(this.getOptionsObject(options, node, errorBranch, optionUndefined), Null.instance);
            GetDifferenceSettingsNode.GetDifferenceSettingsResult settings = getDifferenceSettings.execute(this.sign, resolvedOptions, TemporalUtil.unitMappingDateTimeOrAuto, TemporalUtil.unitMappingDateTime, TemporalUtil.Unit.NANOSECOND, TemporalUtil.Unit.HOUR);
            TemporalUtil.Unit largestUnit = settings.largestUnit();
            JSRealm realm = this.getRealm();
            if (TemporalUtil.Unit.YEAR != largestUnit && TemporalUtil.Unit.MONTH != largestUnit && TemporalUtil.Unit.WEEK != largestUnit && TemporalUtil.Unit.DAY != largestUnit) {
                TemporalUtil.NormalizedTimeDurationWithTotalRecord diffRecord = TemporalUtil.differenceInstant(zonedDateTime.getNanoseconds(), other.getNanoseconds(), settings.roundingIncrement(), settings.smallestUnit(), settings.roundingMode());
                BigInt norm = diffRecord.normalizedTimeDuration();
                TimeDurationRecord result = TemporalUtil.balanceTimeDuration(norm, largestUnit);
                return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, 0.0, 0.0, 0.0, 0.0, (double)this.sign * result.hours(), (double)this.sign * result.minutes(), (double)this.sign * result.seconds(), (double)this.sign * result.milliseconds(), (double)this.sign * result.microseconds(), (double)this.sign * result.nanoseconds(), node, errorBranch);
            }
            Object timeZone = zonedDateTime.getTimeZone();
            if (!TemporalUtil.timeZoneEquals(timeZone, other.getTimeZone(), toTimeZoneIdentifier)) {
                errorBranch.enter(node);
                throw TemporalErrors.createRangeErrorIdenticalTimeZoneExpected();
            }
            if (zonedDateTime.getNanoseconds().compareTo(other.getNanoseconds()) == 0) {
                return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
            }
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            Object dateAddMethod = lookupDateAdd.execute(calendar);
            Object dateUntilMethod = lookupDateUntil.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateAddDateUntil(calendar, dateAddMethod, dateUntilMethod);
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSTemporalPlainDateTimeObject precalculatedPlainDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, options);
            TemporalDurationWithTotalRecord resultRecord = differenceZonedDateTimeWithRounding.execute(zonedDateTime.getNanoseconds(), other.getNanoseconds(), calendarRec, timeZoneRec, precalculatedPlainDateTime, resolvedOptions, largestUnit, settings.roundingIncrement(), settings.smallestUnit(), settings.roundingMode());
            JSTemporalDurationRecord result = resultRecord.duration();
            return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, (double)this.sign * result.getYears(), (double)this.sign * result.getMonths(), (double)this.sign * result.getWeeks(), (double)this.sign * result.getDays(), (double)this.sign * result.getHours(), (double)this.sign * result.getMinutes(), (double)this.sign * result.getSeconds(), (double)this.sign * result.getMilliseconds(), (double)this.sign * result.getMicroseconds(), (double)this.sign * result.getNanoseconds(), node, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object otherParam, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeRound
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeRound(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject round(JSTemporalZonedDateTimeObject zonedDateTime, Object roundToParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalUnitNode getSmallestUnit, @Cached GetRoundingIncrementOptionNode getRoundingIncrementOption, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            boolean inclusive;
            int maximum;
            JSDynamicObject roundTo;
            if (roundToParam == Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorOptionsUndefined();
            }
            if (Strings.isTString(roundToParam)) {
                roundTo = JSOrdinary.createWithNullPrototype(this.getContext());
                JSRuntime.createDataPropertyOrThrow(roundTo, TemporalConstants.SMALLEST_UNIT, roundToParam);
            } else {
                roundTo = this.getOptionsObject(roundToParam, this, errorBranch, optionUndefined);
            }
            int roundingIncrement = getRoundingIncrementOption.execute(roundTo);
            TemporalUtil.RoundingMode roundingMode = JSTemporalZonedDateTimeRound.toTemporalRoundingMode(roundTo, TemporalConstants.HALF_EXPAND, equalNode, getOptionNode);
            TemporalUtil.Unit smallestUnit = getSmallestUnit.execute(roundTo, TemporalConstants.SMALLEST_UNIT, TemporalUtil.unitMappingTimeOrDay, TemporalUtil.Unit.REQUIRED);
            if (TemporalUtil.Unit.DAY == smallestUnit) {
                maximum = 1;
                inclusive = true;
            } else {
                maximum = TemporalUtil.maximumTemporalDurationRoundingIncrement(smallestUnit);
                inclusive = false;
            }
            TemporalUtil.validateTemporalRoundingIncrement(roundingIncrement, maximum, inclusive, this, errorBranch);
            JSRealm realm = this.getRealm();
            BigInt thisNs = zonedDateTime.getNanoseconds();
            Object timeZone = zonedDateTime.getTimeZone();
            Object calendar = zonedDateTime.getCalendar();
            if (smallestUnit == TemporalUtil.Unit.NANOSECOND && roundingIncrement == 1) {
                return JSTemporalZonedDateTime.create(this.getContext(), realm, thisNs, timeZone, calendar);
            }
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, thisNs);
            long offsetNanoseconds = TemporalUtil.getOffsetNanosecondsFor(this.getContext(), realm, timeZoneRec, instant);
            JSTemporalPlainDateTimeObject tdt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, instant, calendar, offsetNanoseconds);
            JSTemporalCalendarObject isoCalendar = TemporalUtil.getISO8601Calendar(this.getContext(), realm);
            JSTemporalPlainDateTimeObject dtStart = JSTemporalPlainDateTime.create(this.getContext(), realm, tdt.getYear(), tdt.getMonth(), tdt.getDay(), 0, 0, 0, 0, 0, 0, isoCalendar, this, errorBranch);
            JSTemporalInstantObject instantStart = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, dtStart, TemporalUtil.Disambiguation.COMPATIBLE);
            BigInt startNs = instantStart.getNanoseconds();
            BigInt endNs = TemporalUtil.addDaysToZonedDateTime(this.getContext(), realm, instantStart, dtStart, timeZoneRec, 1).epochNanoseconds();
            BigInt dayLengthNs = endNs.subtract(startNs);
            if (dayLengthNs.compareValueTo(0L) == 0) {
                errorBranch.enter(this);
                throw Errors.createRangeError("day length of zero now allowed");
            }
            JSTemporalDurationRecord roundResult = TemporalUtil.roundISODateTime(tdt.getYear(), tdt.getMonth(), tdt.getDay(), tdt.getHour(), tdt.getMinute(), tdt.getSecond(), tdt.getMillisecond(), tdt.getMicrosecond(), tdt.getNanosecond(), roundingIncrement, smallestUnit, roundingMode, TemporalUtil.bigIntToLong(dayLengthNs));
            BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(this.getContext(), realm, TemporalUtil.dtoi(roundResult.getYears()), TemporalUtil.dtoi(roundResult.getMonths()), TemporalUtil.dtoi(roundResult.getDays()), TemporalUtil.dtoi(roundResult.getHours()), TemporalUtil.dtoi(roundResult.getMinutes()), TemporalUtil.dtoi(roundResult.getSeconds()), TemporalUtil.dtoi(roundResult.getMilliseconds()), TemporalUtil.dtoi(roundResult.getMicroseconds()), TemporalUtil.dtoi(roundResult.getNanoseconds()), TemporalUtil.OffsetBehaviour.OPTION, offsetNanoseconds, timeZoneRec, TemporalUtil.Disambiguation.COMPATIBLE, TemporalUtil.OffsetOption.PREFER, TemporalUtil.MatchBehaviour.MATCH_EXACTLY);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, epochNanoseconds, timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj, Object roundToParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeEquals
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeEquals(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equals(JSTemporalZonedDateTimeObject thisZonedDateTime, Object otherParam, @Cached ToTemporalZonedDateTimeNode toTemporalZonedDateTime, @Cached ToTemporalTimeZoneIdentifierNode toTimeZoneIdentifier, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            JSTemporalZonedDateTimeObject otherZonedDateTime = toTemporalZonedDateTime.execute(otherParam, Undefined.instance);
            if (!thisZonedDateTime.getNanoseconds().equals(otherZonedDateTime.getNanoseconds())) {
                return false;
            }
            if (!TemporalUtil.timeZoneEquals(thisZonedDateTime.getTimeZone(), otherZonedDateTime.getTimeZone(), toTimeZoneIdentifier)) {
                return false;
            }
            return TemporalUtil.calendarEquals(thisZonedDateTime.getCalendar(), otherZonedDateTime.getCalendar(), toCalendarIdentifier);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static boolean invalidReceiver(Object thisObj, Object otherParam) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeStartOfDay
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeStartOfDay(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object startOfDay(JSTemporalZonedDateTimeObject zonedDateTime, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            Object timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            Object calendar = zonedDateTime.getCalendar();
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            JSTemporalPlainDateTimeObject startDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, dt.getYear(), dt.getMonth(), dt.getDay(), 0, 0, 0, 0, 0, 0, calendar, this, errorBranch);
            JSTemporalInstantObject startInstant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, startDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, startInstant.getNanoseconds(), timeZone, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToInstant
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToInstant(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toInstant(JSTemporalZonedDateTimeObject zonedDateTime) {
            return JSTemporalInstant.create(this.getContext(), this.getRealm(), zonedDateTime.getNanoseconds());
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainDate
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainDate(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toPlainDate(JSTemporalZonedDateTimeObject zdt, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            Object timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), this.getRealm(), zdt.getNanoseconds());
            Object calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), this.getRealm(), timeZoneRec, instant, calendar);
            return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), dt.getYear(), dt.getMonth(), dt.getDay(), calendar, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainTime(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toPlainTime(JSTemporalZonedDateTimeObject zdt, @Cached InlinedBranchProfile errorBranch, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            Object timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            Object calendar = zdt.getCalendar();
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            return JSTemporalPlainTime.create(this.getContext(), realm, dt.getHour(), dt.getMinute(), dt.getSecond(), dt.getMillisecond(), dt.getMicrosecond(), dt.getNanosecond(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainDateTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainDateTime(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toPlainDateTime(JSTemporalZonedDateTimeObject zdt, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            Object timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            Object calendar = zdt.getCalendar();
            return TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainYearMonth
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainYearMonth(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toPlainYearMonth(JSTemporalZonedDateTimeObject zdt, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createYearMonthFromFields()") CalendarMethodsRecordLookupNode lookupYearMonthFromFields, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            Object calendar = zdt.getCalendar();
            Object fieldsMethod = lookupFields.execute(calendar);
            Object yearMonthFromFieldsMethod = lookupYearMonthFromFields.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forFieldsAndYearMonthFromFields(calendar, fieldsMethod, yearMonthFromFieldsMethod);
            Object timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            JSTemporalPlainDateTimeObject temporalDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), temporalDateTime, fieldNames, TemporalUtil.listEmpty);
            return yearMonthFromFieldsNode.execute(calendarRec, fields, Undefined.instance);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeToPlainMonthDay
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeToPlainMonthDay(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toPlainMonthDay(JSTemporalZonedDateTimeObject zonedDateTime, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached(value="createMonthDayFromFields()") CalendarMethodsRecordLookupNode lookupMonthDayFromFields, @Cached TemporalMonthDayFromFieldsNode monthDayFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            Object calendar = zonedDateTime.getCalendar();
            Object fieldsMethod = lookupFields.execute(calendar);
            Object monthDayFromFieldsMethod = lookupMonthDayFromFields.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forFieldsAndMonthDayFromFields(calendar, fieldsMethod, monthDayFromFieldsMethod);
            Object timeZone = zonedDateTime.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSRealm realm = this.getRealm();
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zonedDateTime.getNanoseconds());
            JSTemporalPlainDateTimeObject temporalDateTime = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, TemporalUtil.listDMC);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), temporalDateTime, fieldNames, TemporalUtil.listEmpty);
            return monthDayFromFieldsNode.execute(calendarRec, fields, Undefined.instance);
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }

    public static abstract class JSTemporalZonedDateTimeGetISOFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalZonedDateTimeGetISOFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSObject getISOFields(JSTemporalZonedDateTimeObject zdt, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
            JSRealm realm = this.getRealm();
            JSObject obj = JSOrdinary.create(this.getContext(), realm);
            JSTemporalInstantObject instant = JSTemporalInstant.create(this.getContext(), realm, zdt.getNanoseconds());
            Object calendar = zdt.getCalendar();
            Object timeZone = zdt.getTimeZone();
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeOnlyGetOffsetNanosecondsFor(timeZone);
            JSTemporalPlainDateTimeObject dt = TemporalUtil.builtinTimeZoneGetPlainDateTimeFor(this.getContext(), realm, timeZoneRec, instant, calendar);
            TruffleString offset = TemporalUtil.builtinTimeZoneGetOffsetStringFor(this.getContext(), realm, timeZoneRec, instant);
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.CALENDAR, calendar);
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_DAY, dt.getDay());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_HOUR, dt.getHour());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MICROSECOND, dt.getMicrosecond());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MILLISECOND, dt.getMillisecond());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MINUTE, dt.getMinute());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MONTH, dt.getMonth());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_NANOSECOND, dt.getNanosecond());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_SECOND, dt.getSecond());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_YEAR, dt.getYear());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.OFFSET, offset);
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.TIME_ZONE, timeZone);
            return obj;
        }

        @Specialization(guards={"!isJSTemporalZonedDateTime(thisObj)"})
        static JSObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalZonedDateTimeExpected();
        }
    }
}

