/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.decorators;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.decorators.ApplyDecoratorsToElementDefinitionNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.decorators.CreateDecoratorContextObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ObjectLiteralNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.ClassElementDefinitionRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.SetFunctionNameNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.IsCallableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.SimpleArrayList;

@ImportStatic(value={Strings.class})
public abstract class ApplyDecoratorsToElementDefinition
extends Node {
    protected final JSContext context;
    @Node.Child
    CreateDecoratorContextObjectNode createDecoratorContextNode;

    public ApplyDecoratorsToElementDefinition(JSContext context, CreateDecoratorContextObjectNode createDecoratorContextObjectNode) {
        this.context = context;
        this.createDecoratorContextNode = createDecoratorContextObjectNode;
    }

    public abstract void executeDecorator(VirtualFrame var1, JSDynamicObject var2, ClassElementDefinitionRecord var3, SimpleArrayList<Object> var4);

    public static ApplyDecoratorsToElementDefinition create(JSContext context, ObjectLiteralNode.ObjectLiteralMemberNode member) {
        return ApplyDecoratorsToElementDefinitionNodeGen.create(context, CreateDecoratorContextObjectNode.create(context, member));
    }

    @Specialization(guards={"!record.hasDecorators()"})
    protected static void noDecorators(VirtualFrame frame, JSDynamicObject proto, ClassElementDefinitionRecord record, SimpleArrayList<Object> extraInitializers) {
    }

    @Specialization(guards={"record.isField()", "record.hasDecorators()"})
    protected void decorateField(VirtualFrame frame, JSDynamicObject proto, ClassElementDefinitionRecord record, SimpleArrayList<Object> extraInitializers, @Cached.Shared @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached.Shared @Cached IsCallableNode isCallableNode, @Cached.Shared @Cached InlinedBranchProfile errorBranch) {
        Object[] objectArray = record.getDecorators();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JSDynamicObject value = Undefined.instance;
            Object decorator = objectArray[i2];
            Object newValue = ApplyDecoratorsToElementDefinition.executeDecoratorWithContext(frame, record, value, extraInitializers, decorator, this.createDecoratorContextNode, callNode);
            if (isCallableNode.executeBoolean(newValue)) {
                record.addInitializer(newValue);
                continue;
            }
            ApplyDecoratorsToElementDefinition.checkUndefined(newValue, this, errorBranch);
        }
        record.cleanDecorator();
    }

    @Specialization(guards={"record.isMethod()", "record.hasDecorators()"})
    protected void decorateMethod(VirtualFrame frame, JSDynamicObject proto, ClassElementDefinitionRecord record, SimpleArrayList<Object> extraInitializers, @Cached.Shared @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached.Shared @Cached IsCallableNode isCallableNode, @Cached.Shared @Cached InlinedBranchProfile errorBranch, @Cached.Shared @Cached SetFunctionNameNode setFunctionName) {
        for (Object decorator : record.getDecorators()) {
            Object value = record.getValue();
            Object newValue = ApplyDecoratorsToElementDefinition.executeDecoratorWithContext(frame, record, value, extraInitializers, decorator, this.createDecoratorContextNode, callNode);
            if (isCallableNode.executeBoolean(newValue)) {
                setFunctionName.execute(newValue, record.getKey());
                record.setValue(newValue);
                continue;
            }
            ApplyDecoratorsToElementDefinition.checkUndefined(newValue, this, errorBranch);
        }
        record.cleanDecorator();
    }

    @Specialization(guards={"record.isGetter() || record.isSetter()", "record.hasDecorators()"})
    protected void decorateGetterSetter(VirtualFrame frame, JSDynamicObject proto, ClassElementDefinitionRecord record, SimpleArrayList<Object> extraInitializers, @Bind(value="this") Node node, @Cached.Shared @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached.Shared @Cached IsCallableNode isCallableNode, @Cached.Shared @Cached InlinedBranchProfile errorBranch, @Cached.Shared @Cached SetFunctionNameNode setFunctionName) {
        for (Object decorator : record.getDecorators()) {
            boolean isGetter = record.isGetter();
            Object value = isGetter ? record.getGetter() : record.getSetter();
            Object newValue = ApplyDecoratorsToElementDefinition.executeDecoratorWithContext(frame, record, value, extraInitializers, decorator, this.createDecoratorContextNode, callNode);
            if (isCallableNode.executeBoolean(newValue)) {
                setFunctionName.execute(newValue, record.getKey(), isGetter ? Strings.GET : Strings.SET);
                if (isGetter) {
                    record.setGetter(newValue);
                    continue;
                }
                record.setSetter(newValue);
                continue;
            }
            ApplyDecoratorsToElementDefinition.checkUndefined(newValue, node, errorBranch);
        }
        record.cleanDecorator();
    }

    @Specialization(guards={"record.isAutoAccessor()", "record.hasDecorators()"})
    protected void decorateAuto(VirtualFrame frame, JSDynamicObject proto, ClassElementDefinitionRecord record, SimpleArrayList<Object> extraInitializers, @Bind(value="this") Node node, @Cached.Shared @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached.Shared @Cached IsCallableNode isCallableNode, @Cached(value="create(GET, context)") PropertyGetNode getGetterNode, @Cached(value="create(SET, context)") PropertyGetNode getSetterNode, @Cached(value="create(INIT, context)") PropertyGetNode getInitNode, @Cached(value="create(context)") CreateObjectNode createObjectNode, @Cached(value="create(context, GET)") CreateDataPropertyNode createGetDataPropertyNode, @Cached(value="create(context, SET)") CreateDataPropertyNode createSetDataPropertyNode, @Cached IsObjectNode isObjectNode, @Cached.Shared @Cached InlinedBranchProfile errorBranch) {
        for (Object decorator : record.getDecorators()) {
            JSObject value = createObjectNode.execute(frame);
            createGetDataPropertyNode.executeVoid(value, Strings.GET, record.getGetter());
            createSetDataPropertyNode.executeVoid(value, Strings.SET, record.getSetter());
            Object newValue = ApplyDecoratorsToElementDefinition.executeDecoratorWithContext(frame, record, value, extraInitializers, decorator, this.createDecoratorContextNode, callNode);
            if (isObjectNode.executeBoolean(newValue)) {
                Object newGetter = getGetterNode.getValue(newValue);
                if (isCallableNode.executeBoolean(newGetter)) {
                    record.setGetter(newGetter);
                } else {
                    ApplyDecoratorsToElementDefinition.checkUndefined(newGetter, node, errorBranch);
                }
                Object newSetter = getSetterNode.getValue(newValue);
                if (isCallableNode.executeBoolean(newSetter)) {
                    record.setSetter(newSetter);
                } else {
                    ApplyDecoratorsToElementDefinition.checkUndefined(newSetter, node, errorBranch);
                }
                Object newInit = getInitNode.getValue(newValue);
                if (isCallableNode.executeBoolean(newInit)) {
                    record.addInitializer(newInit);
                    continue;
                }
                ApplyDecoratorsToElementDefinition.checkUndefined(newInit, node, errorBranch);
                continue;
            }
            ApplyDecoratorsToElementDefinition.checkUndefined(newValue, node, errorBranch);
        }
        record.cleanDecorator();
    }

    private static Object executeDecoratorWithContext(VirtualFrame frame, ClassElementDefinitionRecord record, Object value, SimpleArrayList<Object> extraInitializers, Object decorator, CreateDecoratorContextObjectNode createDecoratorContextNode, JSFunctionCallNode callNode) {
        CreateDecoratorContextObjectNode.DecorationState state = new CreateDecoratorContextObjectNode.DecorationState();
        JSObject decoratorContext = createDecoratorContextNode.executeContext(frame, record, extraInitializers, state);
        Object newValue = callNode.executeCall(JSArguments.create(Undefined.instance, decorator, value, decoratorContext));
        state.finished = true;
        return newValue;
    }

    protected static void checkUndefined(Object value, Node node, InlinedBranchProfile errorProfile) {
        assert (value != null);
        if (value != Undefined.instance) {
            errorProfile.enter(node);
            throw Errors.createTypeErrorWrongDecoratorReturn(node);
        }
    }
}

