/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameSlotKind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.codec.BinaryDecoder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.codec.NodeDecoder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSFrameSlot;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.NodeFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.NodeFactoryDecoderGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.BreakTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.ContinueTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Dead;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class JSNodeDecoder {
    public static final int BREAK_TARGET_LABEL = 1;
    public static final int BREAK_TARGET_SWITCH = 2;
    public static final int CONTINUE_TARGET_LOOP = 3;
    public static final int CONTINUE_TARGET_UNLABELED_LOOP = 4;
    public static final int CONTEXT_ARG = -1;
    public static final int SOURCE_ARG = -2;
    private static final boolean VERBOSE = false;
    private static final NodeDecoder<NodeFactory> GEN = NodeFactoryDecoderGen.create();
    private static final Object[] SINGLETONS = new Object[]{null, Undefined.instance, Null.instance, Dead.instance()};

    public static int getSingletonIndex(Object singleton) {
        return Arrays.asList(SINGLETONS).indexOf(singleton);
    }

    public static int getChecksum() {
        return GEN.getChecksum();
    }

    public Object decodeNode(NodeDecoder.DecoderState state, final NodeFactory nodeFactory, final JSContext context, final Source source) {
        block29: while (state.hasRemaining()) {
            Bytecode bc = Bytecode.bcValues[state.getBytecode()];
            switch (bc.ordinal()) {
                case 0: {
                    continue block29;
                }
                case 1: {
                    Object node = GEN.decodeNode(state, nodeFactory);
                    int dest = state.getReg();
                    if (dest < 0) continue block29;
                    state.setObjReg(dest, node);
                    continue block29;
                }
                case 2: {
                    return state.getObject();
                }
                case 3: {
                    JSNodeDecoder.storeResult(state, state.getInt());
                    continue block29;
                }
                case 4: {
                    JSNodeDecoder.storeResult(state, state.getLong());
                    continue block29;
                }
                case 5: {
                    JSNodeDecoder.storeResult(state, state.getBoolean());
                    continue block29;
                }
                case 6: {
                    JSNodeDecoder.storeResult(state, state.getDouble());
                    continue block29;
                }
                case 7: {
                    JSNodeDecoder.storeResult(state, GEN.getClasses()[state.getInt()].getEnumConstants()[state.getInt()]);
                    continue block29;
                }
                case 8: {
                    JSNodeDecoder.storeResult(state, state.getString());
                    continue block29;
                }
                case 9: {
                    JSNodeDecoder.storeResult(state, state.getString().toJavaStringUncached());
                    continue block29;
                }
                case 10: {
                    JSNodeDecoder.storeResult(state, SINGLETONS[state.getInt()]);
                    continue block29;
                }
                case 11: {
                    JSNodeDecoder.storeResult(state, BigInt.valueOf(state.getString().toJavaStringUncached()));
                    continue block29;
                }
                case 13: {
                    state.setObjReg(state.getReg(), state.getObjReg(state.getReg()));
                    continue block29;
                }
                case 12: {
                    Object argument;
                    int argIndex = state.getInt();
                    if (argIndex == -1) {
                        argument = context;
                    } else if (argIndex == -2) {
                        argument = source;
                    } else {
                        assert (argIndex >= 0) : argIndex;
                        argument = state.getArgument(argIndex);
                    }
                    JSNodeDecoder.storeResult(state, argument);
                    continue block29;
                }
                case 14: {
                    int componentTypeIndex = state.getInt();
                    int length = state.getInt();
                    Object array = Array.newInstance(GEN.getClasses()[componentTypeIndex], length);
                    if (array instanceof Object[]) {
                        Object[] objArray = (Object[])array;
                        for (int i2 = 0; i2 < length; ++i2) {
                            Object value;
                            objArray[i2] = value = state.getObject();
                        }
                    } else {
                        for (int i3 = 0; i3 < length; ++i3) {
                            Object value = state.getObject();
                            Array.set(array, i3, value);
                        }
                    }
                    JSNodeDecoder.storeResult(state, array);
                    continue block29;
                }
                case 15: {
                    int length = state.getInt();
                    ArrayList<Object> array = new ArrayList<Object>(length);
                    for (int i4 = 0; i4 < length; ++i4) {
                        array.add(state.getObject());
                    }
                    JSNodeDecoder.storeResult(state, array);
                    continue block29;
                }
                case 16: {
                    JSNodeDecoder.storeResult(state, ((RootNode)state.getObject()).getCallTarget());
                    continue block29;
                }
                case 17: {
                    int i5;
                    int numberOfIndexedSlots = state.getInt();
                    FrameDescriptor.Builder b2 = FrameDescriptor.newBuilder(numberOfIndexedSlots).defaultValue(Undefined.instance);
                    Object[] names = new Object[numberOfIndexedSlots];
                    int[] flags = new int[numberOfIndexedSlots];
                    byte[] tags = new byte[numberOfIndexedSlots];
                    for (i5 = 0; i5 < numberOfIndexedSlots; ++i5) {
                        names[i5] = state.getObject();
                    }
                    for (i5 = 0; i5 < numberOfIndexedSlots; ++i5) {
                        flags[i5] = state.getInt();
                    }
                    for (i5 = 0; i5 < numberOfIndexedSlots; ++i5) {
                        tags[i5] = (byte)state.getInt();
                    }
                    for (i5 = 0; i5 < numberOfIndexedSlots; ++i5) {
                        b2.addSlot(FrameSlotKind.fromTag(tags[i5]), names[i5], flags[i5]);
                    }
                    FrameDescriptor frameDescriptor = b2.build();
                    JSNodeDecoder.storeResult(state, frameDescriptor);
                    continue block29;
                }
                case 18: {
                    Object identifier = state.getObject();
                    int index = state.getInt();
                    int flags = state.getInt();
                    int tag = state.getInt();
                    FrameSlotKind kind = FrameSlotKind.fromTag((byte)tag);
                    JSFrameSlot frameSlot = new JSFrameSlot(index, identifier, flags, kind);
                    JSNodeDecoder.storeResult(state, frameSlot);
                    continue block29;
                }
                case 19: {
                    Source src = (Source)state.getObject();
                    int charIndex = state.getInt();
                    int charLength = state.getInt();
                    SourceSection sourceSection = charIndex < 0 || charLength < 0 || src.getCharacters().length() == 0 && charIndex + charLength > 0 ? src.createUnavailableSection() : src.createSection(charIndex, charLength);
                    JSNodeDecoder.storeResult(state, sourceSection);
                    continue block29;
                }
                case 20: {
                    JSContext ctx = (JSContext)state.getObject();
                    int length = state.getInt();
                    TruffleString functionName = state.getString();
                    int flags = state.getInt32();
                    JSFunctionData functionData = JSFunctionData.create(ctx, null, null, null, length, functionName, flags);
                    JSNodeDecoder.storeResult(state, functionData);
                    continue block29;
                }
                case 21: {
                    JSFunctionData functionData = (JSFunctionData)state.getObject();
                    TruffleString name = state.getString();
                    functionData.setName(name);
                    continue block29;
                }
                case 22: {
                    JSNodeDecoder.storeResult(state, JSNodeDecoder.createJumpTarget(state.getInt()));
                    continue block29;
                }
                case 23: {
                    int position = state.getInt32();
                    Object[] arguments = JSNodeDecoder.getObjectArray(state);
                    ByteBuffer buffer = state.getBuffer();
                    NodeDecoder.DecoderState extracted = new NodeDecoder.DecoderState(new BinaryDecoder(buffer, position), arguments);
                    JSNodeDecoder.storeResult(state, this.decodeNode(extracted, nodeFactory, context, source));
                    continue block29;
                }
                case 24: {
                    int bcPos = state.getBuffer().position() - 1;
                    final int position = state.getInt32();
                    JSFunctionData functionData = (JSFunctionData)state.getObject();
                    final Object[] arguments = JSNodeDecoder.getObjectArray(state);
                    final ByteBuffer buffer = state.getBuffer();
                    functionData.setLazyInit(new JSFunctionData.Initializer(){
                        final /* synthetic */ JSNodeDecoder this$0;
                        {
                            this.this$0 = this$0;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void initializeRoot(JSFunctionData fd) {
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                if (fd.getRootNode() == null) {
                                    NodeDecoder.DecoderState extracted = new NodeDecoder.DecoderState(new BinaryDecoder(buffer, position), arguments);
                                    this.this$0.decodeNode(extracted, nodeFactory, context, source);
                                    fd.releaseLazyInit();
                                }
                            }
                        }
                    });
                    continue block29;
                }
                case 25: {
                    JavaScriptNode jsnode = (JavaScriptNode)state.getObject();
                    int charIndex = state.getInt();
                    int charLength = state.getInt();
                    if (charIndex < 0 || charLength < 0 || source.getCharacters().length() == 0 && charIndex + charLength > 0) {
                        jsnode.setSourceSection(source.createUnavailableSection());
                        continue block29;
                    }
                    jsnode.setSourceSection(source, charIndex, charLength);
                    continue block29;
                }
                case 26: {
                    JavaScriptNode jsnode = (JavaScriptNode)state.getObject();
                    boolean hasStatementTag = state.getBoolean();
                    boolean hasCallTag = state.getBoolean();
                    boolean hasExpressionTag = state.getBoolean();
                    boolean hasRootBodyTag = state.getBoolean();
                    if (hasStatementTag) {
                        jsnode.addStatementTag();
                    }
                    if (hasCallTag) {
                        jsnode.addCallTag();
                    }
                    if (hasExpressionTag) {
                        jsnode.addExpressionTag();
                    }
                    if (!hasRootBodyTag) continue block29;
                    jsnode.addRootBodyTag();
                    continue block29;
                }
            }
            throw new IllegalStateException("invalid bytecode " + String.valueOf((Object)bc));
        }
        throw new IllegalStateException("reached end of buffer without return");
    }

    private static void storeResult(NodeDecoder.DecoderState state, Object value) {
        state.setObjReg(state.getReg(), value);
    }

    private static BreakTarget createJumpTarget(int type) {
        switch (type) {
            case 1: {
                return BreakTarget.forLabel(null, -1);
            }
            case 2: {
                return BreakTarget.forSwitch();
            }
            case 3: {
                return ContinueTarget.forLoop(null, -1);
            }
            case 4: {
                return ContinueTarget.forUnlabeledLoop();
            }
        }
        throw new IllegalStateException("invalid jump target");
    }

    private static Object[] getObjectArray(NodeDecoder.DecoderState state) {
        int length = state.getInt();
        Object[] array = new Object[length];
        for (int i2 = 0; i2 < length; ++i2) {
            array[i2] = state.getObject();
        }
        return array;
    }

    public static enum Bytecode {
        ID_NOP,
        ID_NODE,
        ID_RETURN,
        ID_LDC_INT,
        ID_LDC_LONG,
        ID_LDC_BOOLEAN,
        ID_LDC_DOUBLE,
        ID_LDC_ENUM,
        ID_LDC_STRING,
        ID_LDC_JAVA_STRING,
        ID_LDC_SINGLETON,
        ID_LDC_BIGINT,
        ID_LD_ARG,
        ID_MOV,
        ID_COLLECT_ARRAY,
        ID_COLLECT_LIST,
        ID_CALL_TARGET,
        ID_FRAME_DESCRIPTOR,
        ID_JSFRAME_SLOT,
        ID_SOURCE_SECTION,
        ID_FUNCTION_DATA,
        ID_FUNCTION_DATA_NAME_FIXUP,
        ID_JUMP_TARGET,
        ID_CALL_EXTRACTED,
        ID_CALL_EXTRACTED_LAZY,
        ID_NODE_SOURCE_SECTION_FIXUP,
        ID_NODE_TAGS_FIXUP;

        static final Bytecode[] bcValues;

        static {
            bcValues = Bytecode.values();
        }
    }
}

