/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.exception.AbstractTruffleException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.GraalJSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSErrorType;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSErrorObject;

public final class ThrowTypeErrorRootNode
extends JavaScriptRootNode {
    private final boolean restrictedProperty;

    public ThrowTypeErrorRootNode(JavaScriptLanguage language, boolean restrictedProperty) {
        super(language, null, null);
        this.restrictedProperty = restrictedProperty;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.restrictedProperty) {
            throw Errors.createTypeError("'caller', 'callee', and 'arguments' properties may not be accessed on strict mode functions or the arguments objects for calls to them");
        }
        Object[] args = frame.getArguments();
        throw ThrowTypeErrorRootNode.toTypeError(JSArguments.getUserArgumentCount(args) != 0 ? JSArguments.getUserArgument(args, 0) : Strings.EMPTY_STRING);
    }

    @CompilerDirectives.TruffleBoundary
    private static AbstractTruffleException toTypeError(Object error) {
        if (error instanceof JSErrorObject) {
            GraalJSException exception = ((JSErrorObject)error).getException();
            if (exception instanceof JSException) {
                JSException jsException = (JSException)exception;
                if (jsException.getErrorType() == JSErrorType.TypeError && jsException.getRealm() == JSRealm.get(null)) {
                    return jsException;
                }
            } else {
                return Errors.createTypeError(ThrowTypeErrorRootNode.getExceptionMessage(error), exception, null);
            }
        }
        return Errors.createTypeError(ThrowTypeErrorRootNode.getExceptionMessage(error));
    }

    private static String getExceptionMessage(Object error) {
        CompilerAsserts.neverPartOfCompilation();
        InteropLibrary interop = InteropLibrary.getUncached(error);
        if (interop.hasExceptionMessage(error)) {
            try {
                Object exceptionMessage = interop.getExceptionMessage(error);
                return InteropLibrary.getUncached().asString(exceptionMessage);
            }
            catch (UnsupportedMessageException e2) {
                throw Errors.shouldNotReachHere(e2);
            }
        }
        return Strings.toJavaString(JSRuntime.safeToString(error));
    }

    @Override
    public String getName() {
        return "%ThrowTypeError%";
    }
}

