/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.WriteNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.StatementNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class DeclareEvalVariableNode
extends StatementNode {
    @Node.Child
    private JavaScriptNode dynamicScopeNode;
    @Node.Child
    private WriteNode initScopeNode;
    @Node.Child
    private HasPropertyCacheNode hasProperty;
    @Node.Child
    private PropertySetNode defineProperty;
    private final JSContext context;
    private final TruffleString varName;

    public DeclareEvalVariableNode(JSContext context, TruffleString varName, JavaScriptNode dynamicScopeNode, WriteNode writeDynamicScopeNode) {
        this.context = context;
        this.varName = varName;
        this.dynamicScopeNode = dynamicScopeNode;
        this.initScopeNode = writeDynamicScopeNode;
        this.hasProperty = HasPropertyCacheNode.create(varName, context);
        this.defineProperty = PropertySetNode.create(varName, false, context, false);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object dynamicScope = this.dynamicScopeNode.execute(frame);
        if (dynamicScope == Undefined.instance) {
            dynamicScope = JSOrdinary.createWithNullPrototype(this.context);
            this.initScopeNode.executeWrite(frame, dynamicScope);
        }
        assert (DeclareEvalVariableNode.isValidDynamicScopeObject(dynamicScope));
        if (!this.hasProperty.hasProperty(dynamicScope)) {
            this.defineProperty.setValue(dynamicScope, Undefined.instance);
        }
        return EMPTY;
    }

    private static boolean isValidDynamicScopeObject(Object dynamicScope) {
        return dynamicScope instanceof JSObject && JSObjectUtil.getPrototype((JSObject)dynamicScope) == Null.instance;
    }

    public Object getName() {
        return this.varName;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new DeclareEvalVariableNode(this.context, this.varName, DeclareEvalVariableNode.cloneUninitialized(this.dynamicScopeNode, materializedTags), (WriteNode)((Object)DeclareEvalVariableNode.cloneUninitialized((JavaScriptNode)((Object)this.initScopeNode), materializedTags)));
    }
}

