/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyCacheNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

abstract class FrequencyBasedPolymorphicAccessNode<T extends PropertyCacheNode<?>>
extends JavaScriptBaseNode {
    private static final short MIN_SAMPLED_ACCESSES = 100;
    private static final short MAX_SAMPLED_ACCESSES = 1000;
    private int totalHits;
    private short maxHitsPerKey;
    private final short size;
    private Map<Object, HitsCount> hitsDistributionMap = new HashMap<Object, HitsCount>();

    private FrequencyBasedPolymorphicAccessNode(short size) {
        this.size = size;
        this.hitsDistributionMap = size == 0 ? null : new HashMap();
    }

    protected abstract T[] getHighFrequencyNodes();

    protected abstract void setHighFrequencyNode(int var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void interpreterSample(Object key) {
        if (this.hitsDistributionMap == null) {
            return;
        }
        CompilerAsserts.neverPartOfCompilation();
        Lock lock = this.getLock();
        lock.lock();
        try {
            Map<Object, HitsCount> hitsMap = this.hitsDistributionMap;
            if (hitsMap == null) {
                return;
            }
            int totalHitCount = this.totalHits;
            if (totalHitCount >= 1000) {
                this.stopSampling();
                return;
            }
            this.totalHits = totalHitCount + 1;
            assert (JSRuntime.isPropertyKey(key));
            HitsCount hitsCounter = hitsMap.computeIfAbsent(key, k2 -> new HitsCount());
            short hits = hitsCounter.incrementAndGet();
            if (totalHitCount < 100) {
                this.maxHitsPerKey = (short)Math.max(this.maxHitsPerKey, hits);
                return;
            }
            if (totalHitCount == 100 && this.maxHitsPerKey <= 1) {
                this.stopSampling();
                return;
            }
            if (!hitsCounter.isCached() && hits * (this.size + 1) > totalHitCount) {
                PropertyCacheNode[] highFrequencyNodes = this.getHighFrequencyNodes();
                for (int i2 = 0; i2 < highFrequencyNodes.length; ++i2) {
                    if (highFrequencyNodes[i2] != null) continue;
                    hitsCounter.setCached();
                    this.setHighFrequencyNode(i2, key);
                    if (i2 == highFrequencyNodes.length - 1) {
                        this.stopSampling();
                    }
                    return;
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void stopSampling() {
        CompilerAsserts.neverPartOfCompilation();
        this.hitsDistributionMap = null;
    }

    private static final class HitsCount {
        private short hits;
        private boolean cached;

        HitsCount() {
        }

        public short incrementAndGet() {
            this.hits = (short)(this.hits + 1);
            return this.hits;
        }

        public boolean isCached() {
            return this.cached;
        }

        public void setCached() {
            this.cached = true;
        }

        public String toString() {
            return this.hits + (this.cached ? " [cached]" : "");
        }
    }

    public static final class FrequencyBasedPropertyGetNode
    extends FrequencyBasedPolymorphicAccessNode<PropertyGetNode> {
        @Node.Children
        private PropertyGetNode[] highFrequencyKeys;
        private static final FrequencyBasedPropertyGetNode DISABLED = new FrequencyBasedPropertyGetNode(0);

        @NeverDefault
        public static FrequencyBasedPropertyGetNode create(JSContext context) {
            short size = context.getLanguageOptions().frequencyBasedPropertyCacheLimit();
            if (size == 0) {
                return DISABLED;
            }
            return new FrequencyBasedPropertyGetNode(size);
        }

        private FrequencyBasedPropertyGetNode(short size) {
            super(size);
            this.highFrequencyKeys = new PropertyGetNode[size];
        }

        protected PropertyGetNode[] getHighFrequencyNodes() {
            return this.highFrequencyKeys;
        }

        @Override
        protected void setHighFrequencyNode(int position, Object key) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.highFrequencyKeys[position] = this.insert(PropertyGetNode.create(key, this.getJSContext()));
        }

        public Object executeFastGet(Object key, Object target, Object receiver, TruffleString.EqualNode equalsNode) {
            if (CompilerDirectives.inInterpreter()) {
                this.interpreterSample(key);
            }
            return this.readFromCaches(key, target, receiver, equalsNode);
        }

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
        private Object readFromCaches(Object key, Object target, Object receiver, TruffleString.EqualNode equalsNode) {
            for (PropertyGetNode highFrequencyKey : this.highFrequencyKeys) {
                if (highFrequencyKey == null) break;
                if (highFrequencyKey.getCacheNode() != null && highFrequencyKey.getCacheNode().isGeneric() || !JSRuntime.propertyKeyEquals(equalsNode, highFrequencyKey.getKey(), key)) continue;
                return highFrequencyKey.getValueOrDefault(target, receiver, null);
            }
            return null;
        }

        @Override
        public boolean isAdoptable() {
            return this != DISABLED;
        }
    }

    public static final class FrequencyBasedPropertySetNode
    extends FrequencyBasedPolymorphicAccessNode<PropertySetNode> {
        @Node.Children
        private PropertySetNode[] highFrequencyKeys;
        protected final boolean setOwn;
        protected final boolean strict;
        protected final boolean superProperty;
        private static final FrequencyBasedPropertySetNode DISABLED = new FrequencyBasedPropertySetNode(false, false, false, 0);

        @NeverDefault
        public static FrequencyBasedPropertySetNode create(JSContext context, boolean setOwn, boolean isStrict, boolean superProperty) {
            short size = context.getLanguageOptions().frequencyBasedPropertyCacheLimit();
            if (size == 0) {
                return DISABLED;
            }
            return new FrequencyBasedPropertySetNode(setOwn, isStrict, superProperty, size);
        }

        private FrequencyBasedPropertySetNode(boolean setOwn, boolean isStrict, boolean superProperty, short size) {
            super(size);
            this.setOwn = setOwn;
            this.strict = isStrict;
            this.superProperty = superProperty;
            this.highFrequencyKeys = new PropertySetNode[size];
        }

        protected PropertySetNode[] getHighFrequencyNodes() {
            return this.highFrequencyKeys;
        }

        @Override
        protected void setHighFrequencyNode(int position, Object key) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.highFrequencyKeys[position] = this.insert(PropertySetNode.createImpl(key, false, this.getJSContext(), this.strict, this.setOwn, JSAttributes.getDefault(), false, this.superProperty));
        }

        public boolean executeFastSet(JSDynamicObject target, Object key, Object value, Object receiver, TruffleString.EqualNode equalsNode) {
            if (this.setOwn) {
                return false;
            }
            if (CompilerDirectives.inInterpreter()) {
                this.interpreterSample(key);
            }
            return this.compiledSet(target, key, value, receiver, equalsNode);
        }

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
        private boolean compiledSet(JSDynamicObject target, Object key, Object value, Object receiver, TruffleString.EqualNode equalsNode) {
            for (PropertySetNode highFrequencyKey : this.highFrequencyKeys) {
                if (highFrequencyKey == null) break;
                if (highFrequencyKey.getCacheNode() != null && highFrequencyKey.getCacheNode().isGeneric() || !JSRuntime.propertyKeyEquals(equalsNode, highFrequencyKey.getKey(), key)) continue;
                highFrequencyKey.setValue(target, value, receiver);
                return true;
            }
            return false;
        }

        @Override
        public boolean isAdoptable() {
            return this != DISABLED;
        }
    }
}

