/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Executed;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.InitializeInstanceElementsNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSTargetableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PrivateFieldAddNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.WriteElementNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.ClassElementDefinitionRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class InitializeInstanceElementsNode
extends JavaScriptNode {
    private static final Object[] EMPTY_INITIALIZERS = ScriptArray.EMPTY_OBJECT_ARRAY;
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode constructorNode;
    @Node.Child
    @Executed(with={"constructorNode"})
    protected JSTargetableNode fieldsNode;
    @Node.Child
    @Executed(with={"constructorNode"})
    protected JSTargetableNode initializersNode;
    @Node.Child
    @Executed(with={"constructorNode"})
    protected JSTargetableNode brandNode;
    protected final JSContext context;

    protected InitializeInstanceElementsNode(JSContext context, JavaScriptNode targetNode, JavaScriptNode constructorNode) {
        this.context = context;
        this.targetNode = targetNode;
        this.constructorNode = constructorNode;
        if (constructorNode != null) {
            this.fieldsNode = PropertyNode.createGetHidden(context, null, JSFunction.CLASS_ELEMENTS_ID);
            this.brandNode = PropertyNode.createGetHidden(context, null, JSFunction.PRIVATE_BRAND_ID);
            this.initializersNode = PropertyNode.createGetHidden(context, null, JSFunction.CLASS_INITIALIZERS_ID);
        }
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode targetNode, JavaScriptNode constructorNode) {
        return InitializeInstanceElementsNodeGen.create(context, targetNode, constructorNode);
    }

    public static InitializeInstanceElementsNode create(JSContext context) {
        return InitializeInstanceElementsNodeGen.create(context, null, null);
    }

    public final Object executeStaticElements(Object targetConstructor, ClassElementDefinitionRecord[] staticElements) {
        return this.executeEvaluated(targetConstructor, Undefined.instance, staticElements, EMPTY_INITIALIZERS, Undefined.instance);
    }

    protected abstract Object executeEvaluated(Object var1, Object var2, ClassElementDefinitionRecord[] var3, Object[] var4, Object var5);

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    @Specialization
    protected static Object withFields(Object target, Object constructor, ClassElementDefinitionRecord[] fields, Object[] initializers, Object brand, @Cached(value="createBrandAddNode(brand)", neverDefault=false) @Cached.Shared PrivateFieldAddNode privateBrandAddNode, @Cached(value="createFieldNodes(fields, context)") InitializeFieldOrAccessorNode[] fieldNodes, @Cached(value="createCall()") JSFunctionCallNode callInit) {
        InitializeInstanceElementsNode.privateBrandAdd(target, constructor, fields, initializers, brand, privateBrandAddNode);
        InitializeInstanceElementsNode.executeInitializers(target, initializers, callInit);
        int size = fieldNodes.length;
        assert (size == fields.length);
        for (int i2 = 0; i2 < size; ++i2) {
            fieldNodes[i2].defineField(target, fields[i2]);
        }
        return target;
    }

    private static void executeInitializers(Object target, Object[] initializers, JSFunctionCallNode callInit) {
        for (Object initializer : initializers) {
            callInit.executeCall(JSArguments.createZeroArg(target, initializer));
        }
    }

    @Specialization
    protected static Object privateBrandAdd(Object target, Object constructor, Object fields, Object initializers, Object brand, @Cached(value="createBrandAddNode(brand)", neverDefault=false) @Cached.Shared PrivateFieldAddNode privateBrandAddNode) {
        assert (privateBrandAddNode != null == (brand != Undefined.instance));
        if (privateBrandAddNode != null) {
            privateBrandAddNode.execute(target, brand, constructor);
        }
        return target;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return InitializeInstanceElementsNode.create(this.context, InitializeInstanceElementsNode.cloneUninitialized(this.targetNode, materializedTags), InitializeInstanceElementsNode.cloneUninitialized(this.constructorNode, materializedTags));
    }

    static PrivateFieldAddNode createBrandAddNode(Object brand) {
        CompilerAsserts.neverPartOfCompilation();
        if (brand != Undefined.instance) {
            return PrivateFieldAddNode.create();
        }
        return null;
    }

    @NeverDefault
    static InitializeFieldOrAccessorNode[] createFieldNodes(ClassElementDefinitionRecord[] fields, JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        int size = fields.length;
        InitializeFieldOrAccessorNode[] fieldNodes = new InitializeFieldOrAccessorNode[size];
        for (int i2 = 0; i2 < size; ++i2) {
            ClassElementDefinitionRecord field = fields[i2];
            Object key = field.getKey();
            Object initializer = field.getValue();
            boolean isAnonymousFunctionDefinition = field.isAnonymousFunction();
            boolean hasInitializer = initializer != Undefined.instance;
            JavaScriptBaseNode writeNode = null;
            if (field.isAutoAccessor() || field.isPrivate() && field.isField()) {
                assert (field.getBackingStorageKey() != null) : key;
                writeNode = PrivateFieldAddNode.create();
            } else if (field.isField()) {
                assert (JSRuntime.isPropertyKey(key)) : key;
                writeNode = WriteElementNode.create(context, true, true);
            } else if (!field.isStaticBlock()) {
                assert (field.isMethod() || field.isAccessor()) : field;
                hasInitializer = false;
            }
            JSFunctionCallNode callNode = null;
            if (hasInitializer) {
                callNode = JSFunctionCallNode.createCall();
            }
            fieldNodes[i2] = new InitializeFieldOrAccessorNode(writeNode, callNode, isAnonymousFunctionDefinition);
        }
        return fieldNodes;
    }

    static final class InitializeFieldOrAccessorNode
    extends JavaScriptBaseNode {
        @Node.Child
        Node writeNode;
        @Node.Child
        JSFunctionCallNode callNode;
        @Node.Child
        JSFunctionCallNode callInitializersNode;
        private final boolean isAnonymousFunctionDefinition;

        InitializeFieldOrAccessorNode(Node writeNode, JSFunctionCallNode callNode, boolean isAnonymousFunctionDefinition) {
            this.writeNode = writeNode;
            this.callNode = callNode;
            this.isAnonymousFunctionDefinition = isAnonymousFunctionDefinition;
        }

        void defineField(Object target, ClassElementDefinitionRecord record) {
            Object initValue = Undefined.instance;
            if (this.callNode != null) {
                Object initializer = record.getValue();
                Object key = record.getKey();
                initValue = this.callNode.executeCall(this.isAnonymousFunctionDefinition ? JSArguments.create(target, initializer, Undefined.instance, key) : JSArguments.createOneArg(target, initializer, Undefined.instance));
            } else assert (record.getValue() == Undefined.instance || record.isMethod() || record.isAccessor()) : record;
            if (this.writeNode != null) {
                for (int i2 = 0; i2 < record.getInitializersCount(); ++i2) {
                    Object initializer = record.getInitializers()[i2];
                    initValue = this.callExtraInitializer(target, initializer, initValue);
                }
                this.writeValue(target, record, initValue);
            } else assert ((record.isMethod() || record.isAccessor() || record.isStaticBlock()) && record.getInitializersCount() == 0) : record;
        }

        private Object callExtraInitializer(Object target, Object initializer, Object initValue) {
            return this.getInitializersCallNode().executeCall(JSArguments.createOneArg(target, initializer, initValue));
        }

        private JSFunctionCallNode getInitializersCallNode() {
            if (this.callInitializersNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callInitializersNode = this.insert(JSFunctionCallNode.createCall());
            }
            return this.callInitializersNode;
        }

        private void writeValue(Object target, ClassElementDefinitionRecord record, Object value) {
            if (this.writeNode instanceof PropertySetNode) {
                ((PropertySetNode)this.writeNode).setValue(target, value);
            } else if (this.writeNode instanceof PrivateFieldAddNode) {
                assert (record.getBackingStorageKey() != null) : record.getKey();
                ((PrivateFieldAddNode)this.writeNode).execute(target, record.getBackingStorageKey(), value);
            } else if (this.writeNode != null) {
                assert (JSRuntime.isPropertyKey(record.getKey())) : record.getKey();
                ((WriteElementNode)this.writeNode).executeWithTargetAndIndexAndValue(target, record.getKey(), value);
            }
        }
    }
}

