/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Arrays;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Assumption;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.RootCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Idempotent;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.Frame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.HiddenKey;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CopyDataPropertiesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ObjectLiteralNodeFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertySetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.ClassDefinitionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.ClassElementDefinitionRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.FunctionNameHolder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.NamedEvaluationTargetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.SetFunctionNameNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunction;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Accessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSProperty;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSShape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class ObjectLiteralNode
extends JavaScriptNode {
    @Node.Children
    private final ObjectLiteralMemberNode[] members;
    @Node.Child
    private CreateObjectNode objectCreateNode;

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.LiteralTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("literalType", JSTags.LiteralTag.Type.ObjectLiteral.name());
    }

    protected static Object executeWithRealm(JavaScriptNode valueNode, VirtualFrame frame, JSRealm realm) {
        if (valueNode instanceof JSFunctionExpressionNode) {
            return ((JSFunctionExpressionNode)valueNode).executeWithRealm(frame, realm);
        }
        return valueNode.execute(frame);
    }

    public static ObjectLiteralMemberNode newDataMember(TruffleString name, boolean isStatic, boolean enumerable, JavaScriptNode valueNode, boolean isField) {
        return new ObjectLiteralDataMemberNode(name, isStatic, enumerable ? JSAttributes.getDefault() : JSAttributes.getDefaultNotEnumerable(), valueNode, isField);
    }

    public static ObjectLiteralMemberNode newAutoAccessor(TruffleString name, boolean isStatic, boolean enumerable, JavaScriptNode valueNode) {
        return new AutoAccessorDataMemberNode((Object)name, isStatic, enumerable ? JSAttributes.getDefault() : JSAttributes.getDefaultNotEnumerable(), valueNode);
    }

    public static ObjectLiteralMemberNode newComputedAutoAccessor(JavaScriptNode keyNode, boolean isStatic, boolean enumerable, JavaScriptNode valueNode) {
        return new ComputedAutoAccessorDataMemberNode(keyNode, isStatic, enumerable ? JSAttributes.getDefault() : JSAttributes.getDefaultNotEnumerable(), valueNode);
    }

    public static ObjectLiteralMemberNode newAccessorMember(TruffleString name, boolean isStatic, boolean enumerable, JavaScriptNode getterNode, JavaScriptNode setterNode) {
        return new ObjectLiteralAccessorMemberNode(name, isStatic, JSAttributes.fromConfigurableEnumerable(true, enumerable), getterNode, setterNode);
    }

    public static ObjectLiteralMemberNode newComputedDataMember(JavaScriptNode name, boolean isStatic, boolean enumerable, JavaScriptNode valueNode, boolean isField, boolean isAnonymousFunctionDefinition) {
        int attributes = enumerable ? JSAttributes.getDefault() : JSAttributes.getDefaultNotEnumerable();
        return ObjectLiteralNodeFactory.ComputedObjectLiteralDataMemberNodeGen.create(name, isStatic, attributes, valueNode, isField, isAnonymousFunctionDefinition);
    }

    public static ObjectLiteralMemberNode newComputedAccessorMember(JavaScriptNode name, boolean isStatic, boolean enumerable, JavaScriptNode getter, JavaScriptNode setter) {
        return new ComputedObjectLiteralAccessorMemberNode(name, isStatic, JSAttributes.fromConfigurableEnumerable(true, enumerable), getter, setter);
    }

    public static ObjectLiteralMemberNode newDataMember(Object name, boolean isStatic, int attributes, JavaScriptNode valueNode) {
        return new ObjectLiteralDataMemberNode(name, isStatic, attributes, valueNode, false);
    }

    public static ObjectLiteralMemberNode newAccessorMember(Object name, boolean isStatic, int attributes, JavaScriptNode getterNode, JavaScriptNode setterNode) {
        return new ObjectLiteralAccessorMemberNode(name, isStatic, attributes, getterNode, setterNode);
    }

    public static ObjectLiteralMemberNode newComputedDataMember(JavaScriptNode name, boolean isStatic, int attributes, JavaScriptNode valueNode) {
        return ObjectLiteralNodeFactory.ComputedObjectLiteralDataMemberNodeGen.create(name, isStatic, attributes, valueNode, false, false);
    }

    public static ObjectLiteralMemberNode newPrivateFieldMember(JavaScriptNode name, boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateNode) {
        return new PrivateFieldMemberNode(name, isStatic, valueNode, writePrivateNode);
    }

    public static ObjectLiteralMemberNode newPrivateMethodMember(TruffleString privateName, boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateNode, int privateBrandSlotIndex) {
        return new PrivateMethodMemberNode(privateName, isStatic, valueNode, writePrivateNode, privateBrandSlotIndex);
    }

    public static ObjectLiteralMemberNode newPrivateAccessorMember(boolean isStatic, JavaScriptNode getterNode, JavaScriptNode setterNode, JSWriteFrameSlotNode writePrivateNode, int privateBrandSlotIndex) {
        return new PrivateAccessorMemberNode(isStatic, getterNode, setterNode, writePrivateNode, privateBrandSlotIndex);
    }

    public static ObjectLiteralMemberNode newPrivateAutoAccessorMember(boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateAccessor, JavaScriptNode storageKey, int privateBrandSlotIndex) {
        return new PrivateAutoAccessorMemberNode(isStatic, valueNode, writePrivateAccessor, storageKey, privateBrandSlotIndex);
    }

    public static ObjectLiteralMemberNode newProtoMember(TruffleString name, boolean isStatic, JavaScriptNode valueNode) {
        assert (Strings.equals(JSObject.PROTO, name));
        return new ObjectLiteralProtoMemberNode(isStatic, valueNode);
    }

    public static ObjectLiteralMemberNode newSpreadObjectMember(boolean isStatic, JavaScriptNode valueNode) {
        return new ObjectLiteralSpreadMemberNode(isStatic, JSAttributes.getDefault(), valueNode);
    }

    public static ObjectLiteralMemberNode newStaticBlockMember(JavaScriptNode valueNode) {
        return new StaticBlockNode(valueNode);
    }

    public ObjectLiteralNode(ObjectLiteralMemberNode[] members, CreateObjectNode objectCreateNode) {
        this.members = members;
        this.objectCreateNode = objectCreateNode;
    }

    public static ObjectLiteralNode create(JSContext context, ObjectLiteralMemberNode[] members) {
        if (members.length > 0 && members[0] instanceof ObjectLiteralProtoMemberNode) {
            return new ObjectLiteralNode(Arrays.copyOfRange(members, 1, members.length), CreateObjectNode.createOrdinaryWithPrototype(context, ((ObjectLiteralProtoMemberNode)members[0]).valueNode));
        }
        if (members.length > 256 && ObjectLiteralNode.onlyDataMembers(members)) {
            return ObjectLiteralNode.createDictionaryObject(context, members);
        }
        return new ObjectLiteralNode(members, CreateObjectNode.create(context));
    }

    private static boolean onlyDataMembers(ObjectLiteralMemberNode[] members) {
        for (ObjectLiteralMemberNode member : members) {
            if (member instanceof ObjectLiteralDataMemberNode) continue;
            return false;
        }
        return true;
    }

    private static ObjectLiteralNode createDictionaryObject(JSContext context, ObjectLiteralMemberNode[] members) {
        ObjectLiteralMemberNode[] newMembers = new ObjectLiteralMemberNode[members.length];
        for (int i2 = 0; i2 < members.length; ++i2) {
            ObjectLiteralDataMemberNode member = (ObjectLiteralDataMemberNode)members[i2];
            newMembers[i2] = new DictionaryObjectDataMemberNode(member.name, member.isStatic, member.attributes, member.valueNode);
        }
        return new ObjectLiteralNode(newMembers, CreateObjectNode.createDictionary(context));
    }

    @Override
    public JSObject execute(VirtualFrame frame) {
        JSRealm realm = this.getRealm();
        JSObject ret = this.objectCreateNode.executeWithRealm(frame, realm);
        return this.executeWithObject(frame, ret, realm);
    }

    @ExplodeLoop
    private JSObject executeWithObject(VirtualFrame frame, JSObject ret, JSRealm realm) {
        for (int i2 = 0; i2 < this.members.length; ++i2) {
            this.members[i2].executeVoid(frame, ret, realm);
        }
        return ret;
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == JSDynamicObject.class;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new ObjectLiteralNode(ObjectLiteralMemberNode.cloneUninitialized(this.members, materializedTags), this.objectCreateNode.copyUninitialized(materializedTags));
    }

    private static class ObjectLiteralDataMemberNode
    extends CachingObjectLiteralMemberNode {
        @Node.Child
        protected JavaScriptNode valueNode;

        ObjectLiteralDataMemberNode(Object name, boolean isStatic, int attributes, JavaScriptNode valueNode, boolean isFieldOrStaticBlock) {
            super(name, isStatic, attributes, isFieldOrStaticBlock);
            this.valueNode = valueNode;
        }

        @Override
        public void executeVoid(VirtualFrame frame, JSObject receiver, JSObject homeObject, JSRealm realm) {
            Object value = ObjectLiteralDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject, realm);
            this.execute(receiver, this.name, value);
        }

        @Override
        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            Object key = this.evaluateKey(frame);
            Object value = ObjectLiteralDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject, realm);
            if (this.isFieldOrStaticBlock) {
                return ClassElementDefinitionRecord.createPublicField(key, value, this.isAnonymousFunctionDefinition(), decorators);
            }
            return ClassElementDefinitionRecord.createPublicMethod(key, value, this.isAnonymousFunctionDefinition(), decorators);
        }

        @Override
        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
            this.execute(homeObject, classElement.getKey(), classElement.getValue());
        }

        private void execute(JSObject obj, Object key, Object value) {
            if (this.isFieldOrStaticBlock) {
                return;
            }
            DynamicObjectLibrary dynamicObjectLib = this.dynamicObjectLibrary();
            this.checkNoElementsAssumption(obj, key);
            dynamicObjectLib.putWithFlags(obj, key, value, this.attributes);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ObjectLiteralDataMemberNode(this.name, this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags), this.isFieldOrStaticBlock);
        }
    }

    public static class AutoAccessorDataMemberNode
    extends ObjectLiteralDataMemberNode {
        private static final String ACCESSOR_STORAGE = " accessor storage";
        private static final HiddenKey STORAGE_KEY_MAGIC = new HiddenKey(":storage-key-magic");
        @Node.Child
        private PropertySetNode backingStorageMagicSetNode;
        private final JSFunctionData getterFunctionData;
        private final JSFunctionData setterFunctionData;

        AutoAccessorDataMemberNode(Object name, boolean isStatic, int attributes, JavaScriptNode valueNode) {
            super(name, isStatic, attributes, valueNode, false);
            JSContext context = this.getLanguage().getJSContext();
            this.setterFunctionData = AutoAccessorDataMemberNode.createAutoAccessorSetFunctionData(context);
            this.getterFunctionData = AutoAccessorDataMemberNode.createAutoAccessorGetFunctionData(context);
            this.backingStorageMagicSetNode = PropertySetNode.createSetHidden(STORAGE_KEY_MAGIC, context);
        }

        @Override
        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            Object key = this.evaluateKey(frame);
            HiddenKey backingStorageKey = this.createBackingStorageKey(key);
            JSFunctionObject setter = this.createAutoAccessorSetter(backingStorageKey, realm);
            JSFunctionObject getter = this.createAutoAccessorGetter(backingStorageKey, realm);
            Object value = AutoAccessorDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject, realm);
            return ClassElementDefinitionRecord.createPublicAutoAccessor(key, backingStorageKey, value, getter, setter, this.isAnonymousFunctionDefinition(), decorators);
        }

        @Override
        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
            this.executeWithGetterSetter(homeObject, classElement.getKey(), classElement.getGetter(), classElement.getSetter());
        }

        private static HiddenKey checkAutoAccessorTarget(VirtualFrame frame, PropertyGetNode getMagicNode, DynamicObjectLibrary storageLibrary, Object thiz) {
            JSFunctionObject function = JSFrameUtil.getFunctionObject(frame);
            HiddenKey backingStorageKey = (HiddenKey)getMagicNode.getValue(function);
            if (!(thiz instanceof JSObject) || !storageLibrary.containsKey((JSObject)thiz, backingStorageKey)) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createTypeError("Bad auto-accessor target.");
            }
            return backingStorageKey;
        }

        private static JSFunctionData createAutoAccessorSetFunctionData(final JSContext context) {
            CompilerAsserts.neverPartOfCompilation();
            RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage(), null, null){
                @Node.Child
                private PropertyGetNode getStorageKeyNode;
                @Node.Child
                private DynamicObjectLibrary storageLibrary;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.getStorageKeyNode = PropertyGetNode.createGetHidden(STORAGE_KEY_MAGIC, context);
                    this.storageLibrary = DynamicObjectLibrary.getFactory().createDispatched(5);
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    Object thiz = JSFrameUtil.getThisObj(frame);
                    HiddenKey backingStorageKey = AutoAccessorDataMemberNode.checkAutoAccessorTarget(frame, this.getStorageKeyNode, this.storageLibrary, thiz);
                    Object[] args = frame.getArguments();
                    JSDynamicObject value = JSArguments.getUserArgumentCount(args) > 0 ? JSArguments.getUserArgument(args, 0) : Undefined.instance;
                    this.storageLibrary.put((DynamicObject)thiz, backingStorageKey, value);
                    return value;
                }
            }.getCallTarget();
            return JSFunctionData.createCallOnly(context, callTarget, 1, Strings.SET);
        }

        private static JSFunctionData createAutoAccessorGetFunctionData(final JSContext context) {
            CompilerAsserts.neverPartOfCompilation();
            RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage(), null, null){
                @Node.Child
                private PropertyGetNode getStorageKeyNode;
                @Node.Child
                private DynamicObjectLibrary storageLibrary;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.getStorageKeyNode = PropertyGetNode.createGetHidden(STORAGE_KEY_MAGIC, context);
                    this.storageLibrary = DynamicObjectLibrary.getFactory().createDispatched(5);
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    Object thiz = JSFrameUtil.getThisObj(frame);
                    HiddenKey backingStorageKey = AutoAccessorDataMemberNode.checkAutoAccessorTarget(frame, this.getStorageKeyNode, this.storageLibrary, thiz);
                    return this.storageLibrary.getOrDefault((DynamicObject)thiz, backingStorageKey, Undefined.instance);
                }
            }.getCallTarget();
            return JSFunctionData.createCallOnly(context, callTarget, 0, Strings.GET);
        }

        private void executeWithGetterSetter(JSObject obj, Object key, Object getterV, Object setterV) {
            DynamicObjectLibrary dynamicObjectLib = this.dynamicObjectLibrary();
            this.checkNoElementsAssumption(obj, key);
            Accessor accessor = new Accessor(getterV, setterV);
            dynamicObjectLib.putWithFlags(obj, key, accessor, this.attributes | 8);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new AutoAccessorDataMemberNode(this.name, this.isStatic, (int)this.attributes, this.valueNode);
        }

        public JSFunctionObject createAutoAccessorSetter(HiddenKey backingStorageKey, JSRealm realm) {
            JSFunctionObject functionObject = JSFunction.create(realm, this.setterFunctionData);
            this.backingStorageMagicSetNode.setValue(functionObject, backingStorageKey);
            return functionObject;
        }

        public JSFunctionObject createAutoAccessorGetter(HiddenKey backingStorageKey, JSRealm realm) {
            JSFunctionObject functionObject = JSFunction.create(realm, this.getterFunctionData);
            this.backingStorageMagicSetNode.setValue(functionObject, backingStorageKey);
            return functionObject;
        }

        @CompilerDirectives.TruffleBoundary
        public HiddenKey createBackingStorageKey(Object key) {
            return new HiddenKey(String.valueOf(JSRuntime.safeToString(key)) + ACCESSOR_STORAGE);
        }
    }

    public static class ComputedAutoAccessorDataMemberNode
    extends AutoAccessorDataMemberNode {
        @Node.Child
        private JavaScriptNode keyNode;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode;

        ComputedAutoAccessorDataMemberNode(JavaScriptNode keyNode, boolean isStatic, int attributes, JavaScriptNode valueNode) {
            super((Object)Undefined.instance, isStatic, attributes, valueNode);
            this.keyNode = keyNode;
            this.toPropertyKeyNode = JSToPropertyKeyNode.create();
        }

        @Override
        protected Object evaluateKey(VirtualFrame frame) {
            return this.toPropertyKeyNode.execute(this.keyNode.execute(frame));
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ComputedAutoAccessorDataMemberNode(this.keyNode, this.isStatic, (int)this.attributes, this.valueNode);
        }
    }

    public static class ObjectLiteralAccessorMemberNode
    extends CachingObjectLiteralMemberNode {
        @Node.Child
        protected JavaScriptNode getterNode;
        @Node.Child
        protected JavaScriptNode setterNode;

        ObjectLiteralAccessorMemberNode(Object name, boolean isStatic, int attributes, JavaScriptNode getter, JavaScriptNode setter) {
            super(name, isStatic, attributes, false);
            this.getterNode = getter;
            this.setterNode = setter;
        }

        public boolean hasGetter() {
            return this.getterNode != null;
        }

        public boolean hasSetter() {
            return this.setterNode != null;
        }

        @Override
        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            Object key = this.evaluateKey(frame);
            Object getterV = null;
            Object setterV = null;
            if (this.hasGetter()) {
                getterV = ObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.getterNode, frame, homeObject, realm);
            }
            if (this.hasSetter()) {
                setterV = ObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.setterNode, frame, homeObject, realm);
            }
            assert (getterV != null || setterV != null);
            if (this.hasGetter() && this.hasSetter()) {
                return ClassElementDefinitionRecord.createPublicAccessor(key, getterV, setterV, this.isAnonymousFunctionDefinition, decorators);
            }
            if (this.hasGetter()) {
                return ClassElementDefinitionRecord.createPublicGetter(key, getterV, this.isAnonymousFunctionDefinition, decorators);
            }
            assert (this.hasSetter());
            return ClassElementDefinitionRecord.createPublicSetter(key, setterV, this.isAnonymousFunctionDefinition, decorators);
        }

        @Override
        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
            this.execute(homeObject, classElement.getGetter(), classElement.getSetter());
        }

        @Override
        public final void executeVoid(VirtualFrame frame, JSObject receiver, JSObject homeObject, JSRealm realm) {
            Object getterV = null;
            Object setterV = null;
            if (this.hasGetter()) {
                getterV = ObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.getterNode, frame, homeObject, realm);
            }
            if (this.hasSetter()) {
                setterV = ObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.setterNode, frame, homeObject, realm);
            }
            assert (getterV != null || setterV != null);
            this.execute(receiver, getterV, setterV);
        }

        private void execute(JSObject obj, Object getterV, Object setterV) {
            DynamicObjectLibrary dynamicObjectLib = this.dynamicObjectLibrary();
            this.checkNoElementsAssumption(obj, this.name);
            Object getter = getterV;
            Object setter = setterV;
            if ((this.getterNode == null || this.setterNode == null) && JSProperty.isAccessor(dynamicObjectLib.getPropertyFlagsOrDefault(obj, this.name, 0))) {
                Accessor existing = (Accessor)dynamicObjectLib.getOrDefault(obj, this.name, null);
                getter = getter == null ? existing.getGetter() : getter;
                setter = setter == null ? existing.getSetter() : setter;
            }
            Accessor accessor = new Accessor(getter, setter);
            dynamicObjectLib.putWithFlags(obj, this.name, accessor, this.attributes | 8);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ObjectLiteralAccessorMemberNode(this.name, this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.getterNode, materializedTags), JavaScriptNode.cloneUninitialized(this.setterNode, materializedTags));
        }
    }

    public static abstract class ComputedObjectLiteralDataMemberNode
    extends ClassElementNode {
        @Node.Child
        private JavaScriptNode propertyKey;
        @Node.Child
        protected JavaScriptNode valueNode;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKey;
        @Node.Child
        protected SetFunctionNameNode setFunctionName;

        ComputedObjectLiteralDataMemberNode(JavaScriptNode key, boolean isStatic, int attributes, JavaScriptNode valueNode, boolean isField, boolean isAnonymousFunctionDefinition) {
            super(isStatic, attributes, isField, isAnonymousFunctionDefinition);
            this.propertyKey = key;
            this.valueNode = valueNode;
            this.toPropertyKey = JSToPropertyKeyNode.create();
            this.setFunctionName = ComputedObjectLiteralDataMemberNode.isAnonymousFunctionDefinition(valueNode) ? SetFunctionNameNode.create() : null;
        }

        @Specialization(guards={"!isFieldOrStaticBlock", "!isAnonymousFunctionDefinition", "setFunctionName==null", "!isMethodNode(valueNode)"}, limit="3")
        public final void doNoFieldNoFunctionDef(VirtualFrame frame, JSObject receiver, JSObject homeObject, JSRealm realm, @CachedLibrary(value="receiver") DynamicObjectLibrary dynamicObject) {
            Object key = this.evaluateKey(frame);
            Object value = this.valueNode.execute(frame);
            this.checkNoElementsAssumption(receiver, key);
            dynamicObject.putWithFlags(receiver, key, value, this.attributes | (JSRuntime.isPrivateSymbol(key) ? (byte)1 : 0));
        }

        @Specialization
        public final void doGeneric(VirtualFrame frame, JSObject receiver, JSObject homeObject, JSRealm realm) {
            Object value;
            if (this.isFieldOrStaticBlock) {
                return;
            }
            Object key = this.evaluateKey(frame);
            if (this.isAnonymousFunctionDefinition && this.valueNode instanceof NamedEvaluationTargetNode) {
                value = ((NamedEvaluationTargetNode)this.valueNode).executeWithName(frame, key);
            } else {
                value = ComputedObjectLiteralDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject, realm);
                if (this.setFunctionName != null) {
                    this.setFunctionName.execute(value, key);
                }
            }
            PropertyDescriptor propDesc = PropertyDescriptor.createData(value, this.attributes);
            JSRuntime.definePropertyOrThrow(receiver, key, propDesc);
        }

        private Object evaluateKey(VirtualFrame frame) {
            Object key = this.propertyKey.execute(frame);
            return this.toPropertyKey.execute(key);
        }

        private Object evaluateValue(VirtualFrame frame, JSObject homeObject, Object key, JSRealm realm) {
            Object value;
            if (!(this.isFieldOrStaticBlock || this.isAnonymousFunctionDefinition || this.setFunctionName != null || ComputedObjectLiteralDataMemberNode.isMethodNode(this.valueNode))) {
                return this.valueNode.execute(frame);
            }
            if (this.isAnonymousFunctionDefinition && this.valueNode instanceof NamedEvaluationTargetNode) {
                value = ((NamedEvaluationTargetNode)this.valueNode).executeWithName(frame, key);
            } else {
                value = ComputedObjectLiteralDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject, realm);
                if (this.setFunctionName != null) {
                    this.setFunctionName.execute(value, key);
                }
            }
            return value;
        }

        @Override
        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            Object key = this.evaluateKey(frame);
            Object value = this.evaluateValue(frame, homeObject, key, realm);
            if (this.isFieldOrStaticBlock) {
                return ClassElementDefinitionRecord.createPublicField(key, value, this.isAnonymousFunctionDefinition(), decorators);
            }
            return ClassElementDefinitionRecord.createPublicMethod(key, value, this.isAnonymousFunctionDefinition(), decorators);
        }

        @Override
        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
            PropertyDescriptor propDesc = PropertyDescriptor.createData(classElement.getValue(), this.attributes);
            JSRuntime.definePropertyOrThrow(homeObject, classElement.getKey(), propDesc);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return ObjectLiteralNodeFactory.ComputedObjectLiteralDataMemberNodeGen.create(JavaScriptNode.cloneUninitialized(this.propertyKey, materializedTags), this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags), this.isFieldOrStaticBlock, this.isAnonymousFunctionDefinition);
        }
    }

    private static class ComputedObjectLiteralAccessorMemberNode
    extends ClassElementNode {
        @Node.Child
        private JavaScriptNode propertyKey;
        @Node.Child
        private JavaScriptNode getterNode;
        @Node.Child
        private JavaScriptNode setterNode;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKey;
        @Node.Child
        private SetFunctionNameNode setFunctionName;
        private final boolean isGetterAnonymousFunction;
        private final boolean isSetterAnonymousFunction;

        ComputedObjectLiteralAccessorMemberNode(JavaScriptNode key, boolean isStatic, int attributes, JavaScriptNode getter, JavaScriptNode setter) {
            super(isStatic, attributes);
            this.propertyKey = key;
            this.getterNode = getter;
            this.setterNode = setter;
            this.toPropertyKey = JSToPropertyKeyNode.create();
            this.isGetterAnonymousFunction = ComputedObjectLiteralAccessorMemberNode.isAnonymousFunctionDefinition(getter);
            this.isSetterAnonymousFunction = ComputedObjectLiteralAccessorMemberNode.isAnonymousFunctionDefinition(setter);
            this.setFunctionName = this.isGetterAnonymousFunction || this.isSetterAnonymousFunction ? SetFunctionNameNode.create() : null;
        }

        @Override
        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            Object key = this.evaluateKey(frame);
            Object getterV = null;
            Object setterV = null;
            if (this.hasGetter()) {
                getterV = ComputedObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.getterNode, frame, homeObject, realm);
                if (this.isGetterAnonymousFunction) {
                    this.setFunctionName.execute(getterV, key, Strings.GET);
                }
            }
            if (this.hasSetter()) {
                setterV = ComputedObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.setterNode, frame, homeObject, realm);
                if (this.isSetterAnonymousFunction) {
                    this.setFunctionName.execute(setterV, key, Strings.SET);
                }
            }
            if (this.hasGetter() && this.hasSetter()) {
                return ClassElementDefinitionRecord.createPublicAccessor(key, getterV, setterV, this.isGetterAnonymousFunction || this.isSetterAnonymousFunction, decorators);
            }
            if (this.hasGetter()) {
                return ClassElementDefinitionRecord.createPublicGetter(key, getterV, this.isGetterAnonymousFunction, decorators);
            }
            assert (this.hasSetter());
            return ClassElementDefinitionRecord.createPublicSetter(key, setterV, this.isSetterAnonymousFunction, decorators);
        }

        @Override
        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
            Object getter = classElement.getGetter();
            Object setter = classElement.getSetter();
            assert (!(getter == null && setter == null || getter instanceof Accessor || setter instanceof Accessor));
            PropertyDescriptor propDesc = PropertyDescriptor.createAccessor(getter, setter, this.attributes);
            JSRuntime.definePropertyOrThrow(homeObject, classElement.getKey(), propDesc);
        }

        @Override
        public final void executeVoid(VirtualFrame frame, JSObject receiver, JSObject homeObject, JSRealm realm) {
            Object key = this.evaluateKey(frame);
            Object getterV = null;
            Object setterV = null;
            if (this.hasGetter()) {
                getterV = ComputedObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.getterNode, frame, homeObject, realm);
                if (this.isGetterAnonymousFunction) {
                    this.setFunctionName.execute(getterV, key, Strings.GET);
                }
            }
            if (this.hasSetter()) {
                setterV = ComputedObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.setterNode, frame, homeObject, realm);
                if (this.isSetterAnonymousFunction) {
                    this.setFunctionName.execute(setterV, key, Strings.SET);
                }
            }
            assert (getterV != null || setterV != null);
            PropertyDescriptor propDesc = PropertyDescriptor.createAccessor(getterV, setterV, this.attributes);
            JSRuntime.definePropertyOrThrow(receiver, key, propDesc);
        }

        private Object evaluateKey(VirtualFrame frame) {
            Object key = this.propertyKey.execute(frame);
            return this.toPropertyKey.execute(key);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ComputedObjectLiteralAccessorMemberNode(JavaScriptNode.cloneUninitialized(this.propertyKey, materializedTags), this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.getterNode, materializedTags), JavaScriptNode.cloneUninitialized(this.setterNode, materializedTags));
        }

        public boolean hasGetter() {
            return this.getterNode != null;
        }

        public boolean hasSetter() {
            return this.setterNode != null;
        }
    }

    private static class PrivateFieldMemberNode
    extends PrivateClassElementNode {
        @Node.Child
        private JavaScriptNode keyNode;
        @Node.Child
        private JavaScriptNode valueNode;

        PrivateFieldMemberNode(JavaScriptNode key, boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateNode) {
            super(isStatic, true, writePrivateNode);
            this.keyNode = key;
            this.valueNode = valueNode;
            this.writePrivateNode = writePrivateNode;
        }

        @Override
        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            this.writePrivateNode.execute(frame);
            Object key = this.keyNode.execute(frame);
            Object value = PrivateFieldMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject, realm);
            return ClassElementDefinitionRecord.createPrivateField(key, value, decorators);
        }

        @Override
        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
        }

        @Override
        public int getPrivateBrandSlotIndex() {
            return -1;
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new PrivateFieldMemberNode(JavaScriptNode.cloneUninitialized(this.keyNode, materializedTags), this.isStatic, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags), JavaScriptNode.cloneUninitialized(this.writePrivateNode, materializedTags));
        }
    }

    public static class PrivateMethodMemberNode
    extends PrivateClassElementNode {
        @Node.Child
        private JavaScriptNode valueNode;
        private final TruffleString privateName;
        private final int privateBrandSlotIndex;

        PrivateMethodMemberNode(TruffleString privateName, boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateNode, int privateBrandSlotIndex) {
            super(isStatic, false, writePrivateNode);
            this.privateName = privateName;
            this.valueNode = valueNode;
            this.writePrivateNode = writePrivateNode;
            this.privateBrandSlotIndex = privateBrandSlotIndex;
        }

        @Override
        public int getPrivateBrandSlotIndex() {
            return this.privateBrandSlotIndex;
        }

        @Override
        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            Object value = PrivateMethodMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject, realm);
            return ClassElementDefinitionRecord.createPrivateMethod(this.privateName, value, decorators);
        }

        @Override
        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
            this.writePrivateNode.executeWrite(frame, classElement.getValue());
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new PrivateMethodMemberNode(this.privateName, this.isStatic, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags), JavaScriptNode.cloneUninitialized(this.writePrivateNode, materializedTags), this.privateBrandSlotIndex);
        }
    }

    public static class PrivateAccessorMemberNode
    extends PrivateClassElementNode {
        @Node.Child
        private JavaScriptNode getterNode;
        @Node.Child
        private JavaScriptNode setterNode;
        private final int privateBrandSlotIndex;

        PrivateAccessorMemberNode(boolean isStatic, JavaScriptNode getterNode, JavaScriptNode setterNode, JSWriteFrameSlotNode writePrivateNode, int privateBrandSlotIndex) {
            super(isStatic, false, writePrivateNode);
            this.getterNode = getterNode;
            this.setterNode = setterNode;
            this.writePrivateNode = writePrivateNode;
            this.privateBrandSlotIndex = privateBrandSlotIndex;
        }

        @Override
        public int getPrivateBrandSlotIndex() {
            return this.privateBrandSlotIndex;
        }

        @Override
        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            Object key = this.writePrivateNode.getIdentifier();
            Object getter = null;
            Object setter = null;
            if (this.hasGetter()) {
                getter = PrivateAccessorMemberNode.evaluateWithHomeObject(this.getterNode, frame, homeObject, realm);
            }
            if (this.hasSetter()) {
                setter = PrivateAccessorMemberNode.evaluateWithHomeObject(this.setterNode, frame, homeObject, realm);
            }
            assert (getter != null || setter != null);
            if (this.hasGetter() && this.hasSetter()) {
                return ClassElementDefinitionRecord.createPrivateAccessor(key, getter, setter, decorators);
            }
            if (this.hasGetter()) {
                return ClassElementDefinitionRecord.createPrivateGetter(key, getter, decorators);
            }
            assert (this.hasSetter());
            return ClassElementDefinitionRecord.createPrivateSetter(key, setter, decorators);
        }

        @Override
        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
            Object previous;
            int slotIndex;
            Object getter = classElement.getGetter();
            Object setter = classElement.getSetter();
            assert (getter != null || setter != null);
            Frame privateFrame = this.writePrivateNode.getLevelFrameNode().executeFrame(frame);
            if (privateFrame.isObject(slotIndex = this.writePrivateNode.getSlotIndex()) && (previous = privateFrame.getObject(slotIndex)) instanceof Accessor) {
                getter = getter == null ? ((Accessor)previous).getGetter() : getter;
                setter = setter == null ? ((Accessor)previous).getSetter() : setter;
            }
            Accessor accessor = new Accessor(getter, setter);
            this.writePrivateNode.executeWrite(frame, accessor);
        }

        public boolean hasGetter() {
            return this.getterNode != null;
        }

        public boolean hasSetter() {
            return this.setterNode != null;
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new PrivateAccessorMemberNode(this.isStatic, JavaScriptNode.cloneUninitialized(this.getterNode, materializedTags), JavaScriptNode.cloneUninitialized(this.setterNode, materializedTags), JavaScriptNode.cloneUninitialized(this.writePrivateNode, materializedTags), this.privateBrandSlotIndex);
        }
    }

    public static class PrivateAutoAccessorMemberNode
    extends PrivateClassElementNode {
        private static final HiddenKey STORAGE_KEY_MAGIC = new HiddenKey(":storage-key-magic");
        @Node.Child
        private JavaScriptNode valueNode;
        @Node.Child
        private JavaScriptNode storageKeyNode;
        @Node.Child
        private PropertySetNode backingStorageMagicSetNode;
        private final int privateBrandSlotIndex;
        private final JSFunctionData getterFunctionData;
        private final JSFunctionData setterFunctionData;

        PrivateAutoAccessorMemberNode(boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateAccessorNode, JavaScriptNode storageKeyNode, int privateBrandSlot) {
            super(isStatic, false, writePrivateAccessorNode);
            this.valueNode = valueNode;
            this.storageKeyNode = storageKeyNode;
            this.privateBrandSlotIndex = privateBrandSlot;
            JSContext context = this.getLanguage().getJSContext();
            this.backingStorageMagicSetNode = PropertySetNode.createSetHidden(STORAGE_KEY_MAGIC, context);
            this.setterFunctionData = PrivateAutoAccessorMemberNode.createAutoAccessorSetFunctionData(context);
            this.getterFunctionData = PrivateAutoAccessorMemberNode.createAutoAccessorGetFunctionData(context);
        }

        @Override
        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            HiddenKey storageKey = (HiddenKey)this.storageKeyNode.execute(frame);
            Object value = PrivateAutoAccessorMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject, realm);
            JSFunctionObject setter = this.createAutoAccessorSetter(storageKey, realm);
            JSFunctionObject getter = this.createAutoAccessorGetter(storageKey, realm);
            Accessor accessor = new Accessor(getter, setter);
            this.writePrivateNode.executeWrite(frame, accessor);
            Object accessorKey = this.writePrivateNode.getIdentifier();
            return ClassElementDefinitionRecord.createPrivateAutoAccessor(accessorKey, storageKey, value, getter, setter, decorators);
        }

        @Override
        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
        }

        private static HiddenKey checkAutoAccessorTarget(VirtualFrame frame, PropertyGetNode getStorageKeyNode, DynamicObjectLibrary storageLibrary, Object thiz) {
            JSFunctionObject function = JSFrameUtil.getFunctionObject(frame);
            HiddenKey backingStorageKey = (HiddenKey)getStorageKeyNode.getValue(function);
            if (!(thiz instanceof JSObject) || !storageLibrary.containsKey((JSObject)thiz, backingStorageKey)) {
                throw Errors.createTypeError("Bad auto-accessor target.");
            }
            return backingStorageKey;
        }

        private static JSFunctionData createAutoAccessorGetFunctionData(final JSContext context) {
            CompilerAsserts.neverPartOfCompilation();
            RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage(), null, null){
                @Node.Child
                private PropertyGetNode getStorageKeyNode;
                @Node.Child
                private DynamicObjectLibrary storageLibrary;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.getStorageKeyNode = PropertyGetNode.createGetHidden(STORAGE_KEY_MAGIC, context);
                    this.storageLibrary = DynamicObjectLibrary.getFactory().createDispatched(5);
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    Object thiz = JSFrameUtil.getThisObj(frame);
                    HiddenKey backingStorageKey = PrivateAutoAccessorMemberNode.checkAutoAccessorTarget(frame, this.getStorageKeyNode, this.storageLibrary, thiz);
                    return this.storageLibrary.getOrDefault((JSObject)thiz, backingStorageKey, Undefined.instance);
                }
            }.getCallTarget();
            return JSFunctionData.createCallOnly(context, callTarget, 0, Strings.GET);
        }

        private static JSFunctionData createAutoAccessorSetFunctionData(final JSContext context) {
            CompilerAsserts.neverPartOfCompilation();
            RootCallTarget callTarget = new JavaScriptRootNode(context.getLanguage(), null, null){
                @Node.Child
                private PropertyGetNode getStorageKeyNode;
                @Node.Child
                private DynamicObjectLibrary storageLibrary;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.getStorageKeyNode = PropertyGetNode.createGetHidden(STORAGE_KEY_MAGIC, context);
                    this.storageLibrary = DynamicObjectLibrary.getFactory().createDispatched(5);
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    Object thiz = JSFrameUtil.getThisObj(frame);
                    HiddenKey backingStorageKey = PrivateAutoAccessorMemberNode.checkAutoAccessorTarget(frame, this.getStorageKeyNode, this.storageLibrary, thiz);
                    Object[] args = frame.getArguments();
                    JSDynamicObject value = JSArguments.getUserArgumentCount(args) > 0 ? JSArguments.getUserArgument(args, 0) : Undefined.instance;
                    this.storageLibrary.put((JSObject)thiz, backingStorageKey, value);
                    return value;
                }
            }.getCallTarget();
            return JSFunctionData.createCallOnly(context, callTarget, 1, Strings.SET);
        }

        public JSFunctionObject createAutoAccessorGetter(HiddenKey backingStorageKey, JSRealm realm) {
            JSFunctionObject functionObject = JSFunction.create(realm, this.getterFunctionData);
            this.backingStorageMagicSetNode.setValue(functionObject, backingStorageKey);
            return functionObject;
        }

        public JSFunctionObject createAutoAccessorSetter(HiddenKey backingStorageKey, JSRealm realm) {
            JSFunctionObject functionObject = JSFunction.create(realm, this.setterFunctionData);
            this.backingStorageMagicSetNode.setValue(functionObject, backingStorageKey);
            return functionObject;
        }

        @Override
        public int getPrivateBrandSlotIndex() {
            return this.privateBrandSlotIndex;
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new PrivateAutoAccessorMemberNode(this.isStatic, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags), JavaScriptNode.cloneUninitialized(this.writePrivateNode, materializedTags), JavaScriptNode.cloneUninitialized(this.storageKeyNode, materializedTags), this.privateBrandSlotIndex);
        }
    }

    private static class ObjectLiteralProtoMemberNode
    extends ObjectLiteralMemberNode {
        @Node.Child
        protected JavaScriptNode valueNode;

        ObjectLiteralProtoMemberNode(boolean isStatic, JavaScriptNode valueNode) {
            super(isStatic, 0);
            this.valueNode = valueNode;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, JSObject receiver, JSObject homeObject, JSRealm realm) {
            Object value = this.valueNode.execute(frame);
            if (JSDynamicObject.isJSDynamicObject(value)) {
                if (value == Undefined.instance) {
                    return;
                }
                JSObject.setPrototype(receiver, (JSDynamicObject)value);
            }
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ObjectLiteralProtoMemberNode(this.isStatic, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags));
        }
    }

    private static class ObjectLiteralSpreadMemberNode
    extends ObjectLiteralMemberNode {
        @Node.Child
        private JavaScriptNode valueNode;
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private CopyDataPropertiesNode copyDataPropertiesNode;

        ObjectLiteralSpreadMemberNode(boolean isStatic, int attributes, JavaScriptNode valueNode) {
            super(isStatic, attributes);
            this.valueNode = valueNode;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, JSObject receiver, JSObject target, JSRealm realm) {
            Object sourceValue = this.valueNode.execute(frame);
            if (JSGuards.isNullOrUndefined(sourceValue)) {
                return;
            }
            if (this.toObjectNode == null || this.copyDataPropertiesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                JSContext context = this.getLanguage().getJSContext();
                this.toObjectNode = this.insert(JSToObjectNode.create());
                this.copyDataPropertiesNode = this.insert(CopyDataPropertiesNode.create(context));
            }
            Object from = this.toObjectNode.execute(sourceValue);
            this.copyDataPropertiesNode.execute(target, from);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ObjectLiteralSpreadMemberNode(this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags));
        }
    }

    private static class StaticBlockNode
    extends ClassElementNode {
        @Node.Child
        protected JavaScriptNode valueNode;

        StaticBlockNode(JavaScriptNode valueNode) {
            super(true, 0, true, false);
            this.valueNode = valueNode;
        }

        @Override
        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            Object initializer = StaticBlockNode.evaluateWithHomeObject(this.valueNode, frame, homeObject, realm);
            return ClassElementDefinitionRecord.createStaticBlock(initializer);
        }

        @Override
        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new StaticBlockNode(JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags));
        }
    }

    public static abstract class ObjectLiteralMemberNode
    extends JavaScriptBaseNode {
        public static final ObjectLiteralMemberNode[] EMPTY = new ObjectLiteralMemberNode[0];
        protected final boolean isStatic;
        protected final byte attributes;
        protected final boolean isFieldOrStaticBlock;
        protected final boolean isAnonymousFunctionDefinition;

        protected ObjectLiteralMemberNode(boolean isStatic, int attributes) {
            this(isStatic, attributes, false, false);
        }

        protected ObjectLiteralMemberNode(boolean isStatic, int attributes, boolean isFieldOrStaticBlock, boolean isAnonymousFunctionDefinition) {
            assert (attributes == (attributes & 7));
            this.isStatic = isStatic;
            this.attributes = (byte)attributes;
            this.isFieldOrStaticBlock = isFieldOrStaticBlock;
            this.isAnonymousFunctionDefinition = isAnonymousFunctionDefinition;
        }

        public abstract void executeVoid(VirtualFrame var1, JSObject var2, JSObject var3, JSRealm var4);

        public final void executeVoid(VirtualFrame frame, JSObject obj, JSRealm realm) {
            this.executeVoid(frame, obj, obj, realm);
        }

        public ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame frame, JSObject homeObject, JSRealm realm, Object[] decorators) {
            throw Errors.shouldNotReachHere();
        }

        public void defineClassElement(VirtualFrame frame, JSObject homeObject, ClassElementDefinitionRecord classElement) {
            throw Errors.shouldNotReachHere();
        }

        public final boolean isStatic() {
            return this.isStatic;
        }

        public boolean isPrivate() {
            return false;
        }

        public final boolean isFieldOrStaticBlock() {
            return this.isFieldOrStaticBlock;
        }

        public final boolean isAnonymousFunctionDefinition() {
            return this.isAnonymousFunctionDefinition;
        }

        static boolean isAnonymousFunctionDefinition(JavaScriptNode expression) {
            return expression instanceof FunctionNameHolder && ((FunctionNameHolder)((Object)expression)).isAnonymous();
        }

        @Idempotent
        protected static boolean isMethodNode(JavaScriptNode valueNode) {
            return valueNode instanceof MakeMethodNode;
        }

        protected static Object evaluateWithHomeObject(JavaScriptNode valueNode, VirtualFrame frame, JSObject obj, JSRealm realm) {
            if (ObjectLiteralMemberNode.isMethodNode(valueNode)) {
                return ((MakeMethodNode)valueNode).executeWithObject(frame, obj, realm);
            }
            return ObjectLiteralNode.executeWithRealm(valueNode, frame, realm);
        }

        protected abstract ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> var1);

        public static ObjectLiteralMemberNode[] cloneUninitialized(ObjectLiteralMemberNode[] members, Set<Class<? extends Tag>> materializedTags) {
            ObjectLiteralMemberNode[] copy = (ObjectLiteralMemberNode[])members.clone();
            for (int i2 = 0; i2 < copy.length; ++i2) {
                copy[i2] = copy[i2].copyUninitialized(materializedTags);
            }
            return copy;
        }

        public int getAttributes() {
            return this.attributes;
        }
    }

    private static class DictionaryObjectDataMemberNode
    extends ObjectLiteralMemberNode {
        private final Object name;
        @Node.Child
        private JavaScriptNode valueNode;

        DictionaryObjectDataMemberNode(Object name, boolean isStatic, int attributes, JavaScriptNode valueNode) {
            super(isStatic, attributes);
            assert (JSRuntime.isPropertyKey(name));
            this.name = name;
            this.valueNode = valueNode;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, JSObject receiver, JSObject homeObject, JSRealm realm) {
            Object value = DictionaryObjectDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject, realm);
            PropertyDescriptor propDesc = PropertyDescriptor.createData(value, this.attributes);
            JSObject.defineOwnProperty(receiver, this.name, propDesc, true);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new DictionaryObjectDataMemberNode(this.name, this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags));
        }
    }

    private static abstract class CachingObjectLiteralMemberNode
    extends ClassElementNode {
        protected final Object name;
        @Node.Child
        private DynamicObjectLibrary dynamicObjectLibrary;

        CachingObjectLiteralMemberNode(Object name, boolean isStatic, int attributes, boolean isFieldOrStaticBlock) {
            super(isStatic, attributes, isFieldOrStaticBlock, false);
            assert (this instanceof AutoAccessorDataMemberNode || JSRuntime.isPropertyKey(name) || name == null && isStatic && isFieldOrStaticBlock) : name;
            this.name = name;
        }

        protected Object evaluateKey(VirtualFrame frame) {
            return this.name;
        }

        protected final DynamicObjectLibrary dynamicObjectLibrary() {
            DynamicObjectLibrary dynamicObjectLib = this.dynamicObjectLibrary;
            if (dynamicObjectLib == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                JSContext context = this.getLanguage().getJSContext();
                this.dynamicObjectLibrary = dynamicObjectLib = this.insert(JSObjectUtil.createDispatched(this.name, context.getPropertyCacheLimit()));
                JSObjectUtil.checkForNoSuchPropertyOrMethod(context, this.name);
            }
            return dynamicObjectLib;
        }
    }

    public static abstract class PrivateClassElementNode
    extends ClassElementNode {
        @Node.Child
        protected JSWriteFrameSlotNode writePrivateNode;

        protected PrivateClassElementNode(boolean isStatic, boolean isFieldOrStaticBlock, JSWriteFrameSlotNode writePrivateNode) {
            super(isStatic, JSAttributes.getDefaultNotEnumerable(), isFieldOrStaticBlock, false);
            this.writePrivateNode = writePrivateNode;
        }

        @Override
        public final boolean isPrivate() {
            return true;
        }

        public final ScopeFrameNode getPrivateScopeNode() {
            return this.writePrivateNode.getLevelFrameNode();
        }

        public final int getPrivateMemberSlotIndex() {
            return this.writePrivateNode.getSlotIndex();
        }

        public abstract int getPrivateBrandSlotIndex();
    }

    public static abstract class ClassElementNode
    extends ObjectLiteralMemberNode {
        protected ClassElementNode(boolean isStatic, int attributes, boolean isFieldOrStaticBlock, boolean isAnonymousFunctionDefinition) {
            super(isStatic, attributes, isFieldOrStaticBlock, isAnonymousFunctionDefinition);
        }

        protected ClassElementNode(boolean isStatic, int attributes) {
            super(isStatic, attributes);
        }

        @Override
        public abstract ClassElementDefinitionRecord evaluateClassElementDefinition(VirtualFrame var1, JSObject var2, JSRealm var3, Object[] var4);

        @Override
        public abstract void defineClassElement(VirtualFrame var1, JSObject var2, ClassElementDefinitionRecord var3);

        @Override
        public void executeVoid(VirtualFrame frame, JSObject receiver, JSObject homeObject, JSRealm realm) {
        }

        protected final void checkNoElementsAssumption(JSObject obj, Object key) {
            boolean canHaveNoElementsAssumption;
            Node parent = this.getParent();
            if (parent instanceof ObjectLiteralNode) {
                ObjectLiteralNode objectLit = (ObjectLiteralNode)parent;
                canHaveNoElementsAssumption = objectLit.objectCreateNode.seenArrayPrototype();
            } else if (parent instanceof ClassDefinitionNode) {
                ClassDefinitionNode classDef = (ClassDefinitionNode)parent;
                canHaveNoElementsAssumption = classDef.getCreatePrototypeNode().seenArrayPrototype();
            } else {
                canHaveNoElementsAssumption = true;
            }
            CompilerAsserts.partialEvaluationConstant(canHaveNoElementsAssumption);
            if (!canHaveNoElementsAssumption) {
                assert (!JSShape.hasNoElementsAssumption(obj));
                return;
            }
            this.actuallyCheckNoElementsAssumption(obj, key);
        }

        private void actuallyCheckNoElementsAssumption(JSObject obj, Object key) {
            if (CompilerDirectives.injectBranchProbability(1.0E-4, JSShape.hasNoElementsAssumption(obj)) && key instanceof TruffleString) {
                TruffleString name = (TruffleString)key;
                Assumption noPrototypeElementsAssumption = this.getJSContext().getArrayPrototypeNoElementsAssumption();
                if (noPrototypeElementsAssumption.isValid() && JSRuntime.isArrayIndexString(name)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    noPrototypeElementsAssumption.invalidate("DefineOwnProperty on an Array prototype");
                }
            }
        }
    }

    public static final class MakeMethodNode
    extends JavaScriptNode
    implements FunctionNameHolder.Delegate {
        @Node.Child
        private JavaScriptNode functionNode;
        @Node.Child
        private PropertySetNode makeMethodNode;

        private MakeMethodNode(JSContext context, JavaScriptNode functionNode) {
            this.functionNode = functionNode;
            this.makeMethodNode = PropertySetNode.createSetHidden(JSFunction.HOME_OBJECT_ID, context);
        }

        private MakeMethodNode(JSContext context, JavaScriptNode functionNode, HiddenKey key) {
            this.functionNode = functionNode;
            this.makeMethodNode = PropertySetNode.createSetHidden(key, context);
        }

        public static JavaScriptNode create(JSContext context, JavaScriptNode functionNode) {
            return new MakeMethodNode(context, functionNode);
        }

        public static JavaScriptNode createWithKey(JSContext context, JavaScriptNode functionNode, HiddenKey key) {
            return new MakeMethodNode(context, functionNode, key);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.functionNode.execute(frame);
        }

        public Object executeWithObject(VirtualFrame frame, JSObject obj, JSRealm realm) {
            Object function = ObjectLiteralNode.executeWithRealm(this.functionNode, frame, realm);
            this.makeMethodNode.setValue(function, obj);
            return function;
        }

        @Override
        public FunctionNameHolder getFunctionNameHolder() {
            return (FunctionNameHolder)((Object)this.functionNode);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return MakeMethodNode.create(this.makeMethodNode.getContext(), MakeMethodNode.cloneUninitialized(this.functionNode, materializedTags));
        }
    }
}

