/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Executed;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.HiddenKey;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSTargetableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PrivateFieldSetNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Properties;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Accessor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class PrivateFieldSetNode
extends JSTargetableNode {
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode keyNode;
    @Node.Child
    @Executed
    protected JavaScriptNode valueNode;
    protected final JSContext context;

    public static PrivateFieldSetNode create(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        return PrivateFieldSetNodeGen.create(targetNode, keyNode, valueNode, context);
    }

    protected PrivateFieldSetNode(JavaScriptNode targetNode, JavaScriptNode keyNode, JavaScriptNode valueNode, JSContext context) {
        this.targetNode = targetNode;
        this.keyNode = keyNode;
        this.valueNode = valueNode;
        this.context = context;
    }

    @Specialization(limit="3")
    Object doField(JSObject target, HiddenKey key, Object value, @Bind(value="this") Node node, @CachedLibrary(value="target") DynamicObjectLibrary access, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
        if (!Properties.putIfPresent(access, target, key, value)) {
            errorBranch.enter(node);
            this.missing(target, key, value);
        }
        return value;
    }

    @Specialization
    Object doAccessor(JSObject target, Accessor accessor, Object value, @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
        Object setter = accessor.getSetter();
        if (setter == Undefined.instance) {
            errorBranch.enter(this);
            throw Errors.createTypeErrorCannotSetAccessorProperty(this.keyAsString(), target, this);
        }
        callNode.executeCall(JSArguments.createOneArg(target, setter, value));
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    Object missing(Object target, Object key, Object value) {
        throw Errors.createTypeErrorCannotSetPrivateMember(this.keyAsString(), this);
    }

    @CompilerDirectives.TruffleBoundary
    private Object keyAsString() {
        return Strings.fromJavaString(this.keyNode.expressionToString());
    }

    @Override
    public final JavaScriptNode getTarget() {
        return this.targetNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return PrivateFieldSetNode.create(PrivateFieldSetNode.cloneUninitialized(this.targetNode, materializedTags), PrivateFieldSetNode.cloneUninitialized(this.keyNode, materializedTags), PrivateFieldSetNode.cloneUninitialized(this.valueNode, materializedTags), this.context);
    }
}

