/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSArrayElementIndexNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSArrayLastElementIndexNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.JSArrayPreviousElementIndexNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;

public abstract class JSArrayLastElementIndexNode
extends JSArrayElementIndexNode {
    protected JSArrayLastElementIndexNode(JSContext context) {
        super(context);
    }

    @NeverDefault
    public static JSArrayLastElementIndexNode create(JSContext context) {
        return JSArrayLastElementIndexNodeGen.create(context);
    }

    public final long executeLong(Object object, long length) {
        return this.executeLong(object, length, this.isArray(object));
    }

    public abstract long executeLong(Object var1, long var2, boolean var4);

    @Specialization(guards={"isArray", "!hasPrototypeElements(object)", "getArrayType(object) == cachedArrayType", "!cachedArrayType.hasHoles(object)"}, limit="MAX_CACHED_ARRAY_TYPES")
    public long doWithoutHolesCached(JSDynamicObject object, long length, boolean isArray, @Cached(value="getArrayTypeIfArray(object, isArray)") ScriptArray cachedArrayType) {
        assert (JSArrayLastElementIndexNode.isSupportedArray(object) && cachedArrayType == JSArrayLastElementIndexNode.getArrayType(object));
        return cachedArrayType.lastElementIndex(object);
    }

    @Specialization(guards={"isArray", "!hasPrototypeElements(object)", "!hasHoles(object)"}, replaces={"doWithoutHolesCached"})
    public long doWithoutHolesUncached(JSDynamicObject object, long length, boolean isArray) {
        assert (JSArrayLastElementIndexNode.isSupportedArray(object));
        return JSArrayLastElementIndexNode.getArrayType(object).lastElementIndex(object);
    }

    @Specialization(guards={"isArray", "!hasPrototypeElements(object)", "getArrayType(object) == cachedArrayType", "cachedArrayType.hasHoles(object)"}, limit="MAX_CACHED_ARRAY_TYPES")
    public long doWithHolesCached(JSDynamicObject object, long length, boolean isArray, @Cached(value="getArrayTypeIfArray(object, isArray)") ScriptArray cachedArrayType, @Bind(value="this") Node node, @Cached(value="create(context)") @Cached.Shared JSArrayPreviousElementIndexNode previousElementIndexNode, @Cached @Cached.Shared InlinedConditionProfile isLengthMinusOne) {
        assert (JSArrayLastElementIndexNode.isSupportedArray(object) && cachedArrayType == JSArrayLastElementIndexNode.getArrayType(object));
        return this.holesArrayImpl(object, length, cachedArrayType, node, previousElementIndexNode, isLengthMinusOne);
    }

    @Specialization(guards={"isArray", "hasPrototypeElements(object) || hasHoles(object)"}, replaces={"doWithHolesCached"})
    public long doWithHolesUncached(JSDynamicObject object, long length, boolean isArray, @Cached(value="create(context)") @Cached.Shared JSArrayPreviousElementIndexNode previousElementIndexNode, @Cached @Cached.Shared InlinedConditionProfile isLengthMinusOne, @Cached InlinedExactClassProfile arrayTypeProfile) {
        assert (JSArrayLastElementIndexNode.isSupportedArray(object));
        ScriptArray arrayType = arrayTypeProfile.profile(this, JSArrayLastElementIndexNode.getArrayType(object));
        return this.holesArrayImpl(object, length, arrayType, this, previousElementIndexNode, isLengthMinusOne);
    }

    private long holesArrayImpl(JSDynamicObject object, long length, ScriptArray array, Node node, JSArrayPreviousElementIndexNode previousElementIndexNode, InlinedConditionProfile isLengthMinusOne) {
        long lastIndex = array.lastElementIndex(object);
        if (isLengthMinusOne.profile(node, lastIndex == length - 1L)) {
            return lastIndex;
        }
        JSDynamicObject prototype = object;
        while (prototype != Null.instance) {
            long candidate = previousElementIndexNode.executeLong(prototype, length);
            if ((lastIndex = Math.max(lastIndex, candidate)) >= length - 1L) {
                return length - 1L;
            }
            if (this.context.getArrayPrototypeNoElementsAssumption().isValid()) break;
            prototype = JSObject.getPrototype(prototype);
        }
        return lastIndex;
    }

    @Specialization(guards={"!isArray", "isSuitableForEnumBasedProcessingUsingOwnKeys(object, length)"})
    public long doObjectViaEnumeration(JSDynamicObject object, long length, boolean isArray, @Cached @Cached.Shared JSHasPropertyNode hasPropertyNode) {
        long lengthMinusOne = length - 1L;
        if (hasPropertyNode.executeBoolean((Object)object, lengthMinusOne)) {
            return lengthMinusOne;
        }
        return JSArrayLastElementIndexNode.doObjectViaEnumerationIntl(object, lengthMinusOne);
    }

    @Specialization(guards={"!isArray", "!isSuitableForEnumBasedProcessingUsingOwnKeys(object, length)", "isSuitableForEnumBasedProcessing(object, length)"})
    public long doObjectViaFullEnumeration(JSDynamicObject object, long length, boolean isArray, @Cached @Cached.Shared JSHasPropertyNode hasPropertyNode) {
        long lengthMinusOne = length - 1L;
        if (hasPropertyNode.executeBoolean((Object)object, lengthMinusOne)) {
            return lengthMinusOne;
        }
        return JSArrayLastElementIndexNode.doObjectViaFullEnumerationIntl(object, lengthMinusOne);
    }

    @Specialization(guards={"!isArray", "!isSuitableForEnumBasedProcessing(object, length)"})
    public long doObject(Object object, long length, boolean isArray, @Cached @Cached.Shared JSHasPropertyNode hasPropertyNode) {
        long index;
        for (index = length - 1L; !hasPropertyNode.executeBoolean(object, index) && index > 0L; --index) {
        }
        return index;
    }

    @CompilerDirectives.TruffleBoundary
    private static long doObjectViaEnumerationIntl(JSDynamicObject object, long lengthMinusOne) {
        long result = -1L;
        for (Object key : JSObject.ownPropertyKeys(object)) {
            TruffleString indexStr;
            long candidate;
            if (key == null || !(key instanceof TruffleString) || (candidate = JSRuntime.propertyNameToIntegerIndex(indexStr = (TruffleString)key)) >= lengthMinusOne || candidate <= result) continue;
            result = candidate;
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private static long doObjectViaFullEnumerationIntl(JSDynamicObject object, long length) {
        long result = -1L;
        JSDynamicObject chainObject = object;
        do {
            result = Math.max(result, JSArrayLastElementIndexNode.doObjectViaEnumerationIntl(chainObject, length));
        } while ((chainObject = JSObject.getPrototype(chainObject)) != Null.instance);
        return result;
    }
}

