/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateInline;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.ArrayBufferByteLengthNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.array.TypedArrayLengthNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;

@ImportStatic(value={JSArrayBufferView.class})
@GenerateInline(inlineByDefault=true)
public abstract class TypedArrayLengthNode
extends JavaScriptBaseNode {
    public abstract int execute(Node var1, JSTypedArrayObject var2, JSContext var3);

    @Specialization(guards={"!isOutOfBounds(typedArray, context)", "!typedArray.hasAutoLength()"})
    protected static int doFixedLength(JSTypedArrayObject typedArray, JSContext context) {
        assert (!JSArrayBufferView.isOutOfBounds(typedArray, context));
        return typedArray.getLengthFixed();
    }

    @Specialization(guards={"!isOutOfBounds(typedArray, context)", "typedArray.hasAutoLength()"})
    protected static int doAutoLength(Node node, JSTypedArrayObject typedArray, JSContext context, @Cached ArrayBufferByteLengthNode getByteLengthNode) {
        assert (!JSArrayBufferView.isOutOfBounds(typedArray, context));
        JSArrayBufferObject arrayBuffer = typedArray.getArrayBuffer();
        int byteLength = getByteLengthNode.execute(node, arrayBuffer, context);
        int byteOffset = typedArray.getOffset();
        return byteLength - byteOffset >> typedArray.getArrayType().bytesPerElementShift();
    }

    @Specialization(guards={"isOutOfBounds(typedArray, context)"})
    protected static int doOutOfBounds(JSTypedArrayObject typedArray, JSContext context) {
        return 0;
    }

    @NeverDefault
    public static TypedArrayLengthNode create() {
        return TypedArrayLengthNodeGen.create();
    }
}

