/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.Truncatable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSLeftShiftConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSLeftShiftNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@NodeInfo(shortName="<<")
public abstract class JSLeftShiftNode
extends JSBinaryNode {
    protected JSLeftShiftNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        Truncatable.truncate(left);
        Truncatable.truncate(right);
        if (right instanceof JSConstantNode.JSConstantIntegerNode) {
            return JSLeftShiftConstantNode.create(left, right);
        }
        return JSLeftShiftNodeGen.create(left, right);
    }

    public abstract Object executeObject(Object var1, Object var2);

    @Specialization
    protected int doInteger(int a2, int b2) {
        return a2 << b2;
    }

    @Specialization(guards={"!largerThan2e32(b)"})
    protected int doIntegerDouble(int a2, double b2) {
        return a2 << (int)b2;
    }

    @Specialization
    protected Object doDouble(double a2, double b2, @Cached @Cached.Shared JSLeftShiftNode leftShift, @Cached JSToInt32Node leftInt32, @Cached JSToUInt32Node rightUInt32) {
        return leftShift.executeObject(leftInt32.executeInt(a2), rightUInt32.execute(b2));
    }

    @Specialization
    protected BigInt doBigInt(BigInt a2, BigInt b2) {
        if (a2.signum() == 0) {
            return BigInt.ZERO;
        }
        if (b2.compareTo(BigInt.MAX_INT) < 0) {
            if (b2.compareTo(BigInt.MIN_INT) > 0) {
                try {
                    return a2.shiftLeft(b2.intValue());
                }
                catch (ArithmeticException ae) {
                    throw Errors.createRangeErrorBigIntMaxSizeExceeded();
                }
            }
            return a2.signum() < 0 ? BigInt.NEGATIVE_ONE : BigInt.ZERO;
        }
        throw Errors.createRangeErrorBigIntMaxSizeExceeded();
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a2, Object b2, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a2, b2);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.ANGLE_BRACKET_OPEN_2;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doInteger", "doIntegerDouble", "doDouble", "doBigInt"})
    protected static Object doGeneric(Object a2, Object b2, @Bind(value="this") Node node, @Cached @Cached.Shared JSLeftShiftNode leftShift, @Cached JSToNumericNode leftToNumeric, @Cached JSToNumericNode rightToNumeric, @Cached InlinedBranchProfile mixedNumericTypes) {
        Object operandA = leftToNumeric.execute(a2);
        Object operandB = rightToNumeric.execute(b2);
        JSLeftShiftNode.ensureBothSameNumericType(operandA, operandB, node, mixedNumericTypes);
        return leftShift.executeObject(operandA, operandB);
    }

    @NeverDefault
    public static JSLeftShiftNode create() {
        return JSLeftShiftNodeGen.create(null, null);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSLeftShiftNodeGen.create(JSLeftShiftNode.cloneUninitialized(this.getLeft(), materializedTags), JSLeftShiftNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

