/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Objects;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.Truncatable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSRightShiftConstantNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSRightShiftNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSRightShiftNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;

@NodeInfo(shortName=">>")
public abstract class JSRightShiftConstantNode
extends JSUnaryNode {
    protected final int shiftValue;

    protected JSRightShiftConstantNode(JavaScriptNode operand, int shiftValue) {
        super(operand);
        this.shiftValue = shiftValue;
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        assert (right instanceof JSConstantNode.JSConstantIntegerNode);
        int shiftValue = ((JSConstantNode.JSConstantIntegerNode)right).executeInt(null);
        if (left instanceof JSConstantNode.JSConstantIntegerNode) {
            int leftValue = ((JSConstantNode.JSConstantIntegerNode)left).executeInt(null);
            return JSConstantNode.createInt(leftValue >> shiftValue);
        }
        Truncatable.truncate(left);
        return JSRightShiftConstantNodeGen.create(left, shiftValue);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class)) {
            JSConstantNode constantNode = JSConstantNode.createInt(this.shiftValue);
            JSRightShiftNode node = JSRightShiftNodeGen.create(JSRightShiftConstantNode.cloneUninitialized(this.getOperand(), materializedTags), constantNode);
            JSRightShiftConstantNode.transferSourceSectionAddExpressionTag(this, constantNode);
            JSRightShiftConstantNode.transferSourceSectionAndTags(this, node);
            return node;
        }
        return this;
    }

    public abstract int executeInt(Object var1);

    @Specialization
    protected int doInteger(int a2) {
        return a2 >> this.shiftValue;
    }

    @Specialization
    protected int doSafeInteger(SafeInteger a2) {
        return a2.intValue() >> this.shiftValue;
    }

    @Specialization
    protected int doDouble(double a2, @Cached JSToInt32Node leftInt32Node) {
        return leftInt32Node.executeInt(a2) >> this.shiftValue;
    }

    @Specialization
    protected void doBigInt(BigInt a2) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected Object doOverloaded(JSOverloadedOperatorsObject a2, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a2, this.shiftValue);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.ANGLE_BRACKET_CLOSE_2;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)"}, replaces={"doInteger", "doSafeInteger", "doDouble", "doBigInt"})
    protected int doGeneric(Object a2, @Cached JSToNumericNode leftToNumeric, @Cached(value="makeCopy()") JSRightShiftConstantNode innerShiftNode) {
        Object leftOperand = leftToNumeric.execute(a2);
        return innerShiftNode.executeInt(leftOperand);
    }

    protected JSRightShiftConstantNode makeCopy() {
        return (JSRightShiftConstantNode)this.copyUninitialized(null);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSRightShiftConstantNodeGen.create(JSRightShiftConstantNode.cloneUninitialized(this.getOperand(), materializedTags), this.shiftValue);
    }

    @Override
    public String expressionToString() {
        if (this.getOperand() != null) {
            return "(" + Objects.toString(this.getOperand().expressionToString(), "(intermediate value)") + " >> " + this.shiftValue + ")";
        }
        return null;
    }
}

