/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.Truncatable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSLeftShiftNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSRightShiftConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSRightShiftNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@NodeInfo(shortName=">>")
public abstract class JSRightShiftNode
extends JSBinaryNode {
    protected JSRightShiftNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        Truncatable.truncate(left);
        Truncatable.truncate(right);
        if (right instanceof JSConstantNode.JSConstantIntegerNode) {
            return JSRightShiftConstantNode.create(left, right);
        }
        return JSRightShiftNodeGen.create(left, right);
    }

    public abstract Object execute(Object var1, Object var2);

    @Specialization
    protected int doInteger(int a2, int b2) {
        return a2 >> b2;
    }

    @Specialization
    protected BigInt doBigInt(BigInt a2, BigInt b2, @Cached JSLeftShiftNode leftShift) {
        return leftShift.doBigInt(a2, b2.negate());
    }

    @Specialization(guards={"!largerThan2e32(b)"})
    protected int doIntDouble(int a2, double b2) {
        return a2 >> (int)b2;
    }

    @Specialization
    protected Object doDouble(double a2, double b2, @Cached @Cached.Shared JSRightShiftNode rightShift, @Cached JSToInt32Node leftInt32, @Cached JSToUInt32Node rightUInt32) {
        return rightShift.execute(leftInt32.executeInt(a2), rightUInt32.execute(b2));
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a2, Object b2, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a2, b2);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.ANGLE_BRACKET_CLOSE_2;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doInteger", "doIntDouble", "doDouble", "doBigInt"})
    protected static Object doGeneric(Object a2, Object b2, @Bind(value="this") Node node, @Cached @Cached.Shared JSRightShiftNode rightShift, @Cached JSToNumericNode leftToNumeric, @Cached JSToNumericNode rightToNumeric, @Cached InlinedBranchProfile mixedNumericTypes) {
        Object operandA = leftToNumeric.execute(a2);
        Object operandB = rightToNumeric.execute(b2);
        JSRightShiftNode.ensureBothSameNumericType(operandA, operandB, node, mixedNumericTypes);
        return rightShift.execute(operandA, operandB);
    }

    @NeverDefault
    public static JSRightShiftNode create() {
        return JSRightShiftNodeGen.create(null, null);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSRightShiftNodeGen.create(JSRightShiftNode.cloneUninitialized(this.getLeft(), materializedTags), JSRightShiftNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

