/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.NodeInfo;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.Truncatable;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.JSConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSUnsignedRightShiftConstantNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.binary.JSUnsignedRightShiftNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;

@NodeInfo(shortName=">>>")
public abstract class JSUnsignedRightShiftNode
extends JSBinaryNode {
    protected JSUnsignedRightShiftNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        Truncatable.truncate(left);
        Truncatable.truncate(right);
        if (right instanceof JSConstantNode.JSConstantIntegerNode) {
            return JSUnsignedRightShiftConstantNode.create(left, right);
        }
        return JSUnsignedRightShiftNodeGen.create(left, right);
    }

    static JSUnsignedRightShiftNode create() {
        return JSUnsignedRightShiftNodeGen.create(null, null);
    }

    protected final Number executeNumber(Object a2, Object b2) {
        return (Number)this.execute(a2, b2);
    }

    public abstract Object execute(Object var1, Object var2);

    protected static boolean rvalZero(int b2) {
        return (b2 & 0x1F) == 0;
    }

    @Specialization(guards={"rvalZero(b)", "a >= 0"})
    protected int doIntegerFast(int a2, int b2) {
        return a2;
    }

    @Specialization(guards={"a >= 0"})
    protected int doInteger(int a2, int b2) {
        return a2 >>> b2;
    }

    @Specialization(guards={"!rvalZero(b)"})
    protected int doIntegerNegative(int a2, int b2) {
        return a2 >>> b2;
    }

    @Specialization(guards={"rvalZero(b)"})
    protected double doDoubleZero(double a2, int b2, @Cached @Cached.Shared JSToUInt32Node lvalToUint32Node) {
        return lvalToUint32Node.executeLong(a2);
    }

    @Specialization(guards={"!rvalZero(b)"})
    protected Number doDouble(double a2, int b2, @Cached @Cached.Shared JSToUInt32Node lvalToUint32Node, @Cached @Cached.Shared InlinedConditionProfile returnType) {
        long lnum = lvalToUint32Node.executeLong(a2);
        int shiftCount = b2 & 0x1F;
        if (returnType.profile(this, lnum >= Integer.MAX_VALUE || lnum <= Integer.MIN_VALUE)) {
            return (double)(lnum >>> shiftCount);
        }
        return (int)(lnum >>> shiftCount);
    }

    @Specialization
    protected Number doIntDouble(int a2, double b2, @Cached @Cached.Shared JSToUInt32Node lvalToUint32Node, @Cached @Cached.Shared JSToUInt32Node rvalToUint32Node, @Cached @Cached.Shared InlinedConditionProfile returnType) {
        long lnum = lvalToUint32Node.executeLong(a2);
        int shiftCount = (int)rvalToUint32Node.executeLong(b2) & 0x1F;
        if (returnType.profile(this, lnum >= Integer.MAX_VALUE || lnum <= Integer.MIN_VALUE)) {
            return (double)(lnum >>> shiftCount);
        }
        return (int)(lnum >>> shiftCount);
    }

    @Specialization
    protected double doDoubleDouble(double a2, double b2, @Cached @Cached.Shared JSToUInt32Node lvalToUint32Node, @Cached @Cached.Shared JSToUInt32Node rvalToUint32Node) {
        return lvalToUint32Node.executeLong(a2) >>> ((int)rvalToUint32Node.executeLong(b2) & 0x1F);
    }

    @Specialization
    protected Number doBigInt(BigInt a2, BigInt b2) {
        throw Errors.createTypeError("BigInts have no unsigned right shift, use >> instead");
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a2, Object b2, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a2, b2);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.ANGLE_BRACKET_CLOSE_3;
    }

    @Specialization(guards={"!hasOverloadedOperators(lval)", "!hasOverloadedOperators(rval)", "!isHandled(lval, rval)"})
    protected static Number doGeneric(Object lval, Object rval, @Bind(value="this") Node node, @Cached JSToNumericNode lvalToNumericNode, @Cached JSToNumericNode rvalToNumericNode, @Cached JSUnsignedRightShiftNode innerShiftNode, @Cached InlinedBranchProfile mixedNumericTypes) {
        Object lnum = lvalToNumericNode.execute(lval);
        Object rnum = rvalToNumericNode.execute(rval);
        JSUnsignedRightShiftNode.ensureBothSameNumericType(lnum, rnum, node, mixedNumericTypes);
        return innerShiftNode.executeNumber(lnum, rnum);
    }

    protected static boolean isHandled(Object lval, Object rval) {
        return !(!(lval instanceof Integer) && !(lval instanceof Double) && !(lval instanceof SafeInteger) || !(rval instanceof Integer) && !(rval instanceof Double) && !(rval instanceof SafeInteger));
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSUnsignedRightShiftNodeGen.create(JSUnsignedRightShiftNode.cloneUninitialized(this.getLeft(), materializedTags), JSUnsignedRightShiftNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

