/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import java.math.BigInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;

public abstract class JSNumberToBigIntNode
extends JavaScriptBaseNode {
    protected abstract BigInt execute(Object var1);

    public final BigInt executeBigInt(Object value) {
        BigInt result = this.executeBigIntIfNumberOrNull(value);
        if (result == null) {
            throw CompilerDirectives.shouldNotReachHere("not a Number");
        }
        return result;
    }

    public final BigInt executeBigIntIfNumberOrNull(Object value) {
        return this.execute(value);
    }

    @Specialization
    protected static BigInt doInteger(int value) {
        return BigInt.valueOf(value);
    }

    @Specialization
    protected static BigInt doSafeInteger(SafeInteger value) {
        return BigInt.valueOf(value.longValue());
    }

    protected static boolean doubleRepresentsSameValueAsLong(double value) {
        return JSRuntime.doubleIsRepresentableAsLong(value) && value != 9.223372036854776E18;
    }

    @Specialization(guards={"doubleRepresentsSameValueAsLong(value)"})
    protected static BigInt doDoubleAsLong(double value) {
        return BigInt.valueOf((long)value);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!doubleRepresentsSameValueAsLong(value)"})
    protected static BigInt doDoubleOther(double value) {
        if (!JSRuntime.isInteger(value)) {
            throw Errors.createRangeError("BigInt out of range");
        }
        long bits = Double.doubleToRawLongBits(value);
        boolean negative = (bits & Long.MIN_VALUE) != 0L;
        int exponentOffset = 1023;
        int mantissaLength = 52;
        int exponent = (int)((bits & 0x7FF0000000000000L) >> mantissaLength) - exponentOffset - mantissaLength;
        long mantissa = bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        BigInteger bigInteger = BigInteger.valueOf(negative ? -mantissa : mantissa).shiftLeft(exponent);
        return new BigInt(bigInteger);
    }

    @Fallback
    protected static BigInt doOtherType(Object value) {
        return null;
    }
}

