/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.GetIteratorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorStepNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IteratorValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.IteratorRecord;

public abstract class JSStringListFromIterableNode
extends JavaScriptBaseNode {
    protected final JSContext context;

    protected JSStringListFromIterableNode(JSContext context) {
        this.context = context;
    }

    public abstract List<String> executeIterable(Object var1);

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected static List<String> stringToList(TruffleString s2) {
        int[] codePoints = Strings.toJavaString(s2).codePoints().toArray();
        int length = codePoints.length;
        ArrayList<String> result = new ArrayList<String>(length);
        for (int i2 = 0; i2 < length; ++i2) {
            result.add(new String(codePoints, i2, 1));
        }
        return result;
    }

    @Specialization(guards={"!isUndefined(iterable)", "!isString(iterable)"})
    protected static List<String> toArray(Object iterable, @Bind(value="this") Node node, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached IteratorStepNode iteratorStepNode, @Cached IteratorValueNode iteratorValueNode, @Cached(value="create(context)") IteratorCloseNode iteratorCloseNode) {
        IteratorRecord iteratorRecord = getIteratorNode.execute(node, iterable);
        ArrayList<String> list = new ArrayList<String>();
        Object next = true;
        while (!JSStringListFromIterableNode.isFalse(next)) {
            next = iteratorStepNode.execute(iteratorRecord);
            if (JSStringListFromIterableNode.isFalse(next)) continue;
            Object nextValue = iteratorValueNode.execute(next);
            if (!(nextValue instanceof TruffleString)) {
                iteratorCloseNode.executeAbrupt(iteratorRecord.getIterator());
                throw Errors.createTypeError("nonString value encountered!");
            }
            TruffleString nextStr = (TruffleString)nextValue;
            Boundaries.listAdd(list, Strings.toJavaString(nextStr));
        }
        return list;
    }

    private static boolean isFalse(Object o2) {
        return o2 == Boolean.FALSE;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected List<String> doUndefined(Object value) {
        return Collections.emptyList();
    }
}

