/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToIntegerThrowOnInfinityNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;

@ImportStatic(value={JSGuards.class})
public abstract class JSToIntegerThrowOnInfinityNode
extends JavaScriptBaseNode {
    private final BranchProfile errorBranch = BranchProfile.create();
    private final BranchProfile isIntProfile = BranchProfile.create();
    private final BranchProfile isLongProfile = BranchProfile.create();
    private final BranchProfile isDoubleProfile = BranchProfile.create();

    public abstract Object execute(Object var1);

    public final int executeIntOrThrow(Object value) {
        Number n2 = (Number)this.execute(value);
        if (n2 instanceof Integer) {
            this.isIntProfile.enter();
            return (Integer)n2;
        }
        if (n2 instanceof Long) {
            this.isLongProfile.enter();
            long l2 = (Long)n2;
            if (l2 < Integer.MIN_VALUE || Integer.MAX_VALUE < l2) {
                this.errorBranch.enter();
                throw Errors.createRangeError("value out of range");
            }
            return (int)l2;
        }
        this.isDoubleProfile.enter();
        double d2 = JSRuntime.doubleValue(n2);
        if (d2 < -2.147483648E9 || 2.147483647E9 < d2) {
            this.errorBranch.enter();
            throw Errors.createRangeError("value out of range");
        }
        return (int)d2;
    }

    public final double executeDouble(Object value) {
        return JSRuntime.doubleValue((Number)this.execute(value));
    }

    @NeverDefault
    public static JSToIntegerThrowOnInfinityNode create() {
        return JSToIntegerThrowOnInfinityNodeGen.create();
    }

    @Specialization
    protected static int doInteger(int value) {
        return value;
    }

    @Specialization
    protected static long doLong(long value) {
        return value;
    }

    @Specialization
    protected static int doBoolean(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    @Specialization
    protected static SafeInteger doSafeInteger(SafeInteger value) {
        return value;
    }

    @Specialization
    protected long doDoubleInfinite(double value) {
        if (Double.isNaN(value) || value == 0.0) {
            return 0L;
        }
        if (Double.isInfinite(value)) {
            this.errorBranch.enter();
            throw Errors.createRangeError("infinity not allowed");
        }
        return (long)value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static int doNull(Object value) {
        return 0;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static int doUndefined(Object value) {
        return 0;
    }

    @Specialization
    protected final Number doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization
    protected final Number doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a BigInt value", this);
    }

    @Specialization
    protected Number doString(TruffleString value, @Cached.Shared @Cached JSToIntegerThrowOnInfinityNode toIntOrInf, @Cached JSStringToNumberNode stringToNumberNode) {
        return (Number)toIntOrInf.execute(stringToNumberNode.execute(value));
    }

    @Specialization(guards={"isJSObject(value) || isForeignObject(value)"})
    protected Number doJSOrForeignObject(Object value, @Cached.Shared @Cached JSToIntegerThrowOnInfinityNode toIntOrInf, @Cached JSToNumberNode toNumberNode) {
        return (Number)toIntOrInf.execute(toNumberNode.executeNumber(value));
    }
}

