/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateUncached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.TruffleObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JSGuards;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToObjectNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSBoolean;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNumber;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSSymbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;

@GenerateUncached
@ImportStatic(value={CompilerDirectives.class, JSConfig.class})
public abstract class JSToObjectNode
extends JavaScriptBaseNode {
    protected JSToObjectNode() {
    }

    public abstract Object execute(Object var1);

    @NeverDefault
    public static JSToObjectNode create() {
        return JSToObjectNodeGen.create();
    }

    @NeverDefault
    public static JSToObjectNode getUncached() {
        return JSToObjectNodeGen.getUncached();
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doBoolean(boolean value) {
        return JSBoolean.create(this.getJSContext(), this.getRealm(), value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doString(TruffleString value) {
        return JSString.create(this.getJSContext(), this.getRealm(), value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doInt(int value) {
        return JSNumber.create(this.getJSContext(), this.getRealm(), value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doDouble(double value) {
        return JSNumber.create(this.getJSContext(), this.getRealm(), value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doBigInt(BigInt value) {
        return JSBigInt.create(this.getJSContext(), this.getRealm(), value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization
    protected JSDynamicObject doSymbol(Symbol value) {
        return JSSymbol.create(this.getJSContext(), this.getRealm(), value);
    }

    @Specialization(guards={"cachedClass != null", "isExact(object, cachedClass)"}, limit="1")
    protected static Object doJSObjectCached(Object object, @Cached(value="getClassIfObject(object)") Class<?> cachedClass) {
        return cachedClass.cast(object);
    }

    static Class<?> getClassIfObject(Object object) {
        if (JSGuards.isJSObject(object)) {
            return object.getClass();
        }
        return null;
    }

    @Specialization(replaces={"doJSObjectCached"})
    protected Object doJSObject(JSObject object) {
        return object;
    }

    @Specialization(guards={"isNullOrUndefined(object)"})
    protected JSDynamicObject doNullOrUndefined(Object object) {
        throw Errors.createTypeErrorNotObjectCoercible(object, this);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObjectOrNumber(value)"}, limit="InteropLibraryLimit")
    protected final Object doForeignObject(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
        if (interop.isNull(value)) {
            throw Errors.createTypeErrorNotObjectCoercible(value, this);
        }
        return JSToObjectNode.doForeignObjectNonNull(value, interop, this);
    }

    static Object doForeignObjectNonNull(Object value, InteropLibrary interop, JavaScriptBaseNode node) {
        assert (!interop.isNull(value));
        try {
            if (!interop.hasMembers(value)) {
                if (interop.isBoolean(value)) {
                    return JSBoolean.create(JavaScriptLanguage.get(node).getJSContext(), JSRealm.get(node), interop.asBoolean(value));
                }
                if (interop.isString(value)) {
                    return JSString.create(JavaScriptLanguage.get(node).getJSContext(), JSRealm.get(node), interop.asTruffleString(value));
                }
                if (interop.isNumber(value)) {
                    return JSToObjectNode.doForeignNumber(value, interop, node);
                }
            }
            assert (value instanceof TruffleObject) : value;
            return value;
        }
        catch (UnsupportedMessageException e2) {
            throw Errors.createTypeErrorInteropException(value, e2, "ToObject", node);
        }
    }

    private static Object doForeignNumber(Object value, InteropLibrary interop, JavaScriptBaseNode node) throws UnsupportedMessageException {
        Number number;
        if (interop.fitsInInt(value)) {
            number = interop.asInt(value);
        } else if (interop.fitsInDouble(value)) {
            number = interop.asDouble(value);
        } else if (interop.fitsInLong(value)) {
            number = interop.asLong(value);
        } else if (interop.fitsInBigInteger(value)) {
            number = BigInt.doubleValueOf(interop.asBigInteger(value));
        } else {
            assert (value instanceof TruffleObject && !(value instanceof Number)) : value;
            return value;
        }
        return JSNumber.create(JavaScriptLanguage.get(node).getJSContext(), JSRealm.get(node), number);
    }

    public static abstract class JSToObjectWrapperNode
    extends JSUnaryNode {
        protected JSToObjectWrapperNode(JavaScriptNode operand) {
            super(operand);
        }

        public static JSToObjectWrapperNode createToObject(JavaScriptNode child) {
            return JSToObjectNodeGen.JSToObjectWrapperNodeGen.create(child);
        }

        @Specialization
        protected Object doDefault(Object value, @Cached JSToObjectNode toObjectNode) {
            return toObjectNode.execute(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return JSToObjectNodeGen.JSToObjectWrapperNodeGen.create(JSToObjectWrapperNode.cloneUninitialized(this.getOperand(), materializedTags));
        }
    }
}

